/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.Client.LegacyClient;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JFrame;
import org.jSyncManager.API.Conduit.AbstractConduit;
import org.jSyncManager.API.Conduit.ConduitHandler;
import org.jSyncManager.API.Protocol.Util.DLPDatabaseInfo;
import org.jSyncManager.API.Protocol.Util.DLPDatabaseSet;
import org.jSyncManager.API.Protocol.Util.DLPUserInfo;
import org.jSyncManager.API.Threads.Synchronizer;
import org.jSyncManager.API.Threads.SynchronizerListener;
import org.jSyncManager.API.Transport.SLPTransportInterface;
import org.jSyncManager.Client.LegacyClient.AddConduitDialog;
import org.jSyncManager.Client.LegacyClient.ComSelectDialog;
import org.jSyncManager.Client.LegacyClient.DBSetSelectDialog;
import org.jSyncManager.Client.LegacyClient.DatabaseViewer;
import org.jSyncManager.Client.LegacyClient.LogFrame;
import org.jSyncManager.Client.LegacyClient.MessageDialog;
import org.jSyncManager.Client.LegacyClient.RemoveConduitDialog;
import org.jSyncManager.Client.LegacyClient.SecurityDialog;
import org.jSyncManager.Client.LegacyClient.SyncFrame;
import org.jSyncManager.Client.LegacyClient.SyncPanel;
import org.jSyncManager.Client.LegacyClient.SyncWindow;
import org.jSyncManager.Client.LegacyClient.UserNameEntryDialog;
import org.jSyncManager.Client.RegistrationData;
import org.jSyncManager.Conduit.DefaultConduit;
import org.jSyncManager.Transport.ModemTransport;

public final class JSyncManagerFrame
extends Frame
implements ActionListener,
ItemListener,
WindowListener,
SynchronizerListener {
    private DBSetSelectDialog dbsd = null;
    private DBSetSelectDialog dbsd2 = null;
    private MenuBar ivjGetUserInfoMenuBar;
    private ComSelectDialog ivjcommSelectDlg;
    private TextField ivjlastGoodSyncField;
    private TextField ivjlastSyncField;
    private Button ivjokButton;
    private TextField ivjuserIDField;
    private Dialog ivjuserInfoDlg;
    private TextField ivjuserNameField;
    private CheckboxMenuItem ivjdisablePopups;
    private CheckboxMenuItem ivjUseSyncFrame;
    private Menu ivjMenu3;
    private MenuItem ivjMenuSeparator1;
    private CheckboxMenuItem ivjautoHidePopups;
    private ResourceBundle resEnglishStrings = ResourceBundle.getBundle("org.jSyncManager.Client.LegacyClient.Resources.Text.JSyncManLegacyClientResources");
    private RegistrationData registry;
    private SyncWindow ivjSyncWindow;
    private SyncFrame ivjSyncFrame;
    private SLPTransportInterface transport;
    private Menu ivjConduitsMenu;
    private Menu ivjBackupMenu;
    private CheckboxMenuItem ivjBackupMenuItem;
    private CheckboxMenuItem ivjRestoreMenuItem;
    private Label ivjAuthorLabel;
    private Menu ivjInfoMenu;
    private Label ivjLastGoodSyncLabel;
    private Label ivjLastSyncLabel;
    private Panel ivjMainPanel;
    private Label ivjMainTitleLabel;
    private MenuItem ivjQuitMenuItem;
    private MenuItem ivjSerialPortSelectionMenuItem;
    private Menu ivjSetupMenu;
    private Panel ivjUserContentsPanel;
    private Label ivjUserIDLabel;
    private MenuItem ivjUserInfoMenuItem;
    private Label ivjUserNameLabel;
    private Label ivjVersionLabel;
    private Vector conduitMenuItems = new Vector();
    private CheckboxMenuItem ivjTimeSyncMenuItem;
    private MenuItem ivjInstallConduitMenuItem;
    private MenuItem ivjInstallLanguageMenuItem;
    private MenuItem ivjMenuSeparator2;
    private MenuItem ivjRemoveConduitMenuItem;
    private AddConduitDialog ivjAddConduit;
    private RemoveConduitDialog ivjRemoveConduit;
    private MessageDialog messageDlg = new MessageDialog((Frame)this, this.resEnglishStrings);
    private MenuItem ivjExtractDatabasesMenuItem;
    private FileDialog fileDlg;
    private String userPath;
    private String restoreName;
    private SecurityDialog securityDlg;
    private MenuItem securityDialogMenuItem;
    private LogFrame log;
    private MenuItem logFrameMenuItem;
    private StringBuffer palmSyncLogBuffer = null;
    private Synchronizer sync;
    private Thread syncThread;
    private PrintWriter statusStream = new PrintWriter(new LogStream(true));
    private PrintWriter logStream = new PrintWriter(new LogStream(false));
    private boolean exitAfterError = false;
    private SyncPanel syncPanel = null;
    private boolean exitFlag = false;
    private boolean switchSyncPanelType = false;
    private MenuItem ivjDBInfoMenuItem = null;
    private DatabaseViewer ivjdbViewer = null;
    private boolean dbViewerEnabled = false;

    public JSyncManagerFrame() {
        if (System.getProperty("jsyncman.enabledbviewer") != null && System.getProperty("jsyncman.enabledbviewer").toLowerCase().equals("true")) {
            this.dbViewerEnabled = true;
        }
        this.initialize();
    }

    public void actionPerformed(ActionEvent actionevent) {
        if (actionevent.getSource() == this.getSerialPortSelectionMenuItem()) {
            this.connEtoM2(actionevent);
            return;
        }
        if (actionevent.getSource() == this.getQuitMenuItem()) {
            this.connEtoM3(actionevent);
            return;
        }
        if (actionevent.getSource() == this.getDBInfoMenuItem()) {
            this.connEtoM4(actionevent);
            return;
        }
        if (actionevent.getSource() == this.getUserInfoMenuItem()) {
            this.connEtoM5(actionevent);
            return;
        }
        if (actionevent.getSource() == this.getokButton()) {
            this.connEtoM7(actionevent);
            return;
        }
        if (actionevent.getSource() == this.getautoHidePopups()) {
            this.connEtoM1(actionevent);
            return;
        }
        if (actionevent.getSource() == this.getInstallConduitMenuItem()) {
            this.connEtoM10(actionevent);
            return;
        }
        if (actionevent.getSource() == this.getRemoveConduitMenuItem()) {
            this.connEtoM11(actionevent);
            return;
        }
        if (actionevent.getSource() == this.getExtractDatabasesMenuItem()) {
            if (this.dbsd == null) {
                this.dbsd = new DBSetSelectDialog(this);
            }
            this.dbsd.setLabelRes("dbLoader_Expand");
            this.dbsd.showMe();
            return;
        }
        if (actionevent.getSource() == this.getLogFrameMenuItem()) {
            ((Component)this.log).setVisible(true);
            return;
        }
        if (actionevent.getSource() == this.getSecurityDialogMenuItem()) {
            ((Component)this.getSecurityDlg()).setVisible(true);
            return;
        }
        if (actionevent.getSource() == this.messageDlg.getOkButton()) {
            this.connEtoM13(actionevent);
            return;
        }
        if (this.dbsd != null && actionevent.getSource() == this.dbsd.getDlgOkButton()) {
            File temp = this.dbsd.getDBSet();
            this.dbsd.dispose();
            this.dbsd = null;
            if (temp == null) {
                return;
            }
            this.expandDBSet(temp);
            return;
        }
        if (this.dbsd2 != null && actionevent.getSource() == this.dbsd2.getDlgOkButton()) {
            File temp = this.dbsd2.getDBSet();
            this.dbsd2.dispose();
            this.dbsd2 = null;
            if (temp == null) {
                return;
            }
            this.restorePalm(temp);
            return;
        }
        if (actionevent.getSource() == this.messageDlg.getOkButton()) {
            System.exit(1);
            return;
        }
        this.handleConduitMenuSelection(actionevent);
    }

    void addConduit(AbstractConduit conduit) {
        this.registry.registerConduit(conduit);
        if (conduit.getConfigurationPanel() != null) {
            MenuItem menuitem = new MenuItem(conduit.getConduitName());
            this.conduitMenuItems.addElement(menuitem);
            menuitem.addActionListener(this);
            menuitem.setActionCommand(conduit.getConduitName());
            this.getConduitsMenu().add(menuitem);
        }
    }

    void appendToPalmSyncLog(String text) {
        if (this.palmSyncLogBuffer == null) {
            this.palmSyncLogBuffer = new StringBuffer();
        }
        this.palmSyncLogBuffer.append(text);
        this.palmSyncLogBuffer.append("\n");
    }

    private void connEtoC1(WindowEvent windowevent) {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM1(ActionEvent actionevent) {
        try {
            this.getSyncWindow().setHideEnabled(this.getautoHidePopups().isEnabled());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM10(ActionEvent actionevent) {
        try {
            this.getAddConduit().show();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM11(ActionEvent actionevent) {
        try {
            this.getRemoveConduit().showMe();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM13(ActionEvent actionevent) {
        ((Component)this.messageDlg).setVisible(false);
        if (this.exitAfterError) {
            System.exit(1);
        }
    }

    private void connEtoM2(ActionEvent actionevent) {
        this.getcommSelectDlg().show();
        this.transport = this.getcommSelectDlg().getSelectedTransport();
    }

    private void connEtoM3(ActionEvent actionevent) {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM4(ActionEvent actionevent) {
        try {
            this.getdbViewer().show();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM5(ActionEvent actionevent) {
        try {
            this.getuserInfoDlg().show();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM6(WindowEvent windowevent) {
        try {
            this.getuserInfoDlg().dispose();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM7(ActionEvent actionevent) {
        try {
            this.getuserInfoDlg().dispose();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM8(ItemEvent itemevent) {
        if (!this.getRestoreMenuItem().getState()) {
            return;
        }
        this.getRestoreMenuItem().setState(false);
        if (this.dbsd2 == null) {
            this.dbsd2 = new DBSetSelectDialog(this);
        }
        this.dbsd2.showMe();
    }

    private void connEtoM9(ItemEvent itemevent) {
        try {
            this.getRestoreMenuItem().setState(false);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void displayTransportError() {
        this.messageDlg.getOkButton().addActionListener(this);
        this.messageDlg.show("Missing COMM API", "*** No Serial Port Handler Found!!!", "In order to function, the jSyncManager application requires that the\nSun Java Communications API is installed.\n\nFor more information on serial port handlers, and links for downloading,\nplease visit the jSyncManager homepage at:\n\n                  http://warp.idirect.com/\n\nPress \"Ok\" to exit.");
        this.exitAfterError = true;
    }

    public void dispose() {
        if (this.exitFlag) {
            return;
        }
        try {
            this.exitFlag = true;
            this.registry.setDisablePopups(this.getdisablePopups().getState());
            this.registry.setManualHide(this.getautoHidePopups().getState());
            this.registry.setSyncTimeOption(this.getTimeSyncMenuItem().getState());
            this.registry.setFrameFlag(this.getUseSyncFrameMenuItem().getState());
            this.registry.setWindowPosition(this.getBounds());
            this.registry.setAllowedIDs(this.getSecurityDlg().getIDList());
            this.registry.setSecurityEnabled(this.getSecurityDlg().isSecurityEnabled());
            this.registry.setTransport(this.transport);
            this.registry.saveSettings();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sync.stopSync();
        this.syncThread.interrupt();
        super.dispose();
        System.exit(0);
    }

    public void endOfSync(Synchronizer s) {
        this.getSyncPanel().setDoneEnabled(true);
        JSyncManagerFrame jSyncManagerFrame = this;
        synchronized (jSyncManagerFrame) {
            try {
                this.wait(2500L);
                this.getSyncPanel().setConnectingEnabled(false);
                this.getSyncPanel().setSynchronizingEnabled(false);
                this.getSyncPanel().setDoneEnabled(false);
                this.wait(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.getautoHidePopups().getState()) {
            if (!this.getUseSyncFrameMenuItem().getState()) {
                ((Component)this.getSyncWindow()).setVisible(false);
            } else {
                ((Component)this.getSyncFrame()).setVisible(false);
            }
            this.getSyncPanel().invalidate();
        }
        if (this.getConduitMenuItems().size() > 0) {
            this.getConduitsMenu().setEnabled(true);
        }
        this.getUserInfoMenuItem().setEnabled(true);
        this.getConduitsMenu().setEnabled(true);
        this.getOptionsMenu().setEnabled(true);
        this.getBackupMenuItem().setState(false);
        this.getRestoreMenuItem().setState(false);
        if (this.dbViewerEnabled) {
            this.getDBInfoMenuItem().setEnabled(true);
        }
    }

    private void expandDBSet(File file) {
        DLPDatabaseSet dlpdatabaseset = null;
        if (file == null) {
            return;
        }
        String s = file.getAbsolutePath();
        if (!file.exists() || file.isFile()) {
            this.postToLog("Specified location for database set to extract is invalid.");
            return;
        }
        try {
            dlpdatabaseset = new DLPDatabaseSet(s);
        }
        catch (Exception exception) {
            this.postToLog("Error while opening database set: " + exception.toString());
            return;
        }
        int i = 0;
        while (i < dlpdatabaseset.databaseCount()) {
            this.postToLog("Extracting database: " + dlpdatabaseset.getDatabase(i).getDatabaseInfo().getName());
            dlpdatabaseset.getDatabase(i).exportDatabase(s + System.getProperty("file.separator") + "Extracted");
            ++i;
        }
    }

    private AddConduitDialog getAddConduit() {
        if (this.ivjAddConduit == null) {
            try {
                this.ivjAddConduit = new AddConduitDialog(this, this.messageDlg, this.resEnglishStrings);
                this.ivjAddConduit.setName("AddConduit");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjAddConduit;
    }

    private Label getAuthorLabel() {
        if (this.ivjAuthorLabel == null) {
            try {
                this.ivjAuthorLabel = new Label();
                this.ivjAuthorLabel.setName("AuthorLabel");
                this.ivjAuthorLabel.setAlignment(1);
                this.ivjAuthorLabel.setText(this.resEnglishStrings.getString("jhsAuthorString") + Synchronizer.author);
                this.ivjAuthorLabel.setForeground(Color.blue);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjAuthorLabel;
    }

    private CheckboxMenuItem getautoHidePopups() {
        if (this.ivjautoHidePopups == null) {
            try {
                this.ivjautoHidePopups = new CheckboxMenuItem();
                this.ivjautoHidePopups.setLabel(this.resEnglishStrings.getString("manualHideMenuItemString"));
                this.ivjautoHidePopups.setState(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjautoHidePopups;
    }

    private Menu getBackupMenu() {
        if (this.ivjBackupMenu == null) {
            try {
                this.ivjBackupMenu = new Menu();
                this.ivjBackupMenu.setLabel(this.resEnglishStrings.getString("backupMenu"));
                this.ivjBackupMenu.add(this.getBackupMenuItem());
                this.ivjBackupMenu.add(this.getRestoreMenuItem());
                this.ivjBackupMenu.add(this.getMenuSeparator1());
                this.ivjBackupMenu.add(this.getExtractDatabasesMenuItem());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjBackupMenu;
    }

    private CheckboxMenuItem getBackupMenuItem() {
        if (this.ivjBackupMenuItem == null) {
            try {
                this.ivjBackupMenuItem = new CheckboxMenuItem();
                this.ivjBackupMenuItem.setLabel(this.resEnglishStrings.getString("backupMenuItem"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjBackupMenuItem;
    }

    private ComSelectDialog getcommSelectDlg() {
        if (this.ivjcommSelectDlg == null) {
            try {
                this.ivjcommSelectDlg = new ComSelectDialog(this);
            }
            catch (Exception e) {
                System.out.println(e.toString());
                System.exit(7);
            }
            this.ivjcommSelectDlg.setModal(true);
            this.ivjcommSelectDlg.setName("commSelectDlg");
        }
        return this.ivjcommSelectDlg;
    }

    private Vector getConduitMenuItems() {
        return this.conduitMenuItems;
    }

    public Vector getConduits(Synchronizer s) {
        return this.registry.getConduits();
    }

    private Menu getConduitsMenu() {
        if (this.ivjConduitsMenu == null) {
            try {
                this.ivjConduitsMenu = new Menu();
                this.ivjConduitsMenu.setEnabled(true);
                this.ivjConduitsMenu.setLabel(this.resEnglishStrings.getString("conduitsMenu"));
                this.ivjConduitsMenu.add(this.getInstallConduitMenuItem());
                this.ivjConduitsMenu.add(this.getRemoveConduitMenuItem());
                this.ivjConduitsMenu.add(this.getMenuSeparator2());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjConduitsMenu;
    }

    private MenuItem getDBInfoMenuItem() {
        if (this.ivjDBInfoMenuItem == null) {
            try {
                this.ivjDBInfoMenuItem = new MenuItem();
                this.ivjDBInfoMenuItem.setEnabled(false);
                this.ivjDBInfoMenuItem.setLabel(this.resEnglishStrings.getString("dbInfoMenuItem"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjDBInfoMenuItem;
    }

    private DatabaseViewer getdbViewer() {
        if (this.ivjdbViewer == null) {
            try {
                this.ivjdbViewer = new DatabaseViewer((Frame)this, this.resEnglishStrings);
                this.ivjdbViewer.setName("dbViewer");
                this.ivjdbViewer.setModal(true);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjdbViewer;
    }

    public DefaultConduit getDefaultConduit(Synchronizer s) {
        return this.registry.getDefaultConduit();
    }

    private CheckboxMenuItem getdisablePopups() {
        if (this.ivjdisablePopups == null) {
            try {
                this.ivjdisablePopups = new CheckboxMenuItem();
                this.ivjdisablePopups.setLabel(this.resEnglishStrings.getString("disablePopupsMenuItemString"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjdisablePopups;
    }

    private MenuItem getExtractDatabasesMenuItem() {
        if (this.ivjExtractDatabasesMenuItem == null) {
            try {
                this.ivjExtractDatabasesMenuItem = new MenuItem();
                this.ivjExtractDatabasesMenuItem.setLabel(this.resEnglishStrings.getString("extractDBs"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjExtractDatabasesMenuItem;
    }

    private FileDialog getFileDialog() {
        if (this.fileDlg == null) {
            try {
                this.fileDlg = new FileDialog(this);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.fileDlg;
    }

    private MenuBar getGetUserInfoMenuBar() {
        if (this.ivjGetUserInfoMenuBar == null) {
            try {
                this.ivjGetUserInfoMenuBar = new MenuBar();
                this.ivjGetUserInfoMenuBar.add(this.getSetupMenu());
                this.ivjGetUserInfoMenuBar.add(this.getInfoMenu());
                this.ivjGetUserInfoMenuBar.add(this.getBackupMenu());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjGetUserInfoMenuBar;
    }

    private Menu getInfoMenu() {
        if (this.ivjInfoMenu == null) {
            try {
                this.ivjInfoMenu = new Menu();
                this.ivjInfoMenu.setLabel(this.resEnglishStrings.getString("infoMenuString"));
                this.ivjInfoMenu.add(this.getUserInfoMenuItem());
                if (this.dbViewerEnabled) {
                    this.ivjInfoMenu.add(this.getDBInfoMenuItem());
                }
                this.ivjInfoMenu.add(this.getConduitsMenu());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjInfoMenu;
    }

    private MenuItem getInstallConduitMenuItem() {
        if (this.ivjInstallConduitMenuItem == null) {
            try {
                this.ivjInstallConduitMenuItem = new MenuItem();
                this.ivjInstallConduitMenuItem.setLabel(this.resEnglishStrings.getString("installConduit"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjInstallConduitMenuItem;
    }

    public ResourceBundle getLanguageBundle() {
        return this.resEnglishStrings;
    }

    private TextField getlastGoodSyncField() {
        if (this.ivjlastGoodSyncField == null) {
            try {
                this.ivjlastGoodSyncField = new TextField();
                this.ivjlastGoodSyncField.setName("lastGoodSyncField");
                this.ivjlastGoodSyncField.setEditable(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjlastGoodSyncField;
    }

    private Label getLastGoodSyncLabel() {
        if (this.ivjLastGoodSyncLabel == null) {
            try {
                this.ivjLastGoodSyncLabel = new Label();
                this.ivjLastGoodSyncLabel.setName("LastGoodSyncLabel");
                this.ivjLastGoodSyncLabel.setText(this.resEnglishStrings.getString("uinfoLastGoodSyncString"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjLastGoodSyncLabel;
    }

    private TextField getlastSyncField() {
        if (this.ivjlastSyncField == null) {
            try {
                this.ivjlastSyncField = new TextField();
                this.ivjlastSyncField.setName("lastSyncField");
                this.ivjlastSyncField.setText(this.resEnglishStrings.getString("uinfoPressHSMsgString"));
                this.ivjlastSyncField.setEditable(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjlastSyncField;
    }

    private Label getLastSyncLabel() {
        if (this.ivjLastSyncLabel == null) {
            try {
                this.ivjLastSyncLabel = new Label();
                this.ivjLastSyncLabel.setName("LastSyncLabel");
                this.ivjLastSyncLabel.setText(this.resEnglishStrings.getString("uinfoLastSyncString"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjLastSyncLabel;
    }

    private MenuItem getLogFrameMenuItem() {
        if (this.logFrameMenuItem == null) {
            try {
                this.logFrameMenuItem = new MenuItem();
                this.logFrameMenuItem.setLabel(this.resEnglishStrings.getString("logMenuItem"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.logFrameMenuItem;
    }

    private Panel getMainPanel() {
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        GridBagConstraints gridbagconstraints1 = new GridBagConstraints();
        GridBagConstraints gridbagconstraints2 = new GridBagConstraints();
        if (this.ivjMainPanel == null) {
            try {
                this.ivjMainPanel = new Panel();
                this.ivjMainPanel.setName("MainPanel");
                this.ivjMainPanel.setLayout(new GridBagLayout());
                gridbagconstraints.gridx = 0;
                gridbagconstraints.gridy = 0;
                gridbagconstraints.gridwidth = 1;
                gridbagconstraints.gridheight = 1;
                gridbagconstraints.anchor = 10;
                gridbagconstraints.weightx = 0.0;
                gridbagconstraints.weighty = 0.0;
                this.getMainPanel().add((Component)this.getMainTitleLabel(), gridbagconstraints);
                gridbagconstraints1.gridx = 0;
                gridbagconstraints1.gridy = 1;
                gridbagconstraints1.gridwidth = 1;
                gridbagconstraints1.gridheight = 1;
                gridbagconstraints1.anchor = 10;
                gridbagconstraints1.weightx = 0.0;
                gridbagconstraints1.weighty = 0.0;
                this.getMainPanel().add((Component)this.getVersionLabel(), gridbagconstraints1);
                gridbagconstraints2.gridx = 0;
                gridbagconstraints2.gridy = 2;
                gridbagconstraints2.gridwidth = 1;
                gridbagconstraints2.gridheight = 1;
                gridbagconstraints2.anchor = 10;
                gridbagconstraints2.weightx = 0.0;
                gridbagconstraints2.weighty = 0.0;
                this.getMainPanel().add((Component)this.getAuthorLabel(), gridbagconstraints2);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjMainPanel;
    }

    private Label getMainTitleLabel() {
        if (this.ivjMainTitleLabel == null) {
            try {
                this.ivjMainTitleLabel = new Label();
                this.ivjMainTitleLabel.setName("MainTitleLabel");
                this.ivjMainTitleLabel.setFont(new Font("serif", 2, 36));
                this.ivjMainTitleLabel.setAlignment(1);
                this.ivjMainTitleLabel.setText(this.resEnglishStrings.getString("jHotSyncTitle"));
                this.ivjMainTitleLabel.setForeground(Color.red);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjMainTitleLabel;
    }

    private MenuItem getMenuSeparator1() {
        if (this.ivjMenuSeparator1 == null) {
            try {
                this.ivjMenuSeparator1 = new MenuItem();
                this.ivjMenuSeparator1.setLabel("-");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjMenuSeparator1;
    }

    private MenuItem getMenuSeparator2() {
        if (this.ivjMenuSeparator2 == null) {
            try {
                this.ivjMenuSeparator2 = new MenuItem();
                this.ivjMenuSeparator2.setLabel("-");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjMenuSeparator2;
    }

    public DLPUserInfo getNewUserInfo(Synchronizer s) {
        UserNameEntryDialog usernameentrydialog = this.getUserNameEntryDialog();
        usernameentrydialog.show();
        int j = (int)(Math.random() * 10000.0);
        DLPUserInfo userInfo = new DLPUserInfo(j, 1123, 1597, usernameentrydialog.getUserName());
        this.getuserNameField().setText(userInfo.getUserName());
        this.getuserIDField().setText("" + userInfo.getUserID());
        this.getlastSyncField().setText("none");
        this.getlastGoodSyncField().setText("none");
        return userInfo;
    }

    private Button getokButton() {
        if (this.ivjokButton == null) {
            try {
                this.ivjokButton = new Button();
                this.ivjokButton.setName("okButton");
                this.ivjokButton.setLabel(this.resEnglishStrings.getString("uinfoButtonString"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjokButton;
    }

    private Menu getOptionsMenu() {
        if (this.ivjMenu3 == null) {
            try {
                this.ivjMenu3 = new Menu();
                this.ivjMenu3.setLabel(this.resEnglishStrings.getString("optionsMenuItemString"));
                this.ivjMenu3.add(this.getdisablePopups());
                this.ivjMenu3.add(this.getautoHidePopups());
                this.ivjMenu3.add(this.getUseSyncFrameMenuItem());
                this.ivjMenu3.add(this.getTimeSyncMenuItem());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjMenu3;
    }

    boolean getPopupState() {
        return this.getdisablePopups().getState();
    }

    private MenuItem getQuitMenuItem() {
        if (this.ivjQuitMenuItem == null) {
            try {
                this.ivjQuitMenuItem = new MenuItem();
                this.ivjQuitMenuItem.setLabel(this.resEnglishStrings.getString("quitMenuItemString"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjQuitMenuItem;
    }

    private RemoveConduitDialog getRemoveConduit() {
        if (this.ivjRemoveConduit == null) {
            try {
                this.ivjRemoveConduit = new RemoveConduitDialog(this, this.messageDlg, this.resEnglishStrings);
                this.ivjRemoveConduit.setName("RemoveConduit");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        this.ivjRemoveConduit.setConduitVector(this.registry.getConduits());
        return this.ivjRemoveConduit;
    }

    private MenuItem getRemoveConduitMenuItem() {
        if (this.ivjRemoveConduitMenuItem == null) {
            try {
                this.ivjRemoveConduitMenuItem = new MenuItem();
                this.ivjRemoveConduitMenuItem.setLabel(this.resEnglishStrings.getString("removeConduit"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjRemoveConduitMenuItem;
    }

    private CheckboxMenuItem getRestoreMenuItem() {
        if (this.ivjRestoreMenuItem == null) {
            try {
                this.ivjRestoreMenuItem = new CheckboxMenuItem();
                this.ivjRestoreMenuItem.setLabel(this.resEnglishStrings.getString("restoreMenuItem"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjRestoreMenuItem;
    }

    private MenuItem getSecurityDialogMenuItem() {
        if (this.securityDialogMenuItem == null) {
            try {
                this.securityDialogMenuItem = new MenuItem();
                this.securityDialogMenuItem.setLabel(this.resEnglishStrings.getString("securityMenuItem"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.securityDialogMenuItem;
    }

    private SecurityDialog getSecurityDlg() {
        if (this.securityDlg == null) {
            try {
                this.securityDlg = new SecurityDialog((Frame)this, this.resEnglishStrings);
                this.securityDlg.setManager(this);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.securityDlg;
    }

    private MenuItem getSerialPortSelectionMenuItem() {
        if (this.ivjSerialPortSelectionMenuItem == null) {
            try {
                this.ivjSerialPortSelectionMenuItem = new MenuItem();
                this.ivjSerialPortSelectionMenuItem.setLabel(this.resEnglishStrings.getString("serialPortMenuItemString"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSerialPortSelectionMenuItem;
    }

    private Menu getSetupMenu() {
        if (this.ivjSetupMenu == null) {
            try {
                this.ivjSetupMenu = new Menu();
                this.ivjSetupMenu.setLabel(this.resEnglishStrings.getString("setupMenu"));
                this.ivjSetupMenu.add(this.getSerialPortSelectionMenuItem());
                this.ivjSetupMenu.add(this.getSecurityDialogMenuItem());
                this.ivjSetupMenu.add(this.getLogFrameMenuItem());
                this.ivjSetupMenu.add(this.getOptionsMenu());
                this.ivjSetupMenu.add(this.getMenuSeparator1());
                this.ivjSetupMenu.add(this.getQuitMenuItem());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSetupMenu;
    }

    private SyncFrame getSyncFrame() {
        if (this.ivjSyncFrame == null) {
            try {
                this.ivjSyncFrame = new SyncFrame((Frame)this, this.getSyncPanel());
                this.ivjSyncFrame.setName("SyncFrame");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSyncFrame;
    }

    private SyncPanel getSyncPanel() {
        if (this.syncPanel == null) {
            try {
                this.syncPanel = new SyncPanel();
                this.syncPanel.setName("SyncPanel");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.syncPanel;
    }

    public int getSyncType(Synchronizer s) {
        if (this.getBackupMenuItem().getState()) {
            return 1;
        }
        if (this.getRestoreMenuItem().getState()) {
            return 2;
        }
        return 0;
    }

    private SyncWindow getSyncWindow() {
        if (this.ivjSyncWindow == null) {
            try {
                this.ivjSyncWindow = new SyncWindow(this, this.getSyncPanel());
                this.ivjSyncWindow.setName("SyncWindow");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSyncWindow;
    }

    private CheckboxMenuItem getTimeSyncMenuItem() {
        if (this.ivjTimeSyncMenuItem == null) {
            try {
                this.ivjTimeSyncMenuItem = new CheckboxMenuItem();
                this.ivjTimeSyncMenuItem.setLabel(this.resEnglishStrings.getString("timeSyncMenuItem"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjTimeSyncMenuItem;
    }

    private Panel getUserContentsPanel() {
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        GridBagConstraints gridbagconstraints1 = new GridBagConstraints();
        GridBagConstraints gridbagconstraints2 = new GridBagConstraints();
        GridBagConstraints gridbagconstraints3 = new GridBagConstraints();
        GridBagConstraints gridbagconstraints4 = new GridBagConstraints();
        GridBagConstraints gridbagconstraints5 = new GridBagConstraints();
        GridBagConstraints gridbagconstraints6 = new GridBagConstraints();
        GridBagConstraints gridbagconstraints7 = new GridBagConstraints();
        if (this.ivjUserContentsPanel == null) {
            try {
                this.ivjUserContentsPanel = new Panel();
                this.ivjUserContentsPanel.setName("UserContentsPanel");
                this.ivjUserContentsPanel.setLayout(new GridBagLayout());
                this.ivjUserContentsPanel.setBackground(Color.lightGray);
                this.ivjUserContentsPanel.setVisible(true);
                gridbagconstraints.gridx = 0;
                gridbagconstraints.gridy = 0;
                gridbagconstraints.gridwidth = 1;
                gridbagconstraints.gridheight = 1;
                gridbagconstraints.fill = 2;
                gridbagconstraints.anchor = 10;
                gridbagconstraints.weightx = 0.1;
                gridbagconstraints.weighty = 0.0;
                gridbagconstraints.insets = new Insets(0, 10, 0, 0);
                this.getUserContentsPanel().add((Component)this.getUserNameLabel(), gridbagconstraints);
                gridbagconstraints1.gridx = 1;
                gridbagconstraints1.gridy = 0;
                gridbagconstraints1.gridwidth = 1;
                gridbagconstraints1.gridheight = 1;
                gridbagconstraints1.fill = 2;
                gridbagconstraints1.anchor = 10;
                gridbagconstraints1.weightx = 0.45;
                gridbagconstraints1.weighty = 0.0;
                this.getUserContentsPanel().add((Component)this.getuserNameField(), gridbagconstraints1);
                gridbagconstraints2.gridx = 2;
                gridbagconstraints2.gridy = 0;
                gridbagconstraints2.gridwidth = 1;
                gridbagconstraints2.gridheight = 1;
                gridbagconstraints2.fill = 2;
                gridbagconstraints2.anchor = 10;
                gridbagconstraints2.weightx = 0.08;
                gridbagconstraints2.weighty = 0.0;
                gridbagconstraints2.insets = new Insets(0, 10, 0, 0);
                this.getUserContentsPanel().add((Component)this.getUserIDLabel(), gridbagconstraints2);
                gridbagconstraints3.gridx = 3;
                gridbagconstraints3.gridy = 0;
                gridbagconstraints3.gridwidth = 1;
                gridbagconstraints3.gridheight = 1;
                gridbagconstraints3.fill = 2;
                gridbagconstraints3.anchor = 10;
                gridbagconstraints3.weightx = 0.1;
                gridbagconstraints3.weighty = 0.0;
                this.getUserContentsPanel().add((Component)this.getuserIDField(), gridbagconstraints3);
                gridbagconstraints4.gridx = 0;
                gridbagconstraints4.gridy = 1;
                gridbagconstraints4.gridwidth = 1;
                gridbagconstraints4.gridheight = 1;
                gridbagconstraints4.fill = 2;
                gridbagconstraints4.anchor = 10;
                gridbagconstraints4.weightx = 0.0;
                gridbagconstraints4.weighty = 0.0;
                gridbagconstraints4.insets = new Insets(0, 10, 0, 0);
                this.getUserContentsPanel().add((Component)this.getLastSyncLabel(), gridbagconstraints4);
                gridbagconstraints5.gridx = 1;
                gridbagconstraints5.gridy = 1;
                gridbagconstraints5.gridwidth = 3;
                gridbagconstraints5.gridheight = 1;
                gridbagconstraints5.fill = 2;
                gridbagconstraints5.anchor = 10;
                gridbagconstraints5.weightx = 0.0;
                gridbagconstraints5.weighty = 0.0;
                this.getUserContentsPanel().add((Component)this.getlastSyncField(), gridbagconstraints5);
                gridbagconstraints6.gridx = 0;
                gridbagconstraints6.gridy = 2;
                gridbagconstraints6.gridwidth = 1;
                gridbagconstraints6.gridheight = 1;
                gridbagconstraints6.fill = 2;
                gridbagconstraints6.anchor = 10;
                gridbagconstraints6.weightx = 0.0;
                gridbagconstraints6.weighty = 0.0;
                gridbagconstraints6.insets = new Insets(0, 10, 0, 0);
                this.getUserContentsPanel().add((Component)this.getLastGoodSyncLabel(), gridbagconstraints6);
                gridbagconstraints7.gridx = 1;
                gridbagconstraints7.gridy = 2;
                gridbagconstraints7.gridwidth = 3;
                gridbagconstraints7.gridheight = 1;
                gridbagconstraints7.fill = 2;
                gridbagconstraints7.anchor = 10;
                gridbagconstraints7.weightx = 0.0;
                gridbagconstraints7.weighty = 0.0;
                this.getUserContentsPanel().add((Component)this.getlastGoodSyncField(), gridbagconstraints7);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjUserContentsPanel;
    }

    private TextField getuserIDField() {
        if (this.ivjuserIDField == null) {
            try {
                this.ivjuserIDField = new TextField();
                this.ivjuserIDField.setName("userIDField");
                this.ivjuserIDField.setEditable(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjuserIDField;
    }

    private Label getUserIDLabel() {
        if (this.ivjUserIDLabel == null) {
            try {
                this.ivjUserIDLabel = new Label();
                this.ivjUserIDLabel.setName("UserIDLabel");
                this.ivjUserIDLabel.setText(this.resEnglishStrings.getString("uinfoIDNumString"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjUserIDLabel;
    }

    int getUserIDNumber() {
        try {
            return Integer.parseInt(this.getuserIDField().getText());
        }
        catch (Exception e) {
            return 0;
        }
    }

    private Dialog getuserInfoDlg() {
        if (this.ivjuserInfoDlg == null) {
            try {
                this.ivjuserInfoDlg = new Dialog(this);
                this.ivjuserInfoDlg.setName("userInfoDlg");
                this.ivjuserInfoDlg.setLayout(new BorderLayout());
                ((Component)this.ivjuserInfoDlg).setBounds(398, 289, 376, 147);
                this.ivjuserInfoDlg.setTitle(this.resEnglishStrings.getString("userInfoDlgString"));
                this.getuserInfoDlg().add((Component)this.getokButton(), "South");
                this.getuserInfoDlg().add((Component)this.getUserContentsPanel(), "Center");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjuserInfoDlg;
    }

    private MenuItem getUserInfoMenuItem() {
        if (this.ivjUserInfoMenuItem == null) {
            try {
                this.ivjUserInfoMenuItem = new MenuItem();
                this.ivjUserInfoMenuItem.setEnabled(false);
                this.ivjUserInfoMenuItem.setLabel(this.resEnglishStrings.getString("userInfoMenuItemString"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjUserInfoMenuItem;
    }

    UserNameEntryDialog getUserNameEntryDialog() {
        return new UserNameEntryDialog((Frame)this, this.resEnglishStrings);
    }

    private TextField getuserNameField() {
        if (this.ivjuserNameField == null) {
            try {
                this.ivjuserNameField = new TextField();
                this.ivjuserNameField.setName("userNameField");
                this.ivjuserNameField.setEditable(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjuserNameField;
    }

    private Label getUserNameLabel() {
        if (this.ivjUserNameLabel == null) {
            try {
                this.ivjUserNameLabel = new Label();
                this.ivjUserNameLabel.setName("UserNameLabel");
                this.ivjUserNameLabel.setText(this.resEnglishStrings.getString("uinfoUserNameString"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjUserNameLabel;
    }

    private CheckboxMenuItem getUseSyncFrameMenuItem() {
        if (this.ivjUseSyncFrame == null) {
            try {
                this.ivjUseSyncFrame = new CheckboxMenuItem();
                this.ivjUseSyncFrame.setLabel(this.resEnglishStrings.getString("UseSyncFrameMenuItem"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjUseSyncFrame;
    }

    private Label getVersionLabel() {
        if (this.ivjVersionLabel == null) {
            try {
                this.ivjVersionLabel = new Label();
                this.ivjVersionLabel.setName("VersionLabel");
                this.ivjVersionLabel.setAlignment(1);
                this.ivjVersionLabel.setText(this.resEnglishStrings.getString("versionString") + Synchronizer.getVersion());
                this.ivjVersionLabel.setForeground(Color.blue);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjVersionLabel;
    }

    private void handleConduitMenuSelection(ActionEvent actionevent) {
        int i = 0;
        while (i < this.registry.getConduitCount()) {
            if (actionevent.getActionCommand().equals(this.registry.getConduit(i).getConduitName())) {
                if (this.registry.getConduit(i).getConfigurationPanel() == null) break;
                JFrame tempFrame = new JFrame(this.registry.getConduit(i).getConduitName());
                tempFrame.getContentPane().add(this.registry.getConduit(i).getConfigurationPanel());
                tempFrame.pack();
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                ((Component)tempFrame).setBounds((dimension.width - tempFrame.getBounds().width) / 2, (dimension.height - tempFrame.getBounds().height) / 2, tempFrame.getBounds().width, tempFrame.getBounds().height);
                tempFrame.show();
                break;
            }
            ++i;
        }
    }

    private void handleException(Throwable throwable) {
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        throwable.printStackTrace(System.out);
    }

    private void initConnections() {
        this.addWindowListener(this);
        this.getSerialPortSelectionMenuItem().addActionListener(this);
        this.getQuitMenuItem().addActionListener(this);
        this.getUserInfoMenuItem().addActionListener(this);
        this.getuserInfoDlg().addWindowListener(this);
        this.getokButton().addActionListener(this);
        this.getautoHidePopups().addActionListener(this);
        this.getRestoreMenuItem().addItemListener(this);
        this.getBackupMenuItem().addItemListener(this);
        this.getInstallConduitMenuItem().addActionListener(this);
        this.getRemoveConduitMenuItem().addActionListener(this);
        this.getExtractDatabasesMenuItem().addActionListener(this);
        this.getSecurityDialogMenuItem().addActionListener(this);
        this.getUseSyncFrameMenuItem().addItemListener(this);
        this.getLogFrameMenuItem().addActionListener(this);
        this.messageDlg.getOkButton().addActionListener(this);
        this.getDBInfoMenuItem().addActionListener(this);
    }

    private void initialize() {
        String s = Synchronizer.getHomeDirectory();
        this.userPath = s.endsWith(File.separator) ? s : s + File.separator;
        this.registry = RegistrationData.loadRegistrationData();
        this.setName("GetUserInfo");
        this.setMenuBar(this.getGetUserInfoMenuBar());
        this.setLayout(new BorderLayout());
        ((Component)this).setSize(337, 140);
        this.setTitle(this.resEnglishStrings.getString("jHotSyncTitle"));
        this.add((Component)this.getMainPanel(), "Center");
        this.initConnections();
        try {
            URL resURL = this.getClass().getResource("Resources/Images/icon1.gif");
            if (resURL != null) {
                Image img = Toolkit.getDefaultToolkit().getImage(resURL);
                this.setIconImage(img);
            }
        }
        catch (Throwable ex) {
            // empty catch block
        }
        if (this.registry.getWindowPosition() != null) {
            ((Component)this).setBounds(this.registry.getWindowPosition());
        } else {
            this.pack();
        }
        this.getdisablePopups().setState(this.registry.getDisablePopups());
        this.getautoHidePopups().setState(this.registry.getManualHide());
        this.getUseSyncFrameMenuItem().setState(this.registry.useFrame());
        int i = 0;
        while (i < this.registry.getConduitCount()) {
            if (this.registry.getConduit(i).getConfigurationPanel() != null) {
                MenuItem menuitem = new MenuItem(this.registry.getConduit(i).getConduitName());
                this.conduitMenuItems.addElement(menuitem);
                menuitem.addActionListener(this);
                menuitem.setActionCommand(this.registry.getConduit(i).getConduitName());
                this.getConduitsMenu().add(menuitem);
            }
            ++i;
        }
        if (this.conduitMenuItems.size() > 0) {
            this.getConduitsMenu().setEnabled(true);
        }
        if (this.registry.getSyncTimeOption()) {
            this.getTimeSyncMenuItem().setState(true);
        }
        this.log = new LogFrame(this.resEnglishStrings);
        int j = 0;
        while (j < this.registry.getNumAllowedIDs()) {
            this.getSecurityDlg().addNewID(this.registry.getAllowedIDs()[j]);
            ++j;
        }
        this.getSecurityDlg().setSecurityOption(this.registry.getSecurityEnabled());
        ConduitHandler.setFrameHandle(this);
        this.transport = this.registry.getTransport();
        if (this.transport == null) {
            this.getcommSelectDlg().show();
            this.transport = this.getcommSelectDlg().getSelectedTransport();
        }
        this.sync = new Synchronizer(this.transport, this);
        this.sync.setLogStream(this.logStream);
        this.sync.setStatusStream(this.statusStream);
        this.syncThread = new Thread(this.sync);
        this.syncThread.start();
        if (System.getProperty("jsyncman.hide") == null || !System.getProperty("jsyncman.hide").equals("true")) {
            ((Component)this).setVisible(true);
        }
    }

    boolean isModemListener() {
        return this.transport instanceof ModemTransport;
    }

    public void itemStateChanged(ItemEvent itemevent) {
        if (itemevent.getSource() == this.getRestoreMenuItem()) {
            this.connEtoM8(itemevent);
        }
        if (itemevent.getSource() == this.getBackupMenuItem()) {
            this.connEtoM9(itemevent);
        }
        if (itemevent.getSource() == this.getUseSyncFrameMenuItem()) {
            this.switchSyncPanelType = true;
            return;
        }
    }

    public void midSync(Synchronizer s) {
        this.getSyncPanel().setSynchronizingEnabled(true);
        if (this.dbViewerEnabled) {
            Vector dbInfo = this.sync.getDBInfo();
            int i = 0;
            while (i < dbInfo.size()) {
                this.getdbViewer().addDBEntry((DLPDatabaseInfo)dbInfo.elementAt(i));
                ++i;
            }
        }
    }

    void postToLog(String s) {
        this.log.appendToLog(s);
    }

    public void processUser(DLPUserInfo userInfo, Synchronizer s) {
        this.getuserNameField().setText(userInfo.getUserName());
        this.getuserIDField().setText("" + userInfo.getUserID());
        this.getlastSyncField().setText(userInfo.getLastSyncDate().get(1) <= 1980 ? "none" : userInfo.getLastSyncDate().getTime().toString());
        this.getlastGoodSyncField().setText(userInfo.getLastSuccessfulSyncDate().get(1) <= 1980 ? "none" : userInfo.getLastSuccessfulSyncDate().getTime().toString());
    }

    void removeConduit(String s) {
        String temp = null;
        if (this.registry.getConduitCount() == 0) {
            return;
        }
        int i = 0;
        while (i < this.registry.getConduitCount()) {
            if (this.registry.getConduit(i).getConduitName().equals(s)) {
                if (this.registry.getConduit(i).getConfigurationPanel() != null) {
                    temp = new String(this.registry.getConduit(i).getConduitName());
                }
                this.registry.removeConduit(i);
                break;
            }
            ++i;
        }
        if (temp != null) {
            int j = 0;
            while (j < this.conduitMenuItems.size()) {
                if (((MenuItem)this.conduitMenuItems.elementAt(j)).getLabel().equals(temp)) {
                    this.getConduitsMenu().remove((MenuItem)this.conduitMenuItems.elementAt(j));
                }
                ++j;
            }
        }
    }

    private void restorePalm(File dir) {
        this.getRestoreMenuItem().setState(true);
        this.getBackupMenuItem().setState(false);
        this.restoreName = dir.getAbsolutePath();
    }

    void setStatus(String s) {
        this.getSyncPanel().setStatus(s);
    }

    public void startOfSync(Synchronizer s) {
        if (this.switchSyncPanelType) {
            this.syncPanel = null;
            this.ivjSyncWindow = null;
            this.ivjSyncFrame = null;
            this.switchSyncPanelType = false;
        }
        if (this.getautoHidePopups().getState()) {
            this.getSyncPanel().setHideVisible(true);
        } else {
            this.getSyncPanel().setHideVisible(false);
        }
        if (this.dbViewerEnabled) {
            this.getdbViewer().clearEntries();
        }
        this.getOptionsMenu().setEnabled(false);
        this.getSyncPanel().setConnectingEnabled(false);
        this.getSyncPanel().setSynchronizingEnabled(false);
        this.getSyncPanel().setDoneEnabled(false);
        this.getConduitsMenu().setEnabled(false);
        if (!this.getdisablePopups().getState()) {
            if (!this.getUseSyncFrameMenuItem().getState()) {
                ((Component)this.getSyncWindow()).setVisible(true);
            } else {
                ((Component)this.getSyncFrame()).setVisible(true);
            }
        }
        this.getSyncPanel().setConnectingEnabled(true);
    }

    public boolean useTimeSync(Synchronizer s) {
        return this.getTimeSyncMenuItem().getState();
    }

    public boolean validateUser(int userID, Synchronizer s) {
        return this.getSecurityDlg().idAllowed(userID);
    }

    public void windowActivated(WindowEvent windowevent) {
    }

    public void windowClosed(WindowEvent windowevent) {
    }

    public void windowClosing(WindowEvent windowevent) {
        if (windowevent.getSource() == this) {
            this.connEtoC1(windowevent);
        }
        if (windowevent.getSource() == this.getuserInfoDlg()) {
            this.connEtoM6(windowevent);
        }
    }

    public void windowDeactivated(WindowEvent windowevent) {
    }

    public void windowDeiconified(WindowEvent windowevent) {
    }

    public void windowIconified(WindowEvent windowevent) {
    }

    public void windowOpened(WindowEvent windowevent) {
    }

    public DLPDatabaseSet getRestoreDatabaseSet() {
        if (this.restoreName == null) {
            return null;
        }
        try {
            return new DLPDatabaseSet(this.restoreName);
        }
        catch (Exception e) {
            return null;
        }
    }

    class LogStream
    extends OutputStream {
        StringBuffer in;
        boolean type = false;

        public LogStream(boolean streamtype) {
            this.type = streamtype;
            this.in = new StringBuffer();
        }

        public void write(int b) throws IOException {
            if (b != 10 && b != 13) {
                this.in.append((char)b);
            } else {
                try {
                    if (this.in.charAt(0) == '\n' || this.in.charAt(0) == '\r') {
                        return;
                    }
                }
                catch (Throwable t) {
                    return;
                }
                if (this.type) {
                    JSyncManagerFrame.this.setStatus(this.in.toString());
                } else {
                    JSyncManagerFrame.this.postToLog(this.in.toString());
                }
                this.in = new StringBuffer();
            }
        }
    }
}

