/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.Client.LegacyClient;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import java.util.Vector;
import org.jSyncManager.API.Protocol.Util.DLPDatabaseInfo;

public class DatabaseViewer
extends Dialog
implements ActionListener,
ItemListener,
WindowListener {
    private Panel ivjContentsPane = null;
    private Choice ivjDBChoice = null;
    private TextArea ivjDBInfoArea = null;
    private Label ivjInfoLabel = null;
    private Vector dbList = new Vector();
    private Panel ivjInfoPanel = null;
    private Button ivjQuitButton = null;
    private ResourceBundle resLanguageStrings;

    public DatabaseViewer(Frame parent, ResourceBundle language) {
        super(parent);
        this.resLanguageStrings = language;
        this.initialize();
    }

    public void actionPerformed(ActionEvent actionevent) {
        if (actionevent.getSource() == this.getQuitButton()) {
            this.connEtoM1(actionevent);
        }
    }

    public void addDBEntry(DLPDatabaseInfo info) {
        this.dbList.addElement(info);
        this.getDBChoice().add(info.getName());
    }

    public void clearEntries() {
        this.getDBChoice().removeAll();
    }

    private void connEtoC1(WindowEvent windowevent) {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC2(ItemEvent itemevent) {
        try {
            this.dBChoice_ItemStateChanged(itemevent);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM1(ActionEvent actionevent) {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void dBChoice_ItemStateChanged(ItemEvent itemevent) {
        this.getDBInfoArea().setText(((DLPDatabaseInfo)this.dbList.elementAt(this.getDBChoice().getSelectedIndex())).toString());
    }

    private Panel getContentsPane() {
        if (this.ivjContentsPane == null) {
            try {
                this.ivjContentsPane = new Panel();
                this.ivjContentsPane.setName("ContentsPane");
                this.ivjContentsPane.setLayout(new BorderLayout());
                this.getContentsPane().add((Component)this.getDBInfoArea(), "Center");
                this.getContentsPane().add((Component)this.getInfoLabel(), "North");
                this.getContentsPane().add((Component)this.getInfoPanel(), "South");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjContentsPane;
    }

    private Choice getDBChoice() {
        if (this.ivjDBChoice == null) {
            try {
                this.ivjDBChoice = new Choice();
                this.ivjDBChoice.setName("DBChoice");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjDBChoice;
    }

    private TextArea getDBInfoArea() {
        if (this.ivjDBInfoArea == null) {
            try {
                this.ivjDBInfoArea = new TextArea();
                this.ivjDBInfoArea.setName("DBInfoArea");
                this.ivjDBInfoArea.setFont(new Font("monospaced", 0, 14));
                this.ivjDBInfoArea.setEnabled(true);
                this.ivjDBInfoArea.setEditable(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjDBInfoArea;
    }

    private Label getInfoLabel() {
        if (this.ivjInfoLabel == null) {
            try {
                this.ivjInfoLabel = new Label();
                this.ivjInfoLabel.setName("InfoLabel");
                this.ivjInfoLabel.setAlignment(1);
                this.ivjInfoLabel.setText("Please Select a Database to View from the Choice at Bottom.");
                this.ivjInfoLabel.setForeground(Color.blue);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjInfoLabel;
    }

    private Panel getInfoPanel() {
        if (this.ivjInfoPanel == null) {
            try {
                this.ivjInfoPanel = new Panel();
                this.ivjInfoPanel.setName("InfoPanel");
                this.ivjInfoPanel.setLayout(new BorderLayout());
                this.getInfoPanel().add((Component)this.getQuitButton(), "East");
                this.getInfoPanel().add((Component)this.getDBChoice(), "Center");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjInfoPanel;
    }

    private Button getQuitButton() {
        if (this.ivjQuitButton == null) {
            try {
                this.ivjQuitButton = new Button();
                this.ivjQuitButton.setName("QuitButton");
                this.ivjQuitButton.setLabel("Quit");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjQuitButton;
    }

    private void handleException(Throwable throwable) {
    }

    private void initConnections() {
        this.addWindowListener(this);
        this.getDBChoice().addItemListener(this);
        this.getQuitButton().addActionListener(this);
    }

    private void initialize() {
        this.setName("DatabaseViewer");
        this.setLayout(new BorderLayout());
        ((Component)this).setSize(591, 371);
        this.setTitle("Database Entry Viewer");
        this.add((Component)this.getContentsPane(), "Center");
        this.initConnections();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setBounds((dimension.width - 591) / 2, (dimension.height - 371) / 2, 591, 371);
    }

    public void itemStateChanged(ItemEvent itemevent) {
        if (itemevent.getSource() == this.getDBChoice()) {
            this.connEtoC2(itemevent);
        }
    }

    public void windowActivated(WindowEvent windowevent) {
    }

    public void windowClosed(WindowEvent windowevent) {
    }

    public void windowClosing(WindowEvent windowevent) {
        if (windowevent.getSource() == this) {
            this.connEtoC1(windowevent);
        }
    }

    public void windowDeactivated(WindowEvent windowevent) {
    }

    public void windowDeiconified(WindowEvent windowevent) {
    }

    public void windowIconified(WindowEvent windowevent) {
    }

    public void windowOpened(WindowEvent windowevent) {
    }
}

