/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.Client.LegacyClient;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ResourceBundle;
import org.jSyncManager.API.Threads.Synchronizer;
import org.jSyncManager.Client.LegacyClient.JSyncManagerFrame;

public class DBSetSelectDialog
extends Dialog
implements FilenameFilter {
    private Label ivjActionLabel = null;
    private Panel ivjButtonPanel = null;
    private Button ivjCancelButton = null;
    private Panel ivjContentsPane = null;
    private List ivjDBList = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private Button ivjOkButton = null;
    private static ResourceBundle resJSyncManResources = ResourceBundle.getBundle("org.jSyncManager.Client.LegacyClient.Resources.Text.JSyncManLegacyClientResources");
    private String baseDir;
    private String seperator = System.getProperty("file.separator");
    private JSyncManagerFrame jsparent;

    public DBSetSelectDialog(JSyncManagerFrame parent) {
        super(parent);
        this.jsparent = parent;
        this.initialize();
    }

    public boolean accept(File file, String name) {
        return file.isDirectory() & name.endsWith(".backup");
    }

    private void connEtoC1(WindowEvent arg1) {
        try {
            this.dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ItemEvent arg1) {
        try {
            this.dBList_ItemStateChanged();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1(ActionEvent arg1) {
        try {
            this.dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void dBList_ItemStateChanged() {
        this.getOkButton().setEnabled(this.getDBList().getSelectedIndex() != -1);
    }

    private Label getActionLabel() {
        if (this.ivjActionLabel == null) {
            try {
                this.ivjActionLabel = new Label();
                this.ivjActionLabel.setName("ActionLabel");
                this.ivjActionLabel.setAlignment(1);
                this.ivjActionLabel.setText(resJSyncManResources.getString("dbLoader_Restore"));
                this.ivjActionLabel.setForeground(SystemColor.windowText);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjActionLabel;
    }

    private Panel getButtonPanel() {
        if (this.ivjButtonPanel == null) {
            try {
                this.ivjButtonPanel = new Panel();
                this.ivjButtonPanel.setName("ButtonPanel");
                this.ivjButtonPanel.setLayout(new FlowLayout());
                this.getButtonPanel().add((Component)this.getOkButton(), this.getOkButton().getName());
                this.getButtonPanel().add((Component)this.getCancelButton(), this.getCancelButton().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonPanel;
    }

    private Button getCancelButton() {
        if (this.ivjCancelButton == null) {
            try {
                this.ivjCancelButton = new Button();
                this.ivjCancelButton.setName("CancelButton");
                this.ivjCancelButton.setLabel(resJSyncManResources.getString("cancelButton"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCancelButton;
    }

    private Panel getContentsPane() {
        if (this.ivjContentsPane == null) {
            try {
                this.ivjContentsPane = new Panel();
                this.ivjContentsPane.setName("ContentsPane");
                this.ivjContentsPane.setLayout(new BorderLayout());
                this.getContentsPane().add((Component)this.getButtonPanel(), "South");
                this.getContentsPane().add((Component)this.getDBList(), "Center");
                this.getContentsPane().add((Component)this.getActionLabel(), "North");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjContentsPane;
    }

    private List getDBList() {
        if (this.ivjDBList == null) {
            try {
                this.ivjDBList = new List(8);
                this.ivjDBList.setName("DBList");
                this.ivjDBList.setBackground(Color.white);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDBList;
    }

    public File getDBSet() {
        if (this.getDBList().getSelectedItem() == null) {
            return null;
        }
        return new File(this.baseDir + this.seperator + this.getDBList().getSelectedItem().replace(' ', '_') + ".backup");
    }

    Button getDlgOkButton() {
        return this.getOkButton();
    }

    private Button getOkButton() {
        if (this.ivjOkButton == null) {
            try {
                this.ivjOkButton = new Button();
                this.ivjOkButton.setName("OkButton");
                this.ivjOkButton.setEnabled(false);
                this.ivjOkButton.setLabel(resJSyncManResources.getString("uinfoButtonString"));
                this.ivjOkButton.addActionListener(this.jsparent);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOkButton;
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() throws Exception {
        this.addWindowListener(this.ivjEventHandler);
        this.getCancelButton().addActionListener(this.ivjEventHandler);
        this.getDBList().addItemListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("DBSetSelectDialog");
            this.setLayout(new BorderLayout());
            ((Component)this).setSize(426, 172);
            this.setTitle(resJSyncManResources.getString("dblist_Title"));
            this.add((Component)this.getContentsPane(), "Center");
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setBounds((dimension.width - this.getBounds().width) / 2, (dimension.height - this.getBounds().height) / 2, this.getBounds().width, this.getBounds().height);
        this.baseDir = Synchronizer.getHomeDirectory();
    }

    public void setLabelRes(String resID) {
        this.getActionLabel().setText(resJSyncManResources.getString(resID));
    }

    public void showMe() {
        this.getDBList().removeAll();
        String[] backupDirs = new File(this.baseDir).list(this);
        if (backupDirs == null || backupDirs.length == 0) {
            return;
        }
        int i = 0;
        while (i < backupDirs.length) {
            this.getDBList().add(backupDirs[i].replace('_', ' ').substring(0, backupDirs[i].indexOf(".backup")));
            ++i;
        }
        super.setVisible(true);
    }

    class IvjEventHandler
    implements ActionListener,
    ItemListener,
    WindowListener {
        IvjEventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DBSetSelectDialog.this.getCancelButton()) {
                DBSetSelectDialog.this.connEtoM1(e);
            }
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == DBSetSelectDialog.this.getDBList()) {
                DBSetSelectDialog.this.connEtoC2(e);
            }
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            if (e.getSource() == DBSetSelectDialog.this) {
                DBSetSelectDialog.this.connEtoC1(e);
            }
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }
    }
}

