/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.Client.LegacyClient;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import org.jSyncManager.API.Threads.Synchronizer;
import org.jSyncManager.API.Transport.SLPTransportInterface;
import org.jSyncManager.Client.GUIParts.DetailedErrorMessageDialog;

public class ComSelectDialog
extends JDialog
implements ItemListener,
ActionListener {
    private JRadioButton[] transportRadioBtns;
    private JPanel[] transportPanels;
    private ResourceBundle resources = ResourceBundle.getBundle("org.jSyncManager.Client.LegacyClient.Resources.Text.JSyncManLegacyClientResources");
    private CardLayout transPanelLayout = new CardLayout();
    private TitledBorder border1 = BorderFactory.createTitledBorder(this.resources.getString("transportDlgMsg"));
    private TitledBorder border2 = BorderFactory.createTitledBorder(this.resources.getString("transportSelection"));
    private JPanel radioBtnPanel = new JPanel();
    private JPanel transportsPanel = new JPanel();
    private JButton closeButton = new JButton(this.resources.getString("Security_button"));
    private SLPTransportInterface[] transports;

    public ComSelectDialog(Frame owner) throws Exception {
        super(owner);
        FileInputStream fis;
        this.setTitle(this.resources.getString("transportDlgTitle"));
        this.radioBtnPanel.setBorder(this.border1);
        this.transportsPanel.setBorder(this.border2);
        this.transportsPanel.setLayout(this.transPanelLayout);
        this.radioBtnPanel.setLayout(new GridLayout(0, 1));
        StringBuffer sb = new StringBuffer();
        String s = Synchronizer.getHomeDirectory();
        String s1 = System.getProperty("file.separator");
        sb.append(s);
        if (!s.endsWith(s1)) {
            sb.append(s1);
        }
        sb.append("jsyncman_transports.properties");
        File transFile = new File(sb.toString());
        if (!transFile.exists()) {
            FileWriter fw = new FileWriter(transFile);
            PrintWriter pw = new PrintWriter(fw);
            pw.println("# jSyncManager Transport Properties File\n");
            pw.println("jsyncman.transport.0=CommAPITransport\n");
            pw.println("jsyncman.transport.1=ModemTransport\n");
            pw.println("jsyncman.transport.2=JUSBTransport\n");
            pw.flush();
            fw.flush();
            pw.close();
            fw.close();
        }
        try {
            fis = new FileInputStream(transFile);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(null, this.resources.getString("comselect.transpropfoferr"), this.resources.getString("comselect.transpropfoftitle"), 0);
            throw new Exception("File \"jsyncman_transports.properties\" not found!");
        }
        Properties props = new Properties();
        props.load(fis);
        int i = 0;
        Vector<String> values = new Vector<String>();
        String last = null;
        while ((last = props.getProperty("jsyncman.transport." + i)) != null) {
            values.addElement(last);
            ++i;
        }
        if (i == 0) {
            JOptionPane.showMessageDialog(null, this.resources.getString("comselect.notransports"), this.resources.getString("comselect.transpropfoftitle"), 0);
            throw new Exception("File \"jsyncman_transports.properties\" contains no transports!");
        }
        Vector v1 = new Vector();
        int j = 0;
        while (j < i) {
            try {
                Class<?> c = Class.forName("org.jSyncManager.Transport." + values.elementAt(j));
                v1.addElement(c.newInstance());
            }
            catch (Throwable t) {
                System.err.println(t.toString());
            }
            ++j;
        }
        if (v1.size() == 0) {
            JOptionPane.showMessageDialog(null, this.resources.getString("comselect.notransportsfound"), this.resources.getString("comselect.transpropfoftitle"), 0);
            throw new Exception("Couldn't find any of the transports listed in file \"jsyncman_transports.properties\"!");
        }
        this.transportRadioBtns = new JRadioButton[v1.size()];
        this.transportPanels = new JPanel[v1.size()];
        this.transports = new SLPTransportInterface[v1.size()];
        ButtonGroup bg = new ButtonGroup();
        i = 0;
        while (i < v1.size()) {
            this.transports[i] = (SLPTransportInterface)v1.elementAt(i);
            this.transportRadioBtns[i] = new JRadioButton(this.transports[i].getTransportName());
            this.transportPanels[i] = this.transports[i].getConfigPanel();
            bg.add(this.transportRadioBtns[i]);
            this.radioBtnPanel.add(this.transportRadioBtns[i]);
            this.transportsPanel.add((Component)this.transportPanels[i], this.transports[i].getTransportName());
            this.transportRadioBtns[i].addItemListener(this);
            ++i;
        }
        this.closeButton.addActionListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.radioBtnPanel, "North");
        this.getContentPane().add((Component)this.transportsPanel, "Center");
        this.getContentPane().add((Component)this.closeButton, "South");
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setBounds((dimension.width - this.getBounds().width) / 2, (dimension.height - this.getBounds().height) / 2, this.getBounds().width, this.getBounds().height);
        this.transportRadioBtns[0].doClick();
    }

    public void actionPerformed(ActionEvent e) {
        if ((JButton)e.getSource() == this.closeButton) {
            try {
                this.getSelectedTransport().initialize();
                ((Component)this).setVisible(false);
            }
            catch (Throwable t) {
                DetailedErrorMessageDialog demd = new DetailedErrorMessageDialog(this.resources.getString("comselect.transportiniterrortitle"));
                demd.setErrorText(this.resources.getString("comselect.transportiniterrortext"));
                demd.setDescriptionText(this.resources.getString("comselect.transportiniterrordesc"));
                demd.setDetailsText(t.toString());
                demd.show();
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        JRadioButton btn = (JRadioButton)e.getItem();
        if (e.getStateChange() == 1) {
            this.transPanelLayout.show(this.transportsPanel, btn.getText());
        }
    }

    public SLPTransportInterface getSelectedTransport() {
        int i = 0;
        while (i < this.transports.length) {
            if (this.transportRadioBtns[i].isSelected()) {
                return this.transports[i];
            }
            ++i;
        }
        return null;
    }
}

