/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.Client.GUIParts;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class DetailedErrorMessageDialog
extends JDialog {
    private ResourceBundle resources = ResourceBundle.getBundle("org.jSyncManager.Client.Resources.Text.JSyncManClientResources");
    private String descriptionName = this.resources.getString("detailederror.description");
    private String errorName = this.resources.getString("detailederror.error");
    private String showDetailsName = this.resources.getString("detailederror.showdetails");
    private String hideDetailsName = this.resources.getString("detairederror.hidedetails");
    private String okName = this.resources.getString("ok_button");
    private JLabel errorLabel;
    private JLabel descriptionLabel;
    private JTextArea detailedMessageTextArea;
    private JScrollPane detailedMessageTextAreaScrollPane;
    private JButton detailsButton;
    private JButton okButton;
    private String detailedMessage;
    private String description;
    private String error;

    public DetailedErrorMessageDialog() {
        this.createFields();
        this.createPanels();
        this.pack();
        this.setDefaultCloseOperation(2);
    }

    public DetailedErrorMessageDialog(String title) {
        this();
        this.setTitle(title);
    }

    private void createFields() {
        this.errorLabel = new JLabel();
        this.descriptionLabel = new JLabel();
        this.okButton = new JButton(this.okName);
        this.detailsButton = new JButton(this.showDetailsName);
        this.detailedMessageTextArea = new JTextArea();
        this.detailedMessageTextArea.setLineWrap(true);
        this.detailedMessageTextArea.setWrapStyleWord(true);
        this.detailedMessageTextAreaScrollPane = new JScrollPane(this.detailedMessageTextArea);
        this.detailedMessageTextAreaScrollPane.setBorder(new EmptyBorder(5, 5, 0, 5));
        this.detailedMessageTextAreaScrollPane.setVisible(false);
        this.detailsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DetailedErrorMessageDialog.this.setDetailedMessageVisible(!DetailedErrorMessageDialog.this.detailedMessageTextAreaScrollPane.isVisible());
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DetailedErrorMessageDialog.this.dispose();
            }
        });
    }

    private void createPanels() {
        JPanel rootPanel = new JPanel();
        rootPanel.setLayout(new BorderLayout());
        this.getContentPane().add(rootPanel);
        JPanel mainPanel = new JPanel();
        BoxLayout layout = new BoxLayout(mainPanel, 1);
        mainPanel.setLayout(layout);
        mainPanel.setBorder(new EmptyBorder(5, 5, 0, 5));
        JPanel labelPanel = new JPanel();
        BoxLayout labelLayout = new BoxLayout(labelPanel, 1);
        labelPanel.setLayout(labelLayout);
        JPanel buttonPanel = new JPanel();
        FlowLayout flowLayout = (FlowLayout)buttonPanel.getLayout();
        flowLayout.setAlignment(2);
        labelPanel.setAlignmentX(0.0f);
        buttonPanel.setAlignmentX(0.0f);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.detailsButton);
        labelPanel.add(this.errorLabel);
        labelPanel.add(Box.createVerticalStrut(10));
        labelPanel.add(this.descriptionLabel);
        labelPanel.add(Box.createVerticalStrut(10));
        mainPanel.add(labelPanel);
        mainPanel.add(buttonPanel);
        rootPanel.add((Component)mainPanel, "North");
        rootPanel.add((Component)this.detailedMessageTextAreaScrollPane, "Center");
    }

    private void refresh() {
        this.pack();
        this.validate();
    }

    public void setDetailsText(String message) {
        this.detailedMessageTextArea.setText(message);
        this.refresh();
    }

    public void setDetailsText(Throwable t) {
        this.setDetailsText(t.toString());
    }

    public void setDescriptionText(String description) {
        this.setLabelText(this.descriptionLabel, this.descriptionName, description);
    }

    public void setErrorText(String error) {
        this.setLabelText(this.errorLabel, this.errorName, error);
    }

    public void setErrorText(Throwable error) {
        this.setLabelText(this.errorLabel, this.errorName, error.toString());
    }

    private void setLabelText(JLabel label, String preface, String text) {
        text = this.addLineBreaks(text, preface);
        label.setText("<HTML><BODY>" + preface + text + "</BODY></HTML>");
        this.refresh();
    }

    private String addLineBreaks(String text, String preface) {
        StringTokenizer tokenizer = new StringTokenizer(text, " ", true);
        StringBuffer buffer = new StringBuffer();
        StringBuffer line = new StringBuffer();
        boolean isFirstLine = true;
        int columnCount = 50 - preface.length();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (line.length() + token.length() > columnCount && line.length() > 0) {
                buffer.append(line.toString() + "<BR>");
                line = new StringBuffer();
                if (isFirstLine) {
                    columnCount = 50;
                    isFirstLine = false;
                }
            }
            line.append(token);
        }
        buffer.append(line.toString());
        return buffer.toString();
    }

    private void setDetailedMessageVisible(boolean show) {
        this.detailedMessageTextAreaScrollPane.setVisible(show);
        if (show) {
            ((Component)this).setSize(this.getWidth(), this.getHeight() + 150);
            this.detailsButton.setText(this.hideDetailsName);
        } else {
            this.detailsButton.setText(this.showDetailsName);
            int oldWidth = this.getWidth();
            this.pack();
            ((Component)this).setSize(oldWidth, this.getHeight());
        }
        this.validate();
    }
}

