/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Transport;

import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import org.jSyncManager.API.Transport.TransportException;

public abstract class SLPTransportInterface
implements Serializable {
    protected transient JPanel configPanel = null;
    protected transient ResourceBundle resBundle = null;
    protected transient boolean connected = false;

    public SLPTransportInterface() throws TransportException {
        this.loadResourceBundle();
    }

    public abstract void close() throws TransportException;

    public abstract void flush() throws TransportException;

    public abstract String getTransportName();

    public abstract void open() throws TransportException;

    public abstract byte readByte();

    public abstract void writeBytes(byte[] var1);

    public final JPanel getConfigPanel() {
        if (this.configPanel == null) {
            this.configPanel = this.constructConfigPanel();
        }
        return this.configPanel;
    }

    protected abstract JPanel constructConfigPanel();

    public abstract void initialize() throws TransportException;

    public abstract void initialize(Properties var1, int var2) throws TransportException;

    public abstract String getTransportExceptionText(TransportException var1);

    public abstract String getResourceBundleName();

    public final void loadResourceBundle() throws TransportException {
        try {
            if (this.resBundle == null) {
                String tmpname = this.getResourceBundleName();
                this.resBundle = ResourceBundle.getBundle(tmpname);
            }
        }
        catch (MissingResourceException e) {
            throw new TransportException(e);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected void setConnected(boolean connected) {
        this.connected = connected;
    }
}

