/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Tools;

public class UnsignedByte {
    private UnsignedByte() {
    }

    public static byte increment(byte b) {
        if (b == 127) {
            return -128;
        }
        b = (byte)(b + 1);
        return b;
    }

    public static int intValue(byte b) {
        if (b >= 0) {
            return b;
        }
        return 256 + b;
    }

    public static String toString(byte b) {
        int i = UnsignedByte.intValue(b);
        char c = i / 16 < 10 ? (char)(i / 16 + 48) : (char)(i / 16 + 55);
        char c1 = i % 16 < 10 ? (char)(i % 16 + 48) : (char)(i % 16 + 55);
        return new String("" + c + "" + c1);
    }

    public static char unsignedBytes2Char(byte b1, byte b2) {
        return (char)(UnsignedByte.intValue(b1) * 256 + UnsignedByte.intValue(b2));
    }

    public static int unsignedBytes2Int(byte b1, byte b2, byte b3, byte b4) {
        return UnsignedByte.intValue(b1) * 0x1000000 + UnsignedByte.intValue(b2) * 65536 + UnsignedByte.intValue(b3) * 256 + UnsignedByte.intValue(b4);
    }

    public static String toString(byte[] b, int length) {
        int j;
        int i = 0;
        int startOfLine = 0;
        StringBuffer sb = new StringBuffer();
        while (i < length && i < b.length) {
            sb.append(UnsignedByte.toString(b[i]));
            sb.append(' ');
            if ((i + 1) % 8 == 0 && i != 0) {
                sb.append("| ");
            }
            if ((i + 1) % 16 == 0 && i != 0) {
                j = startOfLine;
                while (j < startOfLine + 16) {
                    if (b[j] >= 32 && b[j] < 127) {
                        sb.append((char)b[j]);
                    } else {
                        sb.append('.');
                    }
                    ++j;
                }
                startOfLine += 16;
                sb.append('\n');
            }
            ++i;
        }
        int bytesInLine = b.length % 16;
        int charsInLine = bytesInLine * 3;
        if (bytesInLine >= 8) {
            charsInLine += 2;
        }
        if (charsInLine != 0) {
            j = 0;
            while (j < 50 - charsInLine) {
                sb.append(' ');
                ++j;
            }
            sb.append("| ");
            j = startOfLine;
            while (j < length) {
                if (b[j] >= 32 && b[j] < 127) {
                    sb.append((char)b[j]);
                } else {
                    sb.append('.');
                }
                ++j;
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String toString(byte[] b) {
        return UnsignedByte.toString(b, b.length);
    }
}

