/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Threads;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.jSyncManager.API.Conduit.AbstractConduit;
import org.jSyncManager.API.Conduit.ConduitHandler;
import org.jSyncManager.API.Conduit.ConduitManager;
import org.jSyncManager.API.Conduit.DatabaseNotFoundException;
import org.jSyncManager.API.Protocol.DLPFunctionCallException;
import org.jSyncManager.API.Protocol.JHotSync;
import org.jSyncManager.API.Protocol.NotConnectedException;
import org.jSyncManager.API.Protocol.Util.DLPBlock;
import org.jSyncManager.API.Protocol.Util.DLPDatabase;
import org.jSyncManager.API.Protocol.Util.DLPDatabaseInfo;
import org.jSyncManager.API.Protocol.Util.DLPDatabaseListGroup;
import org.jSyncManager.API.Protocol.Util.DLPDatabaseSet;
import org.jSyncManager.API.Protocol.Util.DLPRecord;
import org.jSyncManager.API.Protocol.Util.DLPResource;
import org.jSyncManager.API.Protocol.Util.DLPStorageInfo;
import org.jSyncManager.API.Protocol.Util.DLPSystemInfo;
import org.jSyncManager.API.Protocol.Util.DLPUserInfo;
import org.jSyncManager.API.Protocol.Util.DLPVersion;
import org.jSyncManager.API.Threads.SynchronizerListener;
import org.jSyncManager.API.Transport.SLPTransportInterface;
import org.jSyncManager.API.Transport.SerialTransportInterface;
import org.jSyncManager.Transport.ModemTransport;

public class Synchronizer
implements Runnable,
ConduitManager {
    public static final int NORMAL_SYNC = 0;
    public static final int BACKUP_SYNC = 1;
    public static final int RESTORE_SYNC = 2;
    protected static final String version = "$Revision: 2.94 $";
    public static final String author = new String("The jSyncManager Team <http://www.jsyncmanager.org>");
    protected static final String state = "$State: Exp $";
    public PrintWriter statusStream = null;
    public PrintWriter logStream = null;
    public volatile boolean running = true;
    private SynchronizerListener parent = null;
    private JHotSync jhsHandler = null;
    private SLPTransportInterface transport;
    private DLPUserInfo userInfo;
    private Vector databaseInfo = new Vector();
    private DLPSystemInfo sysInfo;
    private DLPStorageInfo storInfo;
    private DLPDatabaseListGroup dbList;
    private String userPath = Synchronizer.getHomeDirectory();
    private boolean initializing = false;
    private StringBuffer palmSyncLogBuffer = null;
    private ConduitList root;
    private static String homeDirectory = null;
    private long startTime = 0L;

    protected Synchronizer() {
    }

    public Synchronizer(SLPTransportInterface transport, SynchronizerListener listener) {
        this();
        this.transport = transport;
        this.parent = listener;
        this.jhsHandler = new JHotSync(transport);
        if (transport instanceof SerialTransportInterface) {
            this.jhsHandler.setSpeed(((SerialTransportInterface)transport).getPreferredSyncSpeed());
        }
    }

    public synchronized void appendToPalmSyncLog(String text) {
        if (this.palmSyncLogBuffer == null) {
            this.palmSyncLogBuffer = new StringBuffer();
        }
        this.palmSyncLogBuffer.append(text);
        this.palmSyncLogBuffer.append("\n");
    }

    private void backupSync() throws NotConnectedException {
        int l = this.databaseInfo.size();
        byte byte0 = 0;
        DLPDatabaseSet dlpdatabaseset = new DLPDatabaseSet();
        this.setStatus("Starting PalmPilot Backup...");
        int i = 0;
        while (i < l) {
            if (Thread.currentThread().isInterrupted()) {
                this.setStatus("Synchronization canceled by thread interruption.");
                this.running = false;
                break;
            }
            DLPDatabaseInfo dlpdatabaseinfo = (DLPDatabaseInfo)this.databaseInfo.elementAt(i);
            if (!dlpdatabaseinfo.checkDatabaseFlag('\u0002') & !dlpdatabaseinfo.checkDatabaseFlag('\u8000')) {
                this.setStatus("Backing up " + dlpdatabaseinfo.getName());
                try {
                    DLPDatabase dlpdatabase;
                    this.jhsHandler.openConduit();
                    byte0 = this.jhsHandler.openDatabase((byte)0, (byte)-128, dlpdatabaseinfo.getName());
                    int i1 = this.jhsHandler.getOpenDatabaseInfo(byte0);
                    if (dlpdatabaseinfo.checkDatabaseFlag('\u0001')) {
                        dlpdatabase = new DLPDatabase(true, dlpdatabaseinfo);
                        int j = 0;
                        while (j < i1) {
                            dlpdatabase.addElement(this.jhsHandler.readResource(byte0, (char)j, '\u0000', '\uffff'));
                            ++j;
                        }
                    } else {
                        dlpdatabase = new DLPDatabase(false, dlpdatabaseinfo);
                        int k = 0;
                        while (k < i1) {
                            dlpdatabase.addElement(this.jhsHandler.readRecord(byte0, (char)k, '\u0000', '\uffff'));
                            ++k;
                        }
                    }
                    try {
                        DLPBlock dlpblock = this.jhsHandler.getApplicationBlock(byte0, 0, 65535);
                        dlpdatabase.setApplicationBlock(dlpblock);
                    }
                    catch (DLPFunctionCallException ex) {
                        // empty catch block
                    }
                    try {
                        DLPBlock dlpblock1 = this.jhsHandler.getSortBlock(byte0, 0, 65535);
                        dlpdatabase.setSortBlock(dlpblock1);
                    }
                    catch (DLPFunctionCallException ex) {
                        // empty catch block
                    }
                    dlpdatabaseset.addDatabase(dlpdatabase);
                    dlpdatabase = null;
                }
                catch (DLPFunctionCallException dlpfunctioncallexception) {
                    this.setStatus("Exception encountered during backup of database: " + dlpdatabaseinfo.getName() + "\n" + dlpfunctioncallexception.toString());
                }
                try {
                    if (byte0 != 0) {
                        this.jhsHandler.closeDatabase(byte0);
                    }
                }
                catch (DLPFunctionCallException dlpfunctioncallexception1) {
                    this.setStatus("Exception encountered during close of database: " + dlpdatabaseinfo.getName() + "\n" + dlpfunctioncallexception1.toString());
                }
            }
            ++i;
        }
        try {
            String s = this.userInfo.getUserName().replace(' ', '_');
            dlpdatabaseset.writeToFile(this.userPath + System.getProperty("file.separator") + s + ".backup");
        }
        catch (IOException ioexception) {
            this.setStatus("Exception during write of backup file: " + ioexception.toString());
        }
    }

    private void endHotSync(boolean state) {
        long totalTime = System.currentTimeMillis() - this.startTime;
        int hours = (int)(totalTime / 3600000L);
        int minutes = (int)(totalTime / 60000L - (long)(hours * 60));
        int seconds = (int)(totalTime / 1000L - (long)(hours * 60) - (long)(minutes * 60));
        int millis = (int)(totalTime % 1000L);
        this.postToLog("Sync Time: " + hours + ":" + minutes + ":" + seconds + "." + millis);
        if (state) {
            try {
                this.jhsHandler.suspend();
            }
            catch (NotConnectedException e) {
                // empty catch block
            }
        }
        this.postToLog("===================================");
        if (this.parent != null) {
            this.parent.endOfSync(this);
        }
    }

    protected void finalize() throws Throwable {
        this.jhsHandler.disconnect();
    }

    private AbstractConduit getConduit(int i) {
        return (AbstractConduit)this.parent.getConduits(this).elementAt(i);
    }

    private int getConduitCount() {
        return this.parent.getConduits(this).size();
    }

    public synchronized Vector getDBInfo() {
        return this.databaseInfo;
    }

    public synchronized DLPDatabaseInfo getDBInfo(String s) throws DatabaseNotFoundException {
        int i = 0;
        while (i < this.databaseInfo.size()) {
            if (((DLPDatabaseInfo)this.databaseInfo.elementAt(i)).getName().equals(s)) {
                return (DLPDatabaseInfo)this.databaseInfo.elementAt(i);
            }
            ++i;
        }
        throw new DatabaseNotFoundException("Database not found: " + s);
    }

    public synchronized DLPVersion getDLPVersion() {
        return this.sysInfo.getDlpVersion();
    }

    public synchronized boolean getPopupState() {
        return false;
    }

    public synchronized DLPStorageInfo getStorageInfo() {
        return this.storInfo;
    }

    public synchronized DLPSystemInfo getSystemInfo() {
        return this.sysInfo;
    }

    public synchronized DLPUserInfo getUserInfo() {
        return this.userInfo;
    }

    public synchronized boolean isModemListener() {
        return this.transport instanceof ModemTransport;
    }

    public synchronized void postToLog(String s) {
        if (this.logStream != null) {
            this.logStream.println(s);
            this.logStream.flush();
        }
    }

    private void restoreSync() throws NotConnectedException {
        DLPDatabaseSet dbSet = this.parent.getRestoreDatabaseSet();
        if (dbSet == null) {
            this.postToLog("Unable to restore, as the client application has provided a null database set object.  Skipping...");
            return;
        }
        this.setStatus("Starting Palm Restore...");
        int i = 0;
        while (i < dbSet.databaseCount()) {
            block24: {
                byte dbHandle;
                if (Thread.currentThread().isInterrupted()) {
                    this.running = false;
                    return;
                }
                DLPDatabase currentDB = dbSet.getDatabase(i);
                DLPDatabaseInfo dbInfo = currentDB.getDatabaseInfo();
                try {
                    this.jhsHandler.openConduit();
                }
                catch (DLPFunctionCallException e) {
                    this.postToLog("Warning:  Call to openConduit() caused the following exception:\n" + e.toString());
                }
                try {
                    dbHandle = this.jhsHandler.createDatabase((byte)0, dbInfo.getCreator(), dbInfo.getType(), dbInfo.getName(), dbInfo.getDatabaseFlags(), (char)dbInfo.getVersion());
                }
                catch (DLPFunctionCallException ex) {
                    dbHandle = 0;
                    try {
                        this.jhsHandler.deleteDatabase((byte)0, dbInfo.getName());
                        dbHandle = this.jhsHandler.createDatabase((byte)0, dbInfo.getCreator(), dbInfo.getType(), dbInfo.getName(), dbInfo.getDatabaseFlags(), (char)dbInfo.getVersion());
                    }
                    catch (DLPFunctionCallException ex2) {
                        this.postToLog("Unable to create or remove database \"" + dbInfo.getName() + "\"; skipping restore.");
                        dbHandle = 0;
                        break block24;
                    }
                }
                try {
                    this.setStatus("Restoring database " + dbInfo.getName());
                    if (currentDB.getApplicationBlock() != null) {
                        this.jhsHandler.writeApplicationBlock(dbHandle, currentDB.getApplicationBlock().getData());
                    }
                    if (currentDB.getSortBlock() != null) {
                        this.jhsHandler.writeSortBlock(dbHandle, currentDB.getSortBlock().getData());
                    }
                    if (dbInfo.checkDatabaseFlag(' ') | dbInfo.getName().equals("NetSync")) {
                        this.jhsHandler.resetSystem();
                    }
                    if (dbInfo.checkDatabaseFlag('\u0001')) {
                        int j = 0;
                        while (j < currentDB.getElements()) {
                            try {
                                DLPResource tempRes = (DLPResource)currentDB.getElement(j);
                                this.jhsHandler.writeResource(dbHandle, tempRes.getResourceType(), tempRes.getResourceID(), tempRes.getData());
                            }
                            catch (DLPFunctionCallException e2) {
                                this.postToLog("% *** Exception encountered while writing resource: " + e2.toString());
                            }
                            ++j;
                        }
                    } else {
                        int k = 0;
                        while (k < currentDB.getElements()) {
                            try {
                                DLPRecord tempRec = (DLPRecord)currentDB.getElement(k);
                                this.jhsHandler.writeRecord(dbHandle, (byte)0, 0, tempRec.getAttributes(), tempRec.getCategory(), tempRec.getData());
                            }
                            catch (DLPFunctionCallException e3) {
                                this.postToLog("% *** Exception encountered while writing record: " + e3.toString());
                            }
                            ++k;
                        }
                    }
                    this.jhsHandler.closeDatabase(dbHandle);
                }
                catch (DLPFunctionCallException e4) {
                    this.postToLog("Unable to restore database \"" + dbInfo.getName() + "\" due to exception: " + e4.toString());
                    try {
                        this.jhsHandler.closeDatabase(dbHandle);
                    }
                    catch (DLPFunctionCallException e5) {
                        this.postToLog("% Error encountered closing database: " + e5.toString() + "\n");
                    }
                }
            }
            ++i;
        }
        this.setStatus("Restore complete!");
    }

    public void run() {
        this.startHotSync();
    }

    public void setLogStream(PrintStream stream) {
        this.logStream = new PrintWriter(stream);
    }

    public void setLogStream(PrintWriter stream) {
        this.logStream = stream;
    }

    public void setSpeed(int speed) {
        this.jhsHandler.setSpeed(speed);
    }

    public synchronized void setStatus(String s) {
        if (this.statusStream != null) {
            this.statusStream.println(s);
            this.statusStream.flush();
        }
        this.postToLog(s);
    }

    public synchronized void setStatusStream(PrintStream stream) {
        this.statusStream = new PrintWriter(stream);
    }

    public synchronized void setStatusStream(PrintWriter stream) {
        this.statusStream = stream;
    }

    private void standardSync() throws NotConnectedException {
        ConduitList curr;
        ConduitHandler conduithandler = new ConduitHandler(this, this.jhsHandler);
        this.root = null;
        int i = 0;
        while (i < this.getConduitCount()) {
            if (this.root == null) {
                this.root = new ConduitList(this.getConduit(i));
            } else {
                ConduitList temp;
                curr = this.root;
                ConduitList prev = null;
                while (this.getConduit(i) != null && curr != null && this.getConduit(i).getPriority() < curr.conduit.getPriority()) {
                    prev = curr;
                    curr = curr.next;
                }
                if (curr == null) {
                    prev.next = temp = new ConduitList(this.getConduit(i));
                } else {
                    temp = new ConduitList(this.getConduit(i));
                    temp.next = curr;
                    if (prev != null) {
                        prev.next = temp;
                    }
                    if (curr == this.root) {
                        this.root = temp;
                    }
                }
            }
            ++i;
        }
        curr = this.root;
        this.setStatus("Starting Synchronization...");
        while (curr != null) {
            Object var8_8;
            if (Thread.currentThread().isInterrupted()) {
                this.running = false;
                break;
            }
            this.setStatus("Calling Conduit " + curr.conduit.toString() + "...");
            try {
                try {
                    this.jhsHandler.openConduit();
                    curr.conduit.startSync(conduithandler, this.getUserInfo());
                }
                catch (DLPFunctionCallException ex) {
                    this.setStatus("Encountered error syncing " + curr.conduit.toString() + "!");
                    var8_8 = null;
                    curr = curr.next;
                    continue;
                }
                var8_8 = null;
                curr = curr.next;
            }
            catch (Throwable throwable) {
                var8_8 = null;
                curr = curr.next;
                throw throwable;
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            this.running = false;
            return;
        }
        try {
            this.jhsHandler.openConduit();
            if (!(System.getProperty("jsyncman.bypassdefault") != null && System.getProperty("jsyncman.bypassdefault").equals("true") || this.parent.getDefaultConduit(this) == null)) {
                this.setStatus("Backing up flagged Databases");
                this.parent.getDefaultConduit(this).startSync(conduithandler, this.getUserInfo());
            }
        }
        catch (Throwable throwable) {
            this.setStatus("Caught exception in default conduit: " + throwable.toString());
        }
        this.setStatus("Finalizing Sync...");
    }

    private void startHotSync() {
        this.running = true;
        do {
            boolean flag = true;
            Runtime.getRuntime().runFinalization();
            Runtime.getRuntime().gc();
            try {
                this.setStatus("Waiting for Wakeup.");
                this.palmSyncLogBuffer = new StringBuffer();
                this.jhsHandler.connect();
                this.startTime = System.currentTimeMillis();
                this.postToLog("Synchronization started at: " + new Date().toString());
                this.setStatus("Starting HotSync Session...");
                if (this.parent != null) {
                    this.parent.startOfSync(this);
                }
                if (Thread.currentThread().isInterrupted()) {
                    this.setStatus("Synchronization canceled by thread interruption.");
                    this.endHotSync(true);
                    this.running = false;
                    break;
                }
                if (flag) {
                    try {
                        this.setStatus("Retrieving System Info.");
                        this.sysInfo = this.jhsHandler.getSystemInfo();
                    }
                    catch (DLPFunctionCallException dlpfunctioncallexception) {
                        if (dlpfunctioncallexception.getErrorCode() == 18) {
                            this.setStatus("Synchronization canceled by user.");
                            this.endHotSync(true);
                            continue;
                        }
                        this.setStatus("*** (2)Error encountered during sync initialization: " + dlpfunctioncallexception.toString());
                    }
                    try {
                        this.jhsHandler.openConduit();
                        this.userInfo = this.jhsHandler.getUserInfo();
                        if (this.userInfo.getUserName() == null) {
                            throw new DLPFunctionCallException(Integer.MAX_VALUE);
                        }
                        this.setStatus("PalmPilot Owner: " + this.userInfo.getUserName());
                        this.parent.processUser(this.userInfo, this);
                    }
                    catch (DLPFunctionCallException ex) {
                        if (ex.getErrorCode() == 18) {
                            this.setStatus("Synchronization canceled by user.");
                            this.endHotSync(true);
                            continue;
                        }
                        this.jhsHandler.startTickles();
                        if (this.parent != null && this.parent.getSyncType(this) != 2) {
                            try {
                                DLPUserInfo userInfo = this.parent.getNewUserInfo(this);
                                if (userInfo != null) {
                                    this.jhsHandler.setUserInfo(userInfo);
                                    continue;
                                }
                                this.endHotSync(false);
                                continue;
                            }
                            catch (DLPFunctionCallException ex2) {
                                this.setStatus("Unable to write user info!");
                            }
                        }
                        this.jhsHandler.stopTickles();
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        this.setStatus("Synchronization canceled by thread interruption.");
                        this.endHotSync(true);
                        this.running = false;
                        break;
                    }
                    if (this.userInfo == null && this.parent.getSyncType(this) != 2 || !this.parent.validateUser(this.userInfo.getUserID(), this)) {
                        this.setStatus("User not allowed to synchronize!  Aborting...");
                        try {
                            this.jhsHandler.addSyncLogEntry("Unable to synchronize data as this Palm's user ID does not pass the hosts security check.  Synchronization aborted.");
                        }
                        catch (DLPFunctionCallException exception) {
                            if (exception.getErrorCode() == 18) {
                                this.setStatus("Synchronization canceled by user.");
                                this.endHotSync(true);
                                continue;
                            }
                            this.setStatus("*** (1)Error encountered during sync initialization: " + exception.toString());
                        }
                        flag = false;
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        this.setStatus("Synchronization canceled by thread interruption.");
                        this.endHotSync(true);
                        this.running = false;
                        break;
                    }
                    try {
                        this.jhsHandler.openConduit();
                        this.setStatus("Retrieving Storage Info.");
                        this.storInfo = this.jhsHandler.getStorageInfo((byte)0);
                    }
                    catch (DLPFunctionCallException dlpfunctioncallexception1) {
                        if (dlpfunctioncallexception1.getErrorCode() == 18) {
                            this.setStatus("Synchronization cancelled by user.");
                            this.endHotSync(true);
                            continue;
                        }
                        this.setStatus("*** (3)Error encountered during sync initialization: " + dlpfunctioncallexception1.toString());
                    }
                    if (this.parent.useTimeSync(this) && (this.sysInfo.getCompatibilityVersion().getVersion() < 3.1f || this.sysInfo.getCompatibilityVersion().getVersion() > 3.99f)) {
                        this.setStatus("Synchronizing Date/Time");
                        try {
                            this.jhsHandler.openConduit();
                            this.jhsHandler.setTime(new GregorianCalendar());
                        }
                        catch (DLPFunctionCallException dlpfunctioncallexception2) {
                            if (dlpfunctioncallexception2.getErrorCode() == 18) {
                                this.setStatus("Synchronization canceled by user.");
                                this.endHotSync(true);
                                continue;
                            }
                            this.setStatus("*** (4)Error encountered during sync initialization: " + dlpfunctioncallexception2.toString());
                        }
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        this.setStatus("Synchronization canceled by thread interruption.");
                        this.endHotSync(true);
                        this.running = false;
                        break;
                    }
                    try {
                        float dlpVersion;
                        this.setStatus("Retrieving Database Info...");
                        this.databaseInfo.removeAllElements();
                        try {
                            dlpVersion = (float)this.sysInfo.getDlpVersion().getMajorVersion() + (float)this.sysInfo.getDlpVersion().getMinorVersion() / 10.0f;
                        }
                        catch (Throwable t) {
                            dlpVersion = 1.0f;
                        }
                        try {
                            DLPStorageInfo storeInfo = this.jhsHandler.getStorageInfo((byte)0);
                        }
                        catch (DLPFunctionCallException dlpfunctioncallexception3) {
                            this.setStatus("*** (4.5)Error encountered during sync initialization: " + dlpfunctioncallexception3.toString());
                        }
                        byte i = 0;
                        int j = 0;
                        do {
                            i = 0;
                            this.jhsHandler.openConduit();
                            this.dbList = this.jhsHandler.getDatabaseList((byte)(0xFFFFFFC0 | ((double)dlpVersion >= 1.2 ? 32 : 0)), (byte)0, (char)j);
                            do {
                                DLPDatabaseInfo dbInfoTemp = (DLPDatabaseInfo)this.dbList.nextElement();
                                this.databaseInfo.addElement(dbInfoTemp);
                            } while (++i < this.dbList.getActualCount());
                            j = this.dbList.getLastIndex() + '\u0001';
                            if (!Thread.currentThread().isInterrupted()) continue;
                            this.setStatus("Synchronization canceled by thread interruption.");
                            this.endHotSync(true);
                            this.running = false;
                            break;
                        } while (this.dbList.hasMoreElements());
                    }
                    catch (DLPFunctionCallException dlpfunctioncallexception3) {
                        if (dlpfunctioncallexception3.getErrorCode() == 18) {
                            this.setStatus("Synchronization canceled by user.");
                            this.endHotSync(true);
                            continue;
                        }
                        this.setStatus("*** (5)Error encountered during sync initialization: " + dlpfunctioncallexception3.toString());
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        this.setStatus("Synchronization canceled by thread interruption.");
                        this.endHotSync(true);
                        this.running = false;
                        break;
                    }
                    try {
                        this.jhsHandler.openConduit();
                    }
                    catch (DLPFunctionCallException dlpE2) {
                        if (dlpE2.getErrorCode() == 18) {
                            this.setStatus("Synchronization canceled by user.");
                            this.endHotSync(true);
                            continue;
                        }
                        this.setStatus("*** (6)Error encountered during sync initialization: " + dlpE2.toString());
                    }
                    if (this.parent != null) {
                        this.parent.midSync(this);
                    }
                    if (this.parent != null && this.parent.getSyncType(this) == 1) {
                        this.backupSync();
                    } else if (this.parent != null && this.parent.getSyncType(this) == 2) {
                        this.restoreSync();
                    } else {
                        this.standardSync();
                    }
                    try {
                        this.appendToPalmSyncLog("jSyncManager Sync complete at " + new GregorianCalendar().getTime().toString());
                        this.jhsHandler.addSyncLogEntry(this.palmSyncLogBuffer.toString());
                    }
                    catch (Exception exception1) {
                        this.setStatus("$$$ Error while writing sync log entry: " + exception1.toString());
                    }
                    this.setStatus("HotSync Successful!");
                }
                this.endHotSync(true);
                if (!Thread.currentThread().isInterrupted()) continue;
                this.running = false;
                break;
            }
            catch (NotConnectedException ex) {
                this.setStatus("*** Connection to Palm lost.  Aborting.");
                this.endHotSync(false);
            }
            catch (SecurityException t) {
                this.setStatus("Fatal sync exception caught: \n" + t.toString() + "\nAborting sync.");
                this.endHotSync(false);
            }
        } while (this.running);
    }

    public synchronized void stopSync() {
        this.running = false;
    }

    public static String getVersion() {
        StringBuffer sb = new StringBuffer(version.substring(version.indexOf(" ") + 1, version.lastIndexOf(" ")));
        sb.append(' ');
        sb.append(state.substring(state.indexOf(" ") + 1, state.lastIndexOf(" ")));
        return sb.toString();
    }

    public static String getHomeDirectory() {
        if (homeDirectory != null) {
            return homeDirectory;
        }
        StringBuffer sb = new StringBuffer();
        String jsmhome = System.getProperty("jsyncman.home");
        if (jsmhome == null) {
            jsmhome = System.getProperty("user.home");
        }
        sb.append(jsmhome);
        if (!jsmhome.endsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append(".jsyncmanager");
        homeDirectory = sb.toString();
        File homeDir = new File(homeDirectory);
        if (!homeDir.exists()) {
            homeDir.mkdirs();
        }
        return homeDirectory;
    }

    class ConduitList {
        AbstractConduit conduit = null;
        ConduitList next = null;

        ConduitList(AbstractConduit c) {
            this.conduit = c;
        }
    }
}

