/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util.StdApps;

import java.util.Calendar;
import java.util.ResourceBundle;
import org.jSyncManager.API.Protocol.Util.DLPRecord;
import org.jSyncManager.API.Protocol.Util.DLP_Date;
import org.jSyncManager.API.Tools.StringManipulator;

public class ToDoListRecord
extends DLPRecord {
    private Calendar dueDate;
    private byte priority;
    private String description;
    private String note;
    private boolean dueDateFlag = false;
    protected static ResourceBundle rb = ResourceBundle.getBundle("org.jSyncManager.API.Resources.Text.JSyncManAPIResources");

    public ToDoListRecord() {
        this.dueDateFlag = true;
        this.noDueDate();
        this.priority = 0;
        this.description = "";
        this.note = "";
    }

    public ToDoListRecord(DLPRecord record) {
        this.recordID = record.getRecordID();
        this.index = record.getIndex();
        this.recordSize = record.getRecordSize();
        this.attributes = record.getAttributes();
        this.category = record.getCategory();
        this.data = record.getData();
        this.parseFields();
    }

    private void generateData() {
        this.data = new byte[6 + this.description.length() + this.note.length()];
        int k = 0;
        int l = 65535;
        if (this.hasDueDate()) {
            l = DLP_Date.calendar2DateType(this.dueDate);
        }
        this.data[k++] = (byte)((l & 0xFF00) / 256);
        this.data[k++] = (byte)(l & 0xFF);
        this.data[k++] = (byte)((this.priority & 0xFF00) / 256);
        this.data[k++] = (byte)(this.priority & 0xFF);
        byte[] abyte0 = this.description.getBytes();
        int i = 0;
        while (i < abyte0.length) {
            this.data[k++] = abyte0[i];
            ++i;
        }
        this.data[k++] = 0;
        abyte0 = this.note.getBytes();
        int j = 0;
        while (j < abyte0.length) {
            this.data[k++] = abyte0[j];
            ++j;
        }
        this.data[k++] = 0;
    }

    public byte[] getData() {
        this.generateData();
        return this.data;
    }

    public String getDescription() {
        return this.description;
    }

    public Calendar getDueDate() {
        return this.dueDate;
    }

    public String getNote() {
        return this.note;
    }

    public byte getPriority() {
        return (byte)(this.priority & 0xFFFFFF7F);
    }

    public boolean hasDueDate() {
        return this.dueDateFlag;
    }

    public boolean isCompleted() {
        return (this.priority & 0x80) > 0;
    }

    public void noDueDate() {
        this.dueDateFlag = false;
    }

    private void parseFields() {
        int j = 2;
        if (this.data == null || this.data.length < 3 || this.checkAttribute((byte)-128)) {
            return;
        }
        if (this.data[0] == -1 && this.data[1] == -1) {
            this.dueDateFlag = false;
        } else {
            this.dueDate = DLP_Date.dateType2Calendar(this.data, 0);
            this.dueDateFlag = true;
        }
        this.priority = this.data[j++];
        int i = j;
        byte[] temp = new byte[128];
        while (this.data[i] != 0) {
            temp[i - j] = this.data[i];
            ++i;
        }
        j = i + 1;
        this.description = StringManipulator.strip(new String(temp));
        i = j;
        temp = new byte[this.data.length - j];
        while (this.data[i] != 0) {
            temp[i - j] = this.data[i];
            ++i;
        }
        j = i + 1;
        this.note = StringManipulator.strip(new String(temp));
    }

    public void setCompletionState(boolean flag) {
        if (flag) {
            this.priority = (byte)(this.priority | 0x80);
        } else if ((this.priority & 0x80) != 0) {
            this.priority = (byte)(this.priority ^ 0x80);
        }
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public void setDueDate(Calendar calendar) {
        this.dueDate = calendar;
        this.dueDateFlag = true;
    }

    public void setNote(String s) {
        this.note = s;
    }

    public void setPriority(char c) {
        this.priority = (byte)(c | (this.isCompleted() ? 128 : 0));
    }

    public String toString() {
        if (this.checkAttribute((byte)-128)) {
            return rb.getString("Deleted") + "\n";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Item Description:   " + this.getDescription() + "\n");
        if (this.hasDueDate()) {
            buf.append("Due Date:           " + this.getDueDate().getTime().toString() + "\n");
        }
        buf.append("Priority:           " + this.getPriority() + "\n");
        if (this.getNote() != null && this.getNote().length() != 0) {
            buf.append("Note:               " + this.getNote() + "\n");
        }
        buf.append("Completion State:   " + (this.isCompleted() ? "Complete" : "Incomplete") + "\n");
        buf.append("\n\n");
        return buf.toString();
    }
}

