/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util.StdApps;

import java.io.IOException;
import java.io.InputStreamReader;
import javax.xml.parsers.ParserConfigurationException;
import org.jSyncManager.API.Protocol.Util.DLPRecordXML;
import org.jSyncManager.API.Protocol.Util.StdApps.ToDoListRecord;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ToDoListDBXML
extends DLPRecordXML {
    public static String XMLNAME = "jSyncManagerToDoListDB";
    ToDoListRecord record = null;

    public ToDoListDBXML() throws ParserConfigurationException, SAXException {
        DOMImplementation domimpl = this.getBuilder().getDOMImplementation();
        DocumentType doctype = domimpl.createDocumentType(XMLNAME, XMLNAME + ".dtd", null);
        this.setDocument(domimpl.createDocument(null, XMLNAME, doctype));
    }

    public ToDoListDBXML(ToDoListRecord rec) throws ParserConfigurationException, SAXException {
        this.record = rec;
    }

    public ToDoListDBXML(Document document) throws ParserConfigurationException, SAXException {
        this.setDocument(document);
    }

    public ToDoListDBXML(InputStreamReader inputfile) throws ParserConfigurationException, SAXException, IOException {
        super(inputfile);
        this.readDocument(inputfile);
    }

    public ToDoListRecord insertRecord(ToDoListRecord rec) {
        Element elem = this.getDocument().getDocumentElement();
        Element tmpelem = null;
        this.record = rec;
        tmpelem = this.createElem("jSyncManagerToDoListRecord", elem);
        super.insertRecord(this.record, tmpelem);
        if (this.record.hasDueDate()) {
            this.createElem("duedate", tmpelem, this.record.getDueDate());
        }
        if (this.record.getNote() != null && this.record.getNote().length() != 0) {
            this.createElem("description", tmpelem, this.record.getDescription());
        }
        this.createElem("priority", tmpelem, this.record.getPriority());
        if (this.record.getNote() != null && this.record.getNote().length() != 0) {
            this.createElem("note", tmpelem, this.record.getNote());
        }
        return this.record;
    }

    public void readDocument(InputStreamReader inputfile) throws ParserConfigurationException, SAXException, IOException {
        super.readDocument(inputfile);
        Element element = this.getDocument().getDocumentElement();
        if (element != null && element.getTagName().equals("jSyncManagerToDoListDB")) {
            this.readElement_jSyncManagerToDoListDB(element);
        }
    }

    void readElement_jSyncManagerToDoListDB(Element element) throws ParserConfigurationException, SAXException {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1) {
                Element nodeElement = (Element)node;
                if (nodeElement.getTagName().equals("jSyncManagerDLPRecord")) {
                    super.readElement(nodeElement);
                }
                if (nodeElement.getTagName().equals("jSyncManagerToDoListRecord")) {
                    this.readElement_jSyncManagerToDoListRecord(nodeElement);
                }
            }
            ++i;
        }
    }

    void readElement_jSyncManagerToDoListRecord(Element element) throws ParserConfigurationException, SAXException {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1) {
                Element nodeElement = (Element)node;
                if (element != null) {
                    if (nodeElement.getTagName().equals("descriptione")) {
                        this.readElement_description(nodeElement);
                    }
                    if (nodeElement.getTagName().equals("priority")) {
                        this.readElement_priority(nodeElement);
                    }
                    if (nodeElement.getTagName().equals("note")) {
                        this.readElement_note(nodeElement);
                    }
                }
            }
            ++i;
        }
    }

    void readElement_description(Element element) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node != null && node.getNodeType() == 3) {
                this.record.setDescription(((Text)node).getData());
            }
            ++i;
        }
    }

    void readElement_priority(Element element) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node != null && node.getNodeType() == 3) {
                byte[] text = ((Text)node).getData().getBytes();
                this.record.setPriority((char)text[0]);
            }
            ++i;
        }
    }

    void readElement_note(Element element) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node != null && node.getNodeType() == 3) {
                this.record.setNote(((Text)node).getData());
            }
            ++i;
        }
    }
}

