/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util.StdApps;

import org.jSyncManager.API.Protocol.Util.DLPBlock;
import org.jSyncManager.API.Protocol.Util.StdApps.CategoryInfo;
import org.jSyncManager.API.Tools.StringManipulator;
import org.jSyncManager.API.Tools.UnsignedByte;

public class ToDoListAppBlock
extends DLPBlock {
    private CategoryInfo[] categories;
    private byte lastUniqueID;
    private int dirtyAppInfo;
    private byte sortOrder;
    public static final byte DUEDATE_PRIORITY = 0;
    public static final byte PRIORITY_DUEDATE = 1;
    public static final byte CATEGORY_PRIORITY = 2;
    public static final byte CATEGORY_DUEDATE = 3;
    private int numCategories = 0;

    public ToDoListAppBlock() {
        this.categories = new CategoryInfo[16];
    }

    public ToDoListAppBlock(DLPBlock block) {
        this.data = block.getData();
        this.blockSize = block.getBlockSize();
        this.parseFields();
    }

    public int findCategoryInfo(int i) {
        int j = 0;
        while (j < 16) {
            if (this.categories[j].getCategoryID() == i) {
                return j;
            }
            ++j;
        }
        return 0;
    }

    private void generateData() {
        this.data = new byte[392];
        int l = 0;
        this.data[l++] = 0;
        this.data[l++] = 0;
        this.data[l++] = 0;
        this.data[l++] = 0;
        int i = 0;
        while (i < 16) {
            byte[] abyte0 = this.categories[i].getCategoryName().getBytes();
            int k = abyte0.length <= 16 ? abyte0.length : 16;
            int i1 = 0;
            while (i1 < k) {
                this.data[l++] = abyte0[i1];
                ++i1;
            }
            if (abyte0.length < 16) {
                int j1 = 0;
                while (j1 < 16 - abyte0.length) {
                    this.data[l++] = 0;
                    ++j1;
                }
            }
            ++i;
        }
        int j = 0;
        while (j < 16) {
            this.data[l++] = this.categories[j].getCategoryID();
            ++j;
        }
        this.data[l++] = this.lastUniqueID;
        this.data[l++] = 0;
        this.data[l++] = 0;
        this.data[l++] = 0;
        this.data[l++] = (byte)((this.dirtyAppInfo & 0xFF000000) / 0x1000000);
        this.data[l++] = (byte)((this.dirtyAppInfo & 0xFF0000) / 65536);
        this.data[l++] = (byte)((this.dirtyAppInfo & 0xFF00) / 256);
        this.data[l++] = (byte)(this.dirtyAppInfo & 0xFF);
        this.data[l++] = this.sortOrder;
    }

    public CategoryInfo getCategoryInfo(int i) {
        try {
            return this.categories[i];
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public byte[] getData() {
        this.generateData();
        return this.data;
    }

    public int getDirtyAppInfo() {
        return this.dirtyAppInfo;
    }

    public byte getLastUniqueID() {
        return this.lastUniqueID;
    }

    public int getNumCategories() {
        return this.numCategories;
    }

    public byte getSortOrder() {
        return this.sortOrder;
    }

    private void parseFields() {
        int i1 = 0;
        int i = 0;
        while (i < 16) {
            this.categories[i] = new CategoryInfo();
            this.categories[i].setModifiedFlag((this.data[i1++] >> i & 1) != 0);
            ++i;
        }
        int j = 0;
        while (j < 16) {
            byte[] abyte0 = new byte[16];
            int l = 0;
            while (l < 16) {
                abyte0[l] = this.data[i1++];
                ++l;
            }
            this.categories[j].setCategoryName(StringManipulator.strip(new String(abyte0)));
            if (this.categories[j].getCategoryName().length() > 0) {
                ++this.numCategories;
            }
            ++j;
        }
        int k = 0;
        while (k < 16) {
            this.categories[k].setCategoryID(this.data[i1++]);
            ++k;
        }
        this.lastUniqueID = this.data[i1++];
        i1 += 3;
        this.dirtyAppInfo = UnsignedByte.unsignedBytes2Int(this.data[i1++], this.data[i1++], this.data[i1++], this.data[i1++]);
        this.sortOrder = this.data[i1++];
    }

    public void setCategoryInfo(CategoryInfo categoryinfo, int i) {
        this.categories[i] = categoryinfo;
    }

    public void setDirtyAppInfo(int i) {
        this.dirtyAppInfo = i;
    }

    private void setNumCategories(int newValue) {
        this.numCategories = newValue;
    }

    public void setSortOrder(byte byte0) {
        this.sortOrder = byte0;
    }
}

