/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util.StdApps;

import java.util.ResourceBundle;
import org.jSyncManager.API.Protocol.Util.DLPRecord;
import org.jSyncManager.API.Tools.StringManipulator;

public class MemoRecord
extends DLPRecord {
    protected String memoText;
    protected static ResourceBundle rb = ResourceBundle.getBundle("org.jSyncManager.API.Resources.Text.JSyncManAPIResources");

    public MemoRecord() {
        this.memoText = "";
    }

    public MemoRecord(DLPRecord record) {
        this.recordID = record.getRecordID();
        this.index = record.getIndex();
        this.recordSize = record.getRecordSize();
        this.attributes = record.getAttributes();
        this.category = record.getCategory();
        this.data = record.getData();
        this.parseFields();
    }

    private void generateData() {
        this.data = new byte[this.memoText.length() + 1];
        byte[] abyte0 = this.memoText.getBytes();
        int i = 0;
        while (i < abyte0.length) {
            this.data[i] = abyte0[i];
            ++i;
        }
        this.data[this.data.length] = 0;
    }

    public byte[] getData() {
        this.generateData();
        return this.data;
    }

    public String getMemoText() {
        return this.memoText;
    }

    private void parseFields() {
        this.memoText = StringManipulator.strip(new String(this.data));
    }

    public void setMemoText(String s) {
        this.memoText = s;
    }

    public String toString() {
        if (this.checkAttribute((byte)-128)) {
            return rb.getString("Deleted") + "\n";
        }
        return this.getMemoText() + (this.getMemoText().endsWith("\n") ? "" : "\n");
    }
}

