/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util.StdApps;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import org.jSyncManager.API.Protocol.Util.DLPRecord;
import org.jSyncManager.API.Protocol.Util.DLP_Date;
import org.jSyncManager.API.Tools.StringManipulator;

public class ExpenseRecord
extends DLPRecord {
    private static ResourceBundle resJSyncManResources = ResourceBundle.getBundle("org.jSyncManager.API.Resources.Text.JSyncManAPIResources");
    private Calendar expenseDate;
    private byte expenseType;
    private byte paymentType;
    private byte currencyType;
    private String expenseAmount;
    private String expenseVendor;
    private String expenseCity;
    private String expenseAttendees;
    private String expenseNote;
    public static final byte AMEX = 0;
    public static final byte CASH = 1;
    public static final byte CHEQUE = 2;
    public static final byte CREDIT_CARD = 3;
    public static final byte MASTERCARD = 4;
    public static final byte PREPAID = 5;
    public static final byte VISA = 6;
    public static final byte UNFILED = 7;
    public static final byte AIRFARE = 0;
    public static final byte BREAKFAST = 1;
    public static final byte BUS = 2;
    public static final byte BUSINESS_MEALS = 3;
    public static final byte CAR_RENTAL = 4;
    public static final byte DINNER = 5;
    public static final byte ENTERTAINMENT = 6;
    public static final byte FAX = 7;
    public static final byte GAS = 8;
    public static final byte GIFTS = 9;
    public static final byte HOTEL = 10;
    public static final byte INCIDENTALS = 11;
    public static final byte LAUNDRY = 12;
    public static final byte LIMO = 13;
    public static final byte LODGING = 14;
    public static final byte LUNCH = 15;
    public static final byte MILEAGE = 16;
    public static final byte OTHER = 17;
    public static final byte PARKING = 18;
    public static final byte POSTAGE = 19;
    public static final byte SNACK = 20;
    public static final byte SUBWAY = 21;
    public static final byte SUPPLIES = 22;
    public static final byte TAXI = 23;
    public static final byte TELEPHONE = 24;
    public static final byte TIPS = 25;
    public static final byte TOLLS = 26;
    public static final byte TRAIN = 27;

    public ExpenseRecord() {
        this.expenseDate = new GregorianCalendar();
        this.expenseType = 0;
        this.paymentType = 0;
        this.currencyType = 0;
        this.expenseAmount = "0.00";
        this.expenseVendor = "null";
        this.expenseCity = "null";
        this.expenseAttendees = "null";
        this.expenseNote = "";
    }

    public ExpenseRecord(DLPRecord record) {
        this.recordID = record.getRecordID();
        this.index = record.getIndex();
        this.recordSize = record.getRecordSize();
        this.attributes = record.getAttributes();
        this.category = record.getCategory();
        this.data = record.getData();
        this.parseFields();
    }

    private void generateData() {
        int i = 10 + this.getExpenseAmount().length() + this.getExpenseVendor().length() + this.getExpenseCity().length() + this.getExpenseAttendees().length() + this.getExpenseNote().length();
        this.data = new byte[i];
        char c = DLP_Date.calendar2DateType(this.getExpenseDate());
        int j = 0;
        this.data[j++] = (byte)((c & 0xFF00) / 256);
        this.data[j++] = (byte)(c & 0xFF);
        this.data[j++] = this.getExpenseType();
        this.data[j++] = this.getPaymentType();
        this.data[j++] = this.getCurrencyType();
        byte[] abyte0 = this.getExpenseAmount().getBytes();
        int k = 0;
        while (k < abyte0.length) {
            this.data[j++] = abyte0[k];
            ++k;
        }
        this.data[j++] = 0;
        abyte0 = this.getExpenseVendor().getBytes();
        int l = 0;
        while (l < abyte0.length) {
            this.data[j++] = abyte0[l];
            ++l;
        }
        this.data[j++] = 0;
        abyte0 = this.getExpenseCity().getBytes();
        int i1 = 0;
        while (i1 < abyte0.length) {
            this.data[j++] = abyte0[i1];
            ++i1;
        }
        this.data[j++] = 0;
        abyte0 = this.getExpenseAttendees().getBytes();
        int j1 = 0;
        while (j1 < abyte0.length) {
            this.data[j++] = abyte0[j1];
            ++j1;
        }
        this.data[j++] = 0;
        abyte0 = this.getExpenseNote().getBytes();
        int k1 = 0;
        while (k1 < abyte0.length) {
            this.data[j++] = abyte0[k1];
            ++k1;
        }
        this.data[j++] = 0;
    }

    public byte getCurrencyType() {
        return this.currencyType;
    }

    public String getCurrencyTypeAsString() {
        switch (this.getCurrencyType()) {
            case 0: {
                return resJSyncManResources.getString("Australia");
            }
            case 1: {
                return resJSyncManResources.getString("Austria");
            }
            case 2: {
                return resJSyncManResources.getString("Belgium");
            }
            case 3: {
                return resJSyncManResources.getString("Brazil");
            }
            case 4: {
                return resJSyncManResources.getString("Canada");
            }
            case 5: {
                return resJSyncManResources.getString("Denmark");
            }
            case 6: {
                return resJSyncManResources.getString("Finland");
            }
            case 7: {
                return resJSyncManResources.getString("France");
            }
            case 8: {
                return resJSyncManResources.getString("Germany");
            }
            case 9: {
                return resJSyncManResources.getString("Hong_Kong");
            }
            case 10: {
                return resJSyncManResources.getString("Iceland");
            }
            case 11: {
                return resJSyncManResources.getString("Ireland");
            }
            case 12: {
                return resJSyncManResources.getString("Italy");
            }
            case 13: {
                return resJSyncManResources.getString("Japan");
            }
            case 14: {
                return resJSyncManResources.getString("Luxembourg");
            }
            case 15: {
                return resJSyncManResources.getString("Mexico");
            }
            case 16: {
                return resJSyncManResources.getString("Netherlands");
            }
            case 17: {
                return resJSyncManResources.getString("New_Zealand");
            }
            case 18: {
                return resJSyncManResources.getString("Norway");
            }
            case 19: {
                return resJSyncManResources.getString("Spain");
            }
            case 20: {
                return resJSyncManResources.getString("Sweden");
            }
            case 21: {
                return resJSyncManResources.getString("Switzerland");
            }
            case 22: {
                return resJSyncManResources.getString("United_Kingdom");
            }
            case 23: {
                return resJSyncManResources.getString("United_States");
            }
            case 24: {
                return resJSyncManResources.getString("None");
            }
        }
        return resJSyncManResources.getString("Unknown");
    }

    public byte[] getData() {
        this.generateData();
        return this.data;
    }

    public String getExpenseAmount() {
        return this.expenseAmount;
    }

    public float getExpenseAmountAsFloat() {
        try {
            return Float.valueOf(this.expenseAmount).floatValue();
        }
        catch (NumberFormatException ex) {
            return 0.0f;
        }
    }

    public String getExpenseAttendees() {
        return this.expenseAttendees;
    }

    public String getExpenseCity() {
        return this.expenseCity;
    }

    public Calendar getExpenseDate() {
        return this.expenseDate;
    }

    public String getExpenseNote() {
        return this.expenseNote;
    }

    public byte getExpenseType() {
        return this.expenseType;
    }

    public String getExpenseTypeAsString() {
        switch (this.getExpenseType()) {
            case 0: {
                return resJSyncManResources.getString("Airfare");
            }
            case 1: {
                return resJSyncManResources.getString("Breakfast");
            }
            case 2: {
                return resJSyncManResources.getString("Bus_Fare");
            }
            case 3: {
                return resJSyncManResources.getString("Business_Meal");
            }
            case 4: {
                return resJSyncManResources.getString("Car_Rental");
            }
            case 5: {
                return resJSyncManResources.getString("Dinner");
            }
            case 6: {
                return resJSyncManResources.getString("Entertainment");
            }
            case 7: {
                return resJSyncManResources.getString("Fax");
            }
            case 8: {
                return resJSyncManResources.getString("Gas");
            }
            case 9: {
                return resJSyncManResources.getString("Gifts");
            }
            case 10: {
                return resJSyncManResources.getString("Hotel");
            }
            case 11: {
                return resJSyncManResources.getString("Incidentals");
            }
            case 12: {
                return resJSyncManResources.getString("Laundry");
            }
            case 13: {
                return resJSyncManResources.getString("Limo");
            }
            case 14: {
                return resJSyncManResources.getString("Lodging");
            }
            case 15: {
                return resJSyncManResources.getString("Lunch");
            }
            case 16: {
                return resJSyncManResources.getString("Milage");
            }
            case 17: {
                return resJSyncManResources.getString("Other");
            }
            case 18: {
                return resJSyncManResources.getString("Parking");
            }
            case 19: {
                return resJSyncManResources.getString("Postage");
            }
            case 20: {
                return resJSyncManResources.getString("Snack");
            }
            case 21: {
                return resJSyncManResources.getString("Subway");
            }
            case 22: {
                return resJSyncManResources.getString("Supplies");
            }
            case 23: {
                return resJSyncManResources.getString("Taxi");
            }
            case 24: {
                return resJSyncManResources.getString("Telephone");
            }
            case 25: {
                return resJSyncManResources.getString("Tips");
            }
            case 26: {
                return resJSyncManResources.getString("Tolls");
            }
            case 27: {
                return resJSyncManResources.getString("Train");
            }
        }
        return resJSyncManResources.getString("Unknown");
    }

    public String getExpenseVendor() {
        return this.expenseVendor;
    }

    public byte getPaymentType() {
        return this.paymentType;
    }

    public String getPaymentTypeAsString() {
        switch (this.getPaymentType()) {
            case 0: {
                return resJSyncManResources.getString("American_Express");
            }
            case 1: {
                return resJSyncManResources.getString("Cash");
            }
            case 2: {
                return resJSyncManResources.getString("Cheque");
            }
            case 3: {
                return resJSyncManResources.getString("Credit_Card");
            }
            case 4: {
                return resJSyncManResources.getString("MasterCard");
            }
            case 5: {
                return resJSyncManResources.getString("Prepaid");
            }
            case 6: {
                return resJSyncManResources.getString("Visa");
            }
            case 7: {
                return resJSyncManResources.getString("Unfiled");
            }
        }
        return resJSyncManResources.getString("Unknown");
    }

    private void parseFields() {
        int i = 2;
        this.expenseDate = DLP_Date.dateType2Calendar(this.data, 0);
        this.expenseType = this.data[i++];
        this.paymentType = this.data[i++];
        this.currencyType = this.data[i++];
        int j = DLPRecord.getLength(this.data, ++i);
        this.expenseAmount = StringManipulator.strip(new String(this.data, i, j));
        i += j;
        j = DLPRecord.getLength(this.data, i);
        this.expenseVendor = StringManipulator.strip(new String(this.data, i, j));
        i += j;
        j = DLPRecord.getLength(this.data, i);
        this.expenseCity = StringManipulator.strip(new String(this.data, i, j));
        i += j;
        j = DLPRecord.getLength(this.data, i);
        this.expenseAttendees = StringManipulator.strip(new String(this.data, i, j));
        i += j;
        j = DLPRecord.getLength(this.data, i);
        this.expenseNote = StringManipulator.strip(new String(this.data, i, j));
    }

    public void setCurrencyType(byte byte0) {
        this.currencyType = byte0;
    }

    public void setExpenseAmount(float f) {
        this.expenseAmount = Float.toString(f);
    }

    public void setExpenseAmount(String s) {
        this.expenseAmount = s;
    }

    public void setExpenseAttendees(String s) {
        this.expenseAttendees = s;
    }

    public void setExpenseCity(String s) {
        this.expenseCity = s;
    }

    public void setExpenseDate(Calendar calendar) {
        this.expenseDate = calendar;
    }

    public void setExpenseNote(String s) {
        this.expenseNote = s;
    }

    public void setExpenseType(byte byte0) {
        this.expenseType = byte0;
    }

    public void setExpenseVendor(String s) {
        this.expenseVendor = s;
    }

    public void setPaymentType(byte byte0) {
        this.paymentType = byte0;
    }

    public String toString() {
        if (this.checkAttribute((byte)-128)) {
            return resJSyncManResources.getString("Deleted") + "\n";
        }
        StringBuffer buf = new StringBuffer();
        if (this.getExpenseDate() != null) {
            buf.append("Expense Date:   " + this.getExpenseDate().getTime().toString() + "\n");
        }
        if (this.getExpenseType() >= 0) {
            buf.append("Expense Type:   " + this.getExpenseTypeAsString() + "\n");
        }
        if (this.getPaymentType() >= 0) {
            buf.append("Payment Type:   " + this.getPaymentTypeAsString() + "\n");
        }
        buf.append("Currency Type:  " + this.getCurrencyTypeAsString() + "\n");
        buf.append("Expense Amount: " + this.getExpenseAmount() + "\n");
        if (this.getExpenseCity().length() != 0) {
            buf.append("City:           " + this.getExpenseCity() + "\n");
        }
        if (this.getExpenseVendor().length() != 0) {
            buf.append("Vendor:         " + this.getExpenseVendor() + "\n");
        }
        if (this.getExpenseAttendees().length() != 0) {
            buf.append("Attendees:      " + this.getExpenseAttendees() + "\n");
        }
        if (this.getExpenseNote().length() != 0) {
            buf.append("Note:           " + this.getExpenseNote() + "\n");
        }
        buf.append("\n\n");
        return buf.toString();
    }
}

