/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util.StdApps;

import java.io.IOException;
import java.io.InputStreamReader;
import javax.xml.parsers.ParserConfigurationException;
import org.jSyncManager.API.Protocol.Util.DLPRecordXML;
import org.jSyncManager.API.Protocol.Util.JSXMLDate;
import org.jSyncManager.API.Protocol.Util.StdApps.ExpenseRecord;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ExpenseDBXML
extends DLPRecordXML {
    public static String XMLNAME = "jSyncManagerExpenseDB";
    ExpenseRecord record = null;
    private static int phone_title_ctr = 0;
    private static int phone_ctr = 0;
    private static int custom_ctr = 0;

    public ExpenseDBXML() throws ParserConfigurationException, SAXException {
        DOMImplementation domimpl = this.getBuilder().getDOMImplementation();
        DocumentType doctype = domimpl.createDocumentType(XMLNAME, XMLNAME + ".dtd", null);
        this.setDocument(domimpl.createDocument(null, XMLNAME, doctype));
    }

    public ExpenseDBXML(ExpenseRecord rec) throws ParserConfigurationException, SAXException {
        this.record = rec;
    }

    public ExpenseDBXML(Document document) throws ParserConfigurationException, SAXException {
        this.setDocument(document);
    }

    public ExpenseDBXML(InputStreamReader inputfile) throws ParserConfigurationException, SAXException, IOException {
        super(inputfile);
        this.readDocument(inputfile);
    }

    public ExpenseRecord insertRecord(ExpenseRecord rec) {
        Element elem = this.getDocument().getDocumentElement();
        Element tmpelem = null;
        this.record = rec;
        tmpelem = this.createElem("jSyncManagerExpenseRecord", elem);
        super.insertRecord(this.record, tmpelem);
        this.createElem("currencytype", tmpelem, this.record.getCurrencyType());
        this.createElem("expensedate", tmpelem, this.record.getExpenseDate());
        this.createElem("expensetype", tmpelem, this.record.getExpenseType());
        this.createElem("paymenttype", tmpelem, this.record.getPaymentType());
        this.createElem("expenseamount", tmpelem, this.record.getExpenseAmountAsFloat());
        this.createElem("attendees", tmpelem, this.record.getExpenseAttendees());
        this.createElem("expensecity", tmpelem, this.record.getExpenseCity());
        this.createElem("expensenote", tmpelem, this.record.getExpenseNote());
        this.createElem("expensevendor", tmpelem, this.record.getExpenseVendor());
        return this.record;
    }

    public void readDocument(InputStreamReader inputfile) throws ParserConfigurationException, SAXException, IOException {
        super.readDocument(inputfile);
        Element element = this.getDocument().getDocumentElement();
        if (element != null && element.getTagName().equals("jSyncManagerExpenseDB")) {
            this.readElement_jSyncManagerExpenseDB(element);
        }
    }

    void readElement_jSyncManagerExpenseDB(Element element) throws ParserConfigurationException, SAXException {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1) {
                Element nodeElement = (Element)node;
                if (nodeElement.getTagName().equals("jSyncManagerDLPRecord")) {
                    super.readElement(nodeElement);
                }
                if (nodeElement.getTagName().equals("jSyncManagerExpenseRecord")) {
                    this.readElement_jSyncManagerExpenseRecord(nodeElement);
                }
            }
            ++i;
        }
    }

    void readElement_jSyncManagerExpenseRecord(Element element) throws ParserConfigurationException, SAXException {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1) {
                Element nodeElement = (Element)node;
                if (element != null) {
                    if (nodeElement.getTagName().equals("expensedate")) {
                        JSXMLDate datexml = new JSXMLDate();
                        datexml.readElement(nodeElement);
                        this.record.setExpenseDate(datexml.getDate());
                    }
                    if (nodeElement.getTagName().equals("expensetype")) {
                        this.record.setExpenseType(this.readByteElement(nodeElement));
                    }
                    if (nodeElement.getTagName().equals("currencytype")) {
                        this.record.setCurrencyType(this.readByteElement(nodeElement));
                    }
                    if (nodeElement.getTagName().equals("paymenttype")) {
                        this.record.setPaymentType(this.readByteElement(nodeElement));
                    }
                    if (nodeElement.getTagName().equals("expenseamount")) {
                        this.record.setExpenseAmount(this.readFloatElement(nodeElement));
                    }
                    if (nodeElement.getTagName().equals("attendees")) {
                        this.record.setExpenseAttendees(this.readStringElement(nodeElement));
                    }
                    if (nodeElement.getTagName().equals("expensecity")) {
                        this.record.setExpenseCity(this.readStringElement(nodeElement));
                    }
                    if (nodeElement.getTagName().equals("expensenote")) {
                        this.record.setExpenseNote(this.readStringElement(nodeElement));
                    }
                    if (nodeElement.getTagName().equals("expensevendor")) {
                        this.record.setExpenseVendor(this.readStringElement(nodeElement));
                    }
                }
            }
            ++i;
        }
    }
}

