/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util.StdApps;

import org.jSyncManager.API.Protocol.Util.DLPBlock;
import org.jSyncManager.API.Protocol.Util.StdApps.CategoryInfo;
import org.jSyncManager.API.Tools.StringManipulator;

public class ExpenseAppBlock
extends DLPBlock {
    private CategoryInfo[] categories;
    private byte lastUniqueID;
    private byte sortOrder;
    private CurrencyInfo[] currencies;
    public static final byte SORT_BY_DATE = 0;
    public static final byte SORT_BY_TYPE = 1;
    public static final byte MAX_CUSTOM_CURRENCIES = 4;
    public static final byte COUNTRY = 10;
    public static final byte SYMBOL = 11;
    public static final byte EXCHANGE_RATE = 12;
    private int numCategories = 0;

    public ExpenseAppBlock() {
        this.categories = new CategoryInfo[16];
        this.currencies = new CurrencyInfo[4];
    }

    public ExpenseAppBlock(DLPBlock block) {
        this.data = block.getData();
        this.blockSize = block.getBlockSize();
        this.parseFields();
    }

    public int findCategoryInfo(int i) {
        int j = 0;
        while (j < 16) {
            if (this.categories[j].getCategoryID() == i) {
                return j;
            }
            ++j;
        }
        return 0;
    }

    private void generateData() {
        this.data = new byte[392];
        int j1 = 0;
        this.data[j1++] = 0;
        this.data[j1++] = 0;
        this.data[j1++] = 0;
        this.data[j1++] = 0;
        int i = 0;
        while (i < 16) {
            byte[] abyte0 = this.categories[i].getCategoryName().getBytes();
            int l = abyte0.length <= 16 ? abyte0.length : 16;
            int k1 = 0;
            while (k1 < l) {
                this.data[j1++] = abyte0[k1];
                ++k1;
            }
            if (abyte0.length < 16) {
                int l1 = 0;
                while (l1 < 16 - abyte0.length) {
                    this.data[j1++] = 0;
                    ++l1;
                }
            }
            ++i;
        }
        int j = 0;
        while (j < 16) {
            this.data[j1++] = this.categories[j].getCategoryID();
            ++j;
        }
        this.data[j1++] = this.lastUniqueID;
        this.data[j1++] = 0;
        this.data[j1++] = 0;
        this.data[j1++] = 0;
        this.data[j1++] = this.sortOrder;
        int k = 0;
        while (k < 4) {
            byte[] abyte1 = this.currencies[k].toBytes();
            int i1 = 0;
            while (i1 < abyte1.length) {
                this.data[j1++] = abyte1[i1];
                ++i1;
            }
            ++k;
        }
    }

    public CategoryInfo getCategoryInfo(int i) {
        try {
            return this.categories[i];
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public String getCurrencyInfo(byte byte0, int i) {
        switch (byte0) {
            case 10: {
                return this.currencies[i].country;
            }
            case 11: {
                return this.currencies[i].symbol;
            }
            case 12: {
                return this.currencies[i].exchangeRate;
            }
        }
        return null;
    }

    public byte[] getData() {
        this.generateData();
        return this.data;
    }

    public byte getLastUniqueID() {
        return this.lastUniqueID;
    }

    public int getNumCategories() {
        return this.numCategories;
    }

    public byte getSortOrder() {
        return this.sortOrder;
    }

    private void parseFields() {
        int count1 = 0;
        int i = 0;
        while (i < 16) {
            this.categories[i] = new CategoryInfo();
            this.categories[i].setModifiedFlag((this.data[count1++] >> i & 1) != 0);
            ++i;
        }
        int j = 0;
        while (j < 16) {
            byte[] temp = new byte[16];
            int m = 0;
            while (m < 16) {
                temp[m] = this.data[count1++];
                ++m;
            }
            this.categories[j].setCategoryName(StringManipulator.strip(new String(temp)));
            if (this.categories[j].getCategoryName().length() > 0) {
                ++this.numCategories;
            }
            ++j;
        }
        int k = 0;
        while (k < 16) {
            this.categories[k].setCategoryID(this.data[count1++]);
            ++k;
        }
        this.lastUniqueID = this.data[count1++];
        count1 += 3;
        this.sortOrder = this.data[count1++];
        int l = 0;
        while (l < 4) {
            this.currencies[l] = new CurrencyInfo(this.data, count1);
            count1 += 28;
            ++l;
        }
    }

    public void setCategoryInfo(CategoryInfo categoryinfo, int i) {
        this.categories[i] = categoryinfo;
    }

    public void setCurrencyInfo(byte byte0, int i, String s) {
        switch (byte0) {
            case 10: {
                this.currencies[i].country = s;
                break;
            }
            case 11: {
                this.currencies[i].symbol = s;
                break;
            }
            case 12: {
                this.currencies[i].exchangeRate = s;
                break;
            }
            default: {
                return;
            }
        }
    }

    private void setNumCategories(int newValue) {
        this.numCategories = newValue;
    }

    public void setSortOrder(byte byte0) {
        this.sortOrder = byte0;
    }

    class CurrencyInfo {
        String country;
        String symbol;
        String exchangeRate;

        byte[] toBytes() {
            byte[] abyte0 = new byte[28];
            int l1 = 0;
            byte[] abyte1 = this.country.getBytes();
            int k1 = abyte1.length <= 16 ? abyte1.length : 16;
            int i = 0;
            while (i < k1) {
                abyte0[l1++] = abyte1[i];
                ++i;
            }
            if (abyte1.length < 16) {
                int j = 0;
                while (j < 16 - abyte1.length) {
                    abyte0[l1++] = 0;
                    ++j;
                }
            }
            k1 = (abyte1 = this.symbol.getBytes()).length <= 4 ? abyte1.length : 4;
            int k = 0;
            while (k < k1) {
                abyte0[l1++] = abyte1[k];
                ++k;
            }
            if (abyte1.length < 4) {
                int l = 0;
                while (l < 4 - abyte1.length) {
                    abyte0[l1++] = 0;
                    ++l;
                }
            }
            k1 = (abyte1 = this.exchangeRate.getBytes()).length <= 8 ? abyte1.length : 8;
            int i1 = 0;
            while (i1 < k1) {
                abyte0[l1++] = abyte1[i1];
                ++i1;
            }
            if (abyte1.length < 8) {
                int j1 = 0;
                while (j1 < 8 - abyte1.length) {
                    abyte0[l1++] = 0;
                    ++j1;
                }
            }
            return abyte0;
        }

        CurrencyInfo(byte[] abyte0, int i) {
            int i1 = i;
            byte[] abyte1 = new byte[16];
            int j = 0;
            while (j < 16) {
                abyte1[j] = abyte0[i1++];
                ++j;
            }
            this.country = new String(abyte1);
            ++i1;
            abyte1 = new byte[4];
            int k = 16;
            while (k < 20) {
                abyte1[k] = abyte0[i1++];
                ++k;
            }
            this.symbol = new String(abyte1);
            ++i1;
            abyte1 = new byte[8];
            int l = 20;
            while (l < 28) {
                abyte1[l] = abyte0[i1++];
                ++l;
            }
            this.exchangeRate = new String(abyte1);
            ++i1;
        }
    }
}

