/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util.StdApps;

import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import java.util.Vector;
import org.jSyncManager.API.Tools.UnsignedByte;

public class DateBookRecordEntry
implements Serializable {
    protected static ResourceBundle rb = ResourceBundle.getBundle("org.jSyncManager.API.Resources.Text.JSyncManAPIResources");
    private Calendar startTime = null;
    private Calendar endTime = null;
    private Calendar alarmTime = null;
    public static final byte ALARM_ADVANCE_MINUTES = 0;
    public static final byte ALARM_ADVANCE_HOURS = 1;
    public static final byte ALARM_ADVANCE_DAYS = 2;
    public static final byte NO_TIME = -1;
    public static final byte NO_ALARM = -1;
    public static final byte REPEAT_TYPE_NONE = 0;
    public static final byte REPEAT_TYPE_DAILY = 1;
    public static final byte REPEAT_TYPE_WEEKLY = 2;
    public static final byte REPEAT_TYPE_MONTHLY_BY_DAY_OF_WEEK = 3;
    public static final byte REPEAT_TYPE_MONTHLY_BY_DAY_OF_MONTH = 4;
    public static final byte REPEAT_TYPE_YEARLY = 5;
    public static final char REPEAT_TYPE_NO_END_DATE = '\uffff';
    public static final byte WHEN_MODIFIED = -128;
    public static final byte HAS_ALARM_INFO = 64;
    public static final byte HAS_REPEAT_INFO = 32;
    public static final byte HAS_NOTE = 16;
    public static final byte HAS_EXCEPTION_INFO = 8;
    public static final byte HAS_DESCRIPTION = 4;
    public static final byte CLEAR_WHEN_MODIFIED = 127;
    public static final byte CLEAR_HAS_ALARM_INFO = -65;
    public static final byte CLEAR_HAS_REPEAT_INFO = -33;
    public static final byte CLEAR_HAS_NOTE = -17;
    public static final byte CLEAR_HAS_EXCEPTION_INFO = -9;
    public static final byte CLEAR_HAS_DESCRIPTION = -5;
    private byte apptFlags = 0;
    private byte alarmAdvance = 0;
    private byte alarmUnitType = 0;
    public static final char YEAR_MASK = '\ufe00';
    public static final char MONTH_MASK = '\u01e0';
    public static final char DAY_MASK = '\u001f';
    public static final int YEAR_ROTATE = 9;
    public static final int MONTH_ROTATE = 5;
    public static final int DAY_ROTATE = 0;
    private byte repeatType = 0;
    private Calendar repeatEndDate = null;
    private byte repeatFrequency = 0;
    private byte repeatOn = 0;
    private byte repeatStartOfWeek = 0;
    private Vector exceptionArray = null;
    public static final GregorianCalendar MAXIMUM_DATE = new GregorianCalendar(2032, 1, 1, 0, 0, 0);

    public DateBookRecordEntry() {
    }

    protected DateBookRecordEntry(DateBookRecordEntry original) {
        this();
        if (original == null) {
            return;
        }
        this.startTime = (Calendar)original.startTime.clone();
        this.endTime = (Calendar)original.endTime.clone();
        this.alarmTime = original.alarmTime != null ? (Calendar)original.alarmTime.clone() : null;
        this.repeatEndDate = original.repeatEndDate != null ? (Calendar)original.repeatEndDate.clone() : null;
        this.apptFlags = original.apptFlags;
        this.alarmAdvance = original.alarmAdvance;
        this.alarmUnitType = original.alarmUnitType;
        this.repeatType = original.repeatType;
        this.repeatFrequency = original.repeatFrequency;
        this.repeatOn = original.repeatOn;
        this.repeatStartOfWeek = original.repeatStartOfWeek;
    }

    public boolean hasNote() {
        return this.hasFlag((byte)16);
    }

    public void setHasNote(boolean hasNote) {
        this.apptFlags = hasNote ? (byte)(this.apptFlags | 0x10) : (byte)(this.apptFlags & 0xFFFFFFEF);
    }

    public boolean hasDescription() {
        return this.hasFlag((byte)4);
    }

    public void setHasDescription(boolean hasDescription) {
        this.apptFlags = hasDescription ? (byte)(this.apptFlags | 4) : (byte)(this.apptFlags & 0xFFFFFFFB);
    }

    public boolean isWhenInfoChanged() {
        return this.hasFlag((byte)-128);
    }

    public void setWhenInfoChanged(boolean whenInfoChanged) {
        this.apptFlags = whenInfoChanged ? (byte)(this.apptFlags | 0xFFFFFF80) : (byte)(this.apptFlags & 0x7F);
    }

    public boolean isRepeating() {
        return this.hasFlag((byte)32);
    }

    public void setRepeating(boolean repeating) {
        this.apptFlags = repeating ? (byte)(this.apptFlags | 0x20) : (byte)(this.apptFlags & 0xFFFFFFDF);
    }

    public boolean hasAlarmSet() {
        return this.hasFlag((byte)64);
    }

    public void setAlarmSet(boolean alarmSet) {
        this.apptFlags = alarmSet ? (byte)(this.apptFlags | 0x40) : (byte)(this.apptFlags & 0xFFFFFFBF);
    }

    public boolean hasExceptionList() {
        return this.hasFlag((byte)8);
    }

    public void setExceptionList(boolean flag) {
        this.apptFlags = flag ? (byte)(this.apptFlags | 8) : (byte)(this.apptFlags & 0xFFFFFFF7);
    }

    public Calendar getAlarmTime() {
        return this.alarmTime;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public boolean hasAlarm() {
        return this.alarmTime != null;
    }

    public void setAlarmTime(Calendar newValue) {
        this.alarmTime = newValue;
    }

    public void setEndTime(Calendar newValue) {
        this.endTime = newValue;
    }

    public void setStartTime(Calendar newValue) {
        this.startTime = newValue;
    }

    public byte getAlarmUnitType() {
        return this.alarmUnitType;
    }

    public void setAlarmUnitType(byte alarmUnitType) {
        this.alarmUnitType = alarmUnitType;
    }

    public byte getApptFlags() {
        return this.apptFlags;
    }

    public void setApptFlags(byte apptFlags) {
        this.apptFlags = apptFlags;
    }

    public Calendar getRepeatEndDate() {
        return this.repeatEndDate;
    }

    public void setRepeatEndDate(Calendar repeatEndDate) {
        this.repeatEndDate = repeatEndDate;
    }

    public byte getRepeatFrequency() {
        return this.repeatFrequency;
    }

    public void setRepeatFrequency(byte repeatFrequency) {
        this.repeatFrequency = repeatFrequency;
    }

    public byte getRepeatOn() {
        return this.repeatOn;
    }

    public void setRepeatOn(byte repeatOn) {
        this.repeatOn = repeatOn;
    }

    public byte getRepeatStartOfWeek() {
        return this.repeatStartOfWeek;
    }

    public void setRepeatStartOfWeek(byte repeatStartOfWeek) {
        this.repeatStartOfWeek = repeatStartOfWeek;
    }

    public byte getRepeatType() {
        return this.repeatType;
    }

    public void setRepeatType(byte repeatType) {
        this.repeatType = repeatType;
    }

    public byte getAlarmAdvance() {
        return this.alarmAdvance;
    }

    public void setAlarmAdvance(byte alarmAdvance) {
        this.alarmAdvance = alarmAdvance;
    }

    public boolean hasFlag(byte flag) {
        return (this.apptFlags & flag) != 0;
    }

    public static Calendar convertDateTime(byte hourByte, byte minuteByte, char date) {
        if (date == '\uffff') {
            return MAXIMUM_DATE;
        }
        int year = (date & 0xFE00) >> 9;
        int month = (date & 0x1E0) >> 5;
        int day = (date & 0x1F) >> 0;
        int hour = hourByte == -1 ? 0 : UnsignedByte.intValue(hourByte);
        int minute = minuteByte == -1 ? 0 : UnsignedByte.intValue(minuteByte);
        return new GregorianCalendar(year + 1904, month - 1, day, hour, minute);
    }

    public DateBookRecordEntry calculateNextEntry() {
        if (!this.isRepeating() || this.equals(this.repeatEndDate)) {
            return null;
        }
        DateBookRecordEntry ret = new DateBookRecordEntry(this);
        do {
            switch (this.repeatType) {
                case 0: {
                    return null;
                }
                case 1: {
                    ret.startTime.add(5, this.repeatFrequency);
                    ret.endTime.add(5, this.repeatFrequency);
                    if (ret.alarmTime == null) break;
                    ret.alarmTime.add(5, this.repeatFrequency);
                    break;
                }
                case 2: {
                    ret.startTime.add(5, this.repeatFrequency * 7);
                    ret.endTime.add(5, this.repeatFrequency * 7);
                    if (ret.alarmTime == null) break;
                    ret.alarmTime.add(5, this.repeatFrequency * 7);
                    break;
                }
                case 3: {
                    ret.startTime.add(2, this.repeatFrequency);
                    ret.startTime.set(4, this.startTime.get(4));
                    ret.startTime.set(7, this.startTime.get(7));
                    ret.endTime.add(2, this.repeatFrequency);
                    ret.endTime.set(4, this.endTime.get(4));
                    ret.endTime.set(7, this.endTime.get(7));
                    if (ret.alarmTime != null) {
                        ret.alarmTime.add(2, this.repeatFrequency);
                    }
                    if (ret.alarmTime != null) {
                        ret.alarmTime.set(4, this.alarmTime.get(4));
                    }
                    if (ret.alarmTime == null) break;
                    ret.alarmTime.set(7, this.alarmTime.get(7));
                    break;
                }
                case 4: {
                    ret.startTime.add(2, this.repeatFrequency);
                    ret.endTime.add(2, this.repeatFrequency);
                    if (ret.alarmTime == null) break;
                    ret.alarmTime.add(2, this.repeatFrequency);
                    break;
                }
                case 5: {
                    ret.startTime.add(1, this.repeatFrequency);
                    ret.endTime.add(1, this.repeatFrequency);
                    if (ret.alarmTime == null) break;
                    ret.alarmTime.add(1, this.repeatFrequency);
                    break;
                }
            }
        } while (this.isExceptionEntry(ret.startTime));
        if (ret.startTime.after(this.repeatEndDate)) {
            return null;
        }
        return ret;
    }

    protected boolean isExceptionEntry(Calendar date) {
        if (this.exceptionArray == null) {
            return false;
        }
        int i = 0;
        while (i < this.exceptionArray.size()) {
            if (((Calendar)this.exceptionArray.elementAt(i)).get(1) == date.get(1) && ((Calendar)this.exceptionArray.elementAt(i)).get(2) == date.get(2) && ((Calendar)this.exceptionArray.elementAt(i)).get(5) == date.get(5)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addExceptionEntry(Calendar date) {
        if (this.exceptionArray == null) {
            this.exceptionArray = new Vector(1, 1);
        }
        this.exceptionArray.addElement(date);
    }

    public void addExceptionEntry(char date) {
        this.addExceptionEntry(DateBookRecordEntry.convertDateTime((byte)0, (byte)0, date));
    }

    public Calendar getExceptionEntry(int i) {
        return (Calendar)this.exceptionArray.elementAt(i);
    }

    public int getExceptionEntryCount() {
        int count = 0;
        if (this.exceptionArray != null) {
            count = this.exceptionArray.size();
        }
        return count;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(rb.getString("StartDate"));
        int i = 0;
        while (i < 20 - rb.getString("StartDate").length()) {
            sb.append(' ');
            ++i;
        }
        sb.append(this.startTime.getTime().toString());
        sb.append('\n');
        sb.append(rb.getString("EndDate"));
        i = 0;
        while (i < 20 - rb.getString("EndDate").length()) {
            sb.append(' ');
            ++i;
        }
        sb.append(this.endTime.getTime().toString());
        sb.append('\n');
        if (this.hasAlarmSet() && this.alarmTime != null) {
            sb.append(rb.getString("AlarmTime"));
            i = 0;
            while (i < 20 - rb.getString("AlarmTime").length()) {
                sb.append(' ');
                ++i;
            }
            sb.append(this.alarmTime.getTime().toString());
            sb.append('\n');
        }
        if (this.isRepeating()) {
            sb.append(rb.getString("RepeatingEntry"));
        }
        sb.append('\n');
        return sb.toString();
    }

    public static byte[] getDateBytesFromCalendar(Calendar c) {
        byte[] ret = new byte[4];
        int i = 0;
        ret[i++] = (byte)c.get(10);
        ret[i++] = (byte)c.get(12);
        char date = '\u0000';
        date = (char)(date | (char)(c.get(1) << 9));
        date = (char)(date | (char)(c.get(2) << 5));
        date = (char)(date | (char)(c.get(5) << 0));
        ret[i++] = (byte)((date & 0xFF00) >> 8);
        ret[i++] = (byte)(date & 0xFF);
        return ret;
    }
}

