/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util.StdApps;

import java.util.Calendar;
import java.util.Enumeration;
import org.jSyncManager.API.Protocol.Util.DLPRecord;
import org.jSyncManager.API.Protocol.Util.StdApps.DateBookRecordEntry;
import org.jSyncManager.API.Tools.UnsignedByte;

public class DateBookRecord
extends DLPRecord
implements Enumeration {
    private String note = null;
    private String description = null;
    private DateBookRecordEntry firstEntry = null;
    private DateBookRecordEntry lastEntry = null;

    public DateBookRecord() {
    }

    public DateBookRecord(DLPRecord record) {
        this.recordID = record.getRecordID();
        this.index = record.getIndex();
        this.recordSize = record.getRecordSize();
        this.attributes = record.getAttributes();
        this.category = record.getCategory();
        this.data = record.getData();
        this.parseFields();
    }

    private synchronized void generateData() {
        byte[] desc;
        if (this.firstEntry == null) {
            return;
        }
        int i = 0;
        int j = 0;
        int size = 8;
        if (this.firstEntry.hasAlarmSet()) {
            size += 2;
        }
        if (this.firstEntry.isRepeating()) {
            size += 8;
        }
        if (this.firstEntry.hasExceptionList()) {
            size += 2;
            size += 2 * this.firstEntry.getExceptionEntryCount();
        }
        if (this.description != null) {
            size += this.description.length() + 1;
        }
        if (this.note != null) {
            size += this.note.length() + 1;
        }
        this.data = new byte[size];
        byte[] starttime = DateBookRecordEntry.getDateBytesFromCalendar(this.firstEntry.getStartTime());
        byte[] endtime = DateBookRecordEntry.getDateBytesFromCalendar(this.firstEntry.getEndTime());
        this.data[i++] = starttime[0];
        this.data[i++] = starttime[1];
        this.data[i++] = endtime[0];
        this.data[i++] = endtime[1];
        this.data[i++] = starttime[2];
        this.data[i++] = starttime[3];
        this.data[i++] = this.firstEntry.getApptFlags();
        this.data[i++] = 0;
        if (this.firstEntry.hasAlarmSet()) {
            this.data[i++] = this.firstEntry.getAlarmAdvance();
            this.data[i++] = this.firstEntry.getAlarmUnitType();
        }
        if (this.firstEntry.isRepeating()) {
            this.data[i++] = this.firstEntry.getRepeatType();
            byte[] repeatEndDate = DateBookRecordEntry.getDateBytesFromCalendar(this.firstEntry.getRepeatEndDate());
            this.data[i++] = repeatEndDate[2];
            this.data[i++] = repeatEndDate[3];
            this.data[i++] = this.firstEntry.getRepeatFrequency();
            this.data[i++] = this.firstEntry.getRepeatOn();
            this.data[i++] = this.firstEntry.getRepeatStartOfWeek();
            this.data[i++] = 0;
        }
        if (this.firstEntry.hasExceptionList()) {
            int count = this.firstEntry.getExceptionEntryCount();
            this.data[i++] = (byte)((count & 0xFF00) >> 8);
            this.data[i++] = (byte)(count & 0xFF);
            j = 0;
            while (j < count) {
                Calendar nextEntry = this.firstEntry.getExceptionEntry(j);
                byte[] exc = DateBookRecordEntry.getDateBytesFromCalendar(nextEntry);
                this.data[i++] = exc[2];
                this.data[i++] = exc[3];
                ++j;
            }
        }
        if (this.description != null && this.description.length() > 0) {
            desc = this.description.getBytes();
            j = 0;
            while (j < desc.length) {
                this.data[i++] = desc[j];
                ++j;
            }
            this.data[i++] = 0;
        }
        if (this.note != null && this.note.length() > 0) {
            desc = this.note.getBytes();
            j = 0;
            while (j < desc.length) {
                this.data[i++] = desc[j];
                ++j;
            }
            this.data[i++] = 0;
        }
    }

    public byte[] getData() {
        this.generateData();
        return this.data;
    }

    public String getDescription() {
        return this.description;
    }

    public DateBookRecordEntry getFirstEntry() {
        return this.firstEntry;
    }

    public String getNote() {
        return this.note;
    }

    public boolean hasMoreElements() {
        if (this.lastEntry == null) {
            return false;
        }
        return this.lastEntry.calculateNextEntry() != null;
    }

    public Object nextElement() {
        if (this.lastEntry != null) {
            this.lastEntry = this.lastEntry.calculateNextEntry();
        }
        return this.lastEntry;
    }

    private void parseFields() {
        this.firstEntry = new DateBookRecordEntry();
        int i = 0;
        if (this.data == null || this.data.length < 8 || this.checkAttribute((byte)-128)) {
            return;
        }
        byte startHours = this.data[i++];
        byte startMinutes = this.data[i++];
        byte endHours = this.data[i++];
        byte endMinutes = this.data[i++];
        char date = UnsignedByte.unsignedBytes2Char(this.data[i++], this.data[i++]);
        this.firstEntry.setStartTime(DateBookRecordEntry.convertDateTime(startHours, startMinutes, date));
        this.firstEntry.setEndTime(DateBookRecordEntry.convertDateTime(endHours, endMinutes, date));
        this.firstEntry.setApptFlags(this.data[i++]);
        ++i;
        if (this.firstEntry.hasAlarmSet()) {
            this.firstEntry.setAlarmAdvance(this.data[i++]);
            this.firstEntry.setAlarmUnitType(this.data[i++]);
        }
        if (this.firstEntry.isRepeating()) {
            this.firstEntry.setRepeatType(this.data[i++]);
            int n = ++i;
            int n2 = ++i;
            this.firstEntry.setRepeatEndDate(DateBookRecordEntry.convertDateTime((byte)0, (byte)0, UnsignedByte.unsignedBytes2Char(this.data[n], this.data[n2])));
            int n3 = ++i;
            this.firstEntry.setRepeatFrequency(this.data[n3]);
            int n4 = ++i;
            this.firstEntry.setRepeatOn(this.data[n4]);
            int n5 = ++i;
            ++i;
            this.firstEntry.setRepeatStartOfWeek(this.data[n5]);
            ++i;
        }
        if (this.firstEntry.hasExceptionList()) {
            int numExceptions = UnsignedByte.unsignedBytes2Char(this.data[i++], this.data[i++]);
            int j = 0;
            while (j < numExceptions) {
                this.firstEntry.addExceptionEntry(UnsignedByte.unsignedBytes2Char(this.data[i++], this.data[i++]));
                ++j;
            }
        }
        int j = i;
        while (this.data[j++] != 0) {
        }
        this.description = new String(this.data, i, j - i);
        i = j;
        if (this.firstEntry.hasNote()) {
            j = i;
            while (this.data[j++] != 0) {
            }
            this.note = new String(this.data, i, j - i);
        }
        this.lastEntry = this.firstEntry;
    }

    public void resetEnumeration() {
        this.lastEntry = null;
    }

    public void setDescription(String newValue) {
        this.description = newValue;
    }

    public void setFirstEntry(DateBookRecordEntry newValue) {
        this.firstEntry = newValue;
        this.lastEntry = newValue;
    }

    public void setNote(String newValue) {
        this.note = newValue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.firstEntry != null) {
            sb.append(this.firstEntry.toString());
            sb.append('\n');
        }
        if (this.description != null) {
            sb.append(this.description);
            sb.append('\n');
        }
        if (this.note != null) {
            sb.append(this.note);
            sb.append('\n');
        }
        return sb.toString();
    }
}

