/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util.StdApps;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Calendar;
import javax.xml.parsers.ParserConfigurationException;
import org.jSyncManager.API.Protocol.Util.DLPRecordXML;
import org.jSyncManager.API.Protocol.Util.JSXMLDate;
import org.jSyncManager.API.Protocol.Util.StdApps.DateBookRecord;
import org.jSyncManager.API.Protocol.Util.StdApps.DateBookRecordEntry;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DateBookDBXML
extends DLPRecordXML {
    public static String XMLNAME = "jSyncManagerDateBookDB";
    DateBookRecord record = null;
    DateBookRecordEntry dbentry = null;
    JSXMLDate dateelem = null;

    public DateBookDBXML() throws ParserConfigurationException, SAXException {
        DOMImplementation domimpl = this.getBuilder().getDOMImplementation();
        DocumentType doctype = domimpl.createDocumentType(XMLNAME, XMLNAME + ".dtd", null);
        this.setDocument(domimpl.createDocument(null, XMLNAME, doctype));
    }

    public DateBookDBXML(DateBookRecord rec) throws ParserConfigurationException, SAXException {
        this.record = rec;
    }

    public DateBookDBXML(Document document) throws ParserConfigurationException, SAXException {
        this.setDocument(document);
    }

    public DateBookDBXML(InputStreamReader inputfile) throws ParserConfigurationException, SAXException, IOException {
        super(inputfile);
        this.readDocument(inputfile);
    }

    public DateBookRecord insertRecord(DateBookRecord rec) {
        Element elem = this.getDocument().getDocumentElement();
        Element tmpelem = null;
        this.record = rec;
        tmpelem = this.createElem("jSyncManagerDateBookRecord", elem);
        super.insertRecord(this.record, tmpelem);
        if (this.record.getNote() != null && this.record.getNote().length() != 0) {
            this.createElem("note", tmpelem, this.record.getNote());
        }
        if (this.record.getDescription() != null && this.record.getDescription().length() != 0) {
            this.createElem("description", tmpelem, this.record.getDescription());
        }
        DateBookRecordEntry tmp = this.record.getFirstEntry();
        if (this.record.getFirstEntry() != null) {
            this.createElem(tmpelem, this.record.getFirstEntry());
        }
        return this.record;
    }

    public Element createElem(Element tmpelem, DateBookRecordEntry rec) {
        Element entryElem = this.createElem("jSyncManagerDateBookRecordEntry", tmpelem);
        this.createElem("startTime", entryElem, this.record.getFirstEntry().getStartTime());
        this.createElem("endTime", entryElem, this.record.getFirstEntry().getEndTime());
        this.createElem("apptflags", entryElem, rec.getApptFlags());
        if (rec.hasAlarmSet()) {
            this.createElem("alarmUnitType", entryElem, rec.getAlarmUnitType());
            this.createElem("alarmAdvance", entryElem, rec.getAlarmAdvance());
        }
        if (rec.isRepeating()) {
            this.createElem("repeatType", entryElem, rec.getRepeatType());
            this.createElem("repeatEndDate", entryElem, rec.getRepeatEndDate());
            this.createElem("repeatFrequency", entryElem, rec.getRepeatFrequency());
            this.createElem("repeatOn", entryElem, rec.getRepeatOn());
            this.createElem("repeatStartOfWeek", entryElem, rec.getRepeatStartOfWeek());
            if (rec.hasExceptionList()) {
                Element exclist = this.createElem("exceptionEntryList", entryElem);
                Calendar[] entries = new Calendar[rec.getExceptionEntryCount()];
                int i = 0;
                while (i < entries.length) {
                    this.createElem("exceptionEntry", exclist, rec.getExceptionEntry(i));
                    ++i;
                }
            }
        }
        return entryElem;
    }

    public void readDocument(InputStreamReader inputfile) throws ParserConfigurationException, SAXException, IOException {
        this.readDocument(inputfile);
        Element element = this.getDocument().getDocumentElement();
        if (element != null && element.getTagName().equals("jSyncManagerDateBookDB")) {
            this.readElement_jSyncManagerDateBookDB(element);
        }
    }

    void readElement_jSyncManagerDateBookDB(Element element) throws SAXException {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node != null && node.getNodeType() == 1) {
                Element nodeElement = (Element)node;
                if (element.getTagName().equals("jSyncManagerDLPRecord")) {
                    super.readElement(element);
                }
                if (nodeElement.getTagName().equals("jSyncManagerDatebookRecord")) {
                    this.readElement_jSyncManagerDatebookRecord(nodeElement);
                }
            }
            ++i;
        }
    }

    void readElement_jSyncManagerDatebookRecord(Element element) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node != null && node.getNodeType() == 1) {
                Element nodeElement = (Element)node;
                if (nodeElement.getTagName().equals("jSyncManagerDateBookRecordEntry")) {
                    this.readElement_jSyncManagerDateBookRecordEntry(nodeElement);
                }
                if (nodeElement.getTagName().equals("note")) {
                    this.readElement_note(nodeElement);
                }
                if (nodeElement.getTagName().equals("description")) {
                    this.readElement_description(nodeElement);
                }
            }
            ++i;
        }
    }

    void readElement_note(Element element) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node != null && node.getNodeType() == 3) {
                this.record.setNote(((Text)node).getData());
            }
            ++i;
        }
    }

    void readElement_description(Element element) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node != null && node.getNodeType() == 3) {
                this.record.setDescription(((Text)node).getData());
            }
            ++i;
        }
    }

    void readElement_jSyncManagerDateBookRecordEntry(Element element) {
        this.dbentry = new DateBookRecordEntry();
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node != null && node.getNodeType() == 1) {
                Element nodeElement = (Element)node;
                if (nodeElement.getTagName().equals("startTime")) {
                    this.readElement_EntryDate(nodeElement);
                    this.dbentry.setStartTime(this.dateelem.getDate());
                }
                if (nodeElement.getTagName().equals("endTime")) {
                    this.readElement_EntryDate(nodeElement);
                    this.dbentry.setEndTime(this.dateelem.getDate());
                }
                if (nodeElement.getTagName().equals("apptflags")) {
                    this.dbentry.setApptFlags(this.readByteElement(nodeElement));
                }
                if (this.dbentry.hasAlarmSet()) {
                    if (nodeElement.getTagName().equals("alarmunittype")) {
                        this.dbentry.setAlarmUnitType(this.readByteElement(nodeElement));
                    }
                    if (nodeElement.getTagName().equals("alarmadvance")) {
                        this.dbentry.setAlarmAdvance(this.readByteElement(nodeElement));
                    }
                }
                if (this.dbentry.isRepeating()) {
                    if (nodeElement.getTagName().equals("repeatType")) {
                        this.dbentry.setRepeatType(this.readByteElement(nodeElement));
                    }
                    if (nodeElement.getTagName().equals("repeatEndDate")) {
                        this.readElement_EntryDate(nodeElement);
                        this.dbentry.setRepeatEndDate(this.dateelem.getDate());
                    }
                    if (nodeElement.getTagName().equals("repeatFrequency")) {
                        this.dbentry.setRepeatFrequency(this.readByteElement(nodeElement));
                    }
                    if (nodeElement.getTagName().equals("repeatOn")) {
                        this.dbentry.setRepeatOn(this.readByteElement(nodeElement));
                    }
                    if (nodeElement.getTagName().equals("repeatStartOfWeek")) {
                        this.dbentry.setRepeatStartOfWeek(this.readByteElement(nodeElement));
                    }
                }
                if (this.dbentry.hasExceptionList()) {
                    if (nodeElement.getTagName().equals("repeatStartOfWeek")) {
                        this.dbentry.setRepeatStartOfWeek(this.readByteElement(nodeElement));
                    }
                    this.readElement_EntryDate(nodeElement);
                    this.dbentry.addExceptionEntry(this.dateelem.getDate());
                }
            }
            ++i;
        }
    }

    void readElement_EntryDate(Element element) {
        NodeList nodes = element.getChildNodes();
        try {
            int i = 0;
            while (i < nodes.getLength()) {
                Element nodeElement;
                Node node = nodes.item(i);
                if (node != null && node.getNodeType() == 1 && (nodeElement = (Element)node).getTagName().equals("JSXMLDate")) {
                    this.dateelem = new JSXMLDate();
                    this.dateelem.readElement(nodeElement);
                }
                ++i;
            }
        }
        catch (ParserConfigurationException exc) {
            exc.printStackTrace(System.err);
        }
        catch (SAXException exc) {
            exc.printStackTrace(System.err);
        }
    }
}

