/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util.StdApps;

import org.jSyncManager.API.Protocol.Util.DLPBlock;
import org.jSyncManager.API.Protocol.Util.StdApps.CategoryInfo;
import org.jSyncManager.API.Tools.StringManipulator;

public class DateBookAppBlock
extends DLPBlock {
    private CategoryInfo[] categories;
    private byte lastUniqueID;
    private int numCategories = 0;
    private byte startOfWeek;

    public DateBookAppBlock() {
    }

    public DateBookAppBlock(DLPBlock block) {
        this.data = block.getData();
        this.blockSize = block.getBlockSize();
        this.parseFields();
    }

    public int findCategoryInfo(int i) {
        int j = 0;
        while (j < 16) {
            if (this.categories[j].getCategoryID() == i) {
                return j;
            }
            ++j;
        }
        return 0;
    }

    private void generateData() {
        this.data = new byte[392];
        int l = 0;
        this.data[l++] = 0;
        this.data[l++] = 0;
        this.data[l++] = 0;
        this.data[l++] = 0;
        int i = 0;
        while (i < 16) {
            byte[] abyte0 = this.categories[i].getCategoryName().getBytes();
            int k = abyte0.length <= 16 ? abyte0.length : 16;
            int i1 = 0;
            while (i1 < k) {
                this.data[l++] = abyte0[i1];
                ++i1;
            }
            if (abyte0.length < 16) {
                int j1 = 0;
                while (j1 < 16 - abyte0.length) {
                    this.data[l++] = 0;
                    ++j1;
                }
            }
            ++i;
        }
        int j = 0;
        while (j < 16) {
            this.data[l++] = this.categories[j].getCategoryID();
            ++j;
        }
        this.data[l++] = this.lastUniqueID;
        this.data[l++] = 0;
        this.data[l++] = 0;
        this.data[l++] = 0;
        this.data[l++] = this.startOfWeek;
    }

    public CategoryInfo getCategoryInfo(int i) {
        try {
            return this.categories[i];
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public byte[] getData() {
        this.generateData();
        return this.data;
    }

    public byte getLastUniqueID() {
        return this.lastUniqueID;
    }

    public int getNumCategories() {
        return this.numCategories;
    }

    public byte getStartOfWeek() {
        return this.startOfWeek;
    }

    private void parseFields() {
        int counter = 0;
        int i = 0;
        while (i < 16) {
            this.categories[i] = new CategoryInfo();
            this.categories[i].setModifiedFlag((this.data[counter++] >> i & 1) != 0);
            ++i;
        }
        int j = 0;
        while (j < 16) {
            byte[] temp = new byte[16];
            int l = 0;
            while (l < 16) {
                temp[l] = this.data[counter++];
                ++l;
            }
            this.categories[j].setCategoryName(StringManipulator.strip(new String(temp)));
            if (this.categories[j].getCategoryName().length() > 0) {
                ++this.numCategories;
            }
            ++j;
        }
        int k = 0;
        while (k < 16) {
            this.categories[k].setCategoryID(this.data[counter++]);
            ++k;
        }
        this.lastUniqueID = this.data[counter++];
        counter += 3;
        this.startOfWeek = this.data[counter++];
    }

    public void setCategoryInfo(CategoryInfo categoryinfo, int i) {
        this.categories[i] = categoryinfo;
    }

    private void setNumCategories(int newValue) {
        this.numCategories = newValue;
    }

    public void setStartOfWeek(byte newValue) {
        this.startOfWeek = newValue;
    }
}

