/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util.StdApps;

import java.util.ResourceBundle;
import org.jSyncManager.API.Protocol.Util.DLPRecord;
import org.jSyncManager.API.Protocol.Util.StdApps.AddressAppBlock;
import org.jSyncManager.API.Tools.StringManipulator;
import org.jSyncManager.API.Tools.UnsignedByte;

public class AddressRecord
extends DLPRecord {
    public static final int MAX_PHONES = 5;
    public static final int MAX_CUSTOMFIELDS = 4;
    public static final int MAX_DATAFLAGS = 32;
    public static final int MAX_PHONELABELS = 8;
    private static ResourceBundle resJSyncManResources = ResourceBundle.getBundle("org.jSyncManager.API.Resources.Text.JSyncManAPIResources");
    private String surname = null;
    private String givenName = null;
    private String title = null;
    private String company = null;
    private String[] phones = new String[5];
    private String address = null;
    private String city = null;
    private String province = null;
    private String postalCode = null;
    private String country = null;
    private String[] customFields = new String[4];
    private String note = null;
    private boolean[] dataFlags = new boolean[32];
    private int contentFlags = 0;
    private int displayForList = 0;
    private int[] phoneFieldOrders = new int[5];
    public static final int NOTE_FLAG = 262144;
    public static final int CUSTOM4_FLAG = 131072;
    public static final int CUSTOM3_FLAG = 65536;
    public static final int CUSTOM2_FLAG = 32768;
    public static final int CUSTOM1_FLAG = 16384;
    public static final int TITLE_FLAG = 8192;
    public static final int COUNTRY_FLAG = 4096;
    public static final int POSTALCODE_FLAG = 2048;
    public static final int PROVINCE_FLAG = 1024;
    public static final int CITY_FLAG = 512;
    public static final int ADDRESS_FLAG = 256;
    public static final int PHONE5_FLAG = 128;
    public static final int PHONE4_FLAG = 64;
    public static final int PHONE3_FLAG = 32;
    public static final int PHONE2_FLAG = 16;
    public static final int PHONE1_FLAG = 8;
    public static final int COMPANY_FLAG = 4;
    public static final int GIVENNAME_FLAG = 2;
    public static final int SURNAME_FLAG = 1;
    public static final int WORK_LABEL = 0;
    public static final int HOME_LABEL = 1;
    public static final int FAX_LABEL = 2;
    public static final int OTHER_LABEL = 3;
    public static final int EMAIL_LABEL = 4;
    public static final int MAIN_LABEL = 5;
    public static final int PAGER_LABEL = 6;
    public static final int MOBILE_LABEL = 7;

    public AddressRecord() {
    }

    public AddressRecord(DLPRecord record) {
        this.recordID = record.getRecordID();
        this.index = record.getIndex();
        this.recordSize = record.getRecordSize();
        this.attributes = record.getAttributes();
        this.category = record.getCategory();
        this.data = record.getData();
        this.parseFields();
    }

    public boolean checkFlags(int flags) {
        return (this.contentFlags & flags) > 0;
    }

    private void generateData() {
        int j;
        byte[] temp;
        int size = 9;
        int i = 0;
        if (this.checkFlags(1)) {
            size += this.surname.length() + 1;
        }
        if (this.checkFlags(2)) {
            size += this.givenName.length() + 1;
        }
        if (this.checkFlags(4)) {
            size += this.company.length() + 1;
        }
        if (this.checkFlags(8)) {
            size += this.phones[0].length() + 1;
        }
        if (this.checkFlags(16)) {
            size += this.phones[1].length() + 1;
        }
        if (this.checkFlags(32)) {
            size += this.phones[2].length() + 1;
        }
        if (this.checkFlags(64)) {
            size += this.phones[3].length() + 1;
        }
        if (this.checkFlags(128)) {
            size += this.phones[4].length() + 1;
        }
        if (this.checkFlags(256)) {
            size += this.address.length() + 1;
        }
        if (this.checkFlags(512)) {
            size += this.city.length() + 1;
        }
        if (this.checkFlags(1024)) {
            size += this.province.length() + 1;
        }
        if (this.checkFlags(2048)) {
            size += this.postalCode.length() + 1;
        }
        if (this.checkFlags(4096)) {
            size += this.country.length() + 1;
        }
        if (this.checkFlags(8192)) {
            size += this.title.length() + 1;
        }
        if (this.checkFlags(16384)) {
            size += this.customFields[0].length() + 1;
        }
        if (this.checkFlags(32768)) {
            size += this.customFields[1].length() + 1;
        }
        if (this.checkFlags(65536)) {
            size += this.customFields[2].length() + 1;
        }
        if (this.checkFlags(131072)) {
            size += this.customFields[3].length() + 1;
        }
        if (this.checkFlags(262144)) {
            size += this.note.length() + 1;
        }
        this.data = new byte[size];
        this.data[i++] = 0;
        this.data[i++] = 0;
        this.data[i++] = (byte)(this.displayForList * 256 + this.phoneFieldOrders[4]);
        this.data[i++] = (byte)(this.phoneFieldOrders[3] * 256 + this.phoneFieldOrders[2]);
        this.data[i++] = (byte)(this.phoneFieldOrders[1] * 256 + this.phoneFieldOrders[0]);
        this.data[i++] = (byte)((this.contentFlags & 0xFF000000) / 0x1000000);
        this.data[i++] = (byte)((this.contentFlags & 0xFF0000) / 65536);
        this.data[i++] = (byte)((this.contentFlags & 0xFF00) / 256);
        this.data[i++] = (byte)((this.contentFlags & 0xFF) / 1);
        this.data[i++] = 0;
        if (this.checkFlags(1)) {
            temp = this.surname.getBytes();
            j = 0;
            while (j < temp.length) {
                this.data[i++] = temp[j];
                ++j;
            }
            this.data[i++] = 0;
        }
        if (this.checkFlags(2)) {
            temp = this.givenName.getBytes();
            j = 0;
            while (j < temp.length) {
                this.data[i++] = temp[j];
                ++j;
            }
            this.data[i++] = 0;
        }
        if (this.checkFlags(4)) {
            this.data[8] = (byte)i;
            temp = this.company.getBytes();
            j = 0;
            while (j < temp.length) {
                this.data[i++] = temp[j];
                ++j;
            }
            this.data[i++] = 0;
        }
        if (this.checkFlags(8)) {
            temp = this.phones[0].getBytes();
            j = 0;
            while (j < temp.length) {
                this.data[i++] = temp[j];
                ++j;
            }
            this.data[i++] = 0;
        }
        if (this.checkFlags(16)) {
            temp = this.phones[1].getBytes();
            j = 0;
            while (j < temp.length) {
                this.data[i++] = temp[j];
                ++j;
            }
            this.data[i++] = 0;
        }
        if (this.checkFlags(32)) {
            temp = this.phones[2].getBytes();
            j = 0;
            while (j < temp.length) {
                this.data[i++] = temp[j];
                ++j;
            }
            this.data[i++] = 0;
        }
        if (this.checkFlags(64)) {
            temp = this.phones[3].getBytes();
            j = 0;
            while (j < temp.length) {
                this.data[i++] = temp[j];
                ++j;
            }
            this.data[i++] = 0;
        }
        if (this.checkFlags(128)) {
            temp = this.phones[4].getBytes();
            j = 0;
            while (j < temp.length) {
                this.data[i++] = temp[j];
                ++j;
            }
            this.data[i++] = 0;
        }
        if (this.checkFlags(256)) {
            temp = this.address.getBytes();
            j = 0;
            while (j < temp.length) {
                this.data[i++] = temp[j];
                ++j;
            }
            this.data[i++] = 0;
        }
        if (this.checkFlags(512)) {
            temp = this.city.getBytes();
            j = 0;
            while (j < temp.length) {
                this.data[i++] = temp[j];
                ++j;
            }
            this.data[i++] = 0;
        }
        if (this.checkFlags(1024)) {
            temp = this.province.getBytes();
            j = 0;
            while (j < temp.length) {
                this.data[i++] = temp[j];
                ++j;
            }
            this.data[i++] = 0;
        }
        if (this.checkFlags(2048)) {
            temp = this.postalCode.getBytes();
            j = 0;
            while (j < temp.length) {
                this.data[i++] = temp[j];
                ++j;
            }
            this.data[i++] = 0;
        }
        if (this.checkFlags(4096)) {
            temp = this.country.getBytes();
            j = 0;
            while (j < temp.length) {
                this.data[i++] = temp[j];
                ++j;
            }
            this.data[i++] = 0;
        }
        if (this.checkFlags(8192)) {
            temp = this.title.getBytes();
            j = 0;
            while (j < temp.length) {
                this.data[i++] = temp[j];
                ++j;
            }
            this.data[i++] = 0;
        }
        if (this.checkFlags(16384)) {
            temp = this.customFields[0].getBytes();
            j = 0;
            while (j < temp.length) {
                this.data[i++] = temp[j];
                ++j;
            }
            this.data[i++] = 0;
        }
        if (this.checkFlags(32768)) {
            temp = this.customFields[1].getBytes();
            j = 0;
            while (j < temp.length) {
                this.data[i++] = temp[j];
                ++j;
            }
            this.data[i++] = 0;
        }
        if (this.checkFlags(65536)) {
            temp = this.customFields[2].getBytes();
            j = 0;
            while (j < temp.length) {
                this.data[i++] = temp[j];
                ++j;
            }
            this.data[i++] = 0;
        }
        if (this.checkFlags(131072)) {
            temp = this.customFields[3].getBytes();
            j = 0;
            while (j < temp.length) {
                this.data[i++] = temp[j];
                ++j;
            }
            this.data[i++] = 0;
        }
        if (this.checkFlags(262144)) {
            temp = this.note.getBytes();
            j = 0;
            while (j < temp.length) {
                this.data[i++] = temp[j];
                ++j;
            }
            this.data[i++] = 0;
        }
    }

    public String getAddress() {
        return this.address;
    }

    public String getCity() {
        return this.city;
    }

    public String getCompany() {
        return this.company;
    }

    public String getCountry() {
        return this.country;
    }

    public String getCustomField(int i) {
        return this.customFields[i];
    }

    public String[] getCustomFields() {
        return this.customFields;
    }

    public byte[] getData() {
        this.generateData();
        return this.data;
    }

    public int getDisplayForList() {
        return this.displayForList;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getNote() {
        return this.note;
    }

    public int[] getPhoneFields() {
        return this.phoneFieldOrders;
    }

    public int getPhoneField(int i) {
        return this.phoneFieldOrders[i % 5];
    }

    public String getPhoneFieldTitle(int fieldID) {
        switch (fieldID % 8) {
            case 0: {
                return resJSyncManResources.getString("Work_Phone");
            }
            case 1: {
                return resJSyncManResources.getString("Home_Phone");
            }
            case 2: {
                return resJSyncManResources.getString("Fax");
            }
            case 3: {
                return resJSyncManResources.getString("Other");
            }
            case 4: {
                return resJSyncManResources.getString("E-Mail");
            }
            case 5: {
                return resJSyncManResources.getString("Main_Phone");
            }
            case 6: {
                return resJSyncManResources.getString("Pager");
            }
            case 7: {
                return resJSyncManResources.getString("Mobile_Phone");
            }
        }
        return resJSyncManResources.getString("Unknown") + " (" + fieldID + "):";
    }

    public String[] getPhones() {
        return this.phones;
    }

    public String getPhones(int i) {
        return this.phones[i % 5];
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getProvince() {
        return this.province;
    }

    public String getState() {
        return this.province;
    }

    public String getSurname() {
        return this.surname;
    }

    public String getTitle() {
        return this.title;
    }

    private void parseFields() {
        int j;
        byte[] temp;
        int i = 0;
        ++i;
        if (this.data == null || this.data.length <= 1) {
            return;
        }
        this.displayForList = (byte)((this.data[i] & 0xF0) / 16);
        this.phoneFieldOrders[4] = this.data[i++] & 0xF;
        this.phoneFieldOrders[3] = (byte)((this.data[i] & 0xF0) / 16);
        this.phoneFieldOrders[2] = this.data[i++] & 0xF;
        this.phoneFieldOrders[1] = (byte)((this.data[i] & 0xF0) / 16);
        this.phoneFieldOrders[0] = this.data[i++] & 0xF;
        this.contentFlags = UnsignedByte.unsignedBytes2Int(this.data[i++], this.data[i++], this.data[i++], this.data[i++]);
        ++i;
        if (this.checkFlags(1)) {
            temp = new byte[256];
            j = 0;
            while (this.data[i] != 0) {
                temp[j++] = this.data[i++];
            }
            ++i;
            this.surname = StringManipulator.strip(new String(temp));
        }
        if (this.checkFlags(2)) {
            temp = new byte[256];
            j = 0;
            while (this.data[i] != 0) {
                temp[j++] = this.data[i++];
            }
            ++i;
            this.givenName = StringManipulator.strip(new String(temp));
        }
        if (this.checkFlags(4)) {
            temp = new byte[256];
            j = 0;
            while (this.data[i] != 0) {
                temp[j++] = this.data[i++];
            }
            ++i;
            this.company = StringManipulator.strip(new String(temp));
        }
        if (this.checkFlags(8)) {
            temp = new byte[256];
            j = 0;
            while (this.data[i] != 0) {
                temp[j++] = this.data[i++];
            }
            ++i;
            this.phones[0] = StringManipulator.strip(new String(temp));
        }
        if (this.checkFlags(16)) {
            temp = new byte[256];
            j = 0;
            while (this.data[i] != 0) {
                temp[j++] = this.data[i++];
            }
            ++i;
            this.phones[1] = StringManipulator.strip(new String(temp));
        }
        if (this.checkFlags(32)) {
            temp = new byte[256];
            j = 0;
            while (this.data[i] != 0) {
                temp[j++] = this.data[i++];
            }
            ++i;
            this.phones[2] = StringManipulator.strip(new String(temp));
        }
        if (this.checkFlags(64)) {
            temp = new byte[256];
            j = 0;
            while (this.data[i] != 0) {
                temp[j++] = this.data[i++];
            }
            ++i;
            this.phones[3] = StringManipulator.strip(new String(temp));
        }
        if (this.checkFlags(128)) {
            temp = new byte[256];
            j = 0;
            while (this.data[i] != 0) {
                temp[j++] = this.data[i++];
            }
            ++i;
            this.phones[4] = StringManipulator.strip(new String(temp));
        }
        if (this.checkFlags(256)) {
            temp = new byte[256];
            j = 0;
            while (this.data[i] != 0) {
                temp[j++] = this.data[i++];
            }
            ++i;
            this.address = StringManipulator.strip(new String(temp));
        }
        if (this.checkFlags(512)) {
            temp = new byte[256];
            j = 0;
            while (this.data[i] != 0) {
                temp[j++] = this.data[i++];
            }
            ++i;
            this.city = StringManipulator.strip(new String(temp));
        }
        if (this.checkFlags(1024)) {
            temp = new byte[256];
            j = 0;
            while (this.data[i] != 0) {
                temp[j++] = this.data[i++];
            }
            ++i;
            this.province = StringManipulator.strip(new String(temp));
        }
        if (this.checkFlags(2048)) {
            temp = new byte[256];
            j = 0;
            while (this.data[i] != 0) {
                temp[j++] = this.data[i++];
            }
            ++i;
            this.postalCode = StringManipulator.strip(new String(temp));
        }
        if (this.checkFlags(4096)) {
            temp = new byte[256];
            j = 0;
            while (this.data[i] != 0) {
                temp[j++] = this.data[i++];
            }
            ++i;
            this.country = StringManipulator.strip(new String(temp));
        }
        if (this.checkFlags(8192)) {
            temp = new byte[256];
            j = 0;
            while (this.data[i] != 0) {
                temp[j++] = this.data[i++];
            }
            ++i;
            this.title = StringManipulator.strip(new String(temp));
        }
        if (this.checkFlags(16384)) {
            temp = new byte[256];
            j = 0;
            while (this.data[i] != 0) {
                temp[j++] = this.data[i++];
            }
            ++i;
            this.customFields[0] = StringManipulator.strip(new String(temp));
        }
        if (this.checkFlags(32768)) {
            temp = new byte[256];
            j = 0;
            while (this.data[i] != 0) {
                temp[j++] = this.data[i++];
            }
            ++i;
            this.customFields[1] = StringManipulator.strip(new String(temp));
        }
        if (this.checkFlags(65536)) {
            temp = new byte[256];
            j = 0;
            while (this.data[i] != 0) {
                temp[j++] = this.data[i++];
            }
            ++i;
            this.customFields[2] = StringManipulator.strip(new String(temp));
        }
        if (this.checkFlags(131072)) {
            temp = new byte[256];
            j = 0;
            while (this.data[i] != 0) {
                temp[j++] = this.data[i++];
            }
            ++i;
            this.customFields[3] = StringManipulator.strip(new String(temp));
        }
        if (this.checkFlags(262144)) {
            temp = new byte[4096];
            j = 0;
            while (this.data[i] != 0) {
                temp[j++] = this.data[i++];
            }
            ++i;
            this.note = StringManipulator.strip(new String(temp));
        }
    }

    public void setAddress(String newValue) {
        if (!this.checkFlags(256) & newValue != null) {
            this.contentFlags |= 0x100;
        }
        if (newValue == null & this.checkFlags(256)) {
            this.contentFlags ^= 0x100;
        }
        this.address = newValue;
    }

    public void setCity(String newValue) {
        if (!this.checkFlags(512) & newValue != null) {
            this.contentFlags |= 0x200;
        }
        if (newValue == null & this.checkFlags(512)) {
            this.contentFlags ^= 0x200;
        }
        this.city = newValue;
    }

    public void setCompany(String newValue) {
        if (!this.checkFlags(4) & newValue != null) {
            this.contentFlags |= 4;
        }
        if (newValue == null & this.checkFlags(4)) {
            this.contentFlags ^= 4;
        }
        this.company = newValue;
    }

    public void setCountry(String newValue) {
        if (!this.checkFlags(4096) & newValue != null) {
            this.contentFlags |= 0x1000;
        }
        if (newValue == null & this.checkFlags(4096)) {
            this.contentFlags ^= 0x1000;
        }
        this.country = newValue;
    }

    public void setCustomFields(String[] newValue) {
        this.customFields = newValue;
    }

    public void setCustomField(String newValue, int i) {
        int FLAG;
        switch (i) {
            case 1: {
                FLAG = 16384;
                break;
            }
            case 2: {
                FLAG = 32768;
                break;
            }
            case 3: {
                FLAG = 65536;
                break;
            }
            default: {
                FLAG = 131072;
            }
        }
        if (!this.checkFlags(FLAG) & newValue != null) {
            this.contentFlags |= FLAG;
        }
        if (newValue == null & this.checkFlags(FLAG)) {
            this.contentFlags ^= FLAG;
        }
        this.customFields[(i - 1) % 4] = newValue;
    }

    public void setDisplayForList(int newValue) {
        this.displayForList = newValue;
    }

    public void setGivenName(String newValue) {
        if (!this.checkFlags(2) & newValue != null) {
            this.contentFlags |= 2;
        }
        if (newValue == null & this.checkFlags(2)) {
            this.contentFlags ^= 2;
        }
        this.givenName = newValue;
    }

    public void setNote(String newValue) {
        if (!this.checkFlags(262144) & newValue != null) {
            this.contentFlags |= 0x40000;
        }
        if (newValue == null & this.checkFlags(262144)) {
            this.contentFlags ^= 0x40000;
        }
        this.note = newValue;
    }

    public void setPhoneFields(int[] tmpOrders) {
        this.phoneFieldOrders = tmpOrders;
    }

    public void setPhoneField(int num, int newValue) {
        int FLAG;
        if (num < 0 | num > 5) {
            return;
        }
        switch (num) {
            case 1: {
                FLAG = 8;
                break;
            }
            case 2: {
                FLAG = 16;
                break;
            }
            case 3: {
                FLAG = 32;
                break;
            }
            case 4: {
                FLAG = 64;
                break;
            }
            default: {
                FLAG = 128;
            }
        }
        if (!this.checkFlags(FLAG)) {
            this.contentFlags |= FLAG;
        }
        this.phoneFieldOrders[num % 5] = newValue;
    }

    public void setPhones(String[] newValue) {
        this.phones = newValue;
    }

    public void setPhone(String newValue, int i) {
        this.phones[i] = newValue;
    }

    public void setPostalCode(String newValue) {
        if (!this.checkFlags(2048) & newValue != null) {
            this.contentFlags |= 0x800;
        }
        if (newValue == null & this.checkFlags(2048)) {
            this.contentFlags ^= 0x800;
        }
        this.postalCode = newValue;
    }

    public void setProvince(String newValue) {
        if (!this.checkFlags(1024) & newValue != null) {
            this.contentFlags |= 0x400;
        }
        if (newValue == null & this.checkFlags(1024)) {
            this.contentFlags ^= 0x400;
        }
        this.province = newValue;
    }

    public void setState(String newValue) {
        if (!this.checkFlags(1024) & newValue != null) {
            this.contentFlags |= 0x400;
        }
        if (newValue == null & this.checkFlags(1024)) {
            this.contentFlags ^= 0x400;
        }
        this.province = newValue;
    }

    public void setSurname(String newValue) {
        if (!this.checkFlags(1) & newValue != null) {
            this.contentFlags |= 1;
        }
        if (newValue == null & this.checkFlags(1)) {
            this.contentFlags ^= 1;
        }
        this.surname = newValue;
    }

    public void setTitle(String newValue) {
        if (!this.checkFlags(8192) & newValue != null) {
            this.contentFlags |= 0x2000;
        }
        if (newValue == null & this.checkFlags(8192)) {
            this.contentFlags ^= 0x2000;
        }
        this.title = newValue;
    }

    public String toString() {
        if (this.checkAttribute((byte)-128)) {
            return resJSyncManResources.getString("Deleted") + "\n";
        }
        StringBuffer buf = new StringBuffer();
        if (this.getTitle() != null) {
            buf.append("Title:                   " + this.getTitle() + "\n");
        }
        if (this.getGivenName() != null) {
            buf.append("First Name:              " + this.getGivenName() + "\n");
        }
        if (this.getSurname() != null) {
            buf.append("Surname:                 " + this.getSurname() + "\n");
        }
        if (this.getCompany() != null) {
            buf.append("Company:                 " + this.getCompany() + "\n");
        }
        if (this.getAddress() != null) {
            buf.append("Address:                 " + this.getAddress() + "\n");
        }
        if (this.getCity() != null) {
            buf.append("City:                    " + this.getCity() + "\n");
        }
        if (this.getProvince() != null) {
            buf.append("Province:                " + this.getProvince() + "\n");
        }
        if (this.getPostalCode() != null) {
            buf.append("Postal Code:             " + this.getPostalCode() + "\n");
        }
        int i = 0;
        while (i < 5) {
            if (this.getPhones(i) != null) {
                String temp = this.getPhoneFieldTitle(this.getPhoneField(i));
                buf.append(temp + ":");
                int j = temp.length();
                while (j < 25) {
                    buf.append(" ");
                    ++j;
                }
                buf.append(temp + this.getPhones(i) + "\n");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < 4) {
            if (this.getCustomField(i2) != null) {
                buf.append("Custom " + i2 + ":                " + this.getCustomField(i2) + "\n");
            }
            ++i2;
        }
        if (this.getNote() != null) {
            buf.append("Note:                    " + this.getNote() + "\n");
        }
        return buf.toString();
    }

    public String toString(AddressAppBlock appBlock) {
        if (appBlock == null) {
            return this.toString();
        }
        StringBuffer buf = new StringBuffer();
        if (this.getTitle() != null) {
            buf.append("Title:                   " + this.getTitle() + "\n");
        }
        if (this.getGivenName() != null) {
            buf.append("First Name:              " + this.getGivenName() + "\n");
        }
        if (this.getSurname() != null) {
            buf.append("Surname:                 " + this.getSurname() + "\n");
        }
        if (this.getCompany() != null) {
            buf.append("Company:                 " + this.getCompany() + "\n");
        }
        if (this.getAddress() != null) {
            buf.append("Address:                 " + this.getAddress() + "\n");
        }
        if (this.getCity() != null) {
            buf.append("City:                    " + this.getCity() + "\n");
        }
        if (this.getProvince() != null) {
            buf.append("Province:                " + this.getProvince() + "\n");
        }
        if (this.getPostalCode() != null) {
            buf.append("Postal Code:             " + this.getPostalCode() + "\n");
        }
        int i = 0;
        while (i < 5) {
            if (this.getPhones(i) != null) {
                String temp = this.getPhoneFieldTitle(this.getPhoneField(i));
                buf.append(temp + ":");
                int j = temp.length();
                while (j < 25) {
                    buf.append(" ");
                    ++j;
                }
                buf.append(temp + this.getPhones(i) + "\n");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < 4) {
            if (this.getCustomField(i2) != null) {
                String temp = new String(appBlock.getFieldLabel(i2 + 14).trim() + ":");
                buf.append(temp);
                int k = temp.length();
                while (k < 25) {
                    buf.append(" ");
                    ++k;
                }
                buf.append(this.getCustomField(i2) + "\n");
            }
            ++i2;
        }
        if (this.getNote() != null) {
            buf.append("Note:                    " + this.getNote() + "\n");
        }
        return buf.toString();
    }
}

