/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util.StdApps;

import java.io.IOException;
import java.io.InputStreamReader;
import javax.xml.parsers.ParserConfigurationException;
import org.jSyncManager.API.Protocol.Util.DLPRecordXML;
import org.jSyncManager.API.Protocol.Util.StdApps.AddressRecord;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class AddressDBXML
extends DLPRecordXML {
    public static String XMLNAME = "jSyncManagerAddressDB";
    AddressRecord record = null;
    private static int phone_title_ctr = 0;
    private static int phone_ctr = 0;
    private static int custom_ctr = 0;

    public AddressDBXML() throws ParserConfigurationException, SAXException {
        DOMImplementation domimpl = this.getBuilder().getDOMImplementation();
        DocumentType doctype = domimpl.createDocumentType(XMLNAME, XMLNAME + ".dtd", null);
        this.setDocument(domimpl.createDocument(null, XMLNAME, doctype));
    }

    public AddressDBXML(AddressRecord rec) throws ParserConfigurationException, SAXException {
        this.record = rec;
    }

    public AddressDBXML(Document document) throws ParserConfigurationException, SAXException {
        this.setDocument(document);
    }

    public AddressDBXML(InputStreamReader inputfile) throws ParserConfigurationException, SAXException, IOException {
        super(inputfile);
        this.readDocument(inputfile);
    }

    public AddressRecord insertRecord(AddressRecord rec) {
        Element elem = this.getDocument().getDocumentElement();
        Element tmpelem = null;
        this.record = rec;
        tmpelem = this.createElem("jSyncManagerAddressRecord", elem);
        super.insertRecord(this.record, tmpelem);
        if (this.record.checkFlags(256)) {
            this.createElem("address", tmpelem, this.record.getAddress());
        }
        if (this.record.checkFlags(512)) {
            this.createElem("city", tmpelem, this.record.getCity());
        }
        if (this.record.checkFlags(4)) {
            this.createElem("company", tmpelem, this.record.getCompany());
        }
        if (this.record.checkFlags(4096)) {
            this.createElem("country", tmpelem, this.record.getCountry());
        }
        if (this.record.checkFlags(16384)) {
            this.createElem("customfield", tmpelem, this.record.getCustomField(0));
        }
        if (this.record.checkFlags(32768)) {
            this.createElem("customfield", tmpelem, this.record.getCustomField(1));
        }
        if (this.record.checkFlags(65536)) {
            this.createElem("customfield", tmpelem, this.record.getCustomField(2));
        }
        if (this.record.checkFlags(131072)) {
            this.createElem("customfield", tmpelem, this.record.getCustomField(3));
        }
        this.createElem("displayforlist", tmpelem, this.record.getDisplayForList());
        if (this.record.checkFlags(2)) {
            this.createElem("givenname", tmpelem, this.record.getGivenName());
        }
        if (this.record.checkFlags(262144)) {
            this.createElem("note", tmpelem, this.record.getNote());
        }
        if (this.record.checkFlags(8)) {
            this.createElem("phone", tmpelem, this.record.getPhones(0));
        }
        if (this.record.checkFlags(16)) {
            this.createElem("phone", tmpelem, this.record.getPhones(1));
        }
        if (this.record.checkFlags(32)) {
            this.createElem("phone", tmpelem, this.record.getPhones(2));
        }
        if (this.record.checkFlags(64)) {
            this.createElem("phone", tmpelem, this.record.getPhones(3));
        }
        if (this.record.checkFlags(128)) {
            this.createElem("phone", tmpelem, this.record.getPhones(4));
        }
        int i = 0;
        while (i < 5) {
            this.createElem("phoneField", tmpelem, this.record.getPhoneField(i));
            ++i;
        }
        if (this.record.checkFlags(2048)) {
            this.createElem("postal", tmpelem, this.record.getPostalCode());
        }
        if (this.record.checkFlags(1024)) {
            this.createElem("province", tmpelem, this.record.getProvince());
        }
        if (this.record.checkFlags(1)) {
            this.createElem("surname", tmpelem, this.record.getSurname());
        }
        if (this.record.checkFlags(8192)) {
            this.createElem("title", tmpelem, this.record.getTitle());
        }
        return this.record;
    }

    public void readDocument(InputStreamReader inputfile) throws ParserConfigurationException, SAXException, IOException {
        super.readDocument(inputfile);
        Element element = this.getDocument().getDocumentElement();
        if (element != null && element.getTagName().equals("jSyncManagerAddressDB")) {
            this.readElement_jSyncManagerAddressDB(element);
        }
    }

    void readElement_jSyncManagerAddressDB(Element element) throws ParserConfigurationException, SAXException {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1) {
                Element nodeElement = (Element)node;
                if (nodeElement.getTagName().equals("jSyncManagerDLPRecord")) {
                    super.readElement(nodeElement);
                }
                if (nodeElement.getTagName().equals("jSyncManagerAddressRecord")) {
                    this.readElement_jSyncManagerAddressRecord(nodeElement);
                }
            }
            ++i;
        }
    }

    void readElement_jSyncManagerAddressRecord(Element element) throws ParserConfigurationException, SAXException {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1) {
                Element nodeElement = (Element)node;
                if (element != null) {
                    if (nodeElement.getTagName().equals("addrrecname")) {
                        this.readElement_addrrecname(nodeElement);
                    }
                    if (nodeElement.getTagName().equals("title")) {
                        this.record.setTitle(this.readStringElement(nodeElement));
                    }
                    if (nodeElement.getTagName().equals("company")) {
                        this.record.setCompany(this.readStringElement(nodeElement));
                    }
                    if (nodeElement.getTagName().equals("address")) {
                        this.readElement_address(nodeElement);
                    }
                    if (nodeElement.getTagName().equals("phone")) {
                        this.readElement_phone(nodeElement);
                    }
                    if (nodeElement.getTagName().equals("customfield")) {
                        this.readElement_customfield(nodeElement);
                    }
                    if (nodeElement.getTagName().equals("displayforlist")) {
                        this.record.setDisplayForList(this.readIntElement(nodeElement));
                    }
                }
            }
            ++i;
        }
    }

    void readElement_addrrecname(Element element) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node != null && node.getNodeType() == 1) {
                Element nodeElement = (Element)node;
                if (nodeElement.getTagName().equals("surname")) {
                    this.record.setSurname(this.readStringElement(element));
                }
                if (nodeElement.getTagName().equals("givenname")) {
                    this.record.setGivenName(this.readStringElement(element));
                }
            }
            ++i;
        }
    }

    void readElement_address(Element element) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node != null && node.getNodeType() == 1) {
                Element nodeElement = (Element)node;
                if (nodeElement.getTagName().equals("street")) {
                    this.record.setAddress(this.readStringElement(nodeElement));
                }
                if (nodeElement.getTagName().equals("city")) {
                    this.record.setCity(this.readStringElement(nodeElement));
                }
                if (nodeElement.getTagName().equals("province")) {
                    this.record.setProvince(this.readStringElement(nodeElement));
                }
                if (nodeElement.getTagName().equals("postalCode")) {
                    this.record.setPostalCode(this.readStringElement(nodeElement));
                }
                if (nodeElement.getTagName().equals("country")) {
                    this.record.setCountry(this.readStringElement(nodeElement));
                }
            }
            ++i;
        }
    }

    void readElement_phone(Element element) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node != null && node.getNodeType() == 1) {
                Element nodeElement = (Element)node;
                if (nodeElement.getTagName().equals("phonefieldtitle")) {
                    this.record.setPhoneFields(this.readIntArrayElement(element));
                }
                if (nodeElement.getTagName().equals("phonefield")) {
                    this.record.setPhones(this.readStringArrayElement(element));
                    this.readElement_phonefield(nodeElement);
                }
            }
            ++i;
        }
    }

    void readElement_phonefieldtitle(Element element) {
    }

    void readElement_phonefield(Element element) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node != null && node.getNodeType() == 3) {
                this.record.setPhone(((Text)node).getData(), phone_ctr++);
            }
            ++i;
        }
    }

    void readElement_customfield(Element element) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node != null && node.getNodeType() == 3) {
                this.record.setCustomField(((Text)node).getData(), custom_ctr++);
            }
            ++i;
        }
    }

    void readElement_addressnote(Element element) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node != null && node.getNodeType() == 3) {
                this.record.setNote(((Text)node).getData());
            }
            ++i;
        }
    }

    void readElement_displayforlist(Element element) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node != null && node.getNodeType() == 3) {
                int display = Integer.parseInt(((Text)node).getData());
                this.record.setDisplayForList(display);
            }
            ++i;
        }
    }
}

