/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util.StdApps;

import org.jSyncManager.API.Protocol.Util.DLPBlock;
import org.jSyncManager.API.Protocol.Util.StdApps.CategoryInfo;
import org.jSyncManager.API.Tools.StringManipulator;
import org.jSyncManager.API.Tools.UnsignedByte;

public class AddressAppBlock
extends DLPBlock {
    public static final byte AUSTRALIA = 0;
    public static final byte AUSTRIA = 1;
    public static final byte BELGIUM = 2;
    public static final byte BRAZIL = 3;
    public static final byte CANADA = 4;
    public static final byte DENMARK = 5;
    public static final byte FINLAND = 6;
    public static final byte FRANCE = 7;
    public static final byte GERMANY = 8;
    public static final byte HONGKONG = 9;
    public static final byte ICELAND = 10;
    public static final byte IRELAND = 11;
    public static final byte ITALY = 12;
    public static final byte JAPAN = 13;
    public static final byte LUXEMBOURG = 14;
    public static final byte MEXICO = 15;
    public static final byte NETHERLANDS = 16;
    public static final byte NEWZEALAND = 17;
    public static final byte NORWAY = 18;
    public static final byte SPAIN = 19;
    public static final byte SWEDEN = 20;
    public static final byte SWITZERLAND = 21;
    public static final byte UNITEDKINGDOM = 22;
    public static final byte UNITEDSTATES = 23;
    public static final char CATEGORY1 = '\u0001';
    public static final char CATEGORY2 = '\u0002';
    public static final char CATEGORY3 = '\u0004';
    public static final char CATEGORY4 = '\b';
    public static final char CATEGORY5 = '\u0010';
    public static final char CATEGORY6 = ' ';
    public static final char CATEGORY7 = '@';
    public static final char CATEGORY8 = '\u0080';
    public static final char CATEGORY9 = '\u0100';
    public static final char CATEGORY10 = '\u0200';
    public static final char CATEGORY11 = '\u0400';
    public static final char CATEGORY12 = '\u0800';
    public static final char CATEGORY13 = '\u1000';
    public static final char CATEGORY14 = '\u2000';
    public static final char CATEGORY15 = '\u4000';
    public static final char CATEGORY16 = '\u8000';
    public static final int NUM_FIELD_LABELS = 22;
    private CategoryInfo[] categories = new CategoryInfo[16];
    private int modifiedFieldLabelBitmap = 0;
    private String[] fieldLabels = new String[22];
    private byte countryCode = 0;
    private boolean viewByCompany = false;
    private byte lastUniqueID = 0;
    private int numCategories = 0;

    public AddressAppBlock() {
    }

    public AddressAppBlock(DLPBlock block) {
        this.data = block.getData();
        this.blockSize = block.getBlockSize();
        this.parseFields();
    }

    private int convertBitmapToOffset(int value) {
        return (int)(Math.log(value) / Math.log(2.0));
    }

    private void generateData() {
        int size = 0;
        int i = 0;
        size += 14;
        size += 256;
        size += 16;
        this.data = new byte[size += 352];
        this.data[i++] = 0;
        this.data[i++] = 0;
        int j = 0;
        while (j < 16) {
            byte[] temp = this.categories[j].getCategoryName().getBytes();
            int k = 0;
            while (k < temp.length) {
                this.data[i++] = temp[k];
                ++k;
            }
            int k2 = 0;
            while (k2 < 16 - temp.length) {
                this.data[i++] = 0;
                ++k2;
            }
            ++j;
        }
        int j2 = 0;
        while (j2 < 16) {
            this.data[i++] = this.categories[j2].getCategoryID();
            ++j2;
        }
        this.data[i++] = this.getLastUniqueID();
        this.data[i++] = 0;
        this.data[i++] = 0;
        this.data[i++] = 0;
        this.data[i++] = 0;
        this.data[i++] = 0;
        this.data[i++] = 0;
        this.data[i++] = 0;
        int j3 = 0;
        while (j3 < 22) {
            byte[] temp = this.getFieldLabel(j3).getBytes();
            int k = 0;
            while (k < temp.length) {
                this.data[i++] = temp[k];
                ++k;
            }
            int k3 = 0;
            while (k3 < 16 - temp.length) {
                this.data[i++] = 0;
                ++k3;
            }
            ++j3;
        }
        this.data[i++] = this.getCountryCode();
        this.data[i++] = this.getViewByCompany() ? (byte)1 : 0;
        this.data[i++] = 0;
        this.data[i++] = 0;
    }

    public CategoryInfo getCategoryInfo(int i) {
        return this.categories[i % 16];
    }

    public byte getCountryCode() {
        return this.countryCode;
    }

    public byte[] getData() {
        this.generateData();
        return this.data;
    }

    public String getFieldLabel(int i) {
        return this.fieldLabels[i % 22];
    }

    public String getFieldLabelByBitmap(int i) {
        return this.fieldLabels[this.convertBitmapToOffset(i) % 22];
    }

    public byte getLastUniqueID() {
        return this.lastUniqueID;
    }

    public int getNumCategories() {
        return this.numCategories;
    }

    public boolean getViewByCompany() {
        return this.viewByCompany;
    }

    public boolean isFieldModified(int category) {
        return (this.modifiedFieldLabelBitmap & category) > 0;
    }

    private void parseFields() {
        String[] catNames = new String[16];
        byte[] catIDs = new byte[16];
        int i = 0;
        char renamedCatsBitmap = UnsignedByte.unsignedBytes2Char(this.data[i++], this.data[i++]);
        int j = 0;
        while (j < 16) {
            byte[] tempName = new byte[16];
            int k = 0;
            while (k < 16) {
                tempName[k] = this.data[i++];
                ++k;
            }
            catNames[j] = StringManipulator.strip(new String(tempName));
            if (catNames[j].length() > 0) {
                ++this.numCategories;
            }
            ++j;
        }
        int j2 = 0;
        while (j2 < 16) {
            catIDs[j2] = this.data[i++];
            ++j2;
        }
        this.lastUniqueID = this.data[i++];
        int j3 = 0;
        while (j3 < 16) {
            this.categories[j3] = new CategoryInfo();
            this.categories[j3].setCategoryID(catIDs[j3]);
            this.categories[j3].setCategoryName(catNames[j3]);
            this.categories[j3].setModifiedFlag((renamedCatsBitmap & (char)Math.pow(2.0, j3)) > 0);
            ++j3;
        }
        i += 3;
        this.modifiedFieldLabelBitmap = UnsignedByte.unsignedBytes2Int(this.data[i++], this.data[i++], this.data[i++], this.data[i++]);
        int j4 = 0;
        while (j4 < 22) {
            byte[] tempName = new byte[16];
            int k = 0;
            while (k < 16) {
                tempName[k] = this.data[i++];
                ++k;
            }
            this.fieldLabels[j4] = StringManipulator.strip(new String(tempName));
            ++j4;
        }
        this.countryCode = this.data[i++];
        if (this.data[i++] != 0) {
            this.viewByCompany = true;
        }
    }

    public void setCategoryInfo(CategoryInfo info, int i) {
        this.categories[i % 16] = info;
    }

    public void setCountryCode(byte newValue) {
        this.countryCode = newValue;
    }

    public void setFieldLabel(String label, int i) {
        this.fieldLabels[(i + 1) % 22] = label;
    }

    public void setLastUniqueID(byte newValue) {
        this.lastUniqueID = newValue;
    }

    private void setNumCategories(int newValue) {
        this.numCategories = newValue;
    }

    public void setViewByCompany(boolean newValue) {
        this.viewByCompany = newValue;
    }
}

