/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JSXMLDocument {
    Document document;
    DocumentBuilder builder = null;

    public JSXMLDocument() throws ParserConfigurationException, SAXException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        this.builder = builderFactory.newDocumentBuilder();
        this.builder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (publicId.equals("--myDTDpublicID--")) {
                    return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                }
                return null;
            }
        });
    }

    public JSXMLDocument(Document document) throws SAXException {
        this.document = document;
    }

    public JSXMLDocument(InputStreamReader inputfile) throws ParserConfigurationException, SAXException, IOException {
        this.readDocument(inputfile);
    }

    public void readDocument(InputStreamReader inputfile) throws ParserConfigurationException, SAXException, IOException {
        this.document = this.builder.parse(new InputSource(inputfile));
    }

    public void writeDocument(OutputStreamWriter outputfile) throws SAXException, IOException {
        int indent = 0;
        Element element = this.document.getDocumentElement();
        if (element != null) {
            ProcessingInstruction startproc = this.document.createProcessingInstruction("xml", "version=\"1.0\" encoding=\"UTF-8\"");
            this.writeProcInstruction(outputfile, startproc, indent);
            this.writeDocument(outputfile, element, indent);
        }
    }

    public void writeDocument(OutputStreamWriter outputfile, String encoding) throws SAXException, IOException {
        int indent = 0;
        Element element = this.document.getDocumentElement();
        ProcessingInstruction startproc = this.document.createProcessingInstruction("xml", "version=\"1.0\"");
        startproc.setData(startproc.getData() + " encoding=\"" + encoding + "\"");
        this.writeProcInstruction(outputfile, startproc, indent);
        this.writeDocument(outputfile, element, indent);
    }

    public void writeDocument(OutputStreamWriter outputfile, Element element, int indent) throws SAXException, IOException {
        this.writeElemTag(outputfile, element, indent);
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    if (element == null) break;
                    this.writeCData(outputfile, (CDATASection)node, indent + 1);
                    break;
                }
                case 1: {
                    if (element == null) break;
                    this.writeElemTag(outputfile, (Element)node, indent + 1);
                    this.writeElement(outputfile, (Element)node, indent + 2);
                    this.writeElemUnTag(outputfile, (Element)node, indent + 1);
                    break;
                }
                case 7: {
                    if (element == null) break;
                    this.writeProcInstruction(outputfile, (ProcessingInstruction)node, indent + 1);
                }
            }
            ++i;
        }
        this.writeElemUnTag(outputfile, element, indent);
    }

    public void writeElement(OutputStreamWriter outputfile, Element element, int indent) throws IOException {
        NodeList nodes = element.getChildNodes();
        int x = 0;
        while (x < nodes.getLength()) {
            Node node = nodes.item(x);
            switch (node.getNodeType()) {
                case 2: {
                    break;
                }
                case 4: {
                    if (element == null) break;
                    this.writeCData(outputfile, (CDATASection)node, indent);
                    break;
                }
                case 1: {
                    if (element == null) break;
                    this.writeElemTag(outputfile, (Element)node, indent);
                    this.writeElement(outputfile, (Element)node, indent + 1);
                    this.writeElemUnTag(outputfile, (Element)node, indent);
                    break;
                }
                case 7: {
                    if (element == null) break;
                    this.writeProcInstruction(outputfile, (ProcessingInstruction)node, indent);
                    break;
                }
                case 3: {
                    String tmpstr = ((Text)node).getData();
                    if (tmpstr == null) break;
                    this.writeIndent(outputfile, indent);
                    outputfile.write(this.escape(tmpstr) + "\n");
                }
            }
            ++x;
        }
    }

    public void writeProcInstruction(OutputStreamWriter outputfile, ProcessingInstruction element, int indent) throws IOException {
        this.writeIndent(outputfile, indent);
        outputfile.write("<?" + element.getTarget() + " " + element.getData() + "?>\n");
    }

    public void writeCData(OutputStreamWriter outputfile, CDATASection element, int indent) throws IOException {
        this.writeIndent(outputfile, indent);
        outputfile.write("<![CDATA[\n");
        this.writeIndent(outputfile, indent + 1);
        outputfile.write(element.getData() + "\n");
        this.writeIndent(outputfile, indent);
        outputfile.write("]]>\n");
    }

    public void writeElemTag(OutputStreamWriter outputfile, Element element, int indent) throws IOException {
        this.writeIndent(outputfile, indent);
        outputfile.write("<" + element.getTagName());
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            if (((Attr)attrs.item(i)).getSpecified()) {
                outputfile.write(" " + ((Attr)attrs.item(i)).getNodeName() + "=\"");
                outputfile.write(((Attr)attrs.item(i)).getValue() + "\"");
            }
            ++i;
        }
        outputfile.write(">\n");
    }

    public void writeElemUnTag(OutputStreamWriter outputfile, Element element, int indent) throws IOException {
        this.writeIndent(outputfile, indent);
        outputfile.write("</" + element.getTagName() + ">\n");
    }

    public void writeIndent(OutputStreamWriter outputfile, int indent) throws IOException {
        int i = 0;
        while (i < indent) {
            outputfile.write("\t");
            ++i;
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public DocumentBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(DocumentBuilder builder) {
        this.builder = builder;
    }

    protected Element createElem(String name, Element toElem) {
        Element tmpelem = this.getDocument().createElement(name);
        toElem.appendChild(tmpelem);
        return tmpelem;
    }

    protected Element createCDataElem(String name, Element toElem, String value) {
        Element tmpelem = this.getDocument().createElement(name);
        CDATASection valueElem = this.getDocument().createCDATASection(value);
        if (valueElem != null) {
            tmpelem.appendChild(valueElem);
        }
        toElem.appendChild(tmpelem);
        return tmpelem;
    }

    protected Element createCDataElemArray(String name, Element toElem, String[] value) {
        Element tmpelem = this.getDocument().createElement(name);
        int i = 0;
        while (i < value.length) {
            CDATASection valueElem = this.getDocument().createCDATASection(value[i]);
            if (valueElem != null) {
                tmpelem.appendChild(valueElem);
            }
            ++i;
        }
        toElem.appendChild(tmpelem);
        return tmpelem;
    }

    public Element createElem(String name, Element elem, Calendar dateentry) {
        Element tmpelem = this.createElem(name, elem);
        this.createElem("dst", tmpelem, dateentry.getTimeZone().useDaylightTime());
        this.createElem("month", tmpelem, dateentry.get(2));
        this.createElem("dayofmonth", tmpelem, dateentry.get(5));
        this.createElem("year", tmpelem, dateentry.get(1));
        this.createElem("hour", tmpelem, dateentry.get(10));
        this.createElem("minute", tmpelem, dateentry.get(12));
        this.createElem("second", tmpelem, dateentry.get(13));
        this.createElem("timezone", tmpelem, dateentry.getTimeZone().getDisplayName());
        return tmpelem;
    }

    protected Element createElem(String name, Element toElem, String value) {
        Element tmpelem = this.getDocument().createElement(name);
        Text valueElem = null;
        valueElem = value.substring(0, 4).equalsIgnoreCase("&#0x") ? this.getDocument().createTextNode(value) : this.getDocument().createTextNode(this.escape(value));
        if (valueElem != null) {
            tmpelem.appendChild(valueElem);
        }
        toElem.appendChild(tmpelem);
        return tmpelem;
    }

    protected Element createElem(String name, Element toElem, boolean value) {
        return this.createElem(name, toElem, value ? "true" : "false");
    }

    protected Element createElem(String name, Element toElem, char value) {
        return this.createCDataElem(name, toElem, this.escape(value));
    }

    protected Element createElem(String name, Element toElem, char[] value) {
        return this.createCDataElemArray(name, toElem, this.escape(value));
    }

    protected Element createElem(String name, Element toElem, byte value) {
        return this.createCDataElem(name, toElem, this.escape(value));
    }

    protected Element createElem(String name, Element toElem, byte[] value) {
        return this.createCDataElemArray(name, toElem, this.escape(value));
    }

    protected Element createElem(String name, Element toElem, int value) {
        return this.createCDataElem(name, toElem, this.escape(value));
    }

    protected Element createElem(String name, Element toElem, int[] value) {
        return this.createCDataElemArray(name, toElem, this.escape(value));
    }

    protected Element createElem(String name, Element toElem, long value) {
        return this.createCDataElem(name, toElem, this.escape(value));
    }

    protected Element createElem(String name, Element toElem, long[] value) {
        return this.createCDataElemArray(name, toElem, this.escape(value));
    }

    protected Element createElem(String name, Element toElem, float value) {
        return this.createCDataElem(name, toElem, this.escape(value));
    }

    protected Element createElem(String name, Element toElem, float[] value) {
        return this.createCDataElemArray(name, toElem, this.escape(value));
    }

    protected Element createElem(String name, Element toElem, double value) {
        return this.createCDataElem(name, toElem, this.escape(value));
    }

    protected Element createElem(String name, Element toElem, double[] value) {
        return this.createCDataElemArray(name, toElem, this.escape(value));
    }

    protected Element createElem(String name, Element toElem, StringBuffer value) {
        return this.createElem(name, toElem, new String(value));
    }

    public String readStringElement(Node node) {
        return ((Text)node).getData();
    }

    public String[] readStringArrayElement(Node node) {
        NodeList nodes = node.getChildNodes();
        String[] tmp = new String[nodes.getLength()];
        int i = 0;
        while (i < nodes.getLength()) {
            Text cdata = (Text)nodes.item(i);
            if (cdata == null || cdata.getNodeType() != 3) {
                throw new DOMException(3, "String Array representations must be in a Text Node");
            }
            tmp[i] = this.unescapeString(cdata.getData());
            ++i;
        }
        return tmp;
    }

    public boolean readBooleanElement(Node node) {
        boolean tmp = false;
        if (node != null && node.getNodeType() == 4) {
            tmp = ((Text)node).getData().equalsIgnoreCase("true");
        }
        return tmp;
    }

    public byte readByteElement(Node node) {
        CDATASection cdata = (CDATASection)node.getFirstChild();
        if (node == null || node.getNodeType() != 4) {
            throw new DOMException(3, "Byte representations must be in a CDATA Section Node");
        }
        byte tmp = this.unescapeByte(cdata.getData());
        return tmp;
    }

    public byte[] readByteArrayElement(Node node) {
        NodeList nodes = node.getChildNodes();
        byte[] tmp = new byte[nodes.getLength()];
        int i = 0;
        while (i < nodes.getLength()) {
            CDATASection cdata = (CDATASection)nodes.item(i);
            if (cdata == null || cdata.getNodeType() != 4) {
                throw new DOMException(3, "Byte Array representations must be in a CDATA Section Node");
            }
            tmp = this.unescapeByteArray(cdata.getData());
            ++i;
        }
        return tmp;
    }

    public char readCharElement(Node node) {
        CDATASection cdata = (CDATASection)node.getFirstChild();
        char tmp = '\u0000';
        if (node == null || node.getNodeType() != 4) {
            throw new DOMException(3, "Character representations must be in a CDATA Section Node");
        }
        tmp = this.unescapeChar(cdata.getData());
        return tmp;
    }

    public char[] readCharArrayElement(Node node) {
        NodeList nodes = node.getChildNodes();
        char[] tmp = new char[nodes.getLength()];
        int i = 0;
        while (i < nodes.getLength()) {
            CDATASection cdata = (CDATASection)nodes.item(i);
            if (cdata == null || cdata.getNodeType() != 4) {
                throw new DOMException(3, "Character Array representations must be in a CDATA Section Node");
            }
            tmp = this.unescapeCharArray(cdata.getData());
            ++i;
        }
        return tmp;
    }

    public int readIntElement(Node node) {
        int tmp = 0;
        CDATASection cdata = (CDATASection)node.getFirstChild();
        if (node == null || node.getNodeType() != 4) {
            throw new DOMException(3, "Integer representations must be in a CDATA Section Node");
        }
        tmp = this.unescapeInt(cdata.getData());
        return tmp;
    }

    public int[] readIntArrayElement(Node node) {
        NodeList nodes = node.getChildNodes();
        int[] tmp = new int[nodes.getLength()];
        int i = 0;
        while (i < nodes.getLength()) {
            CDATASection cdata = (CDATASection)nodes.item(i);
            if (cdata == null || cdata.getNodeType() != 4) {
                throw new DOMException(3, "Integer Array representations must be in a CDATA Section Node");
            }
            tmp = this.unescapeIntArray(cdata.getData());
            ++i;
        }
        return tmp;
    }

    public long readLongElement(Node node) {
        long tmp = 0L;
        CDATASection cdata = (CDATASection)node.getFirstChild();
        if (node == null || node.getNodeType() != 4) {
            throw new DOMException(3, "Long representations must be in a CDATA Section Node");
        }
        tmp = this.unescapeLong(cdata.getData());
        return tmp;
    }

    public long[] readLongArrayElement(Node node) {
        NodeList nodes = node.getChildNodes();
        long[] tmp = new long[nodes.getLength()];
        int i = 0;
        while (i < nodes.getLength()) {
            CDATASection cdata = (CDATASection)nodes.item(i);
            if (cdata == null || cdata.getNodeType() != 4) {
                throw new DOMException(3, "Long Array representations must be in a CDATA Section Node");
            }
            tmp = this.unescapeLongArray(cdata.getData());
            ++i;
        }
        return tmp;
    }

    public float readFloatElement(Node node) {
        float tmp = 0.0f;
        CDATASection cdata = (CDATASection)node.getFirstChild();
        if (node == null || node.getNodeType() != 4) {
            throw new DOMException(3, "Float representations must be in a CDATA Section Node");
        }
        tmp = this.unescapeFloat(cdata.getData());
        return tmp;
    }

    public float[] readFloatArrayElement(Node node) {
        NodeList nodes = node.getChildNodes();
        float[] tmp = new float[nodes.getLength()];
        int i = 0;
        while (i < nodes.getLength()) {
            CDATASection cdata = (CDATASection)nodes.item(i);
            if (cdata == null || cdata.getNodeType() != 4) {
                throw new DOMException(3, "Float Array representations must be in a CDATA Section Node");
            }
            tmp = this.unescapeFloatArray(cdata.getData());
            ++i;
        }
        return tmp;
    }

    public double readDoubleElement(Node node) {
        double tmp = 0.0;
        CDATASection cdata = (CDATASection)node.getFirstChild();
        if (node == null || node.getNodeType() != 4) {
            throw new DOMException(3, "Double representations must be in a CDATA Section Node");
        }
        tmp = this.unescapeDouble(cdata.getData());
        return tmp;
    }

    public double[] readDoubleArrayElement(Node node) {
        NodeList nodes = node.getChildNodes();
        double[] tmp = new double[nodes.getLength()];
        int i = 0;
        while (i < nodes.getLength()) {
            CDATASection cdata = (CDATASection)nodes.item(i);
            if (cdata == null || cdata.getNodeType() != 4) {
                throw new DOMException(3, "Double Array representations must be in a CDATA Section Node");
            }
            tmp = this.unescapeDoubleArray(cdata.getData());
            ++i;
        }
        return tmp;
    }

    public String escape(String in) {
        String out = new String();
        int i = 0;
        while (i < in.length()) {
            char c = in.charAt(i);
            out = out + this.escape(c);
            ++i;
        }
        return out;
    }

    public String escape(byte in) {
        return "&#0x" + Integer.toString(in, 16) + ";";
    }

    public String[] escape(byte[] in) {
        String[] tmp = new String[in.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = this.escape(in[i]);
            ++i;
        }
        return tmp;
    }

    public String escape(char in) {
        String out = new String();
        if (in < ' ' || in > '~') {
            out = out + "&#0x" + Integer.toString(in, 16) + ";";
        } else {
            switch (in) {
                case '(': {
                    out = out + "&#0x0028;";
                    break;
                }
                case ')': {
                    out = out + "&#0x0029;";
                    break;
                }
                case '<': {
                    out = out + "&lt;";
                    break;
                }
                case '>': {
                    out = out + "&gt;";
                    break;
                }
                case '&': {
                    out = out + "&amp;";
                    break;
                }
                case '\"': {
                    out = out + "&quot;";
                    break;
                }
                default: {
                    out = out + in;
                }
            }
        }
        return out;
    }

    public String[] escape(char[] in) {
        String[] tmp = new String[in.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = this.escape(in[i]);
            ++i;
        }
        return tmp;
    }

    public String escape(int in) {
        return "&#0x" + Integer.toString(in, 16) + ";";
    }

    public String[] escape(int[] in) {
        String[] tmp = new String[in.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = "&#0x" + Integer.toString(in[i], 16) + ";";
            ++i;
        }
        return tmp;
    }

    public String escape(long in) {
        return "&#0x" + Long.toString(in, 16) + ";";
    }

    public String[] escape(long[] in) {
        String[] tmp = new String[in.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = "&#0x" + Long.toString(in[i], 16) + ";";
            ++i;
        }
        return tmp;
    }

    public String escape(float in) {
        return "&#0x" + Float.toString(in) + ";";
    }

    public String[] escape(float[] in) {
        String[] tmp = new String[in.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = "&#0x" + Float.toString(in[i]) + ";";
            ++i;
        }
        return tmp;
    }

    public String escape(double in) {
        return "&#0x" + Double.toString(in) + ";";
    }

    public String[] escape(double[] in) {
        String[] tmp = new String[in.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = "&#0x" + Double.toString(in[i]) + ";";
            ++i;
        }
        return tmp;
    }

    public String unescapeString(String input) {
        return new String(this.unescapeCharArray(input));
    }

    public String[] unescapeStringArray(String[] input) {
        String[] tmp = new String[input.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = this.unescapeString(input[i]);
            ++i;
        }
        return tmp;
    }

    public byte unescapeByte(String input) throws NumberFormatException {
        if (!input.substring(0, 4).equalsIgnoreCase("&#0x")) {
            throw new NumberFormatException("Input to JSXMLDocument.unescapeByte(String) should be in the format \"&#0x<hex>;\"");
        }
        return Byte.valueOf(input.substring(4, input.length() - 1), 16);
    }

    public byte[] unescapeByteArray(String input) throws NumberFormatException {
        String tmpstr = input.trim();
        Vector<Byte> vtmpstr = new Vector<Byte>(1, 1);
        int lastctr = 0;
        boolean ctr = false;
        while (lastctr != input.length()) {
            if (tmpstr.substring(0, 4).equalsIgnoreCase("&#0x")) {
                int index = tmpstr.indexOf(";");
                vtmpstr.addElement(new Byte(this.unescapeByte(tmpstr.substring(0, index + 1))));
                tmpstr = tmpstr.substring(index + 1);
                lastctr = index + 1;
                continue;
            }
            throw new NumberFormatException("Input to JSXMLDocument.unescapeByteArray(String) should be in the format [\"&#0x<hex>;\"]*");
        }
        byte[] tmp = new byte[vtmpstr.size()];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = (Byte)vtmpstr.elementAt(i);
            ++i;
        }
        return tmp;
    }

    public char unescapeChar(String input) {
        char tmp = '\u0000';
        tmp = input.substring(0, 4).equalsIgnoreCase("&#0x") ? (char)Integer.parseInt(input.substring(4, input.length() - 1), 16) : input.charAt(0);
        return tmp;
    }

    public char[] unescapeCharArray(String input) throws NumberFormatException {
        String tmpstr = input;
        Vector<Character> vtmpstr = new Vector<Character>(1, 1);
        int lastctr = 0;
        boolean ctr = false;
        while (lastctr != tmpstr.length()) {
            if (tmpstr.substring(0, 4).equalsIgnoreCase("&#0x")) {
                int index = tmpstr.indexOf(";");
                vtmpstr.addElement(new Character(this.unescapeChar(tmpstr.substring(0, index + 1))));
                tmpstr = tmpstr.substring(index + 1);
                lastctr = index + 1;
                continue;
            }
            vtmpstr.addElement(new Character(tmpstr.charAt(0)));
            tmpstr = tmpstr.substring(1);
            ++lastctr;
        }
        char[] tmp = new char[vtmpstr.size()];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = ((Character)vtmpstr.elementAt(i)).charValue();
            ++i;
        }
        return tmp;
    }

    public int unescapeInt(String input) throws NumberFormatException {
        if (!input.substring(0, 4).equalsIgnoreCase("&#0x")) {
            throw new NumberFormatException("Input to JSXMLDocument.unescapeInt(String) should be in the format \"&#0x<hex>;\"");
        }
        return Integer.valueOf(input.substring(4, input.length() - 1), 16);
    }

    public int[] unescapeIntArray(String input) throws NumberFormatException {
        String tmpstr = input.trim();
        Vector<Integer> vtmpstr = new Vector<Integer>(1, 1);
        int lastctr = 0;
        boolean ctr = false;
        while (lastctr != tmpstr.length()) {
            if (tmpstr.substring(0, 4).equalsIgnoreCase("&#0x")) {
                int index = tmpstr.indexOf(";");
                vtmpstr.addElement(new Integer(this.unescapeInt(tmpstr.substring(0, index + 1))));
                tmpstr = tmpstr.substring(index + 1);
                lastctr = index + 1;
                continue;
            }
            throw new NumberFormatException("Input to JSXMLDocument.unescapeInt(String) should be in the format [\"&#0x<hex>;\"]*");
        }
        int[] tmp = new int[vtmpstr.size()];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = (Integer)vtmpstr.elementAt(i);
            ++i;
        }
        return tmp;
    }

    public long unescapeLong(String input) throws NumberFormatException {
        if (!input.substring(0, 4).equalsIgnoreCase("&#0x")) {
            throw new NumberFormatException("Input to JSXMLDocument.unescapeLong(String) should be in the format \"&#0x<hex>;\"");
        }
        return Long.valueOf(input.substring(4, input.length() - 1), 16);
    }

    public long[] unescapeLongArray(String input) throws NumberFormatException {
        String tmpstr = input.trim();
        Vector<Long> vtmpstr = new Vector<Long>(1, 1);
        int lastctr = 0;
        boolean ctr = false;
        while (lastctr != tmpstr.length()) {
            if (tmpstr.substring(0, 4).equalsIgnoreCase("&#0x")) {
                int index = tmpstr.indexOf(";");
                vtmpstr.addElement(new Long(this.unescapeLong(tmpstr.substring(0, index + 1))));
                tmpstr = tmpstr.substring(index + 1);
                lastctr = index + 1;
                continue;
            }
            throw new NumberFormatException("Input to JSXMLDocument.unescapeInt(String) should be in the format [\"&#0x<hex>;\"]*");
        }
        long[] tmp = new long[vtmpstr.size()];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = (Long)vtmpstr.elementAt(i);
            ++i;
        }
        return tmp;
    }

    public float unescapeFloat(String input) throws NumberFormatException {
        if (!input.substring(0, 4).equalsIgnoreCase("&#0x")) {
            throw new NumberFormatException("Input to JSXMLDocument.unescapeFloat(String) should be in the format \"&#0x<hex>;\"");
        }
        return Float.valueOf(input.substring(4, input.length() - 1)).floatValue();
    }

    public float[] unescapeFloatArray(String input) throws NumberFormatException {
        String tmpstr = input.trim();
        Vector<Float> vtmpstr = new Vector<Float>(1, 1);
        int lastctr = 0;
        boolean ctr = false;
        while (lastctr != tmpstr.length()) {
            if (tmpstr.substring(0, 4).equalsIgnoreCase("&#0x")) {
                int index = tmpstr.indexOf(";");
                vtmpstr.addElement(new Float(this.unescapeFloat(tmpstr.substring(0, index + 1))));
                tmpstr = tmpstr.substring(index + 1);
                lastctr = index + 1;
                continue;
            }
            throw new NumberFormatException("Input to JSXMLDocument.unescapeFloat(String) should be in the format [\"&#0x<hex>;\"]*");
        }
        float[] tmp = new float[vtmpstr.size()];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = ((Float)vtmpstr.elementAt(i)).floatValue();
            ++i;
        }
        return tmp;
    }

    public double unescapeDouble(String input) throws NumberFormatException {
        if (!input.substring(0, 4).equalsIgnoreCase("&#0x")) {
            throw new NumberFormatException("Input to JSXMLDocument.unescapeDouble(String) should be in the format \"&#0x<hex>;\"");
        }
        return Double.valueOf(input.substring(4, input.length() - 1));
    }

    public double[] unescapeDoubleArray(String input) throws NumberFormatException {
        String tmpstr = input.trim();
        Vector<Double> vtmpstr = new Vector<Double>(1, 1);
        int lastctr = 0;
        boolean ctr = false;
        while (lastctr != tmpstr.length()) {
            if (tmpstr.substring(0, 4).equalsIgnoreCase("&#0x")) {
                int index = tmpstr.indexOf(";");
                vtmpstr.addElement(new Double(this.unescapeDouble(tmpstr.substring(0, index + 1))));
                tmpstr = tmpstr.substring(index + 1);
                lastctr = index + 1;
                continue;
            }
            throw new NumberFormatException("Input to JSXMLDocument.unescapeDoubleArray(String) should be in the format [\"&#0x<hex>;\"]*");
        }
        double[] tmp = new double[vtmpstr.size()];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = (Double)vtmpstr.elementAt(i);
            ++i;
        }
        return tmp;
    }
}

