/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import org.jSyncManager.API.Protocol.Util.JSCSVCell;

public class JSCSVDocument {
    private Vector document = null;
    private boolean showtitles = false;
    int headerrows = this.isShowtitles() ? 2 : 1;
    private int[] datatypes;
    private String[] titles;
    private String separator = ",";
    private BufferedReader reader = null;
    public static final int DATATYPE_ROW = 0;
    public static final int TITLE_ROW = 1;
    public static final int DLPRECORD_COLS = 5;

    public JSCSVDocument() {
    }

    public JSCSVDocument(File document) throws IOException {
        this.parse(document);
    }

    public JSCSVDocument(InputStreamReader inputfile) throws IOException {
        this.readDocument(inputfile);
    }

    public void readDocument(InputStreamReader inputfile) throws IOException {
        this.parse(inputfile);
    }

    protected void setElementAt(JSCSVCell cell, int row, int col) {
        if (this.getRowNo(row) >= this.getDocument().size()) {
            this.getDocument().setSize(this.getRowNo(row) + 1);
        }
        if ((Vector)this.getDocument().elementAt(this.getRowNo(row)) == null) {
            this.getDocument().setElementAt(new Vector(1, 1), this.getRowNo(row));
        }
        if (col >= ((Vector)this.getDocument().elementAt(this.getRowNo(row))).size()) {
            ((Vector)this.getDocument().elementAt(this.getRowNo(row))).setSize(col + 1);
        }
        if (col >= ((Vector)this.getDocument().elementAt(0)).size()) {
            ((Vector)this.getDocument().elementAt(0)).setSize(col + 1);
        }
        if (this.elementAt(0, col) == null) {
            ((Vector)this.getDocument().elementAt(0)).setElementAt(new JSCSVCell(3), col);
        }
        ((Vector)this.getDocument().elementAt(this.getRowNo(row))).setElementAt(cell, col);
    }

    protected void setElementAt(JSCSVCell cell, String title, int row, int col) {
        this.setElementAt(cell, row, col);
        if (this.isShowtitles()) {
            if (col >= ((Vector)this.getDocument().elementAt(1)).size()) {
                ((Vector)this.getDocument().elementAt(1)).setSize(col + 1);
            }
            if (this.elementAt(1, col) == null || !this.readStringCell(this.elementAt(1, col)).equalsIgnoreCase(title)) {
                ((Vector)this.getDocument().elementAt(1)).setElementAt(new JSCSVCell(title), col);
            }
        }
    }

    protected JSCSVCell elementAt(int row, int col) throws ArrayIndexOutOfBoundsException {
        JSCSVCell tmpcell = null;
        if (this.getDocument().size() > this.getRowNo(row) && ((Vector)this.getDocument().elementAt(this.getRowNo(row) - 1)).size() > col && (Vector)this.getDocument().elementAt(this.getRowNo(row) - 1) != null) {
            tmpcell = (JSCSVCell)((Vector)this.getDocument().elementAt(this.getRowNo(row) - 1)).elementAt(col);
        }
        return tmpcell;
    }

    protected void parse() throws IOException {
        Object line = null;
        do {
            this.parseRow(this.reader.readLine());
        } while (line != null);
    }

    public void parse(BufferedReader input) throws IOException {
        this.reader = input;
        this.parse();
    }

    public void parse(InputStreamReader input) throws IOException {
        this.parse(new BufferedReader(input));
    }

    public void parse(File input) throws FileNotFoundException, IOException {
        this.parse(new BufferedReader(new FileReader(input)));
    }

    protected void parseTypeRow(String line) {
        int tokenct = 0;
        if (line != null) {
            StringTokenizer st = new StringTokenizer(line, this.separator);
            this.datatypes = new int[st.countTokens()];
            while (st.hasMoreTokens()) {
                this.datatypes[tokenct] = Integer.parseInt(st.nextToken());
                ((Vector)this.getDocument().elementAt(0)).setElementAt(new JSCSVCell(this.datatypes[tokenct]), tokenct);
                ++tokenct;
            }
        }
    }

    protected void parseTitleRow(String line) {
        int tokenct = 0;
        if (line != null) {
            StringTokenizer st = new StringTokenizer(line, this.separator);
            this.titles = new String[st.countTokens()];
            while (st.hasMoreTokens()) {
                this.titles[tokenct] = JSCSVCell.unescapeString(st.nextToken());
                ((Vector)this.getDocument().elementAt(0)).setElementAt(new JSCSVCell(this.titles[tokenct]), tokenct);
                ++tokenct;
            }
        }
    }

    protected void parseRow(String line) {
        int tokenct = 0;
        if (this.getDocument().size() == 0) {
            this.parseTypeRow(line);
        } else if (this.isShowtitles() && this.getDocument().size() == 1) {
            this.parseTitleRow(line);
        } else {
            int row = this.getDocument().size();
            if (line != null) {
                StringTokenizer st = new StringTokenizer(line, this.separator);
                while (st.hasMoreTokens()) {
                    if (this.isShowtitles()) {
                        this.setElementAt(new JSCSVCell(st.nextToken(), this.datatypes[tokenct]), this.titles[tokenct], row - this.getHeaderrows(), tokenct);
                    } else {
                        this.setElementAt(new JSCSVCell(st.nextToken(), this.datatypes[tokenct]), row - this.getHeaderrows(), tokenct);
                    }
                    ++tokenct;
                }
            }
        }
    }

    public JSCSVCell getCell(int row, int col) {
        return (JSCSVCell)((Vector)this.document.elementAt(this.getRowNo(row))).elementAt(col);
    }

    public String getValue(int row, int col) {
        return this.getCell(this.getRowNo(row), col).getValue();
    }

    public void writeDataTypes(BufferedWriter outputfile) throws IOException {
        boolean indent = false;
        int col = 0;
        while (col < ((Vector)this.document.elementAt(0)).size()) {
            JSCSVCell element = this.getCell(0, col);
            if (element != null) {
                if (col != 0) {
                    outputfile.write(this.separator);
                }
                element.write(outputfile);
            }
            ++col;
        }
    }

    public void writeTitles(BufferedWriter outputfile) throws IOException {
        boolean indent = false;
        int col = 0;
        while (col < ((Vector)this.document.elementAt(1)).size()) {
            JSCSVCell element = this.getCell(1, col);
            if (element != null) {
                if (col != 0) {
                    outputfile.write(this.separator);
                }
                element.write(outputfile);
            }
            ++col;
        }
    }

    public void writeDocument(OutputStreamWriter outputfile) throws IOException {
        BufferedWriter writer = new BufferedWriter(outputfile);
        this.writeDocument(writer);
    }

    public void writeDocument(BufferedWriter outputfile) throws IOException {
        this.writeDataTypes(outputfile);
        if (this.showtitles) {
            this.writeTitles(outputfile);
        }
        int row = 0;
        while (row < this.document.size()) {
            int col = 0;
            while (col < ((Vector)this.document.elementAt(row)).size()) {
                JSCSVCell element = this.getCell(row, col);
                if (element != null) {
                    if (col != 0) {
                        outputfile.write(this.separator);
                    }
                    element.write(outputfile);
                }
                ++col;
            }
            ++row;
        }
    }

    public Vector getDocument() {
        if (this.document == null) {
            this.document = new Vector(1, 1);
        }
        return this.document;
    }

    public void setDocument(Vector document) {
        this.document = document;
    }

    public String readStringCell(JSCSVCell node) {
        return node.getValue();
    }

    public String[] readStringArrayCell(JSCSVCell node) {
        StringTokenizer st = new StringTokenizer(node.getValue(), JSCSVCell.getValueseparator());
        String[] tmp = new String[st.countTokens()];
        int tokenct = 0;
        while (st.hasMoreTokens()) {
            tmp[tokenct++] = JSCSVCell.unescapeString(st.nextToken());
        }
        return tmp;
    }

    public GregorianCalendar readCalendarCell(JSCSVCell node) throws ParseException {
        DateFormat df = DateFormat.getDateTimeInstance(1, 0);
        GregorianCalendar tmpcal = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        tmpcal.setTime(df.parse(node.getValue()));
        return tmpcal;
    }

    public boolean readBooleanCell(JSCSVCell node) {
        return node.getValue().equalsIgnoreCase("true");
    }

    public byte readByteCell(JSCSVCell node) {
        return node.unescapeByte();
    }

    public byte[] readByteArrayCell(JSCSVCell node) {
        StringTokenizer st = new StringTokenizer(node.getValue(), JSCSVCell.getValueseparator());
        byte[] tmp = new byte[st.countTokens()];
        int tokenct = 0;
        while (st.hasMoreTokens()) {
            tmp[tokenct++] = JSCSVCell.unescapeByte(st.nextToken());
        }
        return tmp;
    }

    public char readCharCell(JSCSVCell node) {
        char tmp = '\u0000';
        tmp = node.unescapeChar();
        return tmp;
    }

    public char[] readCharArrayCell(JSCSVCell node) {
        StringTokenizer st = new StringTokenizer(node.getValue(), JSCSVCell.getValueseparator());
        char[] tmp = new char[st.countTokens()];
        int tokenct = 0;
        while (st.hasMoreTokens()) {
            tmp[tokenct++] = JSCSVCell.unescapeChar(st.nextToken());
        }
        return tmp;
    }

    public int readIntCell(JSCSVCell node) {
        return node.unescapeInt();
    }

    public int[] readIntArrayCell(JSCSVCell node) {
        StringTokenizer st = new StringTokenizer(node.getValue(), JSCSVCell.getValueseparator());
        int[] tmp = new int[st.countTokens()];
        int tokenct = 0;
        while (st.hasMoreTokens()) {
            tmp[tokenct++] = JSCSVCell.unescapeInt(st.nextToken());
        }
        return tmp;
    }

    public long readLongCell(JSCSVCell node) {
        return node.unescapeLong();
    }

    public long[] readLongArrayCell(JSCSVCell node) {
        StringTokenizer st = new StringTokenizer(node.getValue(), JSCSVCell.getValueseparator());
        long[] tmp = new long[st.countTokens()];
        int tokenct = 0;
        while (st.hasMoreTokens()) {
            tmp[tokenct++] = JSCSVCell.unescapeLong(st.nextToken());
        }
        return tmp;
    }

    public float readFloatCell(JSCSVCell node) {
        return node.unescapeFloat();
    }

    public float[] readFloatArrayCell(JSCSVCell node) {
        StringTokenizer st = new StringTokenizer(node.getValue(), JSCSVCell.getValueseparator());
        float[] tmp = new float[st.countTokens()];
        int tokenct = 0;
        while (st.hasMoreTokens()) {
            tmp[tokenct++] = JSCSVCell.unescapeFloat(st.nextToken());
        }
        return tmp;
    }

    public double readDoubleCell(JSCSVCell node) {
        double tmp = 0.0;
        return node.unescapeDouble();
    }

    public double[] readDoubleArrayCell(JSCSVCell node) {
        StringTokenizer st = new StringTokenizer(node.getValue(), JSCSVCell.getValueseparator());
        double[] tmp = new double[st.countTokens()];
        int tokenct = 0;
        while (st.hasMoreTokens()) {
            tmp[tokenct++] = JSCSVCell.unescapeDouble(st.nextToken());
        }
        return tmp;
    }

    public String escape(String in) {
        String out = new String();
        int i = 0;
        while (i < in.length()) {
            char c = in.charAt(i);
            out = out + this.escape(c);
            ++i;
        }
        return out;
    }

    public String escape(byte in) {
        return "&#0x" + Integer.toString(in, 16) + ";";
    }

    public String[] escape(byte[] in) {
        String[] tmp = new String[in.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = this.escape(in[i]);
            ++i;
        }
        return tmp;
    }

    public String escape(char in) {
        String out = new String();
        if (in < ' ' || in > '~') {
            out = out + "&#0x" + Integer.toString(in, 16) + ";";
        } else {
            switch (in) {
                case '(': {
                    out = out + "&#0x0028;";
                    break;
                }
                case ')': {
                    out = out + "&#0x0029;";
                    break;
                }
                case '<': {
                    out = out + "&lt;";
                    break;
                }
                case '>': {
                    out = out + "&gt;";
                    break;
                }
                case '&': {
                    out = out + "&amp;";
                    break;
                }
                case '\"': {
                    out = out + "&quot;";
                    break;
                }
                default: {
                    out = out + in;
                }
            }
        }
        return out;
    }

    public String[] escape(char[] in) {
        String[] tmp = new String[in.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = this.escape(in[i]);
            ++i;
        }
        return tmp;
    }

    public String escape(int in) {
        return "&#0x" + Integer.toString(in, 16) + ";";
    }

    public String[] escape(int[] in) {
        String[] tmp = new String[in.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = "&#0x" + Integer.toString(in[i], 16) + ";";
            ++i;
        }
        return tmp;
    }

    public String escape(long in) {
        return "&#0x" + Long.toString(in, 16) + ";";
    }

    public String[] escape(long[] in) {
        String[] tmp = new String[in.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = "&#0x" + Long.toString(in[i], 16) + ";";
            ++i;
        }
        return tmp;
    }

    public String escape(float in) {
        return "&#0x" + Float.toString(in) + ";";
    }

    public String[] escape(float[] in) {
        String[] tmp = new String[in.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = "&#0x" + Float.toString(in[i]) + ";";
            ++i;
        }
        return tmp;
    }

    public String escape(double in) {
        return "&#0x" + Double.toString(in) + ";";
    }

    public String[] escape(double[] in) {
        String[] tmp = new String[in.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = "&#0x" + Double.toString(in[i]) + ";";
            ++i;
        }
        return tmp;
    }

    public BufferedReader getReader() {
        return this.reader;
    }

    public void setReader(BufferedReader reader) {
        this.reader = reader;
    }

    public void setReader(InputStreamReader reader) {
        this.reader = new BufferedReader(reader);
    }

    public void setReader(File file) throws FileNotFoundException {
        this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public boolean isShowtitles() {
        return this.showtitles;
    }

    public void setShowtitles(boolean showtitles) {
        this.showtitles = showtitles;
        this.setHeaderrows();
    }

    public int getHeaderrows() {
        return this.headerrows;
    }

    public void setHeaderrows() {
        this.headerrows = this.isShowtitles() ? 2 : 1;
    }

    public int getRowNo(int recordno) {
        return recordno + this.getHeaderrows();
    }
}

