/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util;

import java.io.BufferedWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class JSCSVCell
implements Serializable {
    public static final int STRING = 0;
    public static final int CHAR = 1;
    public static final int BYTE = 2;
    public static final int INT = 3;
    public static final int FLOAT = 4;
    public static final int LONG = 5;
    public static final int DOUBLE = 6;
    public static final int STRINGARRAY = 7;
    public static final int CHARARRAY = 8;
    public static final int BYTEARRAY = 9;
    public static final int INTARRAY = 10;
    public static final int LONGARRAY = 11;
    public static final int FLOATARRAY = 12;
    public static final int DOUBLEARRAY = 13;
    public static final int DATE = 14;
    private static final String[] data_descr = new String[]{"String", "char", "byte", "int", "long", "double", "String[]", "char[]", "byte[]", "int[]", "long[]", "double[]", "Date"};
    private String value = null;
    private static String valueseparator = "\n";
    private int type = 0;

    public JSCSVCell() {
    }

    public JSCSVCell(String value) {
        this.setValue(this.escape(value));
        this.setType(0);
    }

    public JSCSVCell(String value, int newtype) {
        this.setValue(this.escape(value));
        this.setType(newtype);
    }

    public JSCSVCell(char value) {
        this.setValue(this.escape(value));
        this.setType(1);
    }

    public JSCSVCell(char[] value) {
        String tmpstr = new String();
        int i = 0;
        while (i < value.length) {
            tmpstr = tmpstr + this.escape(value);
            ++i;
        }
        this.setValue(tmpstr);
        this.setType(8);
    }

    public JSCSVCell(byte value) {
        this.setValue(this.escape(value));
        this.setType(2);
    }

    public JSCSVCell(byte[] value) {
        String tmpstr = new String();
        int i = 0;
        while (i < value.length) {
            tmpstr = tmpstr + this.escape(value);
            ++i;
        }
        this.setValue(tmpstr);
        this.setType(9);
    }

    public JSCSVCell(int value) {
        this.setValue(this.escape(value));
        this.setType(3);
    }

    public JSCSVCell(int[] value) {
        String tmpstr = new String();
        int i = 0;
        while (i < value.length) {
            tmpstr = tmpstr + this.escape(value);
            ++i;
        }
        this.setValue(tmpstr);
        this.setType(10);
    }

    public JSCSVCell(long value) {
        this.setValue(this.escape(value));
        this.setType(5);
    }

    public JSCSVCell(long[] value) {
        String tmpstr = new String();
        int i = 0;
        while (i < value.length) {
            tmpstr = tmpstr + this.escape(value);
            ++i;
        }
        this.setValue(tmpstr);
        this.setType(11);
    }

    public JSCSVCell(float value) {
        this.setValue(this.escape(value));
        this.setType(4);
    }

    public JSCSVCell(float[] value) {
        String tmpstr = new String();
        int i = 0;
        while (i < value.length) {
            tmpstr = tmpstr + this.escape(value);
            ++i;
        }
        this.setValue(tmpstr);
        this.setType(12);
    }

    public JSCSVCell(double value) {
        this.setValue(this.escape(value));
        this.setType(6);
    }

    public JSCSVCell(double[] value) {
        String tmpstr = new String();
        int i = 0;
        while (i < value.length) {
            tmpstr = tmpstr + this.escape(value);
            ++i;
        }
        this.setValue(tmpstr);
        this.setType(13);
    }

    public JSCSVCell(GregorianCalendar dateentry) {
        DateFormat df = DateFormat.getDateTimeInstance(1, 0);
        String tmpstr = df.format(dateentry.getTime());
        this.setValue(tmpstr);
        this.setType(14);
    }

    public void write(BufferedWriter output) {
        String tmpstr = new String("\"");
        tmpstr = tmpstr + this.getValue();
        String string = tmpstr + "\"";
    }

    public String escape(String in) {
        String out = new String();
        int i = 0;
        while (i < in.length()) {
            char c = in.charAt(i);
            out = out + this.escape(c);
            ++i;
        }
        return out;
    }

    public String escape(byte in) {
        return "&#0x" + Integer.toString(in, 16) + ";";
    }

    public String[] escape(byte[] in) {
        String[] tmp = new String[in.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = this.escape(in[i]);
            ++i;
        }
        return tmp;
    }

    public String escape(char in) {
        String out = new String();
        if (in < ' ' || in > '~') {
            out = out + "&#0x" + Integer.toString(in, 16) + ";";
        } else {
            switch (in) {
                case '(': {
                    out = out + "&#0x0028;";
                    break;
                }
                case ')': {
                    out = out + "&#0x0029;";
                    break;
                }
                case '<': {
                    out = out + "&lt;";
                    break;
                }
                case '>': {
                    out = out + "&gt;";
                    break;
                }
                case '&': {
                    out = out + "&amp;";
                    break;
                }
                case '\"': {
                    out = out + "&quot;";
                    break;
                }
                default: {
                    out = out + in;
                }
            }
        }
        return out;
    }

    public String[] escape(char[] in) {
        String[] tmp = new String[in.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = this.escape(in[i]);
            ++i;
        }
        return tmp;
    }

    public String escape(int in) {
        return "&#0x" + Integer.toString(in, 16) + ";";
    }

    public String[] escape(int[] in) {
        String[] tmp = new String[in.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = "&#0x" + Integer.toString(in[i], 16) + ";";
            ++i;
        }
        return tmp;
    }

    public String escape(long in) {
        return "&#0x" + Long.toString(in, 16) + ";";
    }

    public String[] escape(long[] in) {
        String[] tmp = new String[in.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = "&#0x" + Long.toString(in[i], 16) + ";";
            ++i;
        }
        return tmp;
    }

    public String escape(float in) {
        return "&#0x" + Float.toString(in) + ";";
    }

    public String[] escape(float[] in) {
        String[] tmp = new String[in.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = "&#0x" + Float.toString(in[i]) + ";";
            ++i;
        }
        return tmp;
    }

    public String escape(double in) {
        return "&#0x" + Double.toString(in) + ";";
    }

    public String[] escape(double[] in) {
        String[] tmp = new String[in.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = "&#0x" + Double.toString(in[i]) + ";";
            ++i;
        }
        return tmp;
    }

    public String unescapeString() {
        return new String(this.unescapeCharArray());
    }

    public static String unescapeString(String input) {
        return new String(JSCSVCell.unescapeCharArray(input));
    }

    public String[] unescapeStringArray() {
        StringTokenizer st = new StringTokenizer(this.getValue(), JSCSVCell.getValueseparator());
        String[] tmp = new String[st.countTokens()];
        int i = 0;
        while (i < tmp.length) {
            int tokenct = 0;
            while (st.hasMoreTokens()) {
                tmp[tokenct++] = JSCSVCell.unescapeString(st.nextToken());
            }
            ++i;
        }
        return tmp;
    }

    public byte unescapeByte() throws NumberFormatException {
        if (!this.getValue().substring(0, 4).equalsIgnoreCase("&#0x") || this.getValue().indexOf(";", 4) == -1) {
            throw new NumberFormatException("Input to JSCSVDocument.unescapeByte(String) should be in the format \"&#0x<hex>;\"");
        }
        return Byte.valueOf(this.getValue().substring(4, this.getValue().length() - 1), 16);
    }

    public static byte unescapeByte(String input) throws NumberFormatException {
        if (!input.substring(0, 4).equalsIgnoreCase("&#0x") || input.indexOf(";", 4) == -1) {
            throw new NumberFormatException("Input to JSCSVDocument.unescapeByte(String) should be in the format \"&#0x<hex>;\"");
        }
        return Byte.valueOf(input.substring(4, input.length() - 1), 16);
    }

    public byte[] unescapeByteArray() throws NumberFormatException {
        StringTokenizer st = new StringTokenizer(this.getValue(), JSCSVCell.getValueseparator());
        byte[] tmp = new byte[st.countTokens()];
        int tokenct = 0;
        while (st.hasMoreTokens()) {
            tmp[tokenct++] = JSCSVCell.unescapeByte(st.nextToken());
        }
        return tmp;
    }

    public char unescapeChar() {
        char tmp = '\u0000';
        tmp = !this.getValue().substring(0, 4).equalsIgnoreCase("&#0x") || this.getValue().indexOf(";", 4) == -1 ? (char)Integer.parseInt(this.getValue().substring(4, this.getValue().length() - 1), 16) : this.getValue().charAt(0);
        return tmp;
    }

    public static char unescapeChar(String input) {
        char tmp = '\u0000';
        tmp = !input.substring(0, 4).equalsIgnoreCase("&#0x") || input.indexOf(";", 4) == -1 ? (char)Integer.parseInt(input.substring(4, input.length() - 1), 16) : input.charAt(0);
        return tmp;
    }

    public char[] unescapeCharArray() throws NumberFormatException {
        StringTokenizer st = new StringTokenizer(this.getValue(), JSCSVCell.getValueseparator());
        char[] tmp = new char[st.countTokens()];
        int tokenct = 0;
        while (st.hasMoreTokens()) {
            tmp[tokenct++] = JSCSVCell.unescapeChar(st.nextToken());
        }
        return tmp;
    }

    public static char[] unescapeCharArray(String input) throws NumberFormatException {
        StringTokenizer st = new StringTokenizer(input, JSCSVCell.getValueseparator());
        char[] tmp = new char[st.countTokens()];
        int tokenct = 0;
        while (st.hasMoreTokens()) {
            tmp[tokenct++] = JSCSVCell.unescapeChar(st.nextToken());
        }
        return tmp;
    }

    public int unescapeInt() throws NumberFormatException {
        if (!this.getValue().substring(0, 4).equalsIgnoreCase("&#0x") || this.getValue().indexOf(";", 4) == -1) {
            throw new NumberFormatException("Input to JSCSVDocument.unescapeInt(String) should be in the format \"&#0x<hex>;\"");
        }
        return Integer.valueOf(this.getValue().substring(4, this.getValue().length() - 1), 16);
    }

    public static int unescapeInt(String input) throws NumberFormatException {
        if (!input.substring(0, 4).equalsIgnoreCase("&#0x") || input.indexOf(";", 4) == -1) {
            throw new NumberFormatException("Input to JSCSVDocument.unescapeInt(String) should be in the format \"&#0x<hex>;\"");
        }
        return Integer.valueOf(input.substring(4, input.length() - 1), 16);
    }

    public int[] unescapeIntArray() throws NumberFormatException {
        StringTokenizer st = new StringTokenizer(this.getValue(), JSCSVCell.getValueseparator());
        int[] tmp = new int[st.countTokens()];
        int tokenct = 0;
        while (st.hasMoreTokens()) {
            tmp[tokenct++] = JSCSVCell.unescapeInt(st.nextToken());
        }
        return tmp;
    }

    public long unescapeLong() throws NumberFormatException {
        if (!this.getValue().substring(0, 4).equalsIgnoreCase("&#0x") || this.getValue().indexOf(";", 4) == -1) {
            throw new NumberFormatException("Input to JSCSVDocument.unescapeLong(String) should be in the format \"&#0x<hex>;\"");
        }
        return Long.valueOf(this.getValue().substring(4, this.getValue().length() - 1), 16);
    }

    public static long unescapeLong(String input) throws NumberFormatException {
        if (!input.substring(0, 4).equalsIgnoreCase("&#0x") || input.indexOf(";", 4) == -1) {
            throw new NumberFormatException("Input to JSCSVDocument.unescapeLong(String) should be in the format \"&#0x<hex>;\"");
        }
        return Long.valueOf(input.substring(4, input.length() - 1), 16);
    }

    public long[] unescapeLongArray() throws NumberFormatException {
        StringTokenizer st = new StringTokenizer(this.getValue(), JSCSVCell.getValueseparator());
        long[] tmp = new long[st.countTokens()];
        int tokenct = 0;
        while (st.hasMoreTokens()) {
            tmp[tokenct++] = JSCSVCell.unescapeLong(st.nextToken());
        }
        return tmp;
    }

    public float unescapeFloat() throws NumberFormatException {
        if (!this.getValue().substring(0, 4).equalsIgnoreCase("&#0x") || this.getValue().indexOf(";", 4) == -1) {
            throw new NumberFormatException("Input to JSCSVDocument.unescapeFloat(String) should be in the format \"&#0x<hex>;\"");
        }
        return Float.valueOf(this.getValue().substring(4, this.getValue().length() - 1)).floatValue();
    }

    public static float unescapeFloat(String input) throws NumberFormatException {
        if (!input.substring(0, 4).equalsIgnoreCase("&#0x") || input.indexOf(";", 4) == -1) {
            throw new NumberFormatException("Input to JSCSVDocument.unescapeFloat(String) should be in the format \"&#0x<hex>;\"");
        }
        return Float.valueOf(input.substring(4, input.length() - 1)).floatValue();
    }

    public float[] unescapeFloatArray() throws NumberFormatException {
        StringTokenizer st = new StringTokenizer(this.getValue(), JSCSVCell.getValueseparator());
        float[] tmp = new float[st.countTokens()];
        int tokenct = 0;
        while (st.hasMoreTokens()) {
            tmp[tokenct++] = JSCSVCell.unescapeFloat(st.nextToken());
        }
        return tmp;
    }

    public double unescapeDouble() throws NumberFormatException {
        if (!this.getValue().substring(0, 4).equalsIgnoreCase("&#0x") || this.getValue().indexOf(";", 4) == -1) {
            throw new NumberFormatException("Input to JSCSVDocument.unescapeDouble(String) should be in the format \"&#0x<hex>;\"");
        }
        return Double.valueOf(this.getValue().substring(4, this.getValue().length() - 1));
    }

    public static double unescapeDouble(String input) throws NumberFormatException {
        if (!input.substring(0, 4).equalsIgnoreCase("&#0x") || input.indexOf(";", 4) == -1) {
            throw new NumberFormatException("Input to JSCSVDocument.unescapeDouble(String) should be in the format \"&#0x<hex>;\"");
        }
        return Double.valueOf(input.substring(4, input.length() - 1));
    }

    public double[] unescapeDoubleArray() throws NumberFormatException {
        StringTokenizer st = new StringTokenizer(this.getValue(), JSCSVCell.getValueseparator());
        double[] tmp = new double[st.countTokens()];
        int tokenct = 0;
        while (st.hasMoreTokens()) {
            tmp[tokenct++] = JSCSVCell.unescapeDouble(st.nextToken());
        }
        return tmp;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDataDescr(int datatype) {
        return data_descr[datatype];
    }

    public static String getValueseparator() {
        return valueseparator;
    }

    public void setValueseparator(String valueseparator) {
        JSCSVCell.valueseparator = valueseparator;
    }
}

