/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jSyncManager.API.Protocol.Util.InvalidDLPDateException;
import org.jSyncManager.API.Tools.UnsignedByte;

public class DLP_Date
implements Serializable {
    private char year;
    private byte month;
    private byte day;
    private byte hour;
    private byte minute;
    private byte second;

    public DLP_Date() {
        GregorianCalendar gregoriancalendar = new GregorianCalendar();
        gregoriancalendar.setTime(new Date());
        this.year = (char)gregoriancalendar.get(1);
        this.month = (byte)gregoriancalendar.get(2);
        this.day = (byte)gregoriancalendar.get(5);
        this.hour = (byte)gregoriancalendar.get(11);
        if (this.hour == 24) {
            this.hour = 0;
        }
        this.minute = (byte)gregoriancalendar.get(12);
        this.second = (byte)gregoriancalendar.get(13);
    }

    public DLP_Date(Calendar calendar) throws InvalidDLPDateException {
        if (calendar == null) {
            throw new InvalidDLPDateException("Calendar object is null.");
        }
        this.year = (char)calendar.get(1);
        this.month = (byte)(calendar.get(2) + 1);
        this.day = (byte)calendar.get(5);
        this.hour = (byte)calendar.get(11);
        if (this.hour == 24) {
            this.hour = 0;
        }
        this.minute = (byte)calendar.get(12);
        this.second = (byte)calendar.get(13);
    }

    public DLP_Date(byte[] abyte0) throws InvalidDLPDateException {
        if (abyte0.length != 8) {
            throw new InvalidDLPDateException("This is not a date array!");
        }
        this.year = (char)(UnsignedByte.intValue(abyte0[0]) * 256 + UnsignedByte.intValue(abyte0[1]));
        if (this.year < '\u076c') {
            this.year = '\u0000';
            this.month = 0;
            this.day = 0;
            this.hour = 0;
            this.minute = 0;
            this.second = 0;
            return;
        }
        this.month = abyte0[2];
        this.day = abyte0[3];
        this.hour = abyte0[4];
        this.minute = abyte0[5];
        this.second = abyte0[6];
        if (this.year < '\u076c' | this.month < 1 | this.month > 12 | this.day < 1 | this.day > 31 | this.hour < 0 | this.hour > 23 | this.minute < 0 | this.minute > 59 | this.second < 0 | this.second > 59) {
            throw new InvalidDLPDateException("Invalid date array values detected!");
        }
    }

    public static char calendar2DateType(Calendar calendar) {
        int i = 0;
        int j = calendar.get(1) - 1904;
        int k = calendar.get(2) + 1;
        int l = calendar.get(5);
        i += j * 512;
        i += k * 32;
        return (char)(i += l);
    }

    public byte[] convertToBytes() throws InvalidDLPDateException {
        byte[] abyte0 = new byte[]{(byte)(this.year / 256), (byte)(this.year % 256), this.month, this.day, this.hour, this.minute, this.second, 0};
        return abyte0;
    }

    public Calendar convertToCalendar() throws InvalidDLPDateException {
        GregorianCalendar gregoriancalendar = new GregorianCalendar();
        gregoriancalendar.set(this.year, this.month - 1, this.day, this.hour, this.minute, this.second);
        return gregoriancalendar;
    }

    public int convertToSeconds() {
        try {
            Calendar calendar = this.convertToCalendar();
            long l1 = calendar.getTime().getTime();
            long l3 = new GregorianCalendar(1904, 0, 1, 0, 0, 0).getTime().getTime();
            return (int)(l1 - l3);
        }
        catch (Exception ex) {
            long l = new GregorianCalendar().getTime().getTime();
            long l2 = new GregorianCalendar(1904, 0, 1, 0, 0, 0).getTime().getTime();
            return (int)(l - l2);
        }
    }

    public static Calendar dateType2Calendar(byte[] abyte0, int i) {
        char c = UnsignedByte.unsignedBytes2Char(abyte0[i], abyte0[i + 1]);
        int j = 1904;
        int k = -1;
        int l = c & 0x1F;
        return new GregorianCalendar(j += (c & 0xFE00) / 512, k += (c & 0x1E0) / 32, l);
    }

    static Calendar seconds2Calendar(int i) {
        GregorianCalendar gregoriancalendar = new GregorianCalendar(1904, 0, 1, 0, 0, 0);
        GregorianCalendar gregoriancalendar1 = new GregorianCalendar();
        Date date = new Date();
        date.setTime((long)i + gregoriancalendar.getTime().getTime());
        gregoriancalendar1.setTime(date);
        return gregoriancalendar1;
    }

    public String toString() {
        if (this.year != '\u0000') {
            try {
                return this.convertToCalendar().getTime().toString();
            }
            catch (InvalidDLPDateException ex) {
                return "error";
            }
        }
        return "null";
    }
}

