/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import org.jSyncManager.API.Protocol.DLPFunctionCallException;
import org.jSyncManager.API.Protocol.Util.DLP_Date;
import org.jSyncManager.API.Protocol.Util.EncryptionNotSupportedException;
import org.jSyncManager.API.Protocol.Util.InvalidDLPDateException;
import org.jSyncManager.API.Tools.UnsignedByte;

public class DLPUserInfo
implements Serializable {
    private int userID;
    private int viewerID;
    private int lastSyncHostID;
    private Calendar lastGoodSync;
    private Calendar lastSync;
    private String userName;
    private byte[] password;
    private boolean uidChanged = false;
    private boolean vidChanged = false;
    private boolean lastPCIDChanged = false;
    private boolean uNameChanged = false;
    private boolean lastSyncDateChanged = false;
    private static final byte CHANGE_USER_ID = -128;
    private static final byte CHANGE_PC_ID = 64;
    private static final byte CHANGE_SYNC_DATE = 32;
    private static final byte CHANGE_USERNAME = 16;
    private static final byte CHANGE_VIEWER_ID = 8;

    private DLPUserInfo() {
    }

    public DLPUserInfo(int i, int j, int k, String s) {
        this.setUserID(i);
        this.setViewerID(j);
        this.setLastHostID(k);
        try {
            this.setUserName(s);
        }
        catch (Exception ex) {
            try {
                this.setUserName(s.substring(0, 40));
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
    }

    public DLPUserInfo(byte[] userBlock) throws DLPFunctionCallException {
        int i = 0;
        boolean flag = false;
        boolean flag1 = false;
        boolean flag2 = false;
        try {
            this.userID = UnsignedByte.unsignedBytes2Int(userBlock[i++], userBlock[i++], userBlock[i++], userBlock[i++]);
            this.viewerID = UnsignedByte.unsignedBytes2Int(userBlock[i++], userBlock[i++], userBlock[i++], userBlock[i++]);
            this.lastSyncHostID = UnsignedByte.unsignedBytes2Int(userBlock[i++], userBlock[i++], userBlock[i++], userBlock[i++]);
            byte[] temp = new byte[8];
            int j1 = 12;
            System.arraycopy(userBlock, j1, temp, 0, 8);
            this.lastGoodSync = new DLP_Date(temp).convertToCalendar();
            temp = new byte[8];
            System.arraycopy(userBlock, j1 += 8, temp, 0, 8);
            j1 += 8;
            this.lastSync = new DLP_Date(temp).convertToCalendar();
            byte firstUNameByte = userBlock[j1++];
            byte firstPasswdByte = userBlock[j1++];
            if (firstUNameByte == 0) {
                this.userName = null;
            } else {
                byte[] abyte2 = new byte[firstUNameByte - 1];
                int l = 0;
                while (l < abyte2.length) {
                    abyte2[l] = userBlock[j1++];
                    ++l;
                }
                this.userName = new String(abyte2);
                ++j1;
            }
            if (firstPasswdByte == 0) {
                this.password = null;
            } else {
                byte[] password = new byte[firstPasswdByte];
                int i1 = 0;
                while (i1 < password.length) {
                    password[i1] = userBlock[j1++];
                    ++i1;
                }
            }
        }
        catch (InvalidDLPDateException invaliddlpdateexception) {
            throw new DLPFunctionCallException("Invalid parameter present: " + invaliddlpdateexception.toString(), Integer.MAX_VALUE);
        }
    }

    public byte[] getEncryptedPassword() {
        return this.password;
    }

    public int getLastHostID() {
        return this.lastSyncHostID;
    }

    public Calendar getLastSuccessfulSyncDate() {
        return this.lastGoodSync;
    }

    public Calendar getLastSyncDate() {
        return this.lastSync;
    }

    public int getUserID() {
        return this.userID;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getViewerID() {
        return this.viewerID;
    }

    public byte[] object2Bytes() {
        byte[] data = new byte[22 + this.userName.length() + 1];
        int i = 0;
        data[i++] = (byte)(this.userID / 0x1000000);
        data[i++] = (byte)((this.userID & 0xFF0000) / 65536);
        data[i++] = (byte)((this.userID & 0xFF00) / 256);
        data[i++] = (byte)(this.userID & 0xFF);
        data[i++] = (byte)(this.viewerID / 0x1000000);
        data[i++] = (byte)((this.viewerID & 0xFF0000) / 65536);
        data[i++] = (byte)((this.viewerID & 0xFF00) / 256);
        data[i++] = (byte)(this.viewerID & 0xFF);
        data[i++] = (byte)(this.lastSyncHostID / 0x1000000);
        data[i++] = (byte)((this.lastSyncHostID & 0xFF0000) / 65536);
        data[i++] = (byte)((this.lastSyncHostID & 0xFF00) / 256);
        data[i++] = (byte)(this.lastSyncHostID & 0xFF);
        int j = 0;
        while (j < 8) {
            data[i++] = 0;
            ++j;
        }
        if (this.uidChanged) {
            int n = i;
            data[n] = (byte)(data[n] + -128);
        }
        if (this.vidChanged) {
            int n = i;
            data[n] = (byte)(data[n] + 8);
        }
        if (this.lastPCIDChanged) {
            int n = i;
            data[n] = (byte)(data[n] + 64);
        }
        if (this.uNameChanged) {
            int n = i;
            data[n] = (byte)(data[n] + 16);
        }
        if (this.lastSyncDateChanged) {
            int n = i;
            data[n] = (byte)(data[n] + 32);
        }
        int n = ++i;
        data[n] = (byte)(this.userName.length() + 1);
        byte[] temp = this.userName.getBytes();
        System.arraycopy(temp, 0, data, ++i, temp.length);
        i += temp.length;
        data[i++] = 0;
        return data;
    }

    public void setLastHostID(int i) {
        this.lastSyncHostID = i;
        this.lastPCIDChanged = true;
    }

    public void setLastSyncDate(Calendar calendar) {
        this.lastSync = calendar;
        this.lastSyncDateChanged = true;
    }

    public void setUserID(int i) {
        this.userID = i;
        this.uidChanged = true;
    }

    public void setUserName(String s) throws DLPFunctionCallException {
        if (s.length() > 41) {
            throw new DLPFunctionCallException("User Name is too long (" + s.length() + " > 41)", Integer.MAX_VALUE);
        }
        this.userName = s;
        this.uNameChanged = true;
    }

    public void setViewerID(int i) {
        this.viewerID = i;
        this.vidChanged = true;
    }

    public String toString() {
        String s = this.lastGoodSync.get(1) < 1900 ? new String("No Last Successful Sync Date.") : this.lastGoodSync.getTime().toString();
        String s1 = this.lastSync.get(1) < 1900 ? new String("No Last Sync Date.") : this.lastSync.getTime().toString();
        try {
            return new String("User ID: " + this.userID + "\nViewer ID: " + this.viewerID + "\nLast Sync Host ID: " + this.lastSyncHostID + "\nLast Successful Sync: " + s + "\nLast Sync: " + s1 + "\nUsername: " + this.userName);
        }
        catch (NullPointerException nullpointerexception) {
            return nullpointerexception.toString();
        }
    }

    public static byte[] encryptPasswordV4(String passwd) throws EncryptionNotSupportedException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException na) {
            throw new EncryptionNotSupportedException("MD5 encryption not supported on this system.");
        }
        md.update(passwd.getBytes());
        return md.digest();
    }

    public boolean verifyPassword(String passwd) throws EncryptionNotSupportedException {
        byte[] testPassword = DLPUserInfo.encryptPasswordV4(passwd);
        if (testPassword.length != this.password.length) {
            return false;
        }
        int i = 0;
        while (i < this.password.length) {
            try {
                if (this.password[i] != testPassword[i]) {
                    return false;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

