/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util;

import java.io.Serializable;
import org.jSyncManager.API.Protocol.DLPFunctionCallException;
import org.jSyncManager.API.Protocol.Util.DLPVersion;
import org.jSyncManager.API.Tools.UnsignedByte;

public class DLPSystemInfo
implements Serializable {
    private int romVersion = 0;
    private int localeID = 0;
    private byte prodIDSize = 0;
    private int productID = 0;
    private DLPVersion dlpVersion = new DLPVersion(1, 3);
    private DLPVersion compatibilityVersion = new DLPVersion();
    private int maxRecordSize = -1;
    private boolean extInfo = false;

    public DLPSystemInfo(byte[] arg1, byte[] arg2) throws DLPFunctionCallException {
        int i = 0;
        try {
            this.setRomVersion(UnsignedByte.unsignedBytes2Int(arg1[i++], arg1[i++], arg1[i++], arg1[i++]));
            this.setLocaleID(UnsignedByte.unsignedBytes2Int(arg1[i++], arg1[i++], arg1[i++], arg1[i++]));
            int n = ++i;
            this.setProdIDSize(UnsignedByte.intValue(arg1[n]));
            int n2 = ++i;
            int n3 = ++i;
            int n4 = ++i;
            int n5 = ++i;
            ++i;
            this.setProductID(UnsignedByte.unsignedBytes2Int(arg1[n2], arg1[n3], arg1[n4], arg1[n5]));
            if (arg2 != null) {
                int j = 0;
                this.extInfo = true;
                this.setDlpVersion(new DLPVersion(UnsignedByte.intValue(arg2[j++]) * 256 + UnsignedByte.intValue(arg2[j++]), UnsignedByte.intValue(arg2[j++]) * 256 + UnsignedByte.intValue(arg2[j++])));
                this.setCompatibilityVersion(new DLPVersion(UnsignedByte.intValue(arg2[j++]) * 256 + UnsignedByte.intValue(arg2[j++]), UnsignedByte.intValue(arg2[j++]) * 256 + UnsignedByte.intValue(arg2[j++])));
                this.setMaxRecordSize(UnsignedByte.unsignedBytes2Int(arg2[j++], arg2[j++], arg2[j++], arg2[j++]));
            }
        }
        catch (Throwable t) {
            throw new DLPFunctionCallException("Error while parsing System Info: " + t.toString() + "\n" + this.toString(), Integer.MAX_VALUE);
        }
    }

    public DLPVersion getCompatibilityVersion() {
        return this.compatibilityVersion;
    }

    public DLPVersion getDlpVersion() {
        return this.dlpVersion;
    }

    public int getLocaleID() {
        return this.localeID;
    }

    public int getMaxRecordSize() {
        return this.maxRecordSize;
    }

    public int getProductID() {
        return this.productID;
    }

    public int getRomVersion() {
        return this.romVersion;
    }

    private void setCompatibilityVersion(DLPVersion dlpversion) {
        this.compatibilityVersion = dlpversion;
    }

    private void setDlpVersion(DLPVersion dlpversion) {
        this.dlpVersion = dlpversion;
    }

    private void setLocaleID(int i) {
        this.localeID = i;
    }

    private void setMaxRecordSize(int i) {
        this.maxRecordSize = i;
    }

    private void setProdIDSize(int i) {
        this.prodIDSize = (byte)i;
    }

    private void setProductID(int i) {
        this.productID = i;
    }

    private void setRomVersion(int i) {
        this.romVersion = i;
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("ROM Version:           " + this.romVersion + "\n");
        stringbuffer.append("Locale ID:             " + this.localeID + "\n");
        stringbuffer.append("Product ID:            " + this.productID + "\n");
        if (!this.extInfo) {
            return stringbuffer.toString();
        }
        stringbuffer.append("DLP Version:           " + this.dlpVersion.toString() + "\n");
        stringbuffer.append("Compatibility Version: " + this.compatibilityVersion.toString() + "\n");
        stringbuffer.append("Maximum record Size:   " + this.maxRecordSize + "\n");
        return stringbuffer.toString();
    }
}

