/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util;

import java.io.Serializable;
import org.jSyncManager.API.Protocol.DLPFunctionCallException;
import org.jSyncManager.API.Protocol.Util.DLPCardInfo;
import org.jSyncManager.API.Tools.UnsignedByte;

public class DLPStorageInfo
implements Serializable {
    private int numCards = 0;
    private boolean hasMoreCards = false;
    private DLPCardInfo[] cards = null;
    private int romDataBaseCount = 0;
    private int ramDatabaseCount = 0;
    private boolean extResponse = false;

    public DLPStorageInfo(byte[] arg1, byte[] arg2) throws DLPFunctionCallException {
        int i = 0;
        try {
            this.setNumCards(UnsignedByte.intValue(arg1[i++]) + 1);
            this.setHasMoreCards(UnsignedByte.intValue(arg1[i++]) != 0);
            int n = ++i;
            int j = UnsignedByte.intValue(arg1[n]);
            int m = ++i;
            this.cards = new DLPCardInfo[j];
            int k = 0;
            while (k < j) {
                byte[] temp = new byte[UnsignedByte.intValue(arg1[m])];
                System.arraycopy(arg1, m, temp, 0, 26 + UnsignedByte.intValue(arg1[m + 24]) + UnsignedByte.intValue(arg1[m + 25]));
                this.cards[k] = new DLPCardInfo(temp);
                m += UnsignedByte.intValue(arg1[m + 24]) + UnsignedByte.intValue(arg1[m + 25]);
                ++k;
            }
            if (arg2 != null) {
                this.extResponse = true;
                this.setRomDatabaseCount(UnsignedByte.intValue(arg2[0]) * 256 + UnsignedByte.intValue(arg2[1]));
                this.setRamDatabaseCount(UnsignedByte.intValue(arg2[2]) * 256 + UnsignedByte.intValue(arg2[3]));
            }
        }
        catch (Throwable t) {
            throw new DLPFunctionCallException("DLPStorageInfo caught throwable: " + t.toString(), Integer.MAX_VALUE);
        }
    }

    public DLPCardInfo getCardInfo(int i) throws DLPFunctionCallException {
        try {
            return this.cards[i];
        }
        catch (Throwable ex) {
            throw new DLPFunctionCallException("Invalid Card ID number: " + i, Integer.MAX_VALUE);
        }
    }

    public boolean getHasMoreCards() {
        return this.hasMoreCards;
    }

    public int getNumCards() {
        return this.numCards;
    }

    public int getRamDatabaseCount() {
        return this.ramDatabaseCount;
    }

    public int getRomDatabaseCount() {
        return this.romDataBaseCount;
    }

    public boolean hasExtendedResponse() {
        return this.extResponse;
    }

    private void setHasMoreCards(boolean flag) {
        this.hasMoreCards = flag;
    }

    private void setNumCards(int i) {
        this.numCards = i;
    }

    private void setRamDatabaseCount(int i) {
        this.ramDatabaseCount = i;
    }

    private void setRomDatabaseCount(int i) {
        this.romDataBaseCount = i;
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("Number of Cards:    " + this.numCards + "\n");
        stringbuffer.append("Has More Cards:     " + this.hasMoreCards + "\n");
        if (this.extResponse) {
            stringbuffer.append("ROM Database Count: " + this.romDataBaseCount + "\n");
            stringbuffer.append("RAM Database Count: " + this.ramDatabaseCount + "\n");
        }
        int i = 0;
        while (i < this.cards.length) {
            stringbuffer.append("Card #" + i + ":\n");
            stringbuffer.append(this.cards[i].toString());
            ++i;
        }
        return stringbuffer.toString();
    }
}

