/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util;

import java.io.Serializable;
import org.jSyncManager.API.Protocol.DLPFunctionCallException;
import org.jSyncManager.API.Tools.UnsignedByte;

public class DLPResource
implements Serializable {
    private int resourceType = 0;
    private char resourceID = '\u0000';
    private char index = '\u0000';
    private char resourceSize = '\u0000';
    private byte[] data;
    public static final byte DELETE_ALL = -128;

    DLPResource() {
    }

    public DLPResource(byte[] abyte0) throws DLPFunctionCallException {
        int i = 0;
        try {
            this.setResourceType(UnsignedByte.unsignedBytes2Int(abyte0[i++], abyte0[i++], abyte0[i++], abyte0[i++]));
            this.setResourceID(UnsignedByte.unsignedBytes2Char(abyte0[i++], abyte0[i++]));
            this.setIndex(UnsignedByte.unsignedBytes2Char(abyte0[i++], abyte0[i++]));
            this.setResourceSize(UnsignedByte.unsignedBytes2Char(abyte0[i++], abyte0[i++]));
            this.data = new byte[this.getResourceSize()];
            System.arraycopy(abyte0, i, this.data, 0, this.data.length);
        }
        catch (Throwable throwable) {
            throw new DLPFunctionCallException(throwable.toString(), Integer.MAX_VALUE);
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public char getIndex() {
        return this.index;
    }

    public char getResourceID() {
        return this.resourceID;
    }

    public char getResourceSize() {
        return this.resourceSize;
    }

    public int getResourceType() {
        return this.resourceType;
    }

    public String getResourceTypeString() {
        byte[] abyte0 = new byte[4];
        int i = 0;
        int j = 0x1000000;
        while (j > 0) {
            abyte0[i++] = (byte)((this.resourceType & j * 255) / j);
            j /= 256;
        }
        return new String(abyte0);
    }

    void setData(byte[] abyte0) {
        this.data = abyte0;
    }

    void setIndex(char c) {
        this.index = c;
    }

    void setResourceID(char c) {
        this.resourceID = c;
    }

    void setResourceSize(char c) {
        this.resourceSize = c;
    }

    void setResourceType(int i) {
        this.resourceType = i;
    }
}

