/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.jSyncManager.API.Protocol.Util.DLPRecord;

public class DLPRecordWriter
extends Writer {
    private transient OutputStreamWriter os = null;
    private transient DLPRecord dlprecord = null;

    public DLPRecordWriter() {
    }

    public DLPRecordWriter(OutputStreamWriter out) {
        this.os = out;
    }

    public DLPRecordWriter(DLPRecord dlprec, OutputStreamWriter out) {
        this(out);
        this.dlprecord = dlprec;
    }

    public void close() throws IOException {
        if (this.os != null) {
            this.flush();
            this.os.close();
        }
    }

    public void flush() throws IOException {
        if (this.os != null) {
            this.os.flush();
        }
    }

    public String toString() {
        return super.toString() + ":DLPRecordOutputStream: " + (this.dlprecord != null ? this.dlprecord.toString() : "");
    }

    public void write(char[] values) throws IOException {
        if (this.os != null) {
            this.os.write(values, 0, values.length);
        }
    }

    public void write(int param) throws IOException {
        if (this.os != null) {
            this.os.write(param);
        }
    }

    public void write(char[] values, int offset, int length) throws IOException {
        if (length < 0 || values.length < length + offset) {
            throw new IndexOutOfBoundsException("DLPRecordOutputStream.write(byte[], int, int)");
        }
        if (this.os != null) {
            this.os.write(values, offset, length);
        }
    }

    public void write(StringBuffer buff) throws IOException {
        int i = 0;
        while (i < buff.length()) {
            this.getOs().write(buff.charAt(i));
            ++i;
        }
    }

    public void write(String buff) throws IOException {
        this.getOs().write(buff);
    }

    public DLPRecord getRecord() {
        return this.dlprecord;
    }

    public void setRecord(DLPRecord dlprecord) throws IOException {
        this.dlprecord = dlprecord;
    }

    public OutputStreamWriter getOs() {
        return this.os;
    }

    public void setOs(OutputStreamWriter os) {
        this.os = os;
    }
}

