/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.jSyncManager.API.Protocol.Util.DLPRecord;
import org.jSyncManager.API.Protocol.Util.JSCSVCell;
import org.jSyncManager.API.Protocol.Util.JSCSVDocument;

public class DLPRecordCSV
extends JSCSVDocument {
    private DLPRecord record = null;
    private static final int[] dlprecordtypes = new int[]{3, 1, 1, 2, 2};
    private static final String[] dlprecordtitles = new String[]{"DLPRecord_RecordID", "DLPRecord_Index", "DLPRecord_RecordSize", "DLPRecord_Attributes", "DLPRecord_Category"};

    public DLPRecordCSV() {
    }

    public DLPRecordCSV(DLPRecord rec) {
        this.record = rec;
        this.insertRecord(this.record);
    }

    public DLPRecordCSV(File document) throws IOException {
        super(document);
    }

    public DLPRecordCSV(InputStreamReader inputfile) throws IOException {
        super(inputfile);
    }

    public void readDocument(InputStreamReader inputfile) throws IOException {
        super.readDocument(inputfile);
    }

    public void readDocument(int row) {
        this.record.setRecordID(this.elementAt(row, 0).unescapeInt());
        this.record.setIndex(this.elementAt(row, 0).unescapeChar());
        this.record.setRecordSize(this.elementAt(row, 0).unescapeChar());
        this.record.setAttributes(this.elementAt(row, 0).unescapeByte());
        this.record.setCategory(this.elementAt(row, 0).unescapeByte());
    }

    public int insertRecord(DLPRecord rec) {
        this.record = rec;
        int col = 0;
        int row = this.getDocument().size();
        if (row <= 0) {
            this.insertTypes(this.record);
            ++row;
            if (this.isShowtitles()) {
                this.insertTitles(this.record);
                ++row;
            }
        }
        this.setElementAt(new JSCSVCell(this.record.getRecordID()), row, col++);
        this.setElementAt(new JSCSVCell(this.record.getIndex()), row, col++);
        this.setElementAt(new JSCSVCell(this.record.getRecordSize()), row, col++);
        this.setElementAt(new JSCSVCell(this.record.getAttributes()), row, col++);
        this.setElementAt(new JSCSVCell(this.record.getCategory()), row, col++);
        return col;
    }

    public int insertTypes(DLPRecord rec) {
        this.record = rec;
        int col = 0;
        int i = 0;
        while (i < dlprecordtypes.length) {
            this.setElementAt(new JSCSVCell(dlprecordtypes[i]), 0, col++);
            ++i;
        }
        return col;
    }

    public int insertTitles(DLPRecord rec) {
        this.record = rec;
        int col = 0;
        int i = 0;
        while (i < dlprecordtitles.length) {
            this.setElementAt(new JSCSVCell(dlprecordtitles[i]), 1, col++);
            ++i;
        }
        return col;
    }
}

