/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util;

import java.io.Serializable;
import org.jSyncManager.API.Protocol.DLPFunctionCallException;
import org.jSyncManager.API.Tools.UnsignedByte;

public class DLPRecord
implements Serializable {
    protected byte[] inputData;
    protected int recordID = 0;
    protected char index = '\u0000';
    protected char recordSize = '\u0000';
    protected byte attributes = 0;
    protected byte category = 0;
    protected byte[] data;
    public static final byte DELETE_ALL_RECORDS = -128;
    public static final byte DELETE_ALL_IN_CATEGORY = 64;
    public static final byte SORT_DATABASE = -128;
    public static final byte DELETED = -128;
    public static final byte DIRTY = 64;
    public static final byte BUSY = 32;
    public static final byte SECRET = 16;
    public static final byte ARCHIVED = 8;
    public static final byte DATA_INCLUDED = -128;

    public DLPRecord() {
    }

    public DLPRecord(DLPRecord dlp) {
        this.setRecordID(dlp.getRecordID());
        this.setIndex(dlp.getIndex());
        this.setRecordSize(dlp.getRecordSize());
        this.setAttributes(dlp.getAttributes());
        this.setCategory(dlp.getCategory());
        this.setData(dlp.getData());
    }

    public DLPRecord(byte[] inputData) throws DLPFunctionCallException {
        int i = 0;
        try {
            this.setRecordID(UnsignedByte.unsignedBytes2Int(inputData[i++], inputData[i++], inputData[i++], inputData[i++]));
            this.setIndex(UnsignedByte.unsignedBytes2Char(inputData[i++], inputData[i++]));
            this.setRecordSize(UnsignedByte.unsignedBytes2Char(inputData[i++], inputData[i++]));
            this.setAttributes(inputData[i++]);
            this.setCategory(inputData[i++]);
            this.data = new byte[inputData.length - 10];
            System.arraycopy(inputData, i, this.data, 0, this.data.length);
        }
        catch (Throwable throwable) {
            throw new DLPFunctionCallException(throwable.toString(), Integer.MAX_VALUE);
        }
    }

    public boolean checkAttribute(byte value) {
        return (this.attributes & value) != 0;
    }

    private void generateData() {
    }

    public byte getAttributes() {
        return this.attributes;
    }

    public byte getCategory() {
        return this.category;
    }

    public byte[] getData() {
        return this.data;
    }

    public char getIndex() {
        return this.index;
    }

    public static int getLength(byte[] data, int i) {
        int j = i;
        while (data[j] != 0) {
            ++j;
        }
        return j - i + 1;
    }

    public int getRecordID() {
        return this.recordID;
    }

    public char getRecordSize() {
        return this.recordSize;
    }

    private void parseFields() {
    }

    public void setAttributes(byte flags) {
        this.attributes = flags;
    }

    public void setCategory(byte categoryID) {
        this.category = categoryID;
    }

    void setData(byte[] inputData) {
        System.arraycopy(inputData, 0, this.data, 0, inputData.length);
    }

    public void setIndex(char c) {
        this.index = c;
    }

    public void setRecordID(int i) {
        this.recordID = i;
    }

    public void setRecordSize(char c) {
        this.recordSize = c;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Record ID:      ");
        sb.append(this.recordID);
        sb.append('\n');
        sb.append("Record Index:   ");
        sb.append((int)this.index);
        sb.append('\n');
        sb.append("Record Size:    ");
        sb.append((int)this.recordSize);
        sb.append('\n');
        sb.append("Attributes:     ");
        if (this.checkAttribute((byte)-128)) {
            sb.append("DELETED ");
        }
        if (this.checkAttribute((byte)64)) {
            sb.append("DIRTY ");
        }
        if (this.checkAttribute((byte)32)) {
            sb.append("BUSY ");
        }
        if (this.checkAttribute((byte)16)) {
            sb.append("SECRET ");
        }
        if (this.checkAttribute((byte)8)) {
            sb.append("ARCHIVED ");
        }
        sb.append('\n');
        sb.append("Category:       ");
        sb.append(this.category);
        sb.append("\n\n");
        sb.append(UnsignedByte.toString(this.data));
        return sb.toString();
    }

    public StringBuffer getDTD(int indent, boolean needHeader) {
        StringBuffer xmlstr = new StringBuffer();
        if (needHeader) {
            xmlstr.append("<!DOCTYPE jSyncManagerDLPRecord [\n");
        }
        xmlstr.append((Object)DLPRecord.getIndent(indent)).append("<!ELEMENT jSyncManagerDLPRecord");
        xmlstr.append(" (recordID, index, recordSize, attributes, category)>\n");
        xmlstr.append((Object)DLPRecord.getIndent(indent + 1)).append("<!ELEMENT recordID (#PCDATA)>\n");
        xmlstr.append((Object)DLPRecord.getIndent(indent + 1)).append("<!ELEMENT index (#PCDATA)>\n");
        xmlstr.append((Object)DLPRecord.getIndent(indent + 1)).append("<!ELEMENT recordSize (#PCDATA)>\n");
        xmlstr.append((Object)DLPRecord.getIndent(indent + 1)).append("<!ELEMENT attributes (#PCDATA)>\n");
        xmlstr.append((Object)DLPRecord.getIndent(indent + 1)).append("<!ELEMENT category (#PCDATA)>\n");
        if (needHeader) {
            xmlstr.append("]>\n");
        }
        return xmlstr;
    }

    public StringBuffer getXMLHeader() {
        return new StringBuffer();
    }

    public StringBuffer getXMLTrailer() {
        return new StringBuffer();
    }

    public StringBuffer getXML() {
        StringBuffer xmlstr = new StringBuffer();
        xmlstr.append((Object)this.getDTD(0, true));
        xmlstr.append((Object)this.getXML(0));
        return xmlstr;
    }

    public StringBuffer getXML(int indent) {
        StringBuffer xmlstr = new StringBuffer();
        xmlstr.append((Object)DLPRecord.getIndent(indent)).append("<jSyncManagerDLPRecord>\n");
        xmlstr.append((Object)DLPRecord.getIndent(indent + 1)).append("<recordID>" + this.getRecordID()).append("</recordID>\n");
        xmlstr.append((Object)DLPRecord.getIndent(indent + 1)).append("<index>" + this.getIndex()).append("</index>\n");
        xmlstr.append((Object)DLPRecord.getIndent(indent + 1)).append("<recordSize>" + this.getRecordSize()).append("</recordSize>\n");
        xmlstr.append((Object)DLPRecord.getIndent(indent + 1)).append("<attributes>" + this.getAttributes()).append("</attributes>\n");
        xmlstr.append((Object)DLPRecord.getIndent(indent + 1)).append("<category>" + this.getCategory()).append("</category>\n");
        xmlstr.append((Object)DLPRecord.getIndent(indent)).append("</jSyncManagerDLPRecord>\n");
        return xmlstr;
    }

    public StringBuffer getXML(boolean headerNeeded) {
        return this.getXML(1);
    }

    protected static StringBuffer getIndent(int newlevel) {
        StringBuffer tmpstr = new StringBuffer();
        int ind = 0;
        while (ind < newlevel) {
            tmpstr.append("\t");
            ++ind;
        }
        return tmpstr;
    }

    public StringBuffer escape(String in) {
        StringBuffer out = new StringBuffer(in);
        return this.escape(out);
    }

    public StringBuffer escape(StringBuffer in) {
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < in.length()) {
            char c = in.charAt(i);
            switch (c) {
                case '(': {
                    out.append("&#x0028;");
                    break;
                }
                case ')': {
                    out.append("&#x0029;");
                    break;
                }
                case '<': {
                    out.append("&lt;");
                    break;
                }
                case '>': {
                    out.append("&gt;");
                    break;
                }
                case '&': {
                    out.append("&amp;");
                    break;
                }
                case '\"': {
                    out.append("&quot;");
                    break;
                }
                default: {
                    out.append(c);
                }
            }
            ++i;
        }
        return out;
    }

    public StringBuffer getDTD() {
        return new StringBuffer();
    }
}

