/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.jSyncManager.API.Protocol.Util.DLPDatabase;
import org.jSyncManager.API.Protocol.Util.DLPDatabaseInfo;

public class DLPDatabaseSet {
    private Vector databases;
    private Vector databaseInfoSet = new Vector();
    private boolean modifiedFlag = false;
    private static final String DB_LIST_FILENAME = "DBLISTOBJ";
    private boolean fromDirectory = false;
    private String filename;
    private String seperator = System.getProperty("file.separator");

    public DLPDatabaseSet() {
        this.databases = new Vector();
    }

    public DLPDatabaseSet(String filename) throws Exception {
        this.filename = filename;
        FileInputStream fis = new FileInputStream(filename + this.seperator + DB_LIST_FILENAME);
        InflaterInputStream iis = new InflaterInputStream(fis);
        ObjectInputStream ois = new ObjectInputStream(iis);
        this.databaseInfoSet = (Vector)ois.readObject();
        this.fromDirectory = true;
        ois.close();
        iis.close();
        fis.close();
    }

    public void addDatabase(DLPDatabase db) {
        this.modifiedFlag = true;
        this.addDatabaseInfo(db.getDatabaseInfo());
        if (!this.fromDirectory) {
            this.databases.addElement(db);
        } else {
            try {
                FileOutputStream fos = new FileOutputStream(this.filename + this.seperator + db.getUniqueDBID());
                DeflaterOutputStream dos = new DeflaterOutputStream(fos);
                ObjectOutputStream oos = new ObjectOutputStream(dos);
                oos.writeObject(db);
                oos.close();
                dos.close();
                fos.close();
            }
            catch (IOException e) {
                return;
            }
        }
    }

    private void addDatabaseInfo(DLPDatabaseInfo dbInfo) {
        this.databaseInfoSet.addElement(dbInfo);
    }

    public int databaseCount() {
        return this.getDatabaseInfoSet().size();
    }

    public DLPDatabase getDatabase(int i) {
        if (!this.fromDirectory) {
            return (DLPDatabase)this.databases.elementAt(i % this.databaseCount());
        }
        try {
            FileInputStream fis = new FileInputStream(this.filename + this.seperator + this.getDatabaseInfo(i).getUniqueDBID());
            InflaterInputStream iis = new InflaterInputStream(fis);
            ObjectInputStream ois = new ObjectInputStream(iis);
            DLPDatabase ret = (DLPDatabase)ois.readObject();
            ois.close();
            iis.close();
            fis.close();
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    public DLPDatabase getDatabase(String s) {
        int i = 0;
        while (i < this.databases.size()) {
            if (this.getDatabase(i).getDatabaseInfo().getName().equals(s)) {
                return this.getDatabase(i);
            }
            ++i;
        }
        return null;
    }

    public DLPDatabaseInfo getDatabaseInfo(int dbNum) {
        return (DLPDatabaseInfo)this.databaseInfoSet.elementAt(dbNum);
    }

    public DLPDatabaseInfo getDatabaseInfo(String s) {
        if (this.fromDirectory) {
            int i = 0;
            while (i < this.databaseInfoSet.size()) {
                if (this.getDatabaseInfo(i).getName().equals(s)) {
                    return this.getDatabaseInfo(i);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.databases.size()) {
                if (this.getDatabase(i).getDatabaseInfo().getName().equals(s)) {
                    return this.getDatabase(i).getDatabaseInfo();
                }
                ++i;
            }
        }
        return null;
    }

    private Vector getDatabaseInfoSet() {
        return this.databaseInfoSet;
    }

    public boolean hasDatabase(String s) {
        int i = 0;
        while (i < this.databaseCount()) {
            if (this.getDatabaseInfo(i).getName().equals(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isModified() {
        return this.modifiedFlag;
    }

    public void removeDatabase(int i) {
        this.modifiedFlag = true;
        DLPDatabaseInfo temp = this.getDatabaseInfo(i);
        this.removeDatabaseInfo(i);
        if (!this.fromDirectory) {
            this.databases.removeElementAt(i);
        } else {
            File file = new File(this.filename + this.seperator + temp.getUniqueDBID());
            file.delete();
        }
    }

    public void removeDatabase(String s) {
        if (!this.fromDirectory) {
            int i = 0;
            while (i < this.databases.size()) {
                if (this.getDatabase(i).getDatabaseInfo().getName().equals(s)) {
                    this.removeDatabase(i);
                    return;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.databaseInfoSet.size()) {
                if (this.getDatabaseInfo(i).getName().equals(s)) {
                    this.removeDatabase(i);
                    return;
                }
                ++i;
            }
        }
    }

    private void removeDatabaseInfo(int dbNum) {
        this.databaseInfoSet.removeElementAt(dbNum);
    }

    private void setDatabaseListGroup(Vector newValue) {
        this.databaseInfoSet = newValue;
    }

    public void writeToFile(String filename) throws IOException {
        File file = new File(filename);
        if (!file.exists()) {
            file.mkdirs();
        } else if (!file.isDirectory()) {
            file.delete();
            file.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(filename + this.seperator + DB_LIST_FILENAME);
        DeflaterOutputStream dos = new DeflaterOutputStream(fos);
        ObjectOutputStream oos = new ObjectOutputStream(dos);
        oos.writeObject(this.getDatabaseInfoSet());
        oos.close();
        dos.finish();
        fos.close();
        if (this.fromDirectory) {
            return;
        }
        int i = 0;
        while (i < this.databaseCount()) {
            fos = new FileOutputStream(filename + this.seperator + this.getDatabaseInfo(i).getUniqueDBID());
            dos = new DeflaterOutputStream(fos);
            oos = new ObjectOutputStream(dos);
            oos.writeObject(this.getDatabase(i));
            oos.close();
            dos.finish();
            fos.close();
            ++i;
        }
    }
}

