/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util;

import java.util.Enumeration;
import org.jSyncManager.API.Protocol.DLPFunctionCallException;
import org.jSyncManager.API.Protocol.Util.DLPDatabaseInfo;
import org.jSyncManager.API.Tools.UnsignedByte;

public class DLPDatabaseListGroup
implements Enumeration {
    private char lastIndex = '\u0000';
    private byte flags = 0;
    private byte actualCount = 0;
    public static final byte MORE_DATABASES = -128;
    private int nextPtr = 0;
    private DLPDatabaseInfo[] dbInfo = null;

    public DLPDatabaseListGroup(byte[] groupData) throws DLPFunctionCallException {
        int i = 0;
        try {
            this.setLastIndex((char)(UnsignedByte.intValue(groupData[i++]) * 256 + UnsignedByte.intValue(groupData[i++])));
            this.setFlags(groupData[i++]);
            this.setActualCount(groupData[i++]);
            this.dbInfo = new DLPDatabaseInfo[UnsignedByte.intValue(this.getActualCount())];
            int j = 0;
            while (j < this.dbInfo.length) {
                int size = UnsignedByte.intValue(groupData[i]);
                byte[] nextDB = new byte[size];
                int startIndex = i;
                System.arraycopy(groupData, i, nextDB, 0, 44);
                i += 44;
                int k = 44;
                while (groupData[i] != 0) {
                    nextDB[k++] = groupData[i++];
                }
                i = startIndex + size;
                this.dbInfo[j] = new DLPDatabaseInfo(nextDB);
                ++j;
            }
        }
        catch (Throwable throwable) {
            throw new DLPFunctionCallException("DLPDatabaseListGroup caught exception: " + throwable.toString(), Integer.MAX_VALUE);
        }
    }

    public static DLPDatabaseListGroup bytes2DBList(byte[] abyte0) throws DLPFunctionCallException {
        return new DLPDatabaseListGroup(abyte0);
    }

    public boolean checkFlag(byte byte0) {
        return (this.flags & byte0) != 0;
    }

    public byte getActualCount() {
        return this.actualCount;
    }

    public DLPDatabaseInfo getElement(int i) {
        return this.dbInfo[i];
    }

    public byte getFlags() {
        return this.flags;
    }

    public char getLastIndex() {
        return this.lastIndex;
    }

    public boolean hasMoreElements() {
        return this.flags == -128;
    }

    public Object nextElement() {
        return this.dbInfo[this.nextPtr++];
    }

    private void setActualCount(byte byte0) {
        this.actualCount = byte0;
    }

    private void setFlags(byte byte0) {
        this.flags = byte0;
    }

    private void setLastIndex(char c) {
        this.lastIndex = c;
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer();
        int i = 0;
        while (i < this.dbInfo.length) {
            stringbuffer.append(this.dbInfo[i].toString());
            ++i;
        }
        return stringbuffer.toString();
    }
}

