/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util;

import java.io.Serializable;
import org.jSyncManager.API.Protocol.DLPFunctionCallException;
import org.jSyncManager.API.Protocol.Util.DLP_Date;
import org.jSyncManager.API.Tools.UnsignedByte;

public class DLPDatabaseInfo
implements Serializable {
    public static final byte EXCLUDE_FROM_SYNC = -128;
    public static final byte RAM_BASED = 64;
    public static final char UNKNOWN_DB_INDEX = '\uffff';
    private byte miscFlags = 0;
    private char databaseFlags = '\u0000';
    private int type = 0;
    private int creator = 0;
    private int version = 0;
    private int modificationNumber = 0;
    private DLP_Date creationTime = null;
    private DLP_Date backupTime = null;
    private DLP_Date modificationTime = null;
    private String name = null;
    private char databaseIndex = '\u0000';

    DLPDatabaseInfo() {
    }

    public DLPDatabaseInfo(byte[] dbInfoData) throws DLPFunctionCallException {
        int i = 0;
        boolean flag = false;
        try {
            int j = UnsignedByte.intValue(dbInfoData[i++]);
            if (dbInfoData.length < j | j > dbInfoData.length + 1) {
                throw new DLPFunctionCallException("DB Info record size mismatch!", Integer.MAX_VALUE);
            }
            this.setMiscFlags(dbInfoData[i++]);
            this.setDatabaseFlags(UnsignedByte.unsignedBytes2Char(dbInfoData[i++], dbInfoData[i++]));
            this.setType(UnsignedByte.unsignedBytes2Int(dbInfoData[i++], dbInfoData[i++], dbInfoData[i++], dbInfoData[i++]));
            this.setCreator(UnsignedByte.unsignedBytes2Int(dbInfoData[i++], dbInfoData[i++], dbInfoData[i++], dbInfoData[i++]));
            this.setVersion(UnsignedByte.unsignedBytes2Char(dbInfoData[i++], dbInfoData[i++]));
            this.setModificationNumber(UnsignedByte.unsignedBytes2Int(dbInfoData[i++], dbInfoData[i++], dbInfoData[i++], dbInfoData[i++]));
            byte[] nameArray = new byte[8];
            System.arraycopy(dbInfoData, i, nameArray, 0, 8);
            this.setCreationTime(new DLP_Date(nameArray));
            System.arraycopy(dbInfoData, i += 8, nameArray, 0, 8);
            this.setModificationTime(new DLP_Date(nameArray));
            System.arraycopy(dbInfoData, i += 8, nameArray, 0, 8);
            i += 8;
            this.setBackupTime(new DLP_Date(nameArray));
            this.setDatabaseIndex(UnsignedByte.unsignedBytes2Char(dbInfoData[i++], dbInfoData[i++]));
            nameArray = new byte[dbInfoData.length - i];
            System.arraycopy(dbInfoData, i, nameArray, 0, nameArray.length);
            i += nameArray.length;
            this.setName(new String(nameArray));
        }
        catch (Throwable throwable) {
            throw new DLPFunctionCallException(throwable.toString(), Integer.MAX_VALUE);
        }
    }

    public boolean checkDatabaseFlag(char c) {
        return (this.databaseFlags & c) != 0;
    }

    public boolean checkMiscFlag(byte byte0) {
        return (this.miscFlags & byte0) != 0;
    }

    public DLP_Date getBackupTime() {
        return this.backupTime;
    }

    public DLP_Date getCreationTime() {
        return this.creationTime;
    }

    public int getCreator() {
        return this.creator;
    }

    public String getCreatorID() {
        byte[] abyte0 = new byte[4];
        int i = 0;
        int j = 0x1000000;
        while (j > 0) {
            abyte0[i++] = (byte)((this.creator & j * 255) / j);
            j /= 256;
        }
        return new String(abyte0);
    }

    public char getDatabaseFlags() {
        return this.databaseFlags;
    }

    public char getDatabaseIndex() {
        return this.databaseIndex;
    }

    public byte getMiscFlags() {
        return this.miscFlags;
    }

    public int getModificationNumber() {
        return this.modificationNumber;
    }

    public DLP_Date getModificationTime() {
        return this.modificationTime;
    }

    public String getName() {
        return this.name.trim();
    }

    public int getType() {
        return this.type;
    }

    public String getTypeID() {
        byte[] abyte0 = new byte[4];
        int i = 0;
        int j = 0x1000000;
        while (j > 0) {
            abyte0[i++] = (byte)((this.type & j * 255) / j);
            j /= 256;
        }
        return new String(abyte0);
    }

    String getUniqueDBID() {
        return this.getName().replace(' ', '_');
    }

    public int getVersion() {
        return this.version;
    }

    void setBackupTime(DLP_Date dlp_date) {
        this.backupTime = dlp_date;
    }

    void setCreationTime(DLP_Date dlp_date) {
        this.creationTime = dlp_date;
    }

    void setCreator(int i) {
        this.creator = i;
    }

    void setDatabaseFlags(char c) {
        this.databaseFlags = c;
    }

    void setDatabaseIndex(char c) {
        this.databaseIndex = c;
    }

    void setMiscFlags(byte byte0) {
        this.miscFlags = byte0;
    }

    void setModificationNumber(int i) {
        this.modificationNumber = i;
    }

    void setModificationTime(DLP_Date dlp_date) {
        this.modificationTime = dlp_date;
    }

    void setName(String s) {
        this.name = s;
    }

    void setType(int i) {
        this.type = i;
    }

    void setVersion(int i) {
        this.version = i;
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("  Database Flags:      ");
        if ((this.databaseFlags & '\u0001') == 1) {
            stringbuffer.append("RESOURCE_DATABASE ");
        }
        if ((this.databaseFlags & 2) == 2) {
            stringbuffer.append("READ_ONLY ");
        }
        if ((this.databaseFlags & 4) == 4) {
            stringbuffer.append("APP_INFO_DIRTY ");
        }
        if ((this.databaseFlags & 8) == 8) {
            stringbuffer.append("BACKUP_FLAG ");
        }
        if ((this.databaseFlags & 0x10) == 16) {
            stringbuffer.append("INSTALL_NEWER ");
        }
        if ((this.databaseFlags & 0x20) == 32) {
            stringbuffer.append("RESET_AFTER_INSTALL ");
        }
        if ((this.databaseFlags & 0x80) == 128) {
            stringbuffer.append("COPY_PREVENTION ");
        }
        if ((this.databaseFlags & 0x8000) == 32768) {
            stringbuffer.append("DB_OPEN ");
        }
        if (this.databaseFlags == '\u0000') {
            stringbuffer.append("NONE");
        }
        stringbuffer.append("\n");
        stringbuffer.append("  Misc. Flags:         ");
        if ((this.miscFlags & 0xFFFFFF80) == -128) {
            stringbuffer.append("EXCLUDE_FROM_SYNC ");
        }
        if ((this.miscFlags & 0x40) == 64) {
            stringbuffer.append("RAM_BASED ");
        }
        if (this.miscFlags == 0) {
            stringbuffer.append("NONE");
        }
        stringbuffer.append("\n");
        stringbuffer.append("  Database Name:       " + this.name.trim() + "\n");
        stringbuffer.append("  Database Type #:     " + this.getType() + "\n");
        stringbuffer.append("  Database Creator #:  " + this.getCreator() + "\n");
        stringbuffer.append("  Database Type:       " + this.getTypeID() + "\n");
        stringbuffer.append("  Database Creator:    " + this.getCreatorID() + "\n");
        stringbuffer.append("  Database Version:    " + this.version + "\n");
        stringbuffer.append("  Modification Number: " + this.modificationNumber + "\n");
        stringbuffer.append("  Creation Time:       " + this.creationTime.toString() + "\n");
        stringbuffer.append("  Backup Time:         " + this.backupTime.toString() + "\n");
        stringbuffer.append("  Modification Time:   " + this.modificationTime.toString() + "\n");
        stringbuffer.append("  Database Index:      ");
        if (this.getDatabaseIndex() == '\uffff') {
            stringbuffer.append("Unknown\n");
        } else {
            stringbuffer.append((int)this.getDatabaseIndex());
        }
        return stringbuffer.toString();
    }
}

