/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import org.jSyncManager.API.Protocol.Util.DLPBlock;
import org.jSyncManager.API.Protocol.Util.DLPDatabaseInfo;
import org.jSyncManager.API.Protocol.Util.DLPRecord;
import org.jSyncManager.API.Protocol.Util.DLPResource;
import org.jSyncManager.API.Protocol.Util.DLP_Date;
import org.jSyncManager.API.Protocol.Util.DatabaseFormatException;
import org.jSyncManager.API.Tools.UnsignedByte;

public class DLPDatabase
implements Serializable {
    private boolean isResourceDB = false;
    private Vector data = new Vector();
    private DLPDatabaseInfo databaseInfo = null;
    private DLPBlock applicationBlock = null;
    private DLPBlock sortBlock = null;
    public static final byte RAM_BASED_DB_FLAG = -128;
    public static final byte ROM_BASED_DB_FLAG = 64;
    public static final byte READ_MULTI_FLAG = 32;
    public static final char RESOURCE_DATABASE = '\u0001';
    public static final char READ_ONLY = '\u0002';
    public static final char APP_INFO_DIRTY = '\u0004';
    public static final char BACKUP_FLAG = '\b';
    public static final char INSTALL_NEWER = '\u0010';
    public static final char RESET_AFTER_INSTALL = ' ';
    public static final char COPY_PREVENTION = '\u0080';
    public static final char DB_OPEN = '\u8000';
    public static final byte READ_MODE = -128;
    public static final byte WRITE_MODE = 64;
    public static final byte EXCLUSIVE_MODE = 32;
    public static final byte SHOW_SECRET = 16;

    private DLPDatabase() {
    }

    public DLPDatabase(boolean flag, DLPDatabaseInfo dlpdatabaseinfo) {
        this.setIsResourceDB(flag);
        this.setDatabaseInfo(dlpdatabaseinfo);
    }

    public void addElement(DLPRecord dlprecord) {
        this.data.addElement(dlprecord);
    }

    public void addElement(DLPResource dlpresource) {
        this.data.addElement(dlpresource);
    }

    public byte[] convert2File() {
        return null;
    }

    public void exportDatabase(String s) {
        File file = new File(s);
        if (file.isFile()) {
            file.delete();
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        if (this.isResourceDB()) {
            this.exportPRC(s);
        } else {
            this.exportPDB(s);
        }
    }

    private void exportPDB(String s) {
        int i = 78 + 10 * this.getElements();
        if (this.getApplicationBlock() != null) {
            i += this.getApplicationBlock().getData().length;
        }
        if (this.getSortBlock() != null) {
            i += this.getSortBlock().getData().length;
        }
        int j = 0;
        while (j < this.getElements()) {
            i += ((DLPRecord)this.getElement(j)).getData().length;
            ++j;
        }
        byte[] abyte3 = new byte[i];
        int k = 0;
        byte[] abyte4 = this.getDatabaseInfo().getName().getBytes();
        System.arraycopy(abyte4, 0, abyte3, k, abyte4.length);
        k += abyte4.length;
        int i1 = abyte4.length;
        while (i1 < 32) {
            abyte3[k++] = 0;
            ++i1;
        }
        char c = this.getDatabaseInfo().getDatabaseFlags();
        abyte3[k++] = (byte)((c & 0xFF00) / 256);
        abyte3[k++] = (byte)((c & 0xFF) / 1);
        c = (char)this.getDatabaseInfo().getVersion();
        abyte3[k++] = (byte)((c & 0xFF00) / 256);
        abyte3[k++] = (byte)((c & 0xFF) / 1);
        DLP_Date dlp_date = this.getDatabaseInfo().getCreationTime();
        int i3 = dlp_date.convertToSeconds();
        abyte3[k++] = (byte)((i3 & 0xFF000000) / 0x1000000);
        abyte3[k++] = (byte)((i3 & 0xFF0000) / 65536);
        abyte3[k++] = (byte)((i3 & 0xFF00) / 256);
        abyte3[k++] = (byte)((i3 & 0xFF) / 1);
        dlp_date = this.getDatabaseInfo().getModificationTime();
        i3 = dlp_date.convertToSeconds();
        abyte3[k++] = (byte)((i3 & 0xFF000000) / 0x1000000);
        abyte3[k++] = (byte)((i3 & 0xFF0000) / 65536);
        abyte3[k++] = (byte)((i3 & 0xFF00) / 256);
        abyte3[k++] = (byte)((i3 & 0xFF) / 1);
        dlp_date = this.getDatabaseInfo().getBackupTime();
        i3 = dlp_date.convertToSeconds();
        abyte3[k++] = (byte)((i3 & 0xFF000000) / 0x1000000);
        abyte3[k++] = (byte)((i3 & 0xFF0000) / 65536);
        abyte3[k++] = (byte)((i3 & 0xFF00) / 256);
        abyte3[k++] = (byte)((i3 & 0xFF) / 1);
        i3 = this.getDatabaseInfo().getModificationNumber();
        abyte3[k++] = (byte)((i3 & 0xFF000000) / 0x1000000);
        abyte3[k++] = (byte)((i3 & 0xFF0000) / 65536);
        abyte3[k++] = (byte)((i3 & 0xFF00) / 256);
        abyte3[k++] = (byte)((i3 & 0xFF) / 1);
        int l2 = 78 + this.getElements() * 10;
        if (this.getApplicationBlock() != null) {
            i3 = l2;
            abyte3[k++] = (byte)((i3 & 0xFF000000) / 0x1000000);
            abyte3[k++] = (byte)((i3 & 0xFF0000) / 65536);
            abyte3[k++] = (byte)((i3 & 0xFF00) / 256);
            abyte3[k++] = (byte)((i3 & 0xFF) / 1);
            l2 += this.getApplicationBlock().getData().length;
        }
        if (this.getSortBlock() != null) {
            i3 = l2;
            abyte3[k++] = (byte)((i3 & 0xFF000000) / 0x1000000);
            abyte3[k++] = (byte)((i3 & 0xFF0000) / 65536);
            abyte3[k++] = (byte)((i3 & 0xFF00) / 256);
            abyte3[k++] = (byte)((i3 & 0xFF) / 1);
            l2 += this.getSortBlock().getData().length;
        }
        i3 = this.getDatabaseInfo().getType();
        abyte3[k++] = (byte)((i3 & 0xFF000000) / 0x1000000);
        abyte3[k++] = (byte)((i3 & 0xFF0000) / 65536);
        abyte3[k++] = (byte)((i3 & 0xFF00) / 256);
        abyte3[k++] = (byte)((i3 & 0xFF) / 1);
        i3 = this.getDatabaseInfo().getCreator();
        abyte3[k++] = (byte)((i3 & 0xFF000000) / 0x1000000);
        abyte3[k++] = (byte)((i3 & 0xFF0000) / 65536);
        abyte3[k++] = (byte)((i3 & 0xFF00) / 256);
        abyte3[k++] = (byte)((i3 & 0xFF) / 1);
        int j1 = 0;
        while (j1 < 8) {
            abyte3[k++] = 0;
            ++j1;
        }
        c = (char)this.getElements();
        abyte3[k++] = (byte)((c & 0xFF00) / 256);
        abyte3[k++] = (byte)((c & 0xFF) / 1);
        int k1 = 0;
        while (k1 < this.getElements()) {
            DLPRecord dlprecord = (DLPRecord)this.getElement(k1);
            int j3 = l2;
            abyte3[k++] = (byte)((j3 & 0xFF000000) / 0x1000000);
            abyte3[k++] = (byte)((j3 & 0xFF0000) / 65536);
            abyte3[k++] = (byte)((j3 & 0xFF00) / 256);
            abyte3[k++] = (byte)((j3 & 0xFF) / 1);
            abyte3[k++] = dlprecord.getAttributes();
            char c1 = (char)dlprecord.getRecordID();
            abyte3[k++] = 0;
            abyte3[k++] = (byte)((c1 & 0xFF00) / 256);
            abyte3[k++] = (byte)((c1 & 0xFF) / 1);
            l2 += dlprecord.getData().length;
            ++k1;
        }
        if (this.getApplicationBlock() != null) {
            byte[] abyte0 = this.getApplicationBlock().getData();
            System.arraycopy(abyte0, 0, abyte3, k, abyte0.length);
            k += abyte0.length;
        }
        if (this.getSortBlock() != null) {
            byte[] abyte1 = this.getSortBlock().getData();
            System.arraycopy(abyte1, 0, abyte3, k, abyte1.length);
            k += abyte1.length;
        }
        int j2 = 0;
        while (j2 < this.getElements()) {
            DLPRecord dlprecord1 = (DLPRecord)this.getElement(j2);
            byte[] abyte2 = dlprecord1.getData();
            System.arraycopy(abyte2, 0, abyte3, k, abyte2.length);
            k += abyte2.length;
            ++j2;
        }
        String s1 = System.getProperty("file.separator");
        String s2 = s.endsWith(s1) ? s + this.getDatabaseInfo().getName() + ".PDB" : s + s1 + this.getDatabaseInfo().getName() + ".PDB";
        try {
            FileOutputStream fileoutputstream = new FileOutputStream(s2);
            fileoutputstream.write(abyte3);
            fileoutputstream.close();
        }
        catch (Exception exception) {
            System.out.println("Unable to write database due to exception: " + exception.toString());
        }
    }

    private void exportPRC(String s) {
        int i = 78 + 10 * this.getElements();
        int j = 0;
        while (j < this.getElements()) {
            i += ((DLPResource)this.getElement(j)).getData().length;
            ++j;
        }
        byte[] abyte1 = new byte[i];
        int k = 0;
        byte[] abyte2 = this.getDatabaseInfo().getName().getBytes();
        System.arraycopy(abyte2, 0, abyte1, k, abyte2.length);
        k += abyte2.length;
        int i1 = abyte2.length;
        while (i1 < 32) {
            abyte1[k++] = 0;
            ++i1;
        }
        char c = this.getDatabaseInfo().getDatabaseFlags();
        abyte1[k++] = (byte)((c & 0xFF00) / 256);
        abyte1[k++] = (byte)((c & 0xFF) / 1);
        c = (char)this.getDatabaseInfo().getVersion();
        abyte1[k++] = (byte)((c & 0xFF00) / 256);
        abyte1[k++] = (byte)((c & 0xFF) / 1);
        DLP_Date dlp_date = this.getDatabaseInfo().getCreationTime();
        int l2 = dlp_date.convertToSeconds();
        abyte1[k++] = (byte)((l2 & 0xFF000000) / 0x1000000);
        abyte1[k++] = (byte)((l2 & 0xFF0000) / 65536);
        abyte1[k++] = (byte)((l2 & 0xFF00) / 256);
        abyte1[k++] = (byte)((l2 & 0xFF) / 1);
        dlp_date = this.getDatabaseInfo().getModificationTime();
        l2 = dlp_date.convertToSeconds();
        abyte1[k++] = (byte)((l2 & 0xFF000000) / 0x1000000);
        abyte1[k++] = (byte)((l2 & 0xFF0000) / 65536);
        abyte1[k++] = (byte)((l2 & 0xFF00) / 256);
        abyte1[k++] = (byte)((l2 & 0xFF) / 1);
        dlp_date = this.getDatabaseInfo().getBackupTime();
        l2 = dlp_date.convertToSeconds();
        abyte1[k++] = (byte)((l2 & 0xFF000000) / 0x1000000);
        abyte1[k++] = (byte)((l2 & 0xFF0000) / 65536);
        abyte1[k++] = (byte)((l2 & 0xFF00) / 256);
        abyte1[k++] = (byte)((l2 & 0xFF) / 1);
        l2 = this.getDatabaseInfo().getModificationNumber();
        abyte1[k++] = (byte)((l2 & 0xFF000000) / 0x1000000);
        abyte1[k++] = (byte)((l2 & 0xFF0000) / 65536);
        abyte1[k++] = (byte)((l2 & 0xFF00) / 256);
        abyte1[k++] = (byte)((l2 & 0xFF) / 1);
        int j1 = 0;
        while (j1 < 8) {
            abyte1[k++] = 0;
            ++j1;
        }
        l2 = this.getDatabaseInfo().getType();
        abyte1[k++] = (byte)((l2 & 0xFF000000) / 0x1000000);
        abyte1[k++] = (byte)((l2 & 0xFF0000) / 65536);
        abyte1[k++] = (byte)((l2 & 0xFF00) / 256);
        abyte1[k++] = (byte)((l2 & 0xFF) / 1);
        l2 = this.getDatabaseInfo().getCreator();
        abyte1[k++] = (byte)((l2 & 0xFF000000) / 0x1000000);
        abyte1[k++] = (byte)((l2 & 0xFF0000) / 65536);
        abyte1[k++] = (byte)((l2 & 0xFF00) / 256);
        abyte1[k++] = (byte)((l2 & 0xFF) / 1);
        int k1 = 0;
        while (k1 < 8) {
            abyte1[k++] = 0;
            ++k1;
        }
        c = (char)this.getElements();
        abyte1[k++] = (byte)((c & 0xFF00) / 256);
        abyte1[k++] = (byte)((c & 0xFF) / 1);
        int k2 = k + this.getElements() * 10;
        int l1 = 0;
        while (l1 < this.getElements()) {
            DLPResource dlpresource = (DLPResource)this.getElement(l1);
            int i3 = dlpresource.getResourceType();
            abyte1[k++] = (byte)((i3 & 0xFF000000) / 0x1000000);
            abyte1[k++] = (byte)((i3 & 0xFF0000) / 65536);
            abyte1[k++] = (byte)((i3 & 0xFF00) / 256);
            abyte1[k++] = (byte)((i3 & 0xFF) / 1);
            char c1 = dlpresource.getResourceID();
            abyte1[k++] = (byte)((c1 & 0xFF00) / 256);
            abyte1[k++] = (byte)((c1 & 0xFF) / 1);
            i3 = k2;
            abyte1[k++] = (byte)((i3 & 0xFF000000) / 0x1000000);
            abyte1[k++] = (byte)((i3 & 0xFF0000) / 65536);
            abyte1[k++] = (byte)((i3 & 0xFF00) / 256);
            abyte1[k++] = (byte)((i3 & 0xFF) / 1);
            k2 += dlpresource.getData().length;
            ++l1;
        }
        int i2 = 0;
        while (i2 < this.getElements()) {
            DLPResource dlpresource1 = (DLPResource)this.getElement(i2);
            byte[] abyte0 = dlpresource1.getData();
            System.arraycopy(abyte0, 0, abyte1, k, abyte0.length);
            k += abyte0.length;
            ++i2;
        }
        String s1 = System.getProperty("file.separator");
        String s2 = s.endsWith(s1) ? s + this.getDatabaseInfo().getName() + ".PRC" : s + s1 + this.getDatabaseInfo().getName() + ".PRC";
        try {
            FileOutputStream fileoutputstream = new FileOutputStream(s2);
            fileoutputstream.write(abyte1);
            fileoutputstream.close();
        }
        catch (Exception exception) {
            System.out.println("Unable to write database due to exception: " + exception.toString());
        }
    }

    public DLPBlock getApplicationBlock() {
        return this.applicationBlock;
    }

    public DLPDatabaseInfo getDatabaseInfo() {
        return this.databaseInfo;
    }

    public Object getElement(int i) {
        if (i >= this.data.size()) {
            return null;
        }
        return this.data.elementAt(i);
    }

    public int getElements() {
        return this.data.size();
    }

    public DLPBlock getSortBlock() {
        return this.sortBlock;
    }

    String getUniqueDBID() {
        return this.getDatabaseInfo().getUniqueDBID();
    }

    private static DLPDatabase importDB(InputStream inputStream) throws DatabaseFormatException {
        DLPDatabase db = new DLPDatabase();
        DLPDatabaseInfo dbinfo = new DLPDatabaseInfo();
        int i = 0;
        try {
            int nextOffset;
            byte[] buf = DLPDatabase.readStream(inputStream);
            byte[] temp = new byte[32];
            while (buf[i] != 0) {
                temp[i] = buf[i++];
            }
            dbinfo.setName(new String(temp));
            i = 32;
            dbinfo.setDatabaseFlags(UnsignedByte.unsignedBytes2Char(buf[i++], buf[i++]));
            dbinfo.setVersion(UnsignedByte.unsignedBytes2Char(buf[i++], buf[i++]));
            dbinfo.setCreationTime(new DLP_Date(DLP_Date.seconds2Calendar(UnsignedByte.unsignedBytes2Int(buf[i++], buf[i++], buf[i++], buf[i++]))));
            dbinfo.setModificationTime(new DLP_Date(DLP_Date.seconds2Calendar(UnsignedByte.unsignedBytes2Int(buf[i++], buf[i++], buf[i++], buf[i++]))));
            dbinfo.setBackupTime(new DLP_Date(DLP_Date.seconds2Calendar(UnsignedByte.unsignedBytes2Int(buf[i++], buf[i++], buf[i++], buf[i++]))));
            dbinfo.setModificationNumber(UnsignedByte.unsignedBytes2Int(buf[i++], buf[i++], buf[i++], buf[i++]));
            int appInfoOffset = UnsignedByte.unsignedBytes2Int(buf[i++], buf[i++], buf[i++], buf[i++]);
            int sortBlockOffset = UnsignedByte.unsignedBytes2Int(buf[i++], buf[i++], buf[i++], buf[i++]);
            dbinfo.setType(UnsignedByte.unsignedBytes2Int(buf[i++], buf[i++], buf[i++], buf[i++]));
            dbinfo.setCreator(UnsignedByte.unsignedBytes2Int(buf[i++], buf[i++], buf[i++], buf[i++]));
            int uniqueIDSeed = UnsignedByte.unsignedBytes2Int(buf[i++], buf[i++], buf[i++], buf[i++]);
            int nextRecordList = UnsignedByte.unsignedBytes2Int(buf[i++], buf[i++], buf[i++], buf[i++]);
            int numEntries = UnsignedByte.unsignedBytes2Char(buf[i++], buf[i++]);
            db.setDatabaseInfo(dbinfo);
            db.setIsResourceDB(db.getDatabaseInfo().checkDatabaseFlag('\u0001'));
            if (appInfoOffset != 0) {
                nextOffset = sortBlockOffset == 0 ? (numEntries == 0 ? buf.length : UnsignedByte.unsignedBytes2Int(buf[78], buf[79], buf[80], buf[81])) : sortBlockOffset;
                byte[] tempAppInfo = new byte[nextOffset - appInfoOffset];
                System.arraycopy(buf, appInfoOffset, tempAppInfo, 0, nextOffset - appInfoOffset);
                db.setApplicationBlock(new DLPBlock(tempAppInfo));
            }
            if (sortBlockOffset != 0) {
                nextOffset = numEntries == 0 ? buf.length : UnsignedByte.unsignedBytes2Int(buf[78], buf[79], buf[80], buf[81]);
                byte[] tempSortBlock = new byte[nextOffset - sortBlockOffset];
                System.arraycopy(buf, sortBlockOffset, tempSortBlock, 0, nextOffset - sortBlockOffset);
                db.setSortBlock(new DLPBlock(tempSortBlock));
            }
            i = 78;
            int j = 0;
            while (j < numEntries) {
                int recordOffset;
                if (db.getDatabaseInfo().checkDatabaseFlag('\u0001')) {
                    DLPResource resource = new DLPResource();
                    resource.setResourceType(UnsignedByte.unsignedBytes2Int(buf[i++], buf[i++], buf[i++], buf[i++]));
                    resource.setResourceID(UnsignedByte.unsignedBytes2Char(buf[i++], buf[i++]));
                    recordOffset = UnsignedByte.unsignedBytes2Int(buf[i++], buf[i++], buf[i++], buf[i++]);
                    int nextRecOffset = j != numEntries - '\u0001' ? UnsignedByte.unsignedBytes2Int(buf[i + 6], buf[i + 7], buf[i + 8], buf[i + 9]) : buf.length;
                    byte[] tempResource = new byte[nextRecOffset - recordOffset];
                    resource.setResourceSize((char)tempResource.length);
                    System.arraycopy(buf, recordOffset, tempResource, 0, nextRecOffset - recordOffset);
                    resource.setData(tempResource);
                    db.addElement(resource);
                } else {
                    DLPRecord record = new DLPRecord();
                    recordOffset = UnsignedByte.unsignedBytes2Int(buf[i++], buf[i++], buf[i++], buf[i++]);
                    byte attr = buf[i++];
                    record.setAttributes((byte)(attr & 0xF0));
                    record.setCategory((byte)(attr & 0xF));
                    record.setRecordID(UnsignedByte.unsignedBytes2Int((byte)0, buf[i++], buf[i++], buf[i++]));
                    int nextRecOffset = j != numEntries - '\u0001' ? UnsignedByte.unsignedBytes2Int(buf[i], buf[i + 1], buf[i + 2], buf[i + 3]) : buf.length;
                    byte[] tempRecord = new byte[nextRecOffset - recordOffset];
                    record.setRecordSize((char)tempRecord.length);
                    System.arraycopy(buf, recordOffset, tempRecord, 0, nextRecOffset - recordOffset);
                    record.setData(tempRecord);
                    db.addElement(record);
                }
                ++j;
            }
            return db;
        }
        catch (Throwable throwable) {
            throw new DatabaseFormatException(throwable.toString());
        }
    }

    public static DLPDatabase importFromFile(String filename) throws DatabaseFormatException {
        return DLPDatabase.importFromFile(new File(filename));
    }

    public static DLPDatabase importFromFile(File filename) throws DatabaseFormatException {
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(filename);
        }
        catch (IOException ioexception) {
            throw new DatabaseFormatException(ioexception.toString());
        }
        try {
            DLPDatabase db = DLPDatabase.importDB(inputStream);
            inputStream.close();
            return db;
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new DatabaseFormatException(throwable.toString());
        }
    }

    public static DLPDatabase importFromURL(URL url) throws DatabaseFormatException {
        DataInputStream inputStream;
        try {
            inputStream = new DataInputStream(url.openStream());
        }
        catch (IOException ioe) {
            throw new DatabaseFormatException(ioe.toString());
        }
        try {
            DLPDatabase db = DLPDatabase.importDB(inputStream);
            inputStream.close();
            return db;
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new DatabaseFormatException(throwable.toString());
        }
    }

    public boolean isResourceDB() {
        return this.isResourceDB;
    }

    private static byte[] readStream(InputStream stream) throws Exception {
        byte[] buffer = null;
        if (stream instanceof FileInputStream) {
            buffer = new byte[((FileInputStream)stream).available()];
            ((FileInputStream)stream).read(buffer);
        } else {
            byte[] temp;
            int len = 65536;
            buffer = new byte[len];
            int n = 0;
            int count = 0;
            while (true) {
                if (n < len) {
                    count = stream.read(buffer, n, len - n);
                    if (count >= 0) {
                        n += count;
                        continue;
                    }
                }
                if (count < 0) break;
                temp = new byte[len += 65536];
                System.arraycopy(buffer, 0, temp, 0, buffer.length);
                buffer = temp;
                if (count <= 0) break;
            }
            temp = new byte[n];
            System.arraycopy(buffer, 0, temp, 0, n);
            buffer = temp;
        }
        return buffer;
    }

    public void setApplicationBlock(DLPBlock dlpblock) {
        this.applicationBlock = dlpblock;
    }

    private void setDatabaseInfo(DLPDatabaseInfo dlpdatabaseinfo) {
        this.databaseInfo = dlpdatabaseinfo;
    }

    private void setIsResourceDB(boolean flag) {
        this.isResourceDB = flag;
    }

    public void setSortBlock(DLPBlock dlpblock) {
        this.sortBlock = dlpblock;
    }
}

