/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util;

import java.io.Serializable;
import org.jSyncManager.API.Protocol.DLPFunctionCallException;
import org.jSyncManager.API.Protocol.Util.DLP_Date;
import org.jSyncManager.API.Tools.UnsignedByte;

public class DLPCardInfo
implements Serializable {
    private int cardNumber = 0;
    private int cardVersion = 0;
    private DLP_Date creationTime = null;
    private int romSize = 0;
    private int ramSize = 0;
    private int freeRam = 0;
    private String cardName = null;
    private String cardManufacturer;

    private DLPCardInfo() {
    }

    public DLPCardInfo(byte[] abyte0) throws DLPFunctionCallException {
        int i = 0;
        byte[] abyte1 = new byte[8];
        try {
            int n = ++i;
            this.setCardNumber(UnsignedByte.intValue(abyte0[n]));
            int n2 = ++i;
            int n3 = ++i;
            this.setCardVersion(UnsignedByte.intValue(abyte0[n2]) * 256 + UnsignedByte.intValue(abyte0[n3]));
            System.arraycopy(abyte0, ++i, abyte1, 0, 8);
            this.setCreationTime(new DLP_Date(abyte1));
            this.setRomSize(UnsignedByte.unsignedBytes2Int(abyte0[i++], abyte0[i++], abyte0[i++], abyte0[i++]));
            this.setRamSize(UnsignedByte.unsignedBytes2Int(abyte0[i++], abyte0[i++], abyte0[i++], abyte0[i++]));
            this.setFreeRam(UnsignedByte.unsignedBytes2Int(abyte0[i++], abyte0[i++], abyte0[i++], abyte0[i++]));
            i = UnsignedByte.intValue(abyte0[i++]);
            abyte1 = new byte[i];
            System.arraycopy(abyte0, 26, abyte1, 0, i);
            this.setCardName(new String(abyte1));
            abyte1 = new byte[UnsignedByte.intValue(abyte0[25])];
            System.arraycopy(abyte0, 26 + i, abyte1, 0, abyte1.length);
            this.setCardManufacturer(new String(abyte1));
        }
        catch (Exception exception) {
            throw new DLPFunctionCallException(exception.toString(), Integer.MAX_VALUE);
        }
    }

    public String getCardManufacturer() {
        return this.cardManufacturer;
    }

    public String getCardName() {
        return this.cardName;
    }

    public int getCardNumber() {
        return this.cardNumber;
    }

    public int getCardVersion() {
        return this.cardVersion;
    }

    public DLP_Date getCreationTime() {
        return this.creationTime;
    }

    public int getFreeRam() {
        return this.freeRam;
    }

    public int getRamSize() {
        return this.ramSize;
    }

    public int getRomSize() {
        return this.romSize;
    }

    private void setCardManufacturer(String s) {
        this.cardManufacturer = s;
    }

    private void setCardName(String s) {
        this.cardName = s;
    }

    private void setCardNumber(int i) {
        this.cardNumber = i;
    }

    private void setCardVersion(int i) {
        this.cardVersion = i;
    }

    private void setCreationTime(DLP_Date dlp_date) {
        this.creationTime = dlp_date;
    }

    private void setFreeRam(int i) {
        this.freeRam = i;
    }

    private void setRamSize(int i) {
        this.ramSize = i;
    }

    private void setRomSize(int i) {
        this.romSize = i;
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("  Card Number:        " + this.cardNumber + "\n");
        stringbuffer.append("  Card Version:       " + this.cardVersion + "\n");
        stringbuffer.append("  Creation Time:      " + this.creationTime.toString() + "\n");
        stringbuffer.append("  ROM Size:           " + this.romSize + "\n");
        stringbuffer.append("  RAM Size:           " + this.ramSize + "\n");
        stringbuffer.append("  Free RAM:           " + this.freeRam + "\n");
        stringbuffer.append("  Card Name:          " + this.cardName + "\n");
        stringbuffer.append("  Card Manufacturer:  " + this.cardManufacturer + "\n");
        return stringbuffer.toString();
    }
}

