/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol.Util;

import org.jSyncManager.API.Protocol.DLPFunctionCallException;
import org.jSyncManager.API.Tools.UnsignedByte;

public class DLPAppPreference {
    private byte[] preference;
    private char actualSize;
    private char version;
    public static final char READ_ACTUAL_SIZE = '\uffff';
    public static final byte REQUEST_BACKUP_PREF = -128;

    public DLPAppPreference() {
    }

    public DLPAppPreference(byte[] data) throws DLPFunctionCallException {
        int i = 0;
        int j = 0;
        try {
            this.setVersion(UnsignedByte.unsignedBytes2Char(data[i++], data[i++]));
            this.setActualSize(UnsignedByte.unsignedBytes2Char(data[i++], data[i++]));
            this.preference = new byte[UnsignedByte.unsignedBytes2Char(data[i++], data[i++])];
            System.arraycopy(data, i, this.preference, j, data.length - i);
        }
        catch (Throwable t) {
            throw new DLPFunctionCallException("*** Unable to parse Preference: " + t.toString(), Integer.MAX_VALUE);
        }
    }

    public char getActualSize() {
        return this.actualSize;
    }

    public byte[] getPreference() {
        return this.preference;
    }

    public char getVersion() {
        return this.version;
    }

    public void setActualSize(char newValue) {
        this.actualSize = newValue;
    }

    public void setPreference(byte[] newValue) {
        this.preference = newValue;
    }

    public void setVersion(char newValue) {
        this.version = newValue;
    }
}

