/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol;

import java.io.Serializable;
import org.jSyncManager.API.Tools.UnsignedByte;

public class USB_Packet
implements Serializable {
    public byte packetType;
    public byte transactionID;
    public int packetSize;
    public static final byte DATA = 1;
    public static final byte ACK = 2;
    public static final byte NACK = 3;
    public static final byte TICKLE = 4;
    public static final byte ABORT = 8;
    public byte[] data;
    public boolean sent;

    private USB_Packet() {
    }

    public USB_Packet(byte type, byte transID, byte[] data) {
        this.packetType = type;
        this.transactionID = transID;
        this.data = data;
        this.packetSize = data.length;
    }

    public static USB_Packet bytes2Packet(byte[] pkt) {
        USB_Packet usb_packet = new USB_Packet();
        int i = 0;
        usb_packet.packetType = pkt[i++];
        usb_packet.transactionID = pkt[i++];
        usb_packet.packetSize = UnsignedByte.unsignedBytes2Int(pkt[i++], pkt[i++], pkt[i++], pkt[i++]);
        if (pkt.length - 6 == 0) {
            return usb_packet;
        }
        byte[] data = new byte[pkt.length - 6];
        System.arraycopy(pkt, 6, data, 0, pkt.length - 6);
        usb_packet.data = data;
        return usb_packet;
    }

    public static USB_Packet bytes2Packet(byte[] headerPkt, byte[] dataPkt) {
        USB_Packet usb_packet = new USB_Packet();
        int i = 0;
        usb_packet.packetType = headerPkt[i++];
        usb_packet.transactionID = headerPkt[i++];
        usb_packet.packetSize = UnsignedByte.unsignedBytes2Int(headerPkt[i++], headerPkt[i++], headerPkt[i++], headerPkt[i++]);
        if (dataPkt == null || dataPkt.length == 0) {
            return usb_packet;
        }
        usb_packet.data = dataPkt;
        return usb_packet;
    }

    public byte[] packet2Bytes() {
        byte[] pktdata = this.data != null ? new byte[6 + this.data.length] : new byte[]{this.packetType, this.transactionID, (byte)((this.packetSize & 0xFF000000) / 0x1000000), (byte)((this.packetSize & 0xFF0000) / 65536), (byte)((this.packetSize & 0xFF00) / 256), (byte)(this.packetSize & 0xFF)};
        if (this.data != null) {
            System.arraycopy(this.data, 0, pktdata, 6, this.data.length);
        }
        return pktdata;
    }
}

