/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol;

import org.jSyncManager.API.Protocol.CMPDLPTransferInterface;
import org.jSyncManager.API.Protocol.GenericPacket;
import org.jSyncManager.API.Protocol.NotConnectedException;
import org.jSyncManager.API.Protocol.PADP_PacketTooBigException;
import org.jSyncManager.API.Protocol.USB_Packet;
import org.jSyncManager.API.Tools.UnsignedByte;
import org.jSyncManager.API.Transport.TransportException;
import org.jSyncManager.API.Transport.USBTransportInterface;

public class USB
implements CMPDLPTransferInterface {
    public static final byte INITIAL_TRANSACTION_ID = -1;
    protected byte transactionID = 0;
    protected USBTransportInterface transport = null;
    protected boolean connected = false;
    protected boolean debugMode = false;

    public USB(USBTransportInterface usbTransport) {
        this.transport = usbTransport;
        if (System.getProperty("jsyncman.padpdebug") != null && System.getProperty("jsyncman.padpdebug").toLowerCase().equals("true")) {
            this.debugMode = true;
        }
    }

    public void connect() {
        if (this.connected) {
            return;
        }
        try {
            this.transport.open();
            this.connected = true;
        }
        catch (TransportException e) {
            System.err.println(e.toString());
        }
    }

    public GenericPacket readPacket() throws NotConnectedException {
        if (!this.connected) {
            throw new NotConnectedException();
        }
        byte[] header = new byte[6];
        int i = 0;
        while (i < 6) {
            header[i] = this.transport.readByte();
            ++i;
        }
        USB_Packet pkt = USB_Packet.bytes2Packet(header, null);
        byte[] data = new byte[pkt.packetSize];
        i = 0;
        while (i < pkt.packetSize) {
            data[i] = this.transport.readByte();
            ++i;
        }
        pkt.data = data;
        GenericPacket gPkt = new GenericPacket(pkt.data, 0, 0);
        if (this.debugMode) {
            System.out.println("[USB] < ---------------------------------------------------------------------");
            System.out.println(UnsignedByte.toString(gPkt.data, gPkt.data.length));
        }
        return gPkt;
    }

    public void transmitPacket(byte[] data, byte srcSocket, byte destSocket) throws NotConnectedException, PADP_PacketTooBigException {
        if (!this.connected) {
            throw new NotConnectedException();
        }
        byte by = this.transactionID;
        this.transactionID = (byte)(by + 1);
        USB_Packet pkt = new USB_Packet(1, by, data);
        byte[] pktData = pkt.packet2Bytes();
        this.transport.writeBytes(pktData);
        if (this.debugMode) {
            System.out.println("[USB] > ---------------------------------------------------------------------");
            System.out.println(UnsignedByte.toString(pktData, pktData.length));
        }
    }

    public void disconnect() {
        try {
            if (this.connected) {
                this.transport.close();
            }
            this.connected = false;
        }
        catch (TransportException e) {
            System.err.println(e);
        }
    }

    public void suspendConnection() {
        if (!this.connected) {
            return;
        }
        this.transactionID = 0;
        this.disconnect();
        this.connect();
    }
}

