/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol;

import java.io.Serializable;
import org.jSyncManager.API.Protocol.GenericPacket;
import org.jSyncManager.API.Tools.UnsignedByte;

public class SLP_Packet
implements Serializable {
    public static final byte SYSTEM_PACKET = 0;
    public static final byte CMP_PACKET = 1;
    public static final byte PAD_PACKET = 2;
    public static final byte TEST_PACKET = 3;
    public static final byte[] PREAMBLE = new byte[]{-66, -17, -19};
    public byte destinationSocket;
    public byte sourceSocket;
    public byte packetType;
    public char bodySize;
    public byte transactionID;
    public byte checksum;
    public byte[] data;
    public char CRC;

    char calcCRC() {
        byte[] abyte0 = this.packet2Bytes(false);
        int i = 0;
        int k = abyte0.length;
        int l = 0;
        while (--k >= 0) {
            i ^= abyte0[l++] << 8;
            int j = 0;
            while (j < 8) {
                i = (i & 0x8000) != 0 ? i << 1 ^ 0x1021 : (i <<= 1);
                ++j;
            }
        }
        return (char)(i & 0xFFFF);
    }

    byte calcHeaderChecksum() {
        int i = 0;
        int j = 0;
        while (j < 3) {
            i += UnsignedByte.intValue(PREAMBLE[j]);
            ++j;
        }
        i += UnsignedByte.intValue(this.destinationSocket) + UnsignedByte.intValue(this.sourceSocket) + UnsignedByte.intValue(this.packetType) + UnsignedByte.intValue(this.transactionID);
        return (byte)((i += UnsignedByte.intValue((byte)(this.bodySize / 256)) + UnsignedByte.intValue((byte)(this.bodySize % 256))) % 256);
    }

    boolean checkCRC() {
        return this.calcCRC() == this.CRC;
    }

    boolean checkHeaderChecksum() {
        return this.checksum == this.calcHeaderChecksum();
    }

    GenericPacket getGenericPacket() {
        return new GenericPacket(this.data, this.sourceSocket, this.destinationSocket, this.transactionID);
    }

    byte[] packet2Bytes(boolean flag) {
        int i = 0;
        i = flag ? this.data.length + 12 : this.data.length + 10;
        byte[] pkt = new byte[i];
        int j = 0;
        while (j < 3) {
            pkt[j] = PREAMBLE[j];
            ++j;
        }
        pkt[j++] = this.destinationSocket;
        pkt[j++] = this.sourceSocket;
        pkt[j++] = this.packetType;
        pkt[j++] = (byte)(this.bodySize / 256);
        pkt[j++] = (byte)(this.bodySize & 0xFF);
        pkt[j++] = this.transactionID;
        pkt[j++] = this.checksum;
        System.arraycopy(this.data, 0, pkt, j, this.data.length);
        j += this.data.length;
        if (flag) {
            pkt[j++] = (byte)(this.CRC / 256);
            pkt[j++] = (byte)(this.CRC % 256);
        }
        return pkt;
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("");
        stringbuffer.append("SLP Packet - Begin: ----------------------------\n");
        stringbuffer.append("  SLP-PREAMBLE\n");
        stringbuffer.append("  Destination Socket: " + this.destinationSocket);
        stringbuffer.append("\n  Source Socket:      " + this.sourceSocket);
        stringbuffer.append("\n  Packet Type:        ");
        switch (this.packetType) {
            case 0: {
                stringbuffer.append("System Packet");
                break;
            }
            case 1: {
                stringbuffer.append("CMP Packet (Depricated!!!)");
                break;
            }
            case 2: {
                stringbuffer.append("PAD Packet");
                break;
            }
            case 3: {
                stringbuffer.append("Test Packet");
                break;
            }
            default: {
                stringbuffer.append("Error -- unknown packet type " + this.packetType);
            }
        }
        stringbuffer.append("\n  Body Size:          " + this.bodySize);
        stringbuffer.append("\n  Transaction ID:     " + UnsignedByte.intValue(this.transactionID));
        stringbuffer.append("\n  Checksum:           " + UnsignedByte.intValue(this.checksum));
        stringbuffer.append("\n  CRC Value:          " + this.CRC);
        stringbuffer.append("\n  Data: \n    ");
        int i = 1;
        while (i <= this.data.length) {
            stringbuffer.append(UnsignedByte.toString(this.data[i - 1]) + "  ");
            if (i % 8 == 0) {
                stringbuffer.append("\n    ");
            }
            ++i;
        }
        stringbuffer.append("\n");
        stringbuffer.append("SLP Packet - End:   ----------------------------\n\n");
        return stringbuffer.toString();
    }
}

