/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol;

import java.io.PrintStream;
import org.jSyncManager.API.Protocol.GenericPacket;
import org.jSyncManager.API.Protocol.NotConnectedException;
import org.jSyncManager.API.Protocol.SLP_Packet;
import org.jSyncManager.API.Protocol.SLP_QueueOverrunException;
import org.jSyncManager.API.Tools.UnsignedByte;
import org.jSyncManager.API.Transport.SLPTransportInterface;
import org.jSyncManager.API.Transport.TransportException;
import org.jSyncManager.Transport.DebugTransport;

public class SLP {
    public static final byte DEBUG_SOCKET = 0;
    public static final byte CONSOLE_SOCKET = 1;
    public static final byte REMOTE_UI_SOCKET = 2;
    public static final byte DLP_SOCKET = 3;
    public static final byte FIRST_SOCKET = 4;
    public static byte NEXT_SOCKET = (byte)4;
    public static boolean ENABLE_PKT_DUMP = false;
    private final int queueLength = 4;
    private SLPTransportInterface transport;
    private volatile boolean connected = false;
    private boolean debugMode = false;
    private SLP_Packet[] outputQueue;
    private SLP_Packet[] inputQueue;
    private int outputQueueStart = 0;
    private int outputQueueEnd = 0;
    private int inputQueueStart = 0;
    private int inputQueueEnd = 0;
    private OutputHandler outputThread;
    private InputHandler inputThread;
    private PrintStream out = System.out;

    public SLP(SLPTransportInterface slptransportinterface) {
        this.outputQueue = new SLP_Packet[4];
        this.inputQueue = new SLP_Packet[4];
        this.outputThread = new OutputHandler();
        this.inputThread = new InputHandler();
        if (System.getProperty("jsyncman.slptransportdebug") != null && System.getProperty("jsyncman.slptransportdebug").toLowerCase().equals("true")) {
            try {
                this.transport = new DebugTransport(slptransportinterface);
            }
            catch (Throwable e) {
                System.err.println("[SLP] - Unable to initialize the DebugTransport.  Bypassing...");
                this.transport = slptransportinterface;
            }
        } else {
            this.transport = slptransportinterface;
        }
        this.inputThread.setDaemon(true);
        this.outputThread.setDaemon(true);
        this.inputThread.setPriority(7);
        this.outputThread.setPriority(7);
        if (System.getProperty("jsyncman.slpdebug") != null) {
            ENABLE_PKT_DUMP = System.getProperty("jsyncman.slpdebug").toLowerCase().equals("true");
        }
        if (ENABLE_PKT_DUMP) {
            this.enableDebugMode();
        }
    }

    public synchronized void connect() {
        try {
            this.outputQueueStart = 0;
            this.outputQueueEnd = 0;
            this.inputQueueStart = 0;
            this.inputQueueEnd = 0;
            this.transport.open();
            this.connected = true;
        }
        catch (TransportException ex) {
            this.out.println("[SLP]  - Unable to open connection to the transport interface!\n" + ex.toString());
            this.out.println("[SLP]  - Aborting SLP read thread...");
            return;
        }
        this.outputThread.start();
        this.inputThread.start();
    }

    public synchronized void disconnect() {
        if (!this.connected) {
            return;
        }
        if (this.debugMode) {
            this.out.println("[SLP]  - SLP received disconnect command...");
        }
        this.connected = false;
        int i = 0;
        while (i < 4) {
            this.outputQueue[i] = null;
            this.inputQueue[i] = null;
            ++i;
        }
        try {
            OutputHandler outputHandler = this.outputThread;
            synchronized (outputHandler) {
                if (this.debugMode) {
                    this.out.println("[SLP]  - Stopping output thread...");
                }
                this.outputThread.interrupt();
            }
            InputHandler inputHandler = this.inputThread;
            synchronized (inputHandler) {
                if (this.debugMode) {
                    this.out.println("[SLP]  - Stopping input thread...");
                }
                this.inputThread.interrupt();
            }
            if (this.debugMode) {
                this.out.println("[SLP]  - All threads stopped...closing transport...");
            }
            this.transport.close();
            if (this.debugMode) {
                this.out.println("[SLP]  - Stop complete.");
            }
        }
        catch (Exception exception) {
            this.out.println("*** Unable to close the connection to the transport: " + exception.toString());
        }
    }

    public synchronized void enableDebugMode() {
        this.out.println("[SLP]  > SLP Debugging Mode enabled.  Build 2002-10-31-0536");
        this.debugMode = true;
    }

    protected void handleCMPPacket(SLP_Packet slp_packet) {
        if (this.debugMode) {
            this.out.println("[SLP]  > Received CMP packet...");
            this.out.println("*** CMP_PACKET type received by SLP Protocol Manager Class.");
            this.out.println("*** This packet type is no longer valid.  Please upgrade your");
            this.out.println("*** PalmPilot to the latest ROM revision to avoid this error.");
        }
    }

    protected synchronized void handlePADPacket(SLP_Packet slp_packet) {
        if (this.debugMode) {
            this.out.println("[SLP]  > Received PAD Packet...");
        }
        if (slp_packet.packetType != 2) {
            return;
        }
        try {
            if (this.debugMode) {
                this.out.println("[SLP]  > Putting packet in queue pos: " + this.inputQueueEnd);
            }
            this.inputQueue[this.incInputQueueEnd()] = slp_packet;
            if (this.debugMode) {
                this.out.println("[SLP]  > Notifing threads waiting on input...");
            }
            this.notifyAll();
        }
        catch (SLP_QueueOverrunException ex) {
            if (this.debugMode) {
                this.out.println("[SLP]  > SLP Input Queue Overrun!");
            }
            this.disconnect();
        }
    }

    protected void handleSystemPacket(SLP_Packet slp_packet) {
        if (this.debugMode) {
            this.out.println("[SLP]  > Received System Packet...");
        }
        if (slp_packet.packetType != 0) {
            return;
        }
    }

    protected void handleTestPacket(SLP_Packet slp_packet) {
        if (slp_packet.packetType != 3) {
            return;
        }
    }

    protected int incInputQueueEnd() throws SLP_QueueOverrunException {
        int i = this.inputQueueEnd;
        if ((this.inputQueueEnd + 1) % 4 == this.inputQueueStart) {
            throw new SLP_QueueOverrunException("[SLP]  - Attempt to move Input Queue end pointer over start pointer!");
        }
        this.inputQueueEnd = (this.inputQueueEnd + 1) % 4;
        if (this.debugMode) {
            this.out.println("[SLP]  - Incrementing Input Queue End Ptr from " + i + " to " + this.inputQueueEnd);
        }
        return i;
    }

    protected int incInputQueueStart() throws SLP_QueueOverrunException {
        int i = this.inputQueueStart;
        if (this.inputQueueStart == this.inputQueueEnd) {
            throw new SLP_QueueOverrunException("Attempt to move start pointer beyond end pointer!");
        }
        this.inputQueueStart = (this.inputQueueStart + 1) % 4;
        if (this.debugMode) {
            this.out.println("[SLP]  - Incrementing Receive Start Ptr from " + i + " to " + this.inputQueueStart);
        }
        return i;
    }

    protected int incOutputQueueEnd() throws SLP_QueueOverrunException {
        int i = this.outputQueueEnd;
        if ((this.outputQueueEnd + 1) % 4 == this.outputQueueStart) {
            throw new SLP_QueueOverrunException("[SLP]  - Attempt to move Output Queue end pointer over start pointer!");
        }
        this.outputQueueEnd = (this.outputQueueEnd + 1) % 4;
        if (this.debugMode) {
            this.out.println("[SLP]  - Incrementing Output Queue End Ptr from " + i + " to " + this.outputQueueEnd);
        }
        return i;
    }

    protected int incOutputQueueStart() throws SLP_QueueOverrunException {
        int i = this.outputQueueStart;
        if (this.outputQueueStart == this.outputQueueEnd) {
            throw new SLP_QueueOverrunException("[SLP]  - Attempt to move Output Queue start pointer beyond end pointer!");
        }
        this.outputQueueStart = (this.outputQueueStart + 1) % 4;
        if (this.debugMode) {
            this.out.println("[SLP]  - Incrementing Output Queue Start Ptr from " + i + " to " + this.outputQueueStart);
        }
        return i;
    }

    public synchronized GenericPacket readPacket() throws NotConnectedException {
        if (!this.connected) {
            throw new NotConnectedException("[SLP]  - No connection.");
        }
        while (true) {
            try {
                return this.inputQueue[this.incInputQueueStart()].getGenericPacket();
            }
            catch (SLP_QueueOverrunException ex) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex2) {
                    throw new NotConnectedException("[SLP]  - No connection.");
                }
            }
        }
    }

    public void setDebugOutputStream(PrintStream printstream) {
        this.out = printstream;
    }

    public synchronized void writePacket(byte[] abyte0, byte byte0, byte byte1, byte byte2) throws NotConnectedException {
        if (!this.connected) {
            throw new NotConnectedException("[SLP]  - Not connected.");
        }
        if (this.debugMode) {
            this.out.println("[SLP]  > Processing packet for transmission...");
        }
        SLP_Packet slp_packet = new SLP_Packet();
        slp_packet.destinationSocket = byte1;
        slp_packet.sourceSocket = byte0;
        slp_packet.packetType = (byte)2;
        slp_packet.bodySize = (char)(abyte0.length & 0xFFFF);
        slp_packet.transactionID = byte2;
        slp_packet.checksum = slp_packet.calcHeaderChecksum();
        slp_packet.data = abyte0;
        slp_packet.CRC = slp_packet.calcCRC();
        try {
            this.outputQueue[this.incOutputQueueEnd()] = slp_packet;
            OutputHandler outputHandler = this.outputThread;
            synchronized (outputHandler) {
                this.outputThread.notify();
            }
        }
        catch (SLP_QueueOverrunException ex) {
            if (this.debugMode) {
                this.out.println("[SLP]  > Unable to send packet - output queue full!");
            }
            this.disconnect();
        }
    }

    class InputHandler
    extends Thread {
        InputHandler() {
        }

        public void run() {
            boolean flag = false;
            boolean flag1 = false;
            boolean flag2 = false;
            boolean flag3 = false;
            boolean flag5 = false;
            boolean flag7 = false;
            boolean flag9 = false;
            while (SLP.this.connected) {
                StringBuffer stringbuffer;
                boolean flag4 = false;
                boolean flag6 = false;
                boolean flag8 = false;
                SLP_Packet slp_packet = new SLP_Packet();
                while (!(flag4 & flag6 & flag8)) {
                    boolean flag10 = false;
                    byte byte0 = SLP.this.transport.readByte();
                    if (byte0 == SLP_Packet.PREAMBLE[0]) {
                        flag4 = true;
                        flag10 = true;
                    }
                    if (byte0 == SLP_Packet.PREAMBLE[1]) {
                        flag10 = true;
                        if (flag4 & !flag6) {
                            flag6 = true;
                        } else {
                            flag4 = false;
                            flag6 = false;
                        }
                    }
                    if (byte0 == SLP_Packet.PREAMBLE[2]) {
                        flag10 = true;
                        if (flag6 & !flag8) {
                            flag8 = true;
                        } else {
                            flag4 = false;
                            flag6 = false;
                            flag8 = false;
                        }
                    }
                    if (flag10) continue;
                    flag4 = false;
                    flag6 = false;
                    flag8 = false;
                }
                if (SLP.this.debugMode) {
                    SLP.this.out.println("[SLP]  < Found valid preamble (Receiving Packet).");
                }
                slp_packet.destinationSocket = SLP.this.transport.readByte();
                slp_packet.sourceSocket = SLP.this.transport.readByte();
                slp_packet.packetType = SLP.this.transport.readByte();
                byte byte1 = SLP.this.transport.readByte();
                byte byte3 = SLP.this.transport.readByte();
                slp_packet.bodySize = (char)(UnsignedByte.intValue(byte1) * 256 + UnsignedByte.intValue(byte3));
                if (SLP.this.debugMode) {
                    SLP.this.out.println("[SLP]  - Header says this packet contains " + slp_packet.bodySize + " bytes of data. (Size bytes: " + byte1 + ", " + byte3 + ")");
                }
                slp_packet.transactionID = SLP.this.transport.readByte();
                slp_packet.checksum = SLP.this.transport.readByte();
                if (!slp_packet.checkHeaderChecksum()) {
                    if (SLP.this.debugMode) {
                        SLP.this.out.println("[SLP]  - Received packet with checksum mismatch error. (Expecting " + slp_packet.calcHeaderChecksum() + ", but got " + slp_packet.checksum + ").");
                    }
                    if (SLP.this.debugMode) {
                        SLP.this.out.println("[SLP]  - Header data follows: ");
                    }
                    if (SLP.this.debugMode) {
                        SLP.this.out.println("[SLP]  - \tPreamble: \t\tBE EF ED");
                    }
                    if (SLP.this.debugMode) {
                        SLP.this.out.println("[SLP]  -\tDestination:\t" + slp_packet.destinationSocket);
                    }
                    if (SLP.this.debugMode) {
                        SLP.this.out.println("[SLP]  -\tSource:\t\t\t" + slp_packet.sourceSocket);
                    }
                    if (SLP.this.debugMode) {
                        SLP.this.out.println("[SLP]  -\tType:\t\t\t" + slp_packet.packetType);
                    }
                    if (SLP.this.debugMode) {
                        SLP.this.out.println("[SLP]  -\tBody Size:\t\t" + slp_packet.bodySize);
                    }
                    if (SLP.this.debugMode) {
                        SLP.this.out.println("[SLP]  -\tTransaction ID:\t" + slp_packet.transactionID);
                    }
                    if (!SLP.this.debugMode) continue;
                    SLP.this.out.println("[SLP]  -\tChecksum:\t\t" + slp_packet.checksum);
                    continue;
                }
                slp_packet.data = new byte[slp_packet.bodySize];
                char c = '\u0000';
                while (c < slp_packet.bodySize) {
                    slp_packet.data[c] = SLP.this.transport.readByte();
                    c = (char)(c + '\u0001');
                }
                byte byte2 = SLP.this.transport.readByte();
                byte byte4 = SLP.this.transport.readByte();
                slp_packet.CRC = (char)(UnsignedByte.intValue(byte2) * 256 + UnsignedByte.intValue(byte4));
                if (!slp_packet.checkCRC()) {
                    if (!SLP.this.debugMode) continue;
                    SLP.this.out.println("[SLP]  < Received packet with CRC mismatch error. (Expecting " + slp_packet.calcCRC() + ", but got " + slp_packet.CRC + ".  Individual bytes: " + UnsignedByte.toString(byte2) + " " + UnsignedByte.toString(byte4) + ").");
                    stringbuffer = new StringBuffer("[SLP] > Packet data containing incorrect CRC as follows: \n");
                    stringbuffer.append(slp_packet.toString());
                    SLP.this.out.println(stringbuffer.toString());
                    continue;
                }
                if (SLP.this.debugMode) {
                    stringbuffer = new StringBuffer("[SLP]  < Received packet: \n");
                    stringbuffer.append(slp_packet.toString());
                    SLP.this.out.println(stringbuffer.toString());
                }
                switch (slp_packet.packetType) {
                    case 0: {
                        SLP.this.handleSystemPacket(slp_packet);
                        break;
                    }
                    case 1: {
                        SLP.this.handleCMPPacket(slp_packet);
                        break;
                    }
                    case 2: {
                        SLP.this.handlePADPacket(slp_packet);
                        break;
                    }
                    case 3: {
                        SLP.this.handleTestPacket(slp_packet);
                    }
                }
            }
        }
    }

    class OutputHandler
    extends Thread {
        OutputHandler() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (SLP.this.connected) {
                try {
                    SLP_Packet nextPktObj = SLP.this.outputQueue[SLP.this.incOutputQueueStart()];
                    byte[] nextPkt = nextPktObj.packet2Bytes(true);
                    if (SLP.this.debugMode) {
                        StringBuffer stringbuffer = new StringBuffer("");
                        stringbuffer.append("[SLP]  > Writing packet: \n");
                        stringbuffer.append(nextPktObj.toString());
                        System.out.println(stringbuffer.toString());
                    }
                    if (Thread.interrupted()) continue;
                    SLP.this.transport.writeBytes(nextPkt);
                    if (!SLP.this.debugMode) continue;
                    SLP.this.out.println("[SLP]  > Output Handler wrote packet containing " + nextPkt.length + " bytes.");
                    continue;
                }
                catch (SLP_QueueOverrunException ex) {
                    block15: {
                        if (SLP.this.debugMode) {
                            SLP.this.out.println("[SLP]  > Output handler suspending...");
                        }
                        OutputHandler outputHandler = this;
                        synchronized (outputHandler) {
                            Object var5_6;
                            try {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException e) {
                                    var5_6 = null;
                                    if (SLP.this.debugMode) {
                                        SLP.this.out.println("[SLP]  > Output Handler resuming...");
                                    }
                                    break block15;
                                }
                                var5_6 = null;
                            }
                            catch (Throwable throwable) {
                                var5_6 = null;
                                if (SLP.this.debugMode) {
                                    SLP.this.out.println("[SLP]  > Output Handler resuming...");
                                }
                                throw throwable;
                            }
                            if (SLP.this.debugMode) {
                                SLP.this.out.println("[SLP]  > Output Handler resuming...");
                            }
                        }
                    }
                    continue;
                }
                break;
            }
            return;
        }
    }
}

