/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol;

import org.jSyncManager.API.Protocol.PacketTimerInterface;

public class PacketTimer
extends Thread {
    private long timeout;
    private PacketTimerInterface timerWatcher;
    private volatile boolean debugMode = false;

    PacketTimer(long time, PacketTimerInterface watcher, boolean flag) {
        this.timeout = time;
        this.timerWatcher = watcher;
        this.setDaemon(true);
        this.debugMode = flag;
        if (flag) {
            System.out.println("[Timer] > Timer " + time + " constructed.");
        }
    }

    public void run() {
        try {
            PacketTimer packetTimer = this;
            synchronized (packetTimer) {
                this.wait(this.timeout);
            }
        }
        catch (InterruptedException ex) {
            if (this.debugMode) {
                System.out.println("[Timer] > Timer ID " + this.timeout + " interrupted.");
            }
            return;
        }
        if (this.debugMode) {
            System.out.println("[Timer] > Timer ID " + this.timeout + " expired.");
        }
        this.timerWatcher.timerExpired(this);
    }
}

