/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol;

import java.io.Serializable;
import org.jSyncManager.API.Tools.UnsignedByte;

public class PADP_Packet
implements Serializable {
    public static final byte DATA = 1;
    public static final byte ACK = 2;
    public static final byte NACK = 3;
    public static final byte TICKLE = 4;
    public static final byte ABORT = 8;
    public static final byte FIRST_FRAGMENT = -128;
    public static final byte LAST_FRAGMENT = 64;
    public static final byte OUT_OF_MEMORY = 32;
    public byte packetType;
    public byte flags;
    public char packetSize;
    public byte[] data;
    public byte destinationSocket;
    public byte sourceSocket;
    public byte transactionID;
    public boolean sent;

    PADP_Packet() {
        this.flags = 0;
        this.sent = false;
    }

    PADP_Packet(byte type, byte flags, byte[] data, byte destSocket, byte srcSocket, byte transID) {
        flags = 0;
        this.sent = false;
        this.packetType = type;
        this.flags = flags;
        this.data = data;
        this.packetSize = data != null ? (char)data.length : (char)'\u0000';
        this.destinationSocket = destSocket;
        this.sourceSocket = srcSocket;
        this.transactionID = transID;
    }

    static PADP_Packet bytes2Packet(byte[] pkt) {
        PADP_Packet padp_packet = new PADP_Packet();
        int i = 0;
        padp_packet.packetType = pkt[i++];
        padp_packet.flags = pkt[i++];
        padp_packet.packetSize = UnsignedByte.unsignedBytes2Char(pkt[i++], pkt[i++]);
        if (pkt.length - 4 == 0) {
            return padp_packet;
        }
        byte[] data = new byte[pkt.length - 4];
        System.arraycopy(pkt, 4, data, 0, pkt.length - 4);
        padp_packet.data = data;
        return padp_packet;
    }

    byte[] packet2Bytes() {
        byte[] pktdata = this.data != null ? new byte[4 + this.data.length] : new byte[]{this.packetType, this.flags, (byte)(this.packetSize / 256), (byte)(this.packetSize & 0xFF)};
        if (this.data != null) {
            System.arraycopy(this.data, 0, pktdata, 4, this.data.length);
        }
        return pktdata;
    }
}

