/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol;

import java.io.Serializable;
import org.jSyncManager.API.Protocol.GenericPacket;
import org.jSyncManager.API.Protocol.PADP_Packet;
import org.jSyncManager.API.Protocol.PADP_PacketTooBigException;

public class PADPFragmentSet
implements Serializable {
    private PADP_Packet[] packets = null;
    private int fragmentPtr = 0;
    private int size = 0;
    private int bytesReceived = 0;

    PADPFragmentSet() {
        this.packets = new PADP_Packet[64];
    }

    PADPFragmentSet(PADP_Packet[] apadp_packet) {
        this.packets = apadp_packet;
        this.size = apadp_packet.length;
    }

    void addFragment(PADP_Packet padp_packet) {
        this.packets[this.size++] = padp_packet;
        this.bytesReceived += padp_packet.data.length;
    }

    int bytesReceived() {
        return this.bytesReceived;
    }

    static PADPFragmentSet fragmentPacket(byte[] abyte0, byte byte0, byte byte1, byte byte2) throws PADP_PacketTooBigException {
        if (abyte0.length > 65535) {
            throw new PADP_PacketTooBigException("[PADP] > Packet for transmission over 64k in length.");
        }
        PADPFragmentSet padpfragmentset = new PADPFragmentSet();
        boolean flag = false;
        int k = abyte0.length;
        int l = 0;
        while (k > 0) {
            PADP_Packet padp_packet = new PADP_Packet();
            int j = k >= 1024 ? 1024 : k;
            padp_packet.data = new byte[j];
            System.arraycopy(abyte0, abyte0.length - k, padp_packet.data, 0, j);
            k -= j;
            padp_packet.packetType = 1;
            padp_packet.packetSize = (char)l;
            padp_packet.sourceSocket = byte0;
            padp_packet.destinationSocket = byte1;
            padp_packet.transactionID = byte2;
            padpfragmentset.addFragment(padp_packet);
            l += j;
        }
        padpfragmentset.getPacket((int)0).flags = (byte)(padpfragmentset.getPacket((int)0).flags | 0x80);
        padpfragmentset.getPacket((int)0).packetSize = (char)abyte0.length;
        padpfragmentset.getPacket((int)(padpfragmentset.getSize() - 1)).flags = (byte)(padpfragmentset.getPacket((int)(padpfragmentset.getSize() - 1)).flags | 0x40);
        return padpfragmentset;
    }

    PADP_Packet getCurrentFragment() {
        if (this.fragmentPtr < this.packets.length) {
            return this.packets[this.fragmentPtr];
        }
        return null;
    }

    PADP_Packet getNextFragment() {
        if (this.fragmentPtr < this.size) {
            return this.packets[this.fragmentPtr++];
        }
        return null;
    }

    PADP_Packet getPacket(int i) {
        return this.packets[i];
    }

    int getSize() {
        return this.size;
    }

    boolean hasMoreFragments() {
        return this.fragmentPtr < this.packets.length;
    }

    GenericPacket rebuildPacket() {
        int k = 0;
        byte[] abyte0 = new byte[this.packets[0].packetSize];
        int i = 0;
        while (i < this.size) {
            System.arraycopy(this.packets[i].data, 0, abyte0, k, this.packets[i].data.length);
            k += this.packets[i].data.length;
            ++i;
        }
        return new GenericPacket(abyte0, this.packets[0].sourceSocket, this.packets[0].destinationSocket);
    }

    void setSize(int i) {
        this.size = i;
    }
}

