/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol;

import java.io.PrintStream;
import org.jSyncManager.API.Protocol.CMPDLPTransferInterface;
import org.jSyncManager.API.Protocol.GenericPacket;
import org.jSyncManager.API.Protocol.NotConnectedException;
import org.jSyncManager.API.Protocol.PADPFragmentSet;
import org.jSyncManager.API.Protocol.PADP_Packet;
import org.jSyncManager.API.Protocol.PADP_PacketTooBigException;
import org.jSyncManager.API.Protocol.PADP_QueueOverrunException;
import org.jSyncManager.API.Protocol.PacketTimer;
import org.jSyncManager.API.Protocol.PacketTimerInterface;
import org.jSyncManager.API.Protocol.SLP;
import org.jSyncManager.API.Tools.UnsignedByte;

public class PADP
extends Thread
implements PacketTimerInterface,
CMPDLPTransferInterface {
    private final int queueLength = 4;
    private SLP slpHandler;
    private volatile PacketTimer ackTimer;
    private volatile PacketTimer interPktTimer;
    private volatile PacketTimer tickleTimer;
    public static long ACK_TIMEOUT = 2000L;
    public static long IP_TIMEOUT = 10000L;
    private volatile int connectState = 0;
    private byte transID = (byte)-1;
    private PADP_Packet lastFragSent = null;
    private volatile PADPFragmentSet outputQueue;
    private volatile PADPFragmentSet inputQueue = new PADPFragmentSet();
    private volatile GenericPacket[] readyPackets = new GenericPacket[4];
    private volatile int readyQueueStart = 0;
    private volatile int readyQueueEnd = 0;
    private final int maxSendRetries = 10;
    private int retries = 0;
    private boolean debugMode = false;
    private PrintStream out = System.out;
    private volatile boolean more = false;
    private volatile boolean tx = false;
    private static final long TICKLE_TIME = 3000L;

    public PADP(SLP slp) {
        this.slpHandler = slp;
        this.setPriority(8);
        this.setDaemon(false);
        if (System.getProperty("jsyncman.padpdebug") != null && System.getProperty("jsyncman.padpdebug").toLowerCase().equals("true")) {
            this.enableDebugMode();
        }
    }

    public void connect() {
        if (this.connectState >= 1) {
            return;
        }
        if (this.debugMode) {
            this.out.println("[PADP] - Connecting to SLP layer.");
        }
        this.inputQueue = new PADPFragmentSet();
        this.readyPackets = new GenericPacket[4];
        this.readyQueueStart = 0;
        this.readyQueueEnd = 0;
        this.slpHandler.connect();
        this.connectState = 1;
        this.start();
    }

    public synchronized void disconnect() {
        this.ackTimer = null;
        this.interPktTimer = null;
        if (this.isAlive()) {
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.debugMode) {
            this.out.println("[PADP] - Disconnecting from SLP layer...");
        }
        this.slpHandler.disconnect();
        --this.connectState;
        this.notifyAll();
    }

    public void enableDebugMode() {
        this.out.println("[PADP] > PADP Debugging Mode enabled.  Build 2002-10-31-0558");
        this.debugMode = true;
    }

    protected void handleAbort(PADP_Packet padp_packet) {
        if (this.debugMode) {
            this.out.println("[PADP] < Received Abort Packet...");
        }
        this.selfDisconnect();
    }

    protected void handleACK(PADP_Packet padp_packet) {
        if (this.debugMode) {
            this.out.println("[PADP] < Received ACK packet...");
        }
        if (this.lastFragSent != null && padp_packet.transactionID == this.lastFragSent.transactionID) {
            if (this.debugMode) {
                this.out.println("[PADP] - Processing ACKnowledgement...");
            }
            if (this.ackTimer != null && this.ackTimer.isAlive()) {
                this.ackTimer.interrupt();
            }
            this.retries = 0;
            this.lastFragSent = null;
            if ((padp_packet.flags & 0x20) == 32) {
                if (this.debugMode) {
                    this.out.println("[PADP] - PalmPilot out of memory error!  Disconnecting...");
                }
                this.disconnect();
            }
        }
        if (this.outputQueue == null) {
            return;
        }
        PADP_Packet padp_packet1 = this.outputQueue.getNextFragment();
        if (padp_packet1 != null) {
            if (this.debugMode) {
                this.out.println("[PADP] - Sending packet with size or offset " + padp_packet1.packetSize);
            }
            try {
                this.sendPacket(padp_packet1);
            }
            catch (NotConnectedException notConnectedException) {}
        } else {
            this.outputQueue = null;
            PADP pADP = this;
            synchronized (pADP) {
                if (this.debugMode) {
                    this.out.println("[PADP] - Notifing waiting send threads...");
                }
                this.notifyAll();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleData(PADP_Packet padp_packet) {
        if (this.debugMode) {
            this.out.println("[PADP] < Received Data Packet...");
        }
        if (this.interPktTimer != null && this.interPktTimer.isAlive()) {
            this.interPktTimer.interrupt();
        }
        this.interPktTimer = new PacketTimer(IP_TIMEOUT, this, this.debugMode);
        this.interPktTimer.start();
        this.sendAck(padp_packet);
        if ((padp_packet.flags & 0xFFFFFF80) == -128) {
            if (this.inputQueue.getSize() != 0) {
                if (!this.debugMode) return;
                this.out.println("[PADP] - Received out-of-order packet.");
                return;
            }
            if (this.debugMode) {
                this.out.println("[PADP] - Adding fragment to start of input queue...");
            }
            this.inputQueue.addFragment(padp_packet);
            if (this.ackTimer != null && this.ackTimer.isAlive()) {
                this.ackTimer.interrupt();
            }
            this.ackTimer = new PacketTimer(2000L, this, this.debugMode);
            this.ackTimer.start();
        } else {
            if (this.inputQueue.bytesReceived() != padp_packet.packetSize) return;
            if (this.debugMode) {
                this.out.println("[PADP] - Adding fragment " + padp_packet.packetSize + " to input queue...");
            }
            this.inputQueue.addFragment(padp_packet);
            if (this.ackTimer != null && this.ackTimer.isAlive()) {
                this.ackTimer.interrupt();
            }
            this.ackTimer = new PacketTimer(2000L, this, this.debugMode);
            this.ackTimer.start();
        }
        if ((padp_packet.flags & 0x40) != 64) return;
        try {
            if (this.debugMode) {
                this.out.println("[PADP] - Rebuilding packet from " + this.inputQueue.getSize() + " fragments...");
            }
            this.readyPackets[this.incReadyQueueEnd()] = this.inputQueue.rebuildPacket();
            this.inputQueue = new PADPFragmentSet();
            PADP pADP = this;
            synchronized (pADP) {
                if (this.debugMode) {
                    this.out.println("[PADP] - Notifing waiting read threads that data is available...(Added to queue position " + (this.readyQueueEnd - 1 == -1 ? 4 : this.readyQueueEnd - 1) + ")");
                }
                this.notifyAll();
                return;
            }
        }
        catch (PADP_QueueOverrunException padp_queueoverrunexception) {
            if (this.debugMode) {
                this.out.println("[PADP] - Queue Overrun while rebuilding packet: " + padp_queueoverrunexception.toString());
            }
            this.disconnect();
        }
    }

    protected void handleNACK(PADP_Packet padp_packet) {
        if (this.debugMode) {
            this.out.println("[PADP] < Received NACK packet...");
        }
    }

    protected void handleTickle(PADP_Packet padp_packet) {
        if (this.debugMode) {
            System.out.println("[PADP] < Received Tickle Packet...");
        }
        if (this.interPktTimer != null && this.interPktTimer.isAlive()) {
            this.interPktTimer.interrupt();
        }
        this.interPktTimer = new PacketTimer(IP_TIMEOUT, this, this.debugMode);
        this.interPktTimer.start();
    }

    protected int incReadyQueueEnd() throws PADP_QueueOverrunException {
        int i = this.readyQueueEnd;
        if ((this.readyQueueEnd + 1) % 4 == this.readyQueueStart) {
            throw new PADP_QueueOverrunException("Attempt to move Ready Queue end pointer over start pointer!");
        }
        this.readyQueueEnd = (this.readyQueueEnd + 1) % 4;
        return i;
    }

    protected int incReadyQueueStart() throws PADP_QueueOverrunException {
        int i = this.readyQueueStart;
        if (this.readyQueueStart == this.readyQueueEnd) {
            throw new PADP_QueueOverrunException("Attempt to move Ready Queue start pointer beyond end pointer!");
        }
        this.readyQueueStart = (this.readyQueueStart + 1) % 4;
        return i;
    }

    protected byte incTransID() {
        if (this.more) {
            return this.transID;
        }
        byte _tmp = this.transID;
        if (this.transID == -2) {
            this.transID = 1;
        }
        this.transID = this.transID == 127 ? (byte)-128 : (this.transID == -1 ? (byte)1 : (byte)(this.transID + 1));
        if (this.debugMode) {
            this.out.println("[PADP] - Transaction ID is now " + UnsignedByte.intValue(this.transID));
        }
        return this.transID;
    }

    public boolean isConnected() {
        return this.connectState > 0;
    }

    protected PADP_Packet parsePADPacket(GenericPacket genericpacket) {
        if (this.debugMode) {
            this.out.println("[PADP] - Parsing incoming PAD Packet...");
        }
        PADP_Packet padp_packet = PADP_Packet.bytes2Packet(genericpacket.data);
        padp_packet.sourceSocket = genericpacket.source;
        padp_packet.destinationSocket = genericpacket.destination;
        padp_packet.transactionID = genericpacket.transactionID;
        return padp_packet;
    }

    protected synchronized void processPacket(PADP_Packet padp_packet) {
        if (padp_packet.packetType == 2) {
            this.handleACK(padp_packet);
            return;
        }
        if (padp_packet.packetType == 4) {
            this.handleTickle(padp_packet);
            return;
        }
        if (padp_packet.packetType == 8) {
            this.handleAbort(padp_packet);
            return;
        }
        if (padp_packet.packetType == 3) {
            this.handleNACK(padp_packet);
            return;
        }
        if (padp_packet.packetType == 1) {
            this.handleData(padp_packet);
            return;
        }
    }

    public synchronized GenericPacket readPacket() throws NotConnectedException {
        GenericPacket genericpacket;
        block9: {
            if (this.connectState < 1) {
                throw new NotConnectedException("[PADP] - Not connected.");
            }
            if (this.connectState > 1) {
                this.interPktTimer = new PacketTimer(IP_TIMEOUT, this, this.debugMode);
                this.interPktTimer.start();
            }
            if (this.readyQueueStart == this.readyQueueEnd) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    if (!this.debugMode) break block9;
                    this.out.println("[PADP] - Read Packet wait interrupted!");
                }
            }
        }
        if (this.connectState < 2) {
            throw new NotConnectedException("[PADP] - Connection was lost.");
        }
        try {
            genericpacket = this.readyPackets[this.incReadyQueueStart()];
        }
        catch (PADP_QueueOverrunException ex) {
            if (this.debugMode) {
                this.out.println("[PADP] - Queue overrun reading from the Ready Packet queue. (Queue pointer: " + this.readyQueueStart + ")");
            }
            genericpacket = null;
        }
        return genericpacket;
    }

    public void run() {
        if (this.debugMode) {
            this.out.println("[PADP] - Incoming packet thread started...");
        }
        while (this.connectState > 0) {
            GenericPacket genericpacket;
            if (this.lastFragSent != null & !this.tx) {
                if (this.debugMode) {
                    this.out.println("[PADP] - Starting IPT thread. (State: " + this.interPktTimer.isAlive() + ")");
                }
                if (this.interPktTimer == null) {
                    this.interPktTimer = new PacketTimer(IP_TIMEOUT, this, this.debugMode);
                }
                if (!this.interPktTimer.isAlive()) {
                    this.interPktTimer.start();
                } else {
                    this.interPktTimer.interrupt();
                    this.interPktTimer = new PacketTimer(IP_TIMEOUT, this, this.debugMode);
                    this.interPktTimer.start();
                }
            }
            try {
                if (this.debugMode) {
                    this.out.println("[PADP] - Waiting to get next fragment from SLP layer...");
                }
                genericpacket = this.slpHandler.readPacket();
            }
            catch (NotConnectedException ex) {
                if (this.debugMode) {
                    this.out.println("[PADP] - SLP layer lost connection.  Terminating read thread...");
                }
                return;
            }
            if (this.debugMode) {
                this.out.println("[PADP] < Incoming Packet received from SLP with Transaction ID " + UnsignedByte.intValue(genericpacket.transactionID) + ":");
            }
            this.connectState = 2;
            if (genericpacket.transactionID != this.transID) {
                if (!this.debugMode) continue;
                this.out.println("[PADP] < Received packet with transaction ID " + UnsignedByte.intValue(genericpacket.transactionID) + " while waiting for packet with transaction ID " + UnsignedByte.intValue(this.transID) + ".  Discarding packet...");
                continue;
            }
            PADP_Packet padp_packet = this.parsePADPacket(genericpacket);
            if (this.debugMode) {
                this.out.println("[PADP] - Received packet contains " + genericpacket.data.length + " bytes of data.");
            }
            if (this.debugMode) {
                this.out.println("[PADP] - Received packet size value: " + padp_packet.packetSize + " bytes of data.");
            }
            boolean bl = this.more = !((padp_packet.flags & 0x40) == 64 | padp_packet.packetType == 2);
            if (this.debugMode) {
                this.out.println("[PADP] - Setting more to " + this.more + ".");
            }
            this.processPacket(padp_packet);
        }
        if (this.debugMode) {
            this.out.println("[PADP] - PADP Read Thread ending...");
        }
    }

    protected synchronized void selfDisconnect() {
        if (this.connectState < 1) {
            return;
        }
        if (this.ackTimer != null && this.ackTimer.isAlive()) {
            this.ackTimer.interrupt();
        }
        if (this.interPktTimer != null && this.interPktTimer.isAlive()) {
            this.interPktTimer.interrupt();
        }
        if (this.debugMode) {
            this.out.println("[PADP] - Disconnecting from SLP layer...");
        }
        this.slpHandler.disconnect();
        this.suspendConnection();
        this.notifyAll();
    }

    protected void sendAck(PADP_Packet padp_packet) {
        block3: {
            if (this.debugMode) {
                this.out.println("[PADP] > Sending ACKnowledgement...");
            }
            PADP_Packet padp_packet1 = new PADP_Packet();
            padp_packet1.packetType = (byte)2;
            padp_packet1.flags = padp_packet.flags;
            padp_packet1.packetSize = padp_packet.packetSize;
            padp_packet1.sourceSocket = padp_packet.destinationSocket;
            padp_packet1.destinationSocket = padp_packet.sourceSocket;
            padp_packet1.transactionID = padp_packet.transactionID;
            this.incTransID();
            try {
                this.slpHandler.writePacket(padp_packet1.packet2Bytes(), padp_packet1.sourceSocket, padp_packet1.destinationSocket, padp_packet1.transactionID);
            }
            catch (NotConnectedException ex) {
                if (!this.debugMode) break block3;
                this.out.println("[PADP] > ACK not sent due to not connected exception.");
            }
        }
    }

    protected void sendPacket(PADP_Packet padp_packet) throws NotConnectedException {
        block14: {
            if (padp_packet == null) {
                return;
            }
            if (this.debugMode) {
                this.out.println("[PADP] > Sending packet with transaction ID: " + (padp_packet.transactionID < 0 ? padp_packet.transactionID + 256 : padp_packet.transactionID));
            }
            this.lastFragSent = padp_packet;
            try {
                this.slpHandler.writePacket(padp_packet.packet2Bytes(), padp_packet.sourceSocket, padp_packet.destinationSocket, padp_packet.transactionID);
            }
            catch (NotConnectedException ex) {
                if (this.debugMode) {
                    this.out.println("[PADP] - Connection to SLP layer lost.");
                }
                throw ex;
            }
            padp_packet.sent = true;
            this.tx = true;
            this.interPktTimer.interrupt();
            if (this.ackTimer.isAlive()) {
                if (this.debugMode) {
                    this.out.println("[PADP] - Resetting ACK timer...(sendPacket)");
                }
                try {
                    if (this.ackTimer != null && this.ackTimer.isAlive()) {
                        this.ackTimer.interrupt();
                    }
                    this.ackTimer = new PacketTimer(2000L, this, this.debugMode);
                    this.ackTimer.start();
                }
                catch (IllegalThreadStateException ex) {
                    if (this.debugMode) {
                        this.out.println("[PADP] - sendPacket method encountered an exception while starting/resetting ACK timer.");
                    }
                    break block14;
                }
            }
            if (this.debugMode) {
                this.out.println("[PADP] - Starting ACK timer...(sendPacket)");
            }
            try {
                this.ackTimer = new PacketTimer(2000L, this, this.debugMode);
                this.ackTimer.start();
            }
            catch (IllegalThreadStateException ex) {
                if (!this.debugMode) break block14;
                this.out.println("[PADP] - sendPacket method encountered an exception while starting/resetting ACK timer.");
            }
        }
        this.tx = false;
    }

    protected void sendTickle() {
        block3: {
            PADP_Packet padp_packet = new PADP_Packet(4, -64, null, 3, 3, this.incTransID());
            if (this.debugMode) {
                this.out.println("[PADP] > Sending Tickle...");
            }
            try {
                this.slpHandler.writePacket(padp_packet.packet2Bytes(), padp_packet.sourceSocket, padp_packet.destinationSocket, padp_packet.transactionID);
            }
            catch (NotConnectedException ex) {
                if (!this.debugMode) break block3;
                this.out.println("[PADP] - Tickle not sent due to not connected exception.");
            }
        }
    }

    public void setDebugOutputStream(PrintStream printstream) {
        this.out = printstream;
    }

    public synchronized void startTickles() {
        if (this.debugMode) {
            this.out.println("[PADP] - Enabling Tickles...");
        }
        this.tickleTimer = new PacketTimer(3000L, this, false);
        this.tickleTimer.start();
        if (this.interPktTimer != null) {
            this.interPktTimer.interrupt();
            this.interPktTimer = null;
        }
    }

    public synchronized void stopTickles() {
        if (this.debugMode) {
            this.out.println("[PADP] - Disabling Tickles...");
        }
        if (this.tickleTimer != null) {
            if (this.tickleTimer.isAlive()) {
                this.tickleTimer.interrupt();
            }
            this.tickleTimer = null;
        }
        if (this.interPktTimer == null) {
            this.interPktTimer = new PacketTimer(IP_TIMEOUT, this, false);
            this.interPktTimer.start();
        }
    }

    public synchronized void suspendConnection() {
        this.connectState = 1;
        this.transID = (byte)-1;
        this.ackTimer = null;
        this.interPktTimer = null;
        this.notifyAll();
    }

    public synchronized void timerExpired(PacketTimer packettimer) {
        if (this.ackTimer != null && packettimer == this.ackTimer) {
            if (this.debugMode) {
                this.out.println("[PADP] - ACK Timer timed-out.  Retries=" + (this.retries + 1));
            }
            if (this.retries == 10) {
                this.suspendConnection();
            } else {
                ++this.retries;
                if (this.debugMode) {
                    this.out.println("[PADP] - Resending last packet...");
                }
                if (this.lastFragSent == null) {
                    if (this.debugMode) {
                        this.out.println("[PADP] - Warning - variable \"lastFragSent\" is null!");
                    }
                    return;
                }
                try {
                    this.sendPacket(this.lastFragSent);
                }
                catch (NotConnectedException ex) {
                    return;
                }
            }
        }
        if (this.interPktTimer != null && packettimer == this.interPktTimer) {
            if (this.debugMode) {
                this.out.println("[PADP] - Inter-packet timer timed out.  Suspending...");
            }
            this.suspendConnection();
        }
        if (this.tickleTimer != null && packettimer == this.tickleTimer) {
            this.sendTickle();
            this.tickleTimer = new PacketTimer(3000L, this, false);
            this.tickleTimer.start();
        }
    }

    public synchronized void transmitPacket(GenericPacket pkt) throws NotConnectedException, PADP_PacketTooBigException {
        this.transmitPacket(pkt.data, pkt.source, pkt.destination, false);
    }

    public synchronized void transmitPacket(byte[] data, byte hostSocket, byte serverSocket) throws NotConnectedException, PADP_PacketTooBigException {
        this.transmitPacket(data, hostSocket, serverSocket, false);
    }

    protected synchronized void transmitPacket(byte[] data, byte hostSocket, byte serverSocket, boolean flag) throws NotConnectedException, PADP_PacketTooBigException {
        block16: {
            int byte2;
            if (this.connectState < 1) {
                throw new NotConnectedException("[PADP] - Connection was lost.");
            }
            if (this.tickleTimer != null) {
                this.tickleTimer.interrupt();
                this.tickleTimer = null;
            }
            int n = byte2 = flag ? -1 : (int)this.incTransID();
            if (this.debugMode) {
                this.out.println("[PADP] - transmitPacket called to transmit packet of length " + data.length + " with TID#" + (byte2 < 0 ? byte2 + 256 : byte2) + ".");
            }
            try {
                this.outputQueue = PADPFragmentSet.fragmentPacket(data, hostSocket, serverSocket, (byte)byte2);
                if (this.debugMode) {
                    this.out.println("[PADP] - Fragmented packet into " + this.outputQueue.getSize() + " fragments.");
                }
            }
            catch (Exception exception) {
                if (this.debugMode) {
                    this.out.println("[PADP] - Exception encountered while fragmenting packet: " + exception.toString());
                }
                return;
            }
            try {
                this.sendPacket(this.outputQueue.getNextFragment());
                if (this.debugMode) {
                    this.out.println("[PADP] > Packet sent.");
                }
            }
            catch (Exception exception1) {
                if (this.debugMode) {
                    this.out.println("[PADP] > Exception encountered while transmitting fragment: " + exception1.toString());
                }
                return;
            }
            try {
                if (this.debugMode) {
                    this.out.println("[PADP] > Waiting for packet send to complete...");
                }
                this.wait();
            }
            catch (Exception exception2) {
                if (!this.debugMode) break block16;
                this.out.println("[PADP] - Exception encountered while waiting for transmit to complete: " + exception2.toString());
            }
        }
        if (this.debugMode) {
            this.out.println("[PADP] - transmitPacket() awakened.");
        }
        if (this.connectState < 2) {
            throw new NotConnectedException("[PADP] - Connection was lost.");
        }
    }
}

