/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import org.jSyncManager.API.Protocol.CMP_DLP;
import org.jSyncManager.API.Protocol.CMP_Packet;
import org.jSyncManager.API.Protocol.DLPError;
import org.jSyncManager.API.Protocol.DLP_Packet;
import org.jSyncManager.API.Protocol.GenericPacket;
import org.jSyncManager.API.Protocol.NotConnectedException;

public class NetCMP_DLP_Server
extends CMP_DLP {
    Socket socket = null;
    private ObjectOutputStream oos = null;
    private ObjectInputStream ois = null;

    public NetCMP_DLP_Server(Socket skt) throws IOException {
        this.socket = skt;
        this.oos = new ObjectOutputStream(skt.getOutputStream());
        this.ois = new ObjectInputStream(skt.getInputStream());
    }

    public void connect() throws NotConnectedException {
        byte speedFlag = 0;
        try {
            GenericPacket pkt = (GenericPacket)this.ois.readObject();
            if (this.determinePacketType(pkt)) {
                return;
            }
            if (this.speed != 9600) {
                speedFlag = -128;
            }
            pkt = new GenericPacket(new CMP_Packet(2, speedFlag, 0, 0, this.speed).packet2Bytes(), 3, 3);
            this.oos.writeObject(pkt);
        }
        catch (Exception e) {
            throw new NotConnectedException(e.toString());
        }
        this.connected = true;
    }

    public void disconnect(char c) {
        super.disconnect(c);
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public DLP_Packet getDLPPacket(DLP_Packet pkt) throws NotConnectedException, DLPError {
        GenericPacket tmpPkt;
        if (!this.connected) {
            throw new NotConnectedException("Not connected.");
        }
        try {
            tmpPkt = new GenericPacket(pkt.packet2Bytes(), pkt.hostSocket, pkt.serverSocket);
            this.oos.writeObject(tmpPkt);
        }
        catch (IOException ex) {
            throw new NotConnectedException();
        }
        try {
            tmpPkt = (GenericPacket)this.ois.readObject();
        }
        catch (Exception e) {
            throw new NotConnectedException(e.toString());
        }
        if (tmpPkt == null) {
            throw new NotConnectedException();
        }
        if (tmpPkt.data == null) {
            throw new NotConnectedException();
        }
        if (tmpPkt.data[0] < 16 & tmpPkt.data[0] >= 0) {
            return null;
        }
        DLP_Packet dlpPkt = DLP_Packet.bytes2Packet(tmpPkt.data);
        if (dlpPkt.getErrorCode() != '\u0000') {
            throw new DLPError(dlpPkt);
        }
        return dlpPkt;
    }

    public void suspend() throws NotConnectedException {
        this.disconnect('\u0000');
    }
}

