/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.jSyncManager.API.Protocol.CMP_DLP;
import org.jSyncManager.API.Protocol.GenericPacket;
import org.jSyncManager.API.Protocol.NotConnectedException;
import org.jSyncManager.API.Protocol.PADP;

public class NetCMP_DLP_Client
extends CMP_DLP {
    private Socket socket;
    public InetAddress remoteAddress;
    public static final int REMOTE_PORT = 27123;
    private ObjectOutputStream oos = null;
    private ObjectInputStream ois = null;
    private SendThread sendThread = new SendThread();
    private ReceiveThread receiveThread = new ReceiveThread();

    public NetCMP_DLP_Client(PADP padp, InetAddress serverAddress) {
        super(padp);
        this.remoteAddress = serverAddress;
        PADP.ACK_TIMEOUT = 10000L;
        PADP.IP_TIMEOUT = 60000L;
    }

    public void connect() throws NotConnectedException {
        super.connect();
        try {
            this.socket = new Socket(this.remoteAddress, 27123);
            this.oos = new ObjectOutputStream(this.socket.getOutputStream());
            this.ois = new ObjectInputStream(this.socket.getInputStream());
            this.sendThread.start();
            this.receiveThread.start();
        }
        catch (Exception e) {
            throw new NotConnectedException(e.toString());
        }
    }

    public void disconnect(char reasonCode) {
        super.disconnect(reasonCode);
        try {
            this.oos.close();
            this.ois.close();
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class ReceiveThread
    extends Thread {
        ReceiveThread() {
        }

        public void run() {
            while (true) {
                try {
                    GenericPacket pkt = (GenericPacket)NetCMP_DLP_Client.this.ois.readObject();
                    NetCMP_DLP_Client.this.padpHandler.transmitPacket(pkt.data, pkt.source, pkt.destination);
                }
                catch (Exception e) {
                    NetCMP_DLP_Client.this.connected = false;
                    return;
                }
            }
        }
    }

    class SendThread
    extends Thread {
        SendThread() {
        }

        public void run() {
            while (true) {
                try {
                    GenericPacket pkt = NetCMP_DLP_Client.this.padpHandler.readPacket();
                    NetCMP_DLP_Client.this.oos.writeObject(pkt);
                }
                catch (Exception e1) {
                    NetCMP_DLP_Client.this.connected = false;
                    return;
                }
            }
        }
    }
}

