/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol;

import java.util.Calendar;
import org.jSyncManager.API.Protocol.CMP_DLP;
import org.jSyncManager.API.Protocol.DLPError;
import org.jSyncManager.API.Protocol.DLPFunctionCallException;
import org.jSyncManager.API.Protocol.DLP_Packet;
import org.jSyncManager.API.Protocol.NotConnectedException;
import org.jSyncManager.API.Protocol.PADP;
import org.jSyncManager.API.Protocol.SLP;
import org.jSyncManager.API.Protocol.USB;
import org.jSyncManager.API.Protocol.Util.DLPAppPreference;
import org.jSyncManager.API.Protocol.Util.DLPBlock;
import org.jSyncManager.API.Protocol.Util.DLPDatabaseListGroup;
import org.jSyncManager.API.Protocol.Util.DLPRecord;
import org.jSyncManager.API.Protocol.Util.DLPResource;
import org.jSyncManager.API.Protocol.Util.DLPStorageInfo;
import org.jSyncManager.API.Protocol.Util.DLPSystemInfo;
import org.jSyncManager.API.Protocol.Util.DLPUserInfo;
import org.jSyncManager.API.Protocol.Util.DLPVersion;
import org.jSyncManager.API.Protocol.Util.DLP_Date;
import org.jSyncManager.API.Protocol.Util.InvalidDLPDateException;
import org.jSyncManager.API.Tools.UnsignedByte;
import org.jSyncManager.API.Transport.SLPTransportInterface;
import org.jSyncManager.API.Transport.SerialTransportInterface;
import org.jSyncManager.API.Transport.TransportException;
import org.jSyncManager.API.Transport.USBTransportInterface;

public class JHotSync {
    SLP slpHandler = null;
    PADP padpHandler = null;
    CMP_DLP cmpDlpHandler = null;
    SLPTransportInterface transport = null;
    static final DLPVersion DLP_VERSION = new DLPVersion(1, 3);
    USB usbHandler = null;

    public JHotSync(CMP_DLP cmp_dlp) {
        this.cmpDlpHandler = cmp_dlp;
    }

    public JHotSync(SLPTransportInterface slptransportinterface) {
        this.transport = slptransportinterface;
        if (slptransportinterface instanceof SerialTransportInterface) {
            this.slpHandler = new SLP(slptransportinterface);
            this.slpHandler.setDebugOutputStream(System.out);
            this.padpHandler = new PADP(this.slpHandler);
            this.cmpDlpHandler = new CMP_DLP(this.padpHandler);
        }
        if (slptransportinterface instanceof USBTransportInterface) {
            this.usbHandler = new USB((USBTransportInterface)slptransportinterface);
            this.cmpDlpHandler = new CMP_DLP(this.usbHandler);
        }
    }

    public void addSyncLogEntry(String s) throws DLPFunctionCallException, NotConnectedException {
        byte[] abyte0 = s.getBytes();
        byte[][] abyte1 = new byte[1][abyte0.length + 1];
        int i = 0;
        i = 0;
        while (i < abyte0.length) {
            abyte1[0][i] = abyte0[i];
            ++i;
        }
        abyte1[0][i] = 0;
        DLP_Packet dlp_packet = new DLP_Packet(42, abyte1);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.cleanupDatabase()", dlperror.getErrorCode());
        }
    }

    public void cleanupDatabase(byte byte0) throws DLPFunctionCallException, NotConnectedException {
        byte[][] abyte0 = new byte[1][1];
        abyte0[0][0] = byte0;
        DLP_Packet dlp_packet = new DLP_Packet(38, abyte0);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.cleanupDatabase()", dlperror.getErrorCode());
        }
    }

    public void closeAllDatabases() throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet dlp_packet = new DLP_Packet(25, null, 33);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.closeAllDatabases()", dlperror.getErrorCode());
        }
    }

    public void closeDatabase(byte byte0) throws DLPFunctionCallException, NotConnectedException {
        byte[][] abyte0 = new byte[1][1];
        abyte0[0][0] = byte0;
        DLP_Packet dlp_packet = new DLP_Packet(25, abyte0);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.closeDatabase()", dlperror.getErrorCode());
        }
    }

    public void connect() throws NotConnectedException {
        try {
            this.transport.flush();
        }
        catch (TransportException ex) {
            throw new NotConnectedException("Unable to flush serial buffer.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.cmpDlpHandler.connect();
        try {
            if (this.transport instanceof SerialTransportInterface) {
                ((SerialTransportInterface)this.transport).setSpeed(this.getSpeed());
            }
        }
        catch (TransportException exception) {
            throw new NotConnectedException("Unable to change speed to " + this.getSpeed() + " because:\n" + exception.toString());
        }
    }

    public byte createDatabase(byte byte0, int i, int j, String s, char c, char c1) throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet dlp_packet1 = null;
        byte[][] abyte1 = new byte[1][15 + s.length()];
        int k = 0;
        abyte1[0][k++] = (byte)((i & 0xFF000000) / 0x1000000);
        abyte1[0][k++] = (byte)((i & 0xFF0000) / 65536);
        abyte1[0][k++] = (byte)((i & 0xFF00) / 256);
        abyte1[0][k++] = (byte)(i & 0xFF);
        abyte1[0][k++] = (byte)((j & 0xFF000000) / 0x1000000);
        abyte1[0][k++] = (byte)((j & 0xFF0000) / 65536);
        abyte1[0][k++] = (byte)((j & 0xFF00) / 256);
        abyte1[0][k++] = (byte)(j & 0xFF);
        abyte1[0][k++] = byte0;
        abyte1[0][k++] = 0;
        abyte1[0][k++] = (byte)((c & 0xFF00) / 256);
        abyte1[0][k++] = (byte)(c & 0xFF);
        abyte1[0][k++] = (byte)((c1 & 0xFF00) / 256);
        abyte1[0][k++] = (byte)(c1 & 0xFF);
        byte[] abyte0 = s.getBytes();
        int l = 0;
        while (l < abyte0.length) {
            abyte1[0][k++] = abyte0[l];
            ++l;
        }
        abyte1[0][k++] = 0;
        DLP_Packet dlp_packet = new DLP_Packet(24, abyte1);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            dlp_packet1 = this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.createDatabase()", dlperror.getErrorCode());
        }
        abyte0 = dlp_packet1.readArgument(1);
        return abyte0[0];
    }

    public byte createDatabase(byte byte0, String s, String s1, String s2, char c, char c1) throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet dlp_packet1 = null;
        byte[][] abyte1 = new byte[1][15 + s2.length()];
        int i = 0;
        byte[] abyte0 = s.getBytes();
        int j = 0;
        while (j < 4) {
            abyte1[0][i++] = abyte0[j];
            ++j;
        }
        abyte0 = s1.getBytes();
        int k = 0;
        while (k < 4) {
            abyte1[0][i++] = abyte0[k];
            ++k;
        }
        abyte1[0][i++] = byte0;
        abyte1[0][i++] = 0;
        abyte1[0][i++] = (byte)((c & 0xFF00) / 256);
        abyte1[0][i++] = (byte)(c & 0xFF);
        abyte1[0][i++] = (byte)((c1 & 0xFF00) / 256);
        abyte1[0][i++] = (byte)(c1 & 0xFF);
        abyte0 = s2.getBytes();
        int l = 0;
        while (l < abyte0.length) {
            abyte1[0][i++] = abyte0[l];
            ++l;
        }
        abyte1[0][i++] = 0;
        DLP_Packet dlp_packet = new DLP_Packet(24, abyte1);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            dlp_packet1 = this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.createDatabase()", dlperror.getErrorCode());
        }
        abyte0 = dlp_packet1.readArgument(1);
        return abyte0[0];
    }

    public void deleteDatabase(byte byte0, String s) throws DLPFunctionCallException, NotConnectedException {
        byte[] abyte0 = s.getBytes();
        byte[][] abyte1 = new byte[1][2 + s.length() + 1];
        int i = 0;
        abyte1[0][i++] = byte0;
        abyte1[0][i++] = 0;
        int j = 0;
        while (j < abyte0.length) {
            abyte1[0][i++] = abyte0[j];
            ++j;
        }
        abyte1[0][i++] = 0;
        DLP_Packet dlp_packet = new DLP_Packet(26, abyte1);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.deleteDatabase()", dlperror.getErrorCode());
        }
    }

    public void deleteRecord(byte byte0, byte byte1, int i) throws DLPFunctionCallException, NotConnectedException {
        byte[][] abyte0 = new byte[1][6];
        int j = 0;
        abyte0[0][j++] = byte0;
        abyte0[0][j++] = byte1;
        abyte0[0][j++] = (byte)((i & 0xFF000000) / 0x1000000);
        abyte0[0][j++] = (byte)((i & 0xFF0000) / 65536);
        abyte0[0][j++] = (byte)((i & 0xFF00) / 256);
        abyte0[0][j++] = (byte)((i & 0xFF) / 1);
        DLP_Packet dlp_packet = new DLP_Packet(34, abyte0);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.deleteRecord()", dlperror.getErrorCode());
        }
    }

    public void deleteResource(byte dbID, byte flags, int type, char resourceID) throws DLPFunctionCallException, NotConnectedException {
        byte[][] adbID = new byte[1][8];
        int j = 0;
        adbID[0][j++] = dbID;
        adbID[0][j++] = flags;
        adbID[0][j++] = (byte)((type & 0xFF000000) / 0x1000000);
        adbID[0][j++] = (byte)((type & 0xFF0000) / 65536);
        adbID[0][j++] = (byte)((type & 0xFF00) / 256);
        adbID[0][j++] = (byte)((type & 0xFF) / 1);
        adbID[0][j++] = (byte)((resourceID & 0xFF00) / 256);
        adbID[0][j++] = (byte)((resourceID & 0xFF) / 1);
        DLP_Packet dlp_packet = new DLP_Packet(37, adbID);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.deleteResource()", dlperror.getErrorCode());
        }
    }

    public void disconnect() throws NotConnectedException {
        this.cmpDlpHandler.disconnect();
    }

    public void disconnect(char c) throws NotConnectedException {
        this.cmpDlpHandler.disconnect(c);
    }

    public DLPBlock getApplicationBlock(byte byte0, int i, int j) throws DLPFunctionCallException, NotConnectedException {
        Object obj = null;
        byte[][] abyte1 = new byte[1][6];
        int k = 0;
        abyte1[0][k++] = byte0;
        abyte1[0][k++] = 0;
        abyte1[0][k++] = (byte)((i & 0xFF00) / 256);
        abyte1[0][k++] = (byte)(i & 0xFF);
        abyte1[0][k++] = (byte)((j & 0xFF00) / 256);
        abyte1[0][k++] = (byte)(j & 0xFF);
        DLP_Packet dlp_packet = new DLP_Packet(27, abyte1);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            DLP_Packet dlp_packet1 = this.cmpDlpHandler.getDLPPacket(dlp_packet);
            byte[] abyte0 = dlp_packet1.readArgument(1);
            return new DLPBlock(abyte0);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.getApplicationBlock()", dlperror.getErrorCode());
        }
    }

    public CMP_DLP getCmpDlpHandler() {
        return this.cmpDlpHandler;
    }

    public DLPDatabaseListGroup getDatabaseList(byte searchFlags, byte cardNumber, char startIndex) throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet dlp_packet1 = null;
        byte[][] temp = new byte[1][4];
        temp[0][0] = searchFlags;
        temp[0][1] = cardNumber;
        temp[0][2] = (byte)((startIndex & 0xFF00) / 256);
        temp[0][3] = (byte)(startIndex & 0xFF);
        DLP_Packet dlp_packet = new DLP_Packet(22, temp);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            dlp_packet1 = this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.getDatabaseList()", dlperror.getErrorCode());
        }
        return new DLPDatabaseListGroup(dlp_packet1.readArgument(1));
    }

    public int getOpenDatabaseInfo(byte dbID) throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet dlp_packet1 = null;
        byte[][] abyte1 = new byte[1][1];
        abyte1[0][0] = dbID;
        DLP_Packet dlp_packet = new DLP_Packet(43, abyte1);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            dlp_packet1 = this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.getOpenDatabaseInfo()", dlperror.getErrorCode());
        }
        byte[] adbID = dlp_packet1.readArgument(1);
        return UnsignedByte.unsignedBytes2Char(adbID[0], adbID[1]);
    }

    public PADP getPADPHandler() {
        return this.padpHandler;
    }

    public SLP getSLPHandler() {
        return this.slpHandler;
    }

    public DLPBlock getSortBlock(byte byte0, int i, int j) throws DLPFunctionCallException, NotConnectedException {
        Object obj = null;
        byte[][] abyte1 = new byte[1][6];
        int k = 0;
        abyte1[0][k++] = byte0;
        abyte1[0][k++] = 0;
        abyte1[0][k++] = (byte)((i & 0xFF00) / 256);
        abyte1[0][k++] = (byte)(i & 0xFF);
        abyte1[0][k++] = (byte)((j & 0xFF00) / 256);
        abyte1[0][k++] = (byte)(j & 0xFF);
        DLP_Packet dlp_packet = new DLP_Packet(29, abyte1);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            DLP_Packet dlp_packet1 = this.cmpDlpHandler.getDLPPacket(dlp_packet);
            byte[] abyte0 = dlp_packet1.readArgument(1);
            return new DLPBlock(abyte0);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.getApplicationBlock()", dlperror.getErrorCode());
        }
    }

    public int getSpeed() {
        return this.cmpDlpHandler.getSpeed();
    }

    public DLPStorageInfo getStorageInfo(byte card) throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet respPkt = null;
        byte[][] pktData = new byte[1][2];
        pktData[0][0] = card;
        pktData[0][1] = 0;
        DLP_Packet reqPkt = new DLP_Packet(21, pktData);
        reqPkt.hostSocket = (byte)3;
        reqPkt.serverSocket = (byte)3;
        try {
            respPkt = this.cmpDlpHandler.getDLPPacket(reqPkt);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.getStorageInfo()", dlperror.getErrorCode());
        }
        DLPStorageInfo dlpstorageinfo = new DLPStorageInfo(respPkt.readArgument(1), respPkt.readArgument(2));
        return dlpstorageinfo;
    }

    public DLPSystemInfo getSystemInfo() throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet respPkt = null;
        byte[][] pktData = new byte[1][4];
        pktData[0] = DLP_VERSION.versionAsBytes();
        DLP_Packet dlp_packet = new DLP_Packet(18, pktData);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            respPkt = this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.getSystemInfo()", dlperror.getErrorCode());
        }
        respPkt.readArgument(1);
        return new DLPSystemInfo(respPkt.readArgument(1), respPkt.readArgument(2));
    }

    public Calendar getTime() throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet dlp_packet1 = null;
        DLP_Packet dlp_packet = new DLP_Packet(19, null);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            dlp_packet1 = this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError ex) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + ex.getErrorCode() + " in JHotSync.getTime()", ex.getErrorCode());
        }
        try {
            DLP_Date dlp_date = new DLP_Date(dlp_packet1.readArgument(1));
            return dlp_date.convertToCalendar();
        }
        catch (InvalidDLPDateException invaliddlpdateexception) {
            throw new DLPFunctionCallException(invaliddlpdateexception.toString(), Integer.MAX_VALUE);
        }
    }

    public DLPUserInfo getUserInfo() throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet dlp_packet1 = null;
        DLP_Packet dlp_packet = new DLP_Packet(16, null);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            dlp_packet1 = this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Unable to read user info: " + dlperror.toString(), dlperror.getErrorCode());
        }
        return new DLPUserInfo(dlp_packet1.readArgument(1));
    }

    public boolean isConnected() {
        return this.cmpDlpHandler.isConnected();
    }

    public void moveCategory(byte byte0, byte byte1, byte byte2) throws DLPFunctionCallException, NotConnectedException {
        byte[][] abyte0 = new byte[1][4];
        abyte0[0][0] = byte0;
        abyte0[0][1] = byte2;
        abyte0[0][2] = byte1;
        abyte0[0][3] = 0;
        DLP_Packet dlp_packet = new DLP_Packet(44, abyte0);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.moveCategory()", dlperror.getErrorCode());
        }
    }

    public void openConduit() throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet dlp_packet = new DLP_Packet(46, null);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.openConduit()", dlperror.getErrorCode());
        }
    }

    public byte openDatabase(byte byte0, byte byte1, String s) throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet dlp_packet1 = null;
        byte[][] abyte1 = new byte[1][3 + s.length()];
        int i = 0;
        abyte1[0][i++] = byte0;
        abyte1[0][i++] = byte1;
        byte[] abyte0 = s.getBytes();
        int j = 0;
        while (j < abyte0.length) {
            abyte1[0][i++] = abyte0[j];
            ++j;
        }
        abyte1[0][i++] = 0;
        DLP_Packet dlp_packet = new DLP_Packet(23, abyte1);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            dlp_packet1 = this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.openDatabase()", dlperror.getErrorCode());
        }
        abyte0 = dlp_packet1.readArgument(1);
        return abyte0[0];
    }

    public DLPAppPreference readAppPreference(int creatorID, char prefID, char size, byte flags) throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet dlp_packet1 = null;
        byte[][] abyte1 = new byte[1][10];
        int j = 0;
        abyte1[0][j++] = (byte)((creatorID & 0xFF000000) / 0x1000000);
        abyte1[0][j++] = (byte)((creatorID & 0xFF0000) / 65536);
        abyte1[0][j++] = (byte)((creatorID & 0xFF00) / 256);
        abyte1[0][j++] = (byte)((creatorID & 0xFF) / 1);
        abyte1[0][j++] = (byte)((prefID & 0xFF00) / 256);
        abyte1[0][j++] = (byte)((prefID & 0xFF) / 1);
        abyte1[0][j++] = (byte)((size & 0xFF00) / 256);
        abyte1[0][j++] = (byte)((size & 0xFF) / 1);
        abyte1[0][j++] = flags;
        abyte1[0][j++] = 0;
        DLP_Packet dlp_packet = new DLP_Packet(52, abyte1);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            dlp_packet1 = this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.readAppPreference()", dlperror.getErrorCode());
        }
        byte[] abyte0 = dlp_packet1.readArgument(1);
        return new DLPAppPreference(abyte0);
    }

    public DLPRecord readNextModifiedRecord(byte dbID) throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet pkt = null;
        byte[][] data = new byte[1][1];
        data[0][0] = dbID;
        DLP_Packet dlp_packet = new DLP_Packet(31, data);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            pkt = this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.readNextModifiedRecord()", dlperror.getErrorCode());
        }
        byte[] data2 = pkt.readArgument(1);
        return new DLPRecord(data2);
    }

    public DLPRecord readNextModifiedRecordInCategory(byte dbID, byte category) throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet dlp_packet1 = null;
        byte[][] abyte1 = new byte[1][2];
        int i = 0;
        abyte1[0][i++] = dbID;
        abyte1[0][i++] = category;
        DLP_Packet dlp_packet = new DLP_Packet(51, abyte1);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            dlp_packet1 = this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.readNextRecordInCategory()", dlperror.getErrorCode());
        }
        byte[] abyte0 = dlp_packet1.readArgument(1);
        return new DLPRecord(abyte0);
    }

    public DLPRecord readNextRecordInCategory(byte dbID, byte category) throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet dlp_packet1 = null;
        byte[][] abyte1 = new byte[1][2];
        int i = 0;
        abyte1[0][i++] = dbID;
        abyte1[0][i++] = category;
        DLP_Packet dlp_packet = new DLP_Packet(50, abyte1);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            dlp_packet1 = this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.readNextRecordInCategory()", dlperror.getErrorCode());
        }
        byte[] abyte0 = dlp_packet1.readArgument(1);
        return new DLPRecord(abyte0);
    }

    public DLPRecord readRecord(byte byte0, char c, char c1, char c2) throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet dlp_packet1 = null;
        byte[][] abyte1 = new byte[1][8];
        int i = 0;
        abyte1[0][i++] = byte0;
        abyte1[0][i++] = 0;
        abyte1[0][i++] = (byte)((c & 0xFF00) / 256);
        abyte1[0][i++] = (byte)((c & 0xFF) / 1);
        abyte1[0][i++] = (byte)((c1 & 0xFF00) / 256);
        abyte1[0][i++] = (byte)((c1 & 0xFF) / 1);
        abyte1[0][i++] = (byte)((c2 & 0xFF00) / 256);
        abyte1[0][i++] = (byte)((c2 & 0xFF) / 1);
        DLP_Packet dlp_packet = new DLP_Packet(32, abyte1, 33);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            dlp_packet1 = this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.readRecord()", dlperror.getErrorCode());
        }
        byte[] abyte0 = dlp_packet1.readArgument(1);
        return new DLPRecord(abyte0);
    }

    public DLPRecord readRecord(byte byte0, int i, char c, char c1) throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet dlp_packet1 = null;
        byte[][] abyte1 = new byte[1][10];
        int j = 0;
        abyte1[0][j++] = byte0;
        abyte1[0][j++] = 0;
        abyte1[0][j++] = (byte)((i & 0xFF000000) / 0x1000000);
        abyte1[0][j++] = (byte)((i & 0xFF0000) / 65536);
        abyte1[0][j++] = (byte)((i & 0xFF00) / 256);
        abyte1[0][j++] = (byte)((i & 0xFF) / 1);
        abyte1[0][j++] = (byte)((c & 0xFF00) / 256);
        abyte1[0][j++] = (byte)((c & 0xFF) / 1);
        abyte1[0][j++] = (byte)((c1 & 0xFF00) / 256);
        abyte1[0][j++] = (byte)((c1 & 0xFF) / 1);
        DLP_Packet dlp_packet = new DLP_Packet(32, abyte1);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            dlp_packet1 = this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.readRecord()", dlperror.getErrorCode());
        }
        byte[] abyte0 = dlp_packet1.readArgument(1);
        return new DLPRecord(abyte0);
    }

    public int[] readRecordIDList(byte byte0, byte byte1, char c, char c1) throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet dlp_packet1 = null;
        byte[][] abyte1 = new byte[1][6];
        int i = 0;
        abyte1[0][i++] = byte0;
        abyte1[0][i++] = byte1;
        abyte1[0][i++] = (byte)((c & 0xFF00) / 256);
        abyte1[0][i++] = (byte)((c & 0xFF) / 1);
        abyte1[0][i++] = (byte)((c1 & 0xFF00) / 256);
        abyte1[0][i++] = (byte)((c1 & 0xFF) / 1);
        DLP_Packet dlp_packet = new DLP_Packet(49, abyte1);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            dlp_packet1 = this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.readRecordIDList()", dlperror.getErrorCode());
        }
        try {
            int j = 0;
            byte[] abyte0 = dlp_packet1.readArgument(1);
            int[] ai = new int[UnsignedByte.unsignedBytes2Char(abyte0[j++], abyte0[j++])];
            int k = 0;
            while (k < ai.length) {
                ai[k] = UnsignedByte.unsignedBytes2Int(abyte0[j++], abyte0[j++], abyte0[j++], abyte0[j++]);
                ++k;
            }
            return ai;
        }
        catch (Throwable throwable) {
            throw new DLPFunctionCallException("*** Caught exception " + throwable.toString() + " in JHotSync.readRecordIDList()", Integer.MAX_VALUE);
        }
    }

    public DLPResource readResource(byte byte0, char c, char c1, char c2) throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet dlp_packet1 = null;
        byte[][] abyte1 = new byte[1][8];
        int i = 0;
        abyte1[0][i++] = byte0;
        abyte1[0][i++] = 0;
        abyte1[0][i++] = (byte)((c & 0xFF00) / 256);
        abyte1[0][i++] = (byte)((c & 0xFF) / 1);
        abyte1[0][i++] = (byte)((c1 & 0xFF00) / 256);
        abyte1[0][i++] = (byte)((c1 & 0xFF) / 1);
        abyte1[0][i++] = (byte)((c2 & 0xFF00) / 256);
        abyte1[0][i++] = (byte)((c2 & 0xFF) / 1);
        DLP_Packet dlp_packet = new DLP_Packet(35, abyte1);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            dlp_packet1 = this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.readResource()", dlperror.getErrorCode());
        }
        byte[] abyte0 = dlp_packet1.readArgument(1);
        return new DLPResource(abyte0);
    }

    public DLPResource readResource(byte byte0, int i, char c, char c1, char c2) throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet dlp_packet1 = null;
        byte[][] abyte1 = new byte[1][12];
        int j = 0;
        abyte1[0][j++] = byte0;
        abyte1[0][j++] = 0;
        abyte1[0][j++] = (byte)((i & 0xFF000000) / 0x1000000);
        abyte1[0][j++] = (byte)((i & 0xFF0000) / 65536);
        abyte1[0][j++] = (byte)((i & 0xFF00) / 256);
        abyte1[0][j++] = (byte)((i & 0xFF) / 1);
        abyte1[0][j++] = (byte)((c & 0xFF00) / 256);
        abyte1[0][j++] = (byte)((c & 0xFF) / 1);
        abyte1[0][j++] = (byte)((c1 & 0xFF00) / 256);
        abyte1[0][j++] = (byte)((c1 & 0xFF) / 1);
        abyte1[0][j++] = (byte)((c2 & 0xFF00) / 256);
        abyte1[0][j++] = (byte)((c2 & 0xFF) / 1);
        DLP_Packet dlp_packet = new DLP_Packet(35, abyte1, 33);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            dlp_packet1 = this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.readRecord()", dlperror.getErrorCode());
        }
        byte[] abyte0 = dlp_packet1.readArgument(1);
        return new DLPResource(abyte0);
    }

    public void resetRecordIndex(byte byte0) throws DLPFunctionCallException, NotConnectedException {
        byte[][] abyte0 = new byte[1][1];
        abyte0[0][0] = byte0;
        DLP_Packet dlp_packet = new DLP_Packet(48, abyte0);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.readRecord()", dlperror.getErrorCode());
        }
    }

    public void resetSyncFlags(byte byte0) throws DLPFunctionCallException, NotConnectedException {
        byte[][] abyte0 = new byte[1][1];
        abyte0[0][0] = byte0;
        DLP_Packet dlp_packet = new DLP_Packet(39, abyte0);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.cleanupDatabase()", dlperror.getErrorCode());
        }
    }

    public void resetSystem() throws DLPFunctionCallException, NotConnectedException {
        System.out.println("*** resetSystem() called.");
        DLP_Packet dlp_packet = new DLP_Packet(41, null);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.resetSystem()", dlperror.getErrorCode());
        }
    }

    public void setSpeed(int speed) {
        this.cmpDlpHandler.setSpeed(speed);
    }

    public void setTime(Calendar calendar) throws DLPFunctionCallException, NotConnectedException {
        byte[][] abyte0 = null;
        try {
            DLP_Date dlp_date = new DLP_Date(calendar);
            abyte0 = new byte[1][dlp_date.convertToBytes().length];
            abyte0[0] = dlp_date.convertToBytes();
        }
        catch (InvalidDLPDateException invaliddlpdateexception) {
            throw new DLPFunctionCallException(invaliddlpdateexception.toString(), Integer.MAX_VALUE);
        }
        DLP_Packet dlp_packet = new DLP_Packet(20, abyte0);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.setTime()", dlperror.getErrorCode());
        }
    }

    public void setTransport(SLPTransportInterface t) {
        this.transport = t;
        if (t instanceof SerialTransportInterface) {
            this.slpHandler = new SLP(t);
            this.slpHandler.setDebugOutputStream(System.out);
            this.padpHandler = new PADP(this.slpHandler);
            this.cmpDlpHandler = new CMP_DLP(this.padpHandler);
        }
        if (t instanceof USBTransportInterface) {
            this.usbHandler = new USB((USBTransportInterface)t);
            this.cmpDlpHandler = new CMP_DLP(this.usbHandler);
        }
    }

    public void setUserInfo(DLPUserInfo dlpuserinfo) throws DLPFunctionCallException, NotConnectedException {
        byte[] abyte0 = dlpuserinfo.object2Bytes();
        byte[][] abyte1 = new byte[1][abyte0.length];
        abyte1[0] = abyte0;
        DLP_Packet dlp_packet = new DLP_Packet(17, abyte1);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("Error in setUserInfo: " + dlperror.getErrorCode(), dlperror.getErrorCode());
        }
    }

    public void startTickles() {
        if (this.padpHandler != null) {
            this.padpHandler.startTickles();
        }
    }

    public void stopTickles() {
        if (this.padpHandler != null) {
            this.padpHandler.stopTickles();
        }
    }

    public void suspend() throws NotConnectedException {
        this.cmpDlpHandler.suspend();
        try {
            JHotSync jHotSync = this;
            synchronized (jHotSync) {
                this.wait(100L);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            if (this.transport instanceof SerialTransportInterface) {
                ((SerialTransportInterface)this.transport).setSpeed(9600);
            }
        }
        catch (TransportException ex) {
            System.out.println("[JHS]  > Unable to reset speed for suspend!");
        }
    }

    public void writeApplicationBlock(byte dbID, DLPBlock appBlock) throws DLPFunctionCallException, NotConnectedException {
        byte[] temp = appBlock.getData();
        int i = temp.length;
        byte[][] ret = new byte[1][i + 4];
        int j = 0;
        ret[0][j++] = dbID;
        ret[0][j++] = 0;
        ret[0][j++] = (byte)((i & 0xFF00) / 256);
        ret[0][j++] = (byte)(i & 0xFF);
        System.arraycopy(temp, 0, ret[0], j, i);
        DLP_Packet dlp_packet = new DLP_Packet(28, ret);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.writeApplicationBlock()", dlperror.getErrorCode());
        }
    }

    public void writeApplicationBlock(byte byte0, byte[] abyte0) throws DLPFunctionCallException, NotConnectedException {
        int i = abyte0.length;
        byte[][] abyte1 = new byte[1][i + 4];
        int j = 0;
        abyte1[0][j++] = byte0;
        abyte1[0][j++] = 0;
        abyte1[0][j++] = (byte)((i & 0xFF00) / 256);
        abyte1[0][j++] = (byte)(i & 0xFF);
        System.arraycopy(abyte0, 0, abyte1[0], j, i);
        DLP_Packet dlp_packet = new DLP_Packet(28, abyte1);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.writeApplicationBlock()", dlperror.getErrorCode());
        }
    }

    public void writeAppPreference(int creatorID, char prefID, byte flags, DLPAppPreference preference) throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet dlp_packet1 = null;
        byte[][] abyte1 = new byte[1][12 + preference.getPreference().length];
        int j = 0;
        int i = 0;
        abyte1[0][j++] = (byte)((creatorID & 0xFF000000) / 0x1000000);
        abyte1[0][j++] = (byte)((creatorID & 0xFF0000) / 65536);
        abyte1[0][j++] = (byte)((creatorID & 0xFF00) / 256);
        abyte1[0][j++] = (byte)((creatorID & 0xFF) / 1);
        abyte1[0][j++] = (byte)((prefID & 0xFF00) / 256);
        abyte1[0][j++] = (byte)((prefID & 0xFF) / 1);
        abyte1[0][j++] = (byte)((preference.getVersion() & 0xFF00) / 256);
        abyte1[0][j++] = (byte)((preference.getVersion() & 0xFF) / 1);
        abyte1[0][j++] = (byte)((preference.getPreference().length & 0xFF00) / 256);
        abyte1[0][j++] = (byte)((preference.getPreference().length & 0xFF) / 1);
        abyte1[0][j++] = flags;
        abyte1[0][j++] = 0;
        System.arraycopy(preference.getPreference(), i, abyte1[0], j, preference.getPreference().length - j);
        DLP_Packet dlp_packet = new DLP_Packet(53, abyte1);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            dlp_packet1 = this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.writeAppPreference()", dlperror.getErrorCode());
        }
    }

    public int writeRecord(byte byte0, byte byte1, int i, byte byte2, byte byte3, byte[] abyte0) throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet dlp_packet1 = null;
        byte[][] abyte2 = new byte[1][abyte0.length + 8];
        int j = 0;
        abyte2[0][j++] = byte0;
        abyte2[0][j++] = byte1;
        abyte2[0][j++] = (byte)((i & 0xFF000000) / 0x1000000);
        abyte2[0][j++] = (byte)((i & 0xFF0000) / 65536);
        abyte2[0][j++] = (byte)((i & 0xFF00) / 256);
        abyte2[0][j++] = (byte)((i & 0xFF) / 1);
        abyte2[0][j++] = byte2;
        abyte2[0][j++] = byte3;
        System.arraycopy(abyte0, 0, abyte2[0], j, abyte0.length);
        DLP_Packet dlp_packet = new DLP_Packet(33, abyte2);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            dlp_packet1 = this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.writeRecord()", dlperror.getErrorCode());
        }
        j = 0;
        byte[] abyte1 = dlp_packet1.readArgument(1);
        return UnsignedByte.unsignedBytes2Int(abyte1[j++], abyte1[j++], abyte1[j++], abyte1[j++]);
    }

    public int writeRecord(byte dbID, byte flags, DLPRecord record) throws DLPFunctionCallException, NotConnectedException {
        DLP_Packet tempPacket = null;
        byte[] recData = record.getData();
        byte[][] pktData = new byte[1][recData.length + 8];
        int i = 0;
        int k = record.getRecordID();
        pktData[0][i++] = dbID;
        pktData[0][i++] = flags;
        pktData[0][i++] = (byte)((k & 0xFF000000) / 0x1000000);
        pktData[0][i++] = (byte)((k & 0xFF0000) / 65536);
        pktData[0][i++] = (byte)((k & 0xFF00) / 256);
        pktData[0][i++] = (byte)((k & 0xFF) / 1);
        pktData[0][i++] = record.getAttributes();
        pktData[0][i++] = record.getCategory();
        System.arraycopy(recData, 0, pktData[0], i, recData.length);
        DLP_Packet dlp_packet = new DLP_Packet(33, pktData);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            tempPacket = this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.writeRecord()", dlperror.getErrorCode());
        }
        i = 0;
        byte[] adbID = tempPacket.readArgument(1);
        return UnsignedByte.unsignedBytes2Int(adbID[i++], adbID[i++], adbID[i++], adbID[i++]);
    }

    public void writeResource(byte byte0, int i, char c, byte[] abyte0) throws DLPFunctionCallException, NotConnectedException {
        int j = abyte0.length;
        byte[][] abyte1 = new byte[1][j + 10];
        int k = 0;
        abyte1[0][k++] = byte0;
        abyte1[0][k++] = 0;
        abyte1[0][k++] = (byte)((i & 0xFF000000) / 0x1000000);
        abyte1[0][k++] = (byte)((i & 0xFF0000) / 65536);
        abyte1[0][k++] = (byte)((i & 0xFF00) / 256);
        abyte1[0][k++] = (byte)((i & 0xFF) / 1);
        abyte1[0][k++] = (byte)((c & 0xFF00) / 256);
        abyte1[0][k++] = (byte)((c & 0xFF) / 1);
        abyte1[0][k++] = (byte)((j & 0xFF00) / 256);
        abyte1[0][k++] = (byte)((j & 0xFF) / 1);
        System.arraycopy(abyte0, 0, abyte1[0], k, j);
        DLP_Packet dlp_packet = new DLP_Packet(36, abyte1);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.writeResource()", dlperror.getErrorCode());
        }
    }

    public void writeResource(byte byte0, DLPResource dlpresource) throws DLPFunctionCallException, NotConnectedException {
        byte[] abyte0 = dlpresource.getData();
        int i = dlpresource.getResourceType();
        char c = dlpresource.getResourceID();
        int j = abyte0.length;
        byte[][] abyte1 = new byte[1][j + 10];
        int k = 0;
        abyte1[0][k++] = byte0;
        abyte1[0][k++] = 0;
        abyte1[0][k++] = (byte)((i & 0xFF000000) / 0x1000000);
        abyte1[0][k++] = (byte)((i & 0xFF0000) / 65536);
        abyte1[0][k++] = (byte)((i & 0xFF00) / 256);
        abyte1[0][k++] = (byte)((i & 0xFF) / 1);
        abyte1[0][k++] = (byte)((c & 0xFF00) / 256);
        abyte1[0][k++] = (byte)((c & 0xFF) / 1);
        abyte1[0][k++] = (byte)((j & 0xFF00) / 256);
        abyte1[0][k++] = (byte)((j & 0xFF) / 1);
        System.arraycopy(abyte0, 0, abyte1[0], k, j);
        DLP_Packet dlp_packet = new DLP_Packet(36, abyte1);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.writeResource()", dlperror.getErrorCode());
        }
    }

    public void writeSortBlock(byte dbID, DLPBlock sortBlock) throws DLPFunctionCallException, NotConnectedException {
        byte[] blockData = sortBlock.getData();
        int i = blockData.length;
        byte[][] pktData = new byte[1][i + 4];
        int j = 0;
        pktData[0][j++] = dbID;
        pktData[0][j++] = 0;
        pktData[0][j++] = (byte)((i & 0xFF00) / 256);
        pktData[0][j++] = (byte)(i & 0xFF);
        System.arraycopy(blockData, 0, pktData[0], j, i);
        DLP_Packet dlp_packet = new DLP_Packet(30, pktData);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.writeSortBlock()", dlperror.getErrorCode());
        }
    }

    public void writeSortBlock(byte byte0, byte[] abyte0) throws DLPFunctionCallException, NotConnectedException {
        int i = abyte0.length;
        byte[][] abyte1 = new byte[1][i + 4];
        int j = 0;
        abyte1[0][j++] = byte0;
        abyte1[0][j++] = 0;
        abyte1[0][j++] = (byte)((i & 0xFF00) / 256);
        abyte1[0][j++] = (byte)(i & 0xFF);
        System.arraycopy(abyte0, 0, abyte1[0], j, i);
        DLP_Packet dlp_packet = new DLP_Packet(30, abyte1);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.cmpDlpHandler.getDLPPacket(dlp_packet);
        }
        catch (DLPError dlperror) {
            throw new DLPFunctionCallException("*** Caught DLP Error number " + dlperror.getErrorCode() + " in JHotSync.getApplicationBlock()", dlperror.getErrorCode());
        }
    }
}

